/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.http.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DebugInputStream
extends FilterInputStream {
    private byte[] iBuf = new byte[512];
    private boolean iBuffered = false;
    private int iCur = 0;
    private int iMaxLen = 0;
    private OutputStream iBut;

    public DebugInputStream(InputStream is, OutputStream os) {
        super(is);
        this.iBut = os;
    }

    private void buffer() throws IOException {
        int total;
        this.iBuffered = true;
        while ((total = this.in.read(this.iBuf, this.iMaxLen, this.iBuf.length - this.iMaxLen)) > -1) {
            this.iMaxLen += total;
            if (this.iMaxLen != this.iBuf.length) continue;
            byte[] b = new byte[this.iBuf.length << 1];
            System.arraycopy(this.iBuf, 0, b, 0, this.iBuf.length);
            this.iBuf = b;
        }
        if (this.iBut != null) {
            this.iBut.write("-----------------------------\n".getBytes());
            this.iBut.write("Dumping raw data from stream:\n".getBytes());
            this.iBut.write(this.iBuf, 0, this.iMaxLen);
            this.iBut.write("\n".getBytes());
            this.iBut.write("-----------------------------\n".getBytes());
        }
    }

    public synchronized int read() throws IOException {
        if (!this.iBuffered) {
            this.buffer();
        }
        if (this.iCur >= this.iMaxLen) {
            return -1;
        }
        return this.iBuf[this.iCur++];
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int i;
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int c = this.read();
        if (c == -1) {
            return -1;
        }
        b[off] = (byte)c;
        for (i = 1; i < len && (c = this.read()) != -1; ++i) {
            if (b == null) continue;
            b[off + i] = (byte)c;
        }
        return i;
    }
}

