/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.util.GlobalProperties;

public class CIMNameSpace
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 4090304642015551161L;
    private static final String HTTP = "http";
    private static final String DEFAULT_PROTOCOL = "http";
    private static final String DEFAULT_FILE = "/cimom";
    private static final String DEFAULT_HOST = null;
    private static final int DEFAULT_PORT = 5988;
    private static final String DEFAULT_NAMESPACE = "root/cimv2";
    public static final char NAMESPACE_SEPARATOR = '/';
    private String iHost;
    private String iNamespace;
    private int iPort;
    private String iFile = "/";
    private URI iUri;
    private String iProtocol = "http";

    public CIMNameSpace() throws CIMException {
        this.iHost = DEFAULT_HOST;
        this.iPort = 5988;
        this.iFile = DEFAULT_FILE;
        this.iProtocol = "http";
        this.iNamespace = DEFAULT_NAMESPACE;
        try {
            this.iUri = new URI(this.iProtocol, null, this.iHost, this.iPort, this.iFile, null, null);
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", e);
        }
    }

    public CIMNameSpace(String pURI) throws CIMException {
        this(pURI, null);
    }

    public CIMNameSpace(String pHost, String pNamespace) throws CIMException {
        this.iUri = null;
        if (pHost == null) {
            pHost = DEFAULT_HOST;
        }
        if (pNamespace == null) {
            pNamespace = DEFAULT_NAMESPACE;
        }
        this.setNamespace(pNamespace);
        try {
            int pos;
            this.iUri = pHost.indexOf(47) == -1 ? ((pos = pHost.indexOf(58)) == -1 && pos + 1 == pHost.length() ? new URI("http", null, pHost, 5988, DEFAULT_FILE, null, null) : new URI("http", pHost, DEFAULT_FILE, null)) : new URI(pHost);
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", e);
        }
        this.iHost = this.iUri.getHost();
        this.iPort = this.iUri.getPort();
        this.iFile = this.iUri.getPath();
        this.iProtocol = this.iUri.getScheme();
        if (this.iFile == null || this.iFile.length() == 0 || this.iFile.equals("/")) {
            this.iFile = DEFAULT_FILE;
        }
        if (this.iPort == -1) {
            this.iPort = 5988;
        }
        this.iNamespace = pNamespace;
        if (this.iHost == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", "Invalid hostname: \"" + pHost + "\"");
        }
        try {
            this.iUri = new URI(this.iProtocol, null, this.iHost, this.iPort, this.iFile, null, null);
        }
        catch (Exception e) {
            Logger logger = GlobalProperties.getLogger();
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "invalid URI format", e);
            }
            throw new CIMException("CIM_ERR_FAILED", e, "malformed URI");
        }
    }

    protected void updateURI() throws CIMException {
        try {
            this.iUri = new URI(this.iProtocol, null, this.iHost, this.iPort, this.iFile, null, null);
        }
        catch (Exception e) {
            Logger logger = GlobalProperties.getLogger();
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "invalid URI format", e);
            }
            throw new CIMException("CIM_ERR_FAILED", e, "malformed URI");
        }
    }

    public Object clone() {
        CIMNameSpace that = new CIMNameSpace();
        that.iHost = this.iHost;
        that.iNamespace = this.iNamespace;
        that.iPort = this.iPort;
        that.iProtocol = this.iProtocol;
        that.iFile = this.iFile;
        that.iUri = this.iUri;
        return that;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CIMNameSpace)) {
            return false;
        }
        CIMNameSpace that = (CIMNameSpace)o;
        if (!this.iUri.equals(that.iUri)) {
            return false;
        }
        return this.iNamespace.equals(that.iNamespace);
    }

    public String getHost() {
        return this.iHost;
    }

    public URI getHostURI() throws CIMException {
        return this.iUri;
    }

    public URL getHostURL() throws CIMException {
        URL url = null;
        try {
            url = this.iUri.toURL();
        }
        catch (Throwable e) {
            Logger logger = GlobalProperties.getLogger();
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "invalid URI format", e);
            }
            try {
                url = new URL(this.iProtocol, this.iHost, this.iPort, this.iFile);
            }
            catch (Throwable n) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "invalid URI format", e);
                }
                throw new CIMException("CIM_ERR_FAILED", n, "malformed URI");
            }
        }
        return url;
    }

    public String getNameSpace() {
        return this.iNamespace;
    }

    public String getScheme() {
        return this.iUri.getScheme();
    }

    public int hashCode() {
        return this.iUri.hashCode();
    }

    public static CIMNameSpace parse(String pURI) throws CIMException {
        return new CIMNameSpace(pURI);
    }

    public void setPort(int pPort) {
        if (pPort < 0) {
            throw new IllegalArgumentException("invalid port number argument: " + pPort);
        }
        this.iPort = pPort;
        this.updateURI();
    }

    public int getPort() {
        return this.iPort;
    }

    public void setHost(String pHost) {
        if (pHost == null) {
            throw new IllegalArgumentException("null hostname argument");
        }
        String realHost = pHost;
        int i = pHost.indexOf(58);
        if (i > -1) {
            realHost = pHost.substring(0, i);
            String realPort = pHost.substring(i + 1);
            int newPort = -1;
            try {
                this.iPort = newPort = Integer.parseInt(realPort);
            }
            catch (NumberFormatException e) {
                newPort = -1;
            }
            this.iHost = realHost;
        } else {
            this.iHost = pHost;
        }
        this.updateURI();
    }

    public void setNameSpace(String pNamespace) throws CIMException {
        if (pNamespace == null) {
            throw new IllegalArgumentException("null namespace argument");
        }
        this.setNamespace(pNamespace);
        this.updateURI();
    }

    protected void setNamespace(String namespace) {
        if (namespace != null) {
            if (namespace.indexOf(92) > -1) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER", "namespace should not contain '\\' character");
            }
            boolean tryAgain = false;
            do {
                tryAgain = false;
                if (namespace.startsWith("/")) {
                    namespace = namespace.substring(1);
                    tryAgain = true;
                }
                if (!namespace.endsWith("/")) continue;
                namespace = namespace.substring(0, namespace.length() - 1);
                tryAgain = true;
            } while (tryAgain);
            this.iNamespace = namespace;
        } else {
            this.iNamespace = "";
        }
    }

    public String toString() {
        return "//" + (this.iHost == null ? "" : this.iHost) + '/' + (this.iNamespace == null ? "" : this.iNamespace) + "/";
    }
}

