/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtopenlite.command.program.openlist;

import com.ibm.jtopenlite.Conv;
import com.ibm.jtopenlite.command.program.openlist.ListEntryFormat;
import com.ibm.jtopenlite.command.program.openlist.ListFormatListener;
import com.ibm.jtopenlite.command.program.openlist.ListInformation;
import com.ibm.jtopenlite.command.program.openlist.OpenListProgram;
import com.ibm.jtopenlite.command.program.openlist.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetListEntries
implements OpenListProgram<ListEntryFormat, ListFormatListener> {
    private static final byte[] ZERO = new byte[4];
    private int inputLength_;
    private byte[] requestHandle_;
    private int recordLength_;
    private int numberOfRecordsToReturn_;
    private int startingRecord_;
    private ListEntryFormat formatter_;
    private ListFormatListener formatListener_;
    private ListInformation info_;
    private byte[] tempData_;

    public GetListEntries() {
    }

    public GetListEntries(int n, byte[] byArray, int n2, int n3, int n4, ListEntryFormat listEntryFormat, ListFormatListener listFormatListener) {
        this.inputLength_ = n < 8 ? 8 : n;
        this.requestHandle_ = byArray;
        this.recordLength_ = n2;
        this.numberOfRecordsToReturn_ = n3;
        this.startingRecord_ = n4;
        this.formatter_ = listEntryFormat;
        this.formatListener_ = listFormatListener;
    }

    @Override
    public String getProgramName() {
        return "QGYGTLE";
    }

    @Override
    public String getProgramLibrary() {
        return "QGY";
    }

    @Override
    public int getNumberOfParameters() {
        return 7;
    }

    @Override
    public void newCall() {
        this.info_ = null;
    }

    @Override
    public ListEntryFormat getFormatter() {
        return this.formatter_;
    }

    @Override
    public void setFormatter(ListEntryFormat listEntryFormat) {
        this.formatter_ = listEntryFormat;
    }

    @Override
    public ListFormatListener getFormatListener() {
        return this.formatListener_;
    }

    @Override
    public void setFormatListener(ListFormatListener listFormatListener) {
        this.formatListener_ = listFormatListener;
    }

    public int getLengthOfReceiverVariable() {
        return this.inputLength_;
    }

    public void setLengthOfReceiverVariable(int n) {
        this.inputLength_ = n < 8 ? 8 : n;
    }

    @Override
    public ListInformation getListInformation() {
        return this.info_;
    }

    public byte[] getRequestHandle() {
        return this.requestHandle_;
    }

    public void setRequestHandle(byte[] byArray) {
        this.requestHandle_ = byArray;
    }

    public int getRecordLength() {
        return this.recordLength_;
    }

    public void setRecordLength(int n) {
        this.recordLength_ = n;
    }

    public int getNumberOfRecordsToReturn() {
        return this.numberOfRecordsToReturn_;
    }

    public void setNumberOfRecordsToReturn(int n) {
        this.numberOfRecordsToReturn_ = n;
    }

    public int getStartingRecord() {
        return this.startingRecord_;
    }

    public void setStartingRecord(int n) {
        this.startingRecord_ = n;
    }

    @Override
    public int getParameterInputLength(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                return 4;
            }
        }
        return 0;
    }

    @Override
    public int getParameterOutputLength(int n) {
        switch (n) {
            case 0: {
                return this.inputLength_;
            }
            case 3: {
                return 80;
            }
            case 6: {
                return 4;
            }
        }
        return 0;
    }

    @Override
    public int getParameterType(int n) {
        switch (n) {
            case 0: 
            case 3: {
                return 2;
            }
            case 6: {
                return 3;
            }
        }
        return 1;
    }

    @Override
    public final byte[] getTempDataBuffer() {
        int n = 0;
        for (int i = 0; i < this.getNumberOfParameters(); ++i) {
            int n2 = this.getParameterOutputLength(i);
            if (n2 > n) {
                n = n2;
            }
            if ((n2 = this.getParameterInputLength(i)) <= n) continue;
            n = n2;
        }
        if (this.tempData_ == null || this.tempData_.length < n) {
            this.tempData_ = new byte[n];
        }
        return this.tempData_;
    }

    @Override
    public byte[] getParameterInputData(int n) {
        byte[] byArray = this.getTempDataBuffer();
        switch (n) {
            case 1: {
                Conv.intToByteArray(this.inputLength_, byArray, 0);
                return byArray;
            }
            case 2: {
                if (this.requestHandle_.length == 4) {
                    return this.requestHandle_;
                }
                System.arraycopy(this.requestHandle_, 0, byArray, 0, 4);
                return byArray;
            }
            case 4: {
                Conv.intToByteArray(this.numberOfRecordsToReturn_, byArray, 0);
                return byArray;
            }
            case 5: {
                Conv.intToByteArray(this.startingRecord_, byArray, 0);
                return byArray;
            }
            case 6: {
                return ZERO;
            }
        }
        return null;
    }

    @Override
    public void setParameterOutputData(int n, byte[] byArray, int n2) {
        switch (n) {
            case 0: {
                if (this.formatter_ == null) break;
                this.formatter_.format(byArray, n2, this.recordLength_, this.formatListener_);
                break;
            }
            case 3: {
                if (n2 < 12) {
                    this.info_ = null;
                    break;
                }
                this.info_ = Util.readOpenListInformationParameter(byArray, n2);
                break;
            }
        }
    }
}

