/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtopenlite;

import com.ibm.jtopenlite.HostServerConnection;
import com.ibm.jtopenlite.SystemInfo;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostServerConnectionPool<T extends HostServerConnection> {
    private final SystemInfo info_;
    private final Map<String, Set<T>> freeConnections_ = new HashMap<String, Set<T>>();
    private final Set<T> usedConnections_ = new HashSet<T>();
    private int freeConnectionCount_;
    private int usedConnectionCount_;

    public HostServerConnectionPool(SystemInfo systemInfo) {
        this.info_ = systemInfo;
    }

    public SystemInfo getInfo() {
        return this.info_;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public void checkin(T t) throws IOException {
        if (!((HostServerConnection)t).isClosed() && ((HostServerConnection)t).getInfo().equals(this.info_)) {
            String string = ((HostServerConnection)t).getUser();
            Set<T> set = this.freeConnections_.get(string);
            if (set == null) {
                set = new HashSet<T>();
                this.freeConnections_.put(string, set);
            }
            set.add(t);
            ++this.freeConnectionCount_;
            if (this.usedConnections_.remove(t)) {
                --this.usedConnectionCount_;
            }
        } else {
            this.remove(t);
        }
    }

    public T checkout(String string) throws IOException {
        Iterator<T> iterator;
        Set<T> set = this.freeConnections_.get(string);
        if (set != null && (iterator = set.iterator()).hasNext()) {
            HostServerConnection hostServerConnection = (HostServerConnection)iterator.next();
            iterator.remove();
            --this.freeConnectionCount_;
            this.usedConnections_.add(hostServerConnection);
            ++this.usedConnectionCount_;
            return (T)hostServerConnection;
        }
        return null;
    }

    public void remove(T t) {
        String string = ((HostServerConnection)t).getUser();
        Set<T> set = this.freeConnections_.get(string);
        if (set != null && set.remove(t)) {
            --this.freeConnectionCount_;
        }
        if (this.usedConnections_.remove(t)) {
            --this.usedConnectionCount_;
        }
    }

    public void close() throws IOException {
        this.closeFree();
        this.closeUsed();
    }

    public void closeFree() throws IOException {
        Iterator<String> iterator = this.freeConnections_.keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            Set<T> set = this.freeConnections_.get(string);
            Iterator<T> iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                HostServerConnection hostServerConnection = (HostServerConnection)iterator2.next();
                try {
                    hostServerConnection.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                iterator2.remove();
                --this.freeConnectionCount_;
            }
            iterator.remove();
        }
    }

    public void closeUsed() throws IOException {
        Iterator<T> iterator = this.usedConnections_.iterator();
        while (iterator.hasNext()) {
            HostServerConnection hostServerConnection = (HostServerConnection)iterator.next();
            try {
                hostServerConnection.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            iterator.remove();
            --this.usedConnectionCount_;
        }
    }

    public void close(String string) throws IOException {
        this.closeFree(string);
        this.closeUsed(string);
    }

    public void closeFree(String string) throws IOException {
        Set<T> set = this.freeConnections_.remove(string);
        if (set != null) {
            for (HostServerConnection hostServerConnection : set) {
                try {
                    hostServerConnection.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                --this.freeConnectionCount_;
            }
        }
    }

    public void closeUsed(String string) throws IOException {
        Iterator<T> iterator = this.usedConnections_.iterator();
        while (iterator.hasNext()) {
            HostServerConnection hostServerConnection = (HostServerConnection)iterator.next();
            if (!hostServerConnection.getUser().equals(string)) continue;
            iterator.remove();
            try {
                hostServerConnection.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            --this.usedConnectionCount_;
        }
    }

    public int getConnectionCount() {
        return this.freeConnectionCount_ + this.usedConnectionCount_;
    }

    public int getFreeConnectionCount() {
        return this.freeConnectionCount_;
    }

    public int getUsedConnectionCount() {
        return this.usedConnectionCount_;
    }

    public int getConnectionCount(String string) {
        return this.getFreeConnectionCount(string) + this.getUsedConnectionCount(string);
    }

    public int getFreeConnectionCount(String string) {
        Set<T> set = this.freeConnections_.get(string);
        return set == null ? 0 : set.size();
    }

    public int getUsedConnectionCount(String string) {
        Iterator<T> iterator = this.usedConnections_.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            HostServerConnection hostServerConnection = (HostServerConnection)iterator.next();
            if (!hostServerConnection.getUser().equals(string)) continue;
            ++n;
        }
        return n;
    }

    public String[] getUsers() {
        Set<String> set = this.freeConnections_.keySet();
        return set.toArray(new String[set.size()]);
    }
}

