/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ExceptionTable
extends Attribute {
    private int[] exceptionIndexTable;

    public ExceptionTable(ExceptionTable exceptionTable) {
        this(exceptionTable.getNameIndex(), exceptionTable.getLength(), exceptionTable.getExceptionIndexTable(), exceptionTable.getConstantPool());
    }

    public ExceptionTable(int n, int n2, int[] nArray, ConstantPool constantPool) {
        super((byte)3, n, n2, constantPool);
        this.exceptionIndexTable = nArray != null ? nArray : new int[]{};
    }

    ExceptionTable(int n, int n2, DataInput dataInput, ConstantPool constantPool) throws IOException {
        this(n, n2, (int[])null, constantPool);
        int n3 = dataInput.readUnsignedShort();
        this.exceptionIndexTable = new int[n3];
        for (int i = 0; i < n3; ++i) {
            this.exceptionIndexTable[i] = dataInput.readUnsignedShort();
        }
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitExceptionTable(this);
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.exceptionIndexTable.length);
        for (int n : this.exceptionIndexTable) {
            dataOutputStream.writeShort(n);
        }
    }

    public int[] getExceptionIndexTable() {
        return this.exceptionIndexTable;
    }

    public int getNumberOfExceptions() {
        return this.exceptionIndexTable == null ? 0 : this.exceptionIndexTable.length;
    }

    public String[] getExceptionNames() {
        String[] stringArray = new String[this.exceptionIndexTable.length];
        for (int i = 0; i < this.exceptionIndexTable.length; ++i) {
            stringArray[i] = super.getConstantPool().getConstantString(this.exceptionIndexTable[i], (byte)7).replace('/', '.');
        }
        return stringArray;
    }

    public void setExceptionIndexTable(int[] nArray) {
        this.exceptionIndexTable = nArray != null ? nArray : new int[]{};
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Exceptions: ");
        for (int i = 0; i < this.exceptionIndexTable.length; ++i) {
            String string = super.getConstantPool().getConstantString(this.exceptionIndexTable[i], (byte)7);
            stringBuilder.append(Utility.compactClassName(string, false));
            if (i >= this.exceptionIndexTable.length - 1) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        ExceptionTable exceptionTable = (ExceptionTable)this.clone();
        if (this.exceptionIndexTable != null) {
            exceptionTable.exceptionIndexTable = new int[this.exceptionIndexTable.length];
            System.arraycopy(this.exceptionIndexTable, 0, exceptionTable.exceptionIndexTable, 0, this.exceptionIndexTable.length);
        }
        exceptionTable.setConstantPool(constantPool);
        return exceptionTable;
    }
}

