/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.Utils;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

abstract class ConstantPool {
    protected static final Entry[] noRefs = new Entry[0];
    protected static final ClassEntry[] noClassRefs = new ClassEntry[0];
    static final byte[] TAGS_IN_ORDER = new byte[]{1, 3, 4, 5, 6, 8, 7, 13, 12, 9, 10, 11, 15, 16, 17, 18};
    static final byte[] TAG_ORDER = new byte[19];
    static final byte[] NUMBER_TAGS;
    static final byte[] EXTRA_TAGS;
    static final byte[] LOADABLE_VALUE_TAGS;
    static final byte[] ANY_MEMBER_TAGS;
    static final byte[] FIELD_SPECIFIC_TAGS;

    private ConstantPool() {
    }

    static int verbose() {
        return Utils.currentPropMap().getInteger("com.sun.java.util.jar.pack.verbose");
    }

    public static synchronized Utf8Entry getUtf8Entry(String string) {
        Map<String, Utf8Entry> map = Utils.getTLGlobals().getUtf8Entries();
        Utf8Entry utf8Entry = map.get(string);
        if (utf8Entry == null) {
            utf8Entry = new Utf8Entry(string);
            map.put(utf8Entry.stringValue(), utf8Entry);
        }
        return utf8Entry;
    }

    public static ClassEntry getClassEntry(String string) {
        Map<String, ClassEntry> map = Utils.getTLGlobals().getClassEntries();
        ClassEntry classEntry = map.get(string);
        if (classEntry == null) {
            classEntry = new ClassEntry(ConstantPool.getUtf8Entry(string));
            assert (string.equals(classEntry.stringValue()));
            map.put(classEntry.stringValue(), classEntry);
        }
        return classEntry;
    }

    public static LiteralEntry getLiteralEntry(Comparable<?> comparable) {
        Map<Object, LiteralEntry> map = Utils.getTLGlobals().getLiteralEntries();
        LiteralEntry literalEntry = map.get(comparable);
        if (literalEntry == null) {
            literalEntry = comparable instanceof String ? new StringEntry(ConstantPool.getUtf8Entry((String)((Object)comparable))) : new NumberEntry((Number)((Object)comparable));
            map.put(comparable, literalEntry);
        }
        return literalEntry;
    }

    public static StringEntry getStringEntry(String string) {
        return (StringEntry)ConstantPool.getLiteralEntry(string);
    }

    public static SignatureEntry getSignatureEntry(String string) {
        Map<String, SignatureEntry> map = Utils.getTLGlobals().getSignatureEntries();
        SignatureEntry signatureEntry = map.get(string);
        if (signatureEntry == null) {
            signatureEntry = new SignatureEntry(string);
            assert (signatureEntry.stringValue().equals(string));
            map.put(string, signatureEntry);
        }
        return signatureEntry;
    }

    public static SignatureEntry getSignatureEntry(Utf8Entry utf8Entry, ClassEntry[] classEntryArray) {
        return ConstantPool.getSignatureEntry(SignatureEntry.stringValueOf(utf8Entry, classEntryArray));
    }

    public static DescriptorEntry getDescriptorEntry(Utf8Entry utf8Entry, SignatureEntry signatureEntry) {
        String string;
        Map<String, DescriptorEntry> map = Utils.getTLGlobals().getDescriptorEntries();
        DescriptorEntry descriptorEntry = map.get(string = DescriptorEntry.stringValueOf(utf8Entry, signatureEntry));
        if (descriptorEntry == null) {
            descriptorEntry = new DescriptorEntry(utf8Entry, signatureEntry);
            assert (descriptorEntry.stringValue().equals(string)) : descriptorEntry.stringValue() + " != " + string;
            map.put(string, descriptorEntry);
        }
        return descriptorEntry;
    }

    public static DescriptorEntry getDescriptorEntry(Utf8Entry utf8Entry, Utf8Entry utf8Entry2) {
        return ConstantPool.getDescriptorEntry(utf8Entry, ConstantPool.getSignatureEntry(utf8Entry2.stringValue()));
    }

    public static MemberEntry getMemberEntry(byte by, ClassEntry classEntry, DescriptorEntry descriptorEntry) {
        String string;
        Map<String, MemberEntry> map = Utils.getTLGlobals().getMemberEntries();
        MemberEntry memberEntry = map.get(string = MemberEntry.stringValueOf(by, classEntry, descriptorEntry));
        if (memberEntry == null) {
            memberEntry = new MemberEntry(by, classEntry, descriptorEntry);
            assert (memberEntry.stringValue().equals(string)) : memberEntry.stringValue() + " != " + string;
            map.put(string, memberEntry);
        }
        return memberEntry;
    }

    public static MethodHandleEntry getMethodHandleEntry(byte by, MemberEntry memberEntry) {
        String string;
        Map<String, MethodHandleEntry> map = Utils.getTLGlobals().getMethodHandleEntries();
        MethodHandleEntry methodHandleEntry = map.get(string = MethodHandleEntry.stringValueOf(by, memberEntry));
        if (methodHandleEntry == null) {
            methodHandleEntry = new MethodHandleEntry(by, memberEntry);
            assert (methodHandleEntry.stringValue().equals(string));
            map.put(string, methodHandleEntry);
        }
        return methodHandleEntry;
    }

    public static MethodTypeEntry getMethodTypeEntry(SignatureEntry signatureEntry) {
        String string;
        Map<String, MethodTypeEntry> map = Utils.getTLGlobals().getMethodTypeEntries();
        MethodTypeEntry methodTypeEntry = map.get(string = signatureEntry.stringValue());
        if (methodTypeEntry == null) {
            methodTypeEntry = new MethodTypeEntry(signatureEntry);
            assert (methodTypeEntry.stringValue().equals(string));
            map.put(string, methodTypeEntry);
        }
        return methodTypeEntry;
    }

    public static MethodTypeEntry getMethodTypeEntry(Utf8Entry utf8Entry) {
        return ConstantPool.getMethodTypeEntry(ConstantPool.getSignatureEntry(utf8Entry.stringValue()));
    }

    public static InvokeDynamicEntry getInvokeDynamicEntry(BootstrapMethodEntry bootstrapMethodEntry, DescriptorEntry descriptorEntry) {
        String string;
        Map<String, InvokeDynamicEntry> map = Utils.getTLGlobals().getInvokeDynamicEntries();
        InvokeDynamicEntry invokeDynamicEntry = map.get(string = InvokeDynamicEntry.stringValueOf(bootstrapMethodEntry, descriptorEntry));
        if (invokeDynamicEntry == null) {
            invokeDynamicEntry = new InvokeDynamicEntry(bootstrapMethodEntry, descriptorEntry);
            assert (invokeDynamicEntry.stringValue().equals(string));
            map.put(string, invokeDynamicEntry);
        }
        return invokeDynamicEntry;
    }

    public static BootstrapMethodEntry getBootstrapMethodEntry(MethodHandleEntry methodHandleEntry, Entry[] entryArray) {
        String string;
        Map<String, BootstrapMethodEntry> map = Utils.getTLGlobals().getBootstrapMethodEntries();
        BootstrapMethodEntry bootstrapMethodEntry = map.get(string = BootstrapMethodEntry.stringValueOf(methodHandleEntry, entryArray));
        if (bootstrapMethodEntry == null) {
            bootstrapMethodEntry = new BootstrapMethodEntry(methodHandleEntry, entryArray);
            assert (bootstrapMethodEntry.stringValue().equals(string));
            map.put(string, bootstrapMethodEntry);
        }
        return bootstrapMethodEntry;
    }

    static boolean isMemberTag(byte by) {
        switch (by) {
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    static byte numberTagOf(Number number) {
        if (number instanceof Integer) {
            return 3;
        }
        if (number instanceof Float) {
            return 4;
        }
        if (number instanceof Long) {
            return 5;
        }
        if (number instanceof Double) {
            return 6;
        }
        throw new RuntimeException("bad literal value " + number);
    }

    static boolean isRefKind(byte by) {
        return 1 <= by && by <= 9;
    }

    static String qualifiedStringValue(Entry entry, Entry entry2) {
        return ConstantPool.qualifiedStringValue(entry.stringValue(), entry2.stringValue());
    }

    static String qualifiedStringValue(String string, String string2) {
        assert (string.indexOf(".") < 0);
        return string + "." + string2;
    }

    static int compareSignatures(String string, String string2) {
        return ConstantPool.compareSignatures(string, string2, null, null);
    }

    static int compareSignatures(String string, String string2, String[] stringArray, String[] stringArray2) {
        int n;
        char c = string.charAt(0);
        char c2 = string2.charAt(0);
        if (c != '(' && c2 == '(') {
            return -1;
        }
        if (c2 != '(' && c == '(') {
            return 1;
        }
        if (stringArray == null) {
            stringArray = ConstantPool.structureSignature(string);
        }
        if (stringArray2 == null) {
            stringArray2 = ConstantPool.structureSignature(string2);
        }
        if (stringArray.length != stringArray2.length) {
            return stringArray.length - stringArray2.length;
        }
        int n2 = n = stringArray.length;
        while (--n2 >= 0) {
            int n3 = stringArray[n2].compareTo(stringArray2[n2]);
            if (n3 == 0) continue;
            return n3;
        }
        assert (string.equals(string2));
        return 0;
    }

    static int countClassParts(Utf8Entry utf8Entry) {
        int n = 0;
        String string = utf8Entry.stringValue();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != 'L') continue;
            ++n;
        }
        return n;
    }

    static String flattenSignature(String[] stringArray) {
        String string = stringArray[0];
        if (stringArray.length == 1) {
            return string;
        }
        int n = string.length();
        for (int i = 1; i < stringArray.length; ++i) {
            n += stringArray[i].length();
        }
        char[] cArray = new char[n];
        int n2 = 0;
        int n3 = 1;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            cArray[n2++] = c;
            if (c != 'L') continue;
            String string2 = stringArray[n3++];
            string2.getChars(0, string2.length(), cArray, n2);
            n2 += string2.length();
        }
        assert (n2 == n);
        assert (n3 == stringArray.length);
        return new String(cArray);
    }

    private static int skipTo(char c, String string, int n) {
        return (n = string.indexOf(c, n)) >= 0 ? n : string.length();
    }

    static String[] structureSignature(String string) {
        int n = string.indexOf(76);
        if (n < 0) {
            String[] stringArray = new String[]{string};
            return stringArray;
        }
        char[] cArray = null;
        String[] stringArray = null;
        for (int i = 0; i <= 1; ++i) {
            int n2 = 0;
            int n3 = 1;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = n + 1;
            while (n7 > 0) {
                int n8;
                if (n4 < n7) {
                    n4 = ConstantPool.skipTo(';', string, n7);
                }
                if (n5 < n7) {
                    n5 = ConstantPool.skipTo('<', string, n7);
                }
                int n9 = n8 = n4 < n5 ? n4 : n5;
                if (i != 0) {
                    string.getChars(n6, n7, cArray, n2);
                    stringArray[n3] = string.substring(n7, n8);
                }
                n2 += n7 - n6;
                ++n3;
                n6 = n8;
                n7 = string.indexOf(76, n8) + 1;
            }
            if (i != 0) {
                string.getChars(n6, string.length(), cArray, n2);
                break;
            }
            cArray = new char[n2 += string.length() - n6];
            stringArray = new String[n3];
        }
        stringArray[0] = new String(cArray);
        return stringArray;
    }

    public static Index makeIndex(String string, Entry[] entryArray) {
        return new Index(string, entryArray);
    }

    public static Index makeIndex(String string, Collection<Entry> collection) {
        return new Index(string, collection);
    }

    public static void sort(Index index) {
        index.clearIndex();
        Arrays.sort(index.cpMap);
        if (ConstantPool.verbose() > 2) {
            System.out.println("sorted " + index.dumpString());
        }
    }

    public static Index[] partition(Index index, int[] nArray) {
        List<Entry> list;
        int n;
        ArrayList<ArrayList<Entry>> arrayList = new ArrayList<ArrayList<Entry>>();
        Entry[] entryArray = index.cpMap;
        assert (nArray.length == entryArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            n = nArray[i];
            if (n < 0) continue;
            while (n >= arrayList.size()) {
                arrayList.add(null);
            }
            list = (ArrayList<Entry>)arrayList.get(n);
            if (list == null) {
                list = new ArrayList<Entry>();
                arrayList.set(n, (ArrayList<Entry>)list);
            }
            list.add(entryArray[i]);
        }
        Index[] indexArray = new Index[arrayList.size()];
        for (n = 0; n < indexArray.length; ++n) {
            list = (List)arrayList.get(n);
            if (list == null) continue;
            indexArray[n] = new Index(index.debugName + "/part#" + n, list);
            assert (indexArray[n].indexOf((Entry)list.get(0)) == 0);
        }
        return indexArray;
    }

    public static Index[] partitionByTag(Index index) {
        Entry[] entryArray = index.cpMap;
        int[] nArray = new int[entryArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            Entry entry = entryArray[i];
            nArray[i] = entry == null ? -1 : (int)entry.tag;
        }
        Index[] indexArray = ConstantPool.partition(index, nArray);
        for (int i = 0; i < indexArray.length; ++i) {
            if (indexArray[i] == null) continue;
            indexArray[i].debugName = ConstantPool.tagName(i);
        }
        if (indexArray.length < 19) {
            Index[] indexArray2 = new Index[19];
            System.arraycopy(indexArray, 0, indexArray2, 0, indexArray.length);
            indexArray = indexArray2;
        }
        return indexArray;
    }

    public static void completeReferencesIn(Set<Entry> set, boolean bl) {
        ConstantPool.completeReferencesIn(set, bl, null);
    }

    public static void completeReferencesIn(Set<Entry> set, boolean bl, List<BootstrapMethodEntry> list) {
        set.remove(null);
        ListIterator<Entry> listIterator = new ArrayList<Entry>(set).listIterator(set.size());
        while (listIterator.hasPrevious()) {
            Entry entry;
            Entry entry2;
            Entry entry3 = listIterator.previous();
            listIterator.remove();
            assert (entry3 != null);
            if (bl && entry3.tag == 13) {
                entry2 = (SignatureEntry)entry3;
                entry = entry2.asUtf8Entry();
                set.remove(entry2);
                set.add(entry);
                entry3 = entry;
            }
            if (list != null && entry3.tag == 17) {
                entry2 = (BootstrapMethodEntry)entry3;
                set.remove(entry2);
                if (!list.contains(entry2)) {
                    list.add((BootstrapMethodEntry)entry2);
                }
            }
            int n = 0;
            while ((entry = entry3.getRef(n)) != null) {
                if (set.add(entry)) {
                    listIterator.add(entry);
                }
                ++n;
            }
        }
    }

    static double percent(int n, int n2) {
        return (double)((int)(10000.0 * (double)n / (double)n2 + 0.5)) / 100.0;
    }

    public static String tagName(int n) {
        switch (n) {
            case 1: {
                return "Utf8";
            }
            case 3: {
                return "Integer";
            }
            case 4: {
                return "Float";
            }
            case 5: {
                return "Long";
            }
            case 6: {
                return "Double";
            }
            case 7: {
                return "Class";
            }
            case 8: {
                return "String";
            }
            case 9: {
                return "Fieldref";
            }
            case 10: {
                return "Methodref";
            }
            case 11: {
                return "InterfaceMethodref";
            }
            case 12: {
                return "NameandType";
            }
            case 15: {
                return "MethodHandle";
            }
            case 16: {
                return "MethodType";
            }
            case 18: {
                return "InvokeDynamic";
            }
            case 50: {
                return "**All";
            }
            case 0: {
                return "**None";
            }
            case 51: {
                return "**LoadableValue";
            }
            case 52: {
                return "**AnyMember";
            }
            case 53: {
                return "*FieldSpecific";
            }
            case 13: {
                return "*Signature";
            }
            case 17: {
                return "*BootstrapMethod";
            }
        }
        return "tag#" + n;
    }

    public static String refKindName(int n) {
        switch (n) {
            case 1: {
                return "getField";
            }
            case 2: {
                return "getStatic";
            }
            case 3: {
                return "putField";
            }
            case 4: {
                return "putStatic";
            }
            case 5: {
                return "invokeVirtual";
            }
            case 6: {
                return "invokeStatic";
            }
            case 7: {
                return "invokeSpecial";
            }
            case 8: {
                return "newInvokeSpecial";
            }
            case 9: {
                return "invokeInterface";
            }
        }
        return "refKind#" + n;
    }

    private static boolean verifyTagOrder(byte[] byArray) {
        int n = -1;
        for (byte by : byArray) {
            int n2 = TAG_ORDER[by];
            assert (n2 > 0) : "tag not found: " + by;
            assert (TAGS_IN_ORDER[n2 - 1] == by) : "tag repeated: " + by + " => " + n2 + " => " + TAGS_IN_ORDER[n2 - 1];
            assert (n < n2) : "tags not in order: " + Arrays.toString(byArray) + " at " + by;
            n = n2;
        }
        return true;
    }

    static {
        for (int i = 0; i < TAGS_IN_ORDER.length; ++i) {
            ConstantPool.TAG_ORDER[ConstantPool.TAGS_IN_ORDER[i]] = (byte)(i + 1);
        }
        NUMBER_TAGS = new byte[]{3, 4, 5, 6};
        EXTRA_TAGS = new byte[]{15, 16, 17, 18};
        LOADABLE_VALUE_TAGS = new byte[]{3, 4, 5, 6, 8, 7, 15, 16};
        ANY_MEMBER_TAGS = new byte[]{9, 10, 11};
        FIELD_SPECIFIC_TAGS = new byte[]{3, 4, 5, 6, 8};
        assert (ConstantPool.verifyTagOrder(TAGS_IN_ORDER) && ConstantPool.verifyTagOrder(NUMBER_TAGS) && ConstantPool.verifyTagOrder(EXTRA_TAGS) && ConstantPool.verifyTagOrder(LOADABLE_VALUE_TAGS) && ConstantPool.verifyTagOrder(ANY_MEMBER_TAGS) && ConstantPool.verifyTagOrder(FIELD_SPECIFIC_TAGS));
    }

    public static class BootstrapMethodEntry
    extends Entry {
        final MethodHandleEntry bsmRef;
        final Entry[] argRefs;

        @Override
        public Entry getRef(int n) {
            if (n == 0) {
                return this.bsmRef;
            }
            if (n - 1 < this.argRefs.length) {
                return this.argRefs[n - 1];
            }
            return null;
        }

        @Override
        protected int computeValueHash() {
            int n = this.bsmRef.hashCode();
            return Arrays.hashCode(this.argRefs) + (n << 8) ^ n;
        }

        BootstrapMethodEntry(MethodHandleEntry methodHandleEntry, Entry[] entryArray) {
            super((byte)17);
            this.bsmRef = methodHandleEntry;
            this.argRefs = (Entry[])entryArray.clone();
            this.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            if (object == null || object.getClass() != BootstrapMethodEntry.class) {
                return false;
            }
            BootstrapMethodEntry bootstrapMethodEntry = (BootstrapMethodEntry)object;
            return this.bsmRef.eq(bootstrapMethodEntry.bsmRef) && Arrays.equals(this.argRefs, bootstrapMethodEntry.argRefs);
        }

        @Override
        public int compareTo(Object object) {
            int n = this.superCompareTo(object);
            if (n == 0) {
                BootstrapMethodEntry bootstrapMethodEntry = (BootstrapMethodEntry)object;
                if (Utils.SORT_BSS_BSM_MAJOR) {
                    n = this.bsmRef.compareTo(bootstrapMethodEntry.bsmRef);
                }
                if (n == 0) {
                    n = BootstrapMethodEntry.compareArgArrays(this.argRefs, bootstrapMethodEntry.argRefs);
                }
                if (n == 0) {
                    n = this.bsmRef.compareTo(bootstrapMethodEntry.bsmRef);
                }
            }
            return n;
        }

        @Override
        public String stringValue() {
            return BootstrapMethodEntry.stringValueOf(this.bsmRef, this.argRefs);
        }

        static String stringValueOf(MethodHandleEntry methodHandleEntry, Entry[] entryArray) {
            StringBuffer stringBuffer = new StringBuffer(methodHandleEntry.stringValue());
            int n = 60;
            boolean bl = false;
            for (Entry entry : entryArray) {
                stringBuffer.append((char)n).append(entry.stringValue());
                n = 59;
            }
            if (n == 60) {
                stringBuffer.append((char)n);
            }
            stringBuffer.append('>');
            return stringBuffer.toString();
        }

        static int compareArgArrays(Entry[] entryArray, Entry[] entryArray2) {
            int n = entryArray.length - entryArray2.length;
            if (n != 0) {
                return n;
            }
            for (int i = 0; i < entryArray.length && (n = entryArray[i].compareTo(entryArray2[i])) == 0; ++i) {
            }
            return n;
        }
    }

    public static class ClassEntry
    extends Entry {
        final Utf8Entry ref;

        @Override
        public Entry getRef(int n) {
            return n == 0 ? this.ref : null;
        }

        @Override
        protected int computeValueHash() {
            return this.ref.hashCode() + this.tag;
        }

        ClassEntry(Entry entry) {
            super((byte)7);
            this.ref = (Utf8Entry)entry;
            this.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            return object != null && object.getClass() == ClassEntry.class && ((ClassEntry)object).ref.eq(this.ref);
        }

        @Override
        public int compareTo(Object object) {
            int n = this.superCompareTo(object);
            if (n == 0) {
                n = this.ref.compareTo(((ClassEntry)object).ref);
            }
            return n;
        }

        @Override
        public String stringValue() {
            return this.ref.stringValue();
        }
    }

    public static class DescriptorEntry
    extends Entry {
        final Utf8Entry nameRef;
        final SignatureEntry typeRef;

        @Override
        public Entry getRef(int n) {
            if (n == 0) {
                return this.nameRef;
            }
            if (n == 1) {
                return this.typeRef;
            }
            return null;
        }

        DescriptorEntry(Entry entry, Entry entry2) {
            super((byte)12);
            if (entry2 instanceof Utf8Entry) {
                entry2 = ConstantPool.getSignatureEntry(entry2.stringValue());
            }
            this.nameRef = (Utf8Entry)entry;
            this.typeRef = (SignatureEntry)entry2;
            this.hashCode();
        }

        @Override
        protected int computeValueHash() {
            int n = this.typeRef.hashCode();
            return this.nameRef.hashCode() + (n << 8) ^ n;
        }

        @Override
        public boolean equals(Object object) {
            if (object == null || object.getClass() != DescriptorEntry.class) {
                return false;
            }
            DescriptorEntry descriptorEntry = (DescriptorEntry)object;
            return this.nameRef.eq(descriptorEntry.nameRef) && this.typeRef.eq(descriptorEntry.typeRef);
        }

        @Override
        public int compareTo(Object object) {
            int n = this.superCompareTo(object);
            if (n == 0) {
                DescriptorEntry descriptorEntry = (DescriptorEntry)object;
                n = this.typeRef.compareTo(descriptorEntry.typeRef);
                if (n == 0) {
                    n = this.nameRef.compareTo(descriptorEntry.nameRef);
                }
            }
            return n;
        }

        @Override
        public String stringValue() {
            return DescriptorEntry.stringValueOf(this.nameRef, this.typeRef);
        }

        static String stringValueOf(Entry entry, Entry entry2) {
            return ConstantPool.qualifiedStringValue(entry2, entry);
        }

        public String prettyString() {
            return this.nameRef.stringValue() + this.typeRef.prettyString();
        }

        public boolean isMethod() {
            return this.typeRef.isMethod();
        }

        public byte getLiteralTag() {
            return this.typeRef.getLiteralTag();
        }
    }

    public static abstract class Entry
    implements Comparable<Object> {
        protected final byte tag;
        protected int valueHash;

        protected Entry(byte by) {
            this.tag = by;
        }

        public final byte getTag() {
            return this.tag;
        }

        public final boolean tagEquals(int n) {
            return this.getTag() == n;
        }

        public Entry getRef(int n) {
            return null;
        }

        public boolean eq(Entry entry) {
            assert (entry != null);
            return this == entry || this.equals(entry);
        }

        public abstract boolean equals(Object var1);

        public final int hashCode() {
            if (this.valueHash == 0) {
                this.valueHash = this.computeValueHash();
                if (this.valueHash == 0) {
                    this.valueHash = 1;
                }
            }
            return this.valueHash;
        }

        protected abstract int computeValueHash();

        @Override
        public abstract int compareTo(Object var1);

        protected int superCompareTo(Object object) {
            Entry entry = (Entry)object;
            if (this.tag != entry.tag) {
                return TAG_ORDER[this.tag] - TAG_ORDER[entry.tag];
            }
            return 0;
        }

        public final boolean isDoubleWord() {
            return this.tag == 6 || this.tag == 5;
        }

        public final boolean tagMatches(int n) {
            byte[] byArray;
            if (this.tag == n) {
                return true;
            }
            switch (n) {
                case 50: {
                    return true;
                }
                case 13: {
                    return this.tag == 1;
                }
                case 51: {
                    byArray = LOADABLE_VALUE_TAGS;
                    break;
                }
                case 52: {
                    byArray = ANY_MEMBER_TAGS;
                    break;
                }
                case 53: {
                    byArray = FIELD_SPECIFIC_TAGS;
                    break;
                }
                default: {
                    return false;
                }
            }
            for (byte by : byArray) {
                if (by != this.tag) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            String string = this.stringValue();
            if (ConstantPool.verbose() > 4) {
                if (this.valueHash != 0) {
                    string = string + " hash=" + this.valueHash;
                }
                string = string + " id=" + System.identityHashCode(this);
            }
            return ConstantPool.tagName(this.tag) + "=" + string;
        }

        public abstract String stringValue();
    }

    public static final class Index
    extends AbstractList<Entry> {
        protected String debugName;
        protected Entry[] cpMap;
        protected boolean flattenSigs;
        protected Entry[] indexKey;
        protected int[] indexValue;

        protected Entry[] getMap() {
            return this.cpMap;
        }

        protected Index(String string) {
            this.debugName = string;
        }

        protected Index(String string, Entry[] entryArray) {
            this(string);
            this.setMap(entryArray);
        }

        protected void setMap(Entry[] entryArray) {
            this.clearIndex();
            this.cpMap = entryArray;
        }

        protected Index(String string, Collection<Entry> collection) {
            this(string);
            this.setMap(collection);
        }

        protected void setMap(Collection<Entry> collection) {
            this.cpMap = new Entry[collection.size()];
            collection.toArray(this.cpMap);
            this.setMap(this.cpMap);
        }

        @Override
        public int size() {
            return this.cpMap.length;
        }

        @Override
        public Entry get(int n) {
            return this.cpMap[n];
        }

        public Entry getEntry(int n) {
            return this.cpMap[n];
        }

        private int findIndexOf(Entry entry) {
            int n;
            if (this.indexKey == null) {
                this.initializeIndex();
            }
            if (this.indexKey[n = this.findIndexLocation(entry)] != entry) {
                if (this.flattenSigs && entry.tag == 13) {
                    SignatureEntry signatureEntry = (SignatureEntry)entry;
                    return this.findIndexOf(signatureEntry.asUtf8Entry());
                }
                return -1;
            }
            int n2 = this.indexValue[n];
            assert (entry.equals(this.cpMap[n2]));
            return n2;
        }

        public boolean contains(Entry entry) {
            return this.findIndexOf(entry) >= 0;
        }

        public int indexOf(Entry entry) {
            int n = this.findIndexOf(entry);
            if (n < 0 && ConstantPool.verbose() > 0) {
                System.out.println("not found: " + entry);
                System.out.println("       in: " + this.dumpString());
                Thread.dumpStack();
            }
            assert (n >= 0);
            return n;
        }

        public int lastIndexOf(Entry entry) {
            return this.indexOf(entry);
        }

        public boolean assertIsSorted() {
            for (int i = 1; i < this.cpMap.length; ++i) {
                if (this.cpMap[i - 1].compareTo(this.cpMap[i]) <= 0) continue;
                System.out.println("Not sorted at " + (i - 1) + "/" + i + ": " + this.dumpString());
                return false;
            }
            return true;
        }

        protected void clearIndex() {
            this.indexKey = null;
            this.indexValue = null;
        }

        private int findIndexLocation(Entry entry) {
            int n = this.indexKey.length;
            int n2 = entry.hashCode();
            int n3 = n2 & n - 1;
            int n4 = (n2 >>> 8 | 1) & n - 1;
            Entry entry2;
            while ((entry2 = this.indexKey[n3]) != entry && entry2 != null) {
                if ((n3 += n4) < n) continue;
                n3 -= n;
            }
            return n3;
        }

        private void initializeIndex() {
            int n;
            if (ConstantPool.verbose() > 2) {
                System.out.println("initialize Index " + this.debugName + " [" + this.size() + "]");
            }
            int n2 = (int)((double)(this.cpMap.length + 10) * 1.5);
            for (n = 1; n < n2; n <<= 1) {
            }
            this.indexKey = new Entry[n];
            this.indexValue = new int[n];
            for (int i = 0; i < this.cpMap.length; ++i) {
                Entry entry = this.cpMap[i];
                if (entry == null) continue;
                int n3 = this.findIndexLocation(entry);
                assert (this.indexKey[n3] == null);
                this.indexKey[n3] = entry;
                this.indexValue[n3] = i;
            }
        }

        public Entry[] toArray(Entry[] entryArray) {
            int n = this.size();
            if (entryArray.length < n) {
                return super.toArray(entryArray);
            }
            System.arraycopy(this.cpMap, 0, entryArray, 0, n);
            if (entryArray.length > n) {
                entryArray[n] = null;
            }
            return entryArray;
        }

        public Entry[] toArray() {
            return this.toArray(new Entry[this.size()]);
        }

        public Object clone() {
            return new Index(this.debugName, (Entry[])this.cpMap.clone());
        }

        @Override
        public String toString() {
            return "Index " + this.debugName + " [" + this.size() + "]";
        }

        public String dumpString() {
            String string = this.toString();
            string = string + " {\n";
            for (int i = 0; i < this.cpMap.length; ++i) {
                string = string + "    " + i + ": " + this.cpMap[i] + "\n";
            }
            string = string + "}";
            return string;
        }
    }

    public static class IndexGroup {
        private Index[] indexByTag = new Index[19];
        private Index[] indexByTagGroup;
        private int[] untypedFirstIndexByTag;
        private int totalSizeQQ;
        private Index[][] indexByTagAndClass;

        private Index makeTagGroupIndex(byte by, byte[] byArray) {
            if (this.indexByTagGroup == null) {
                this.indexByTagGroup = new Index[4];
            }
            int n = by - 50;
            assert (this.indexByTagGroup[n] == null);
            int n2 = 0;
            Entry[] entryArray = null;
            for (int i = 1; i <= 2; ++i) {
                this.untypedIndexOf(null);
                for (byte by2 : byArray) {
                    int n3;
                    Index index = this.indexByTag[by2];
                    if (index == null || (n3 = index.cpMap.length) == 0) continue;
                    assert (by != 50 ? n2 < this.untypedFirstIndexByTag[by2] : n2 == this.untypedFirstIndexByTag[by2]);
                    if (entryArray != null) {
                        assert (entryArray[n2] == null);
                        assert (entryArray[n2 + n3 - 1] == null);
                        System.arraycopy(index.cpMap, 0, entryArray, n2, n3);
                    }
                    n2 += n3;
                }
                if (entryArray != null) continue;
                assert (i == 1);
                entryArray = new Entry[n2];
                n2 = 0;
            }
            this.indexByTagGroup[n] = new Index(ConstantPool.tagName(by), entryArray);
            return this.indexByTagGroup[n];
        }

        public int untypedIndexOf(Entry entry) {
            int n;
            int n2;
            if (this.untypedFirstIndexByTag == null) {
                this.untypedFirstIndexByTag = new int[20];
                n2 = 0;
                for (int i = 0; i < TAGS_IN_ORDER.length; ++i) {
                    n = TAGS_IN_ORDER[i];
                    Index index = this.indexByTag[n];
                    if (index == null) continue;
                    int n3 = index.cpMap.length;
                    this.untypedFirstIndexByTag[n] = n2;
                    n2 += n3;
                }
                this.untypedFirstIndexByTag[19] = n2;
            }
            if (entry == null) {
                return -1;
            }
            n2 = entry.tag;
            Index index = this.indexByTag[n2];
            if (index == null) {
                return -1;
            }
            n = index.findIndexOf(entry);
            if (n >= 0) {
                n += this.untypedFirstIndexByTag[n2];
            }
            return n;
        }

        public void initIndexByTag(byte by, Index index) {
            assert (this.indexByTag[by] == null);
            Entry[] entryArray = index.cpMap;
            for (int i = 0; i < entryArray.length; ++i) {
                assert (entryArray[i].tag == by);
            }
            if (by == 1) assert (entryArray.length == 0 || entryArray[0].stringValue().equals(""));
            this.indexByTag[by] = index;
            this.untypedFirstIndexByTag = null;
            this.indexByTagGroup = null;
            if (this.indexByTagAndClass != null) {
                this.indexByTagAndClass[by] = null;
            }
        }

        public Index getIndexByTag(byte by) {
            if (by >= 50) {
                return this.getIndexByTagGroup(by);
            }
            Index index = this.indexByTag[by];
            if (index == null) {
                this.indexByTag[by] = index = new Index(ConstantPool.tagName(by), new Entry[0]);
            }
            return index;
        }

        private Index getIndexByTagGroup(byte by) {
            Index index;
            if (this.indexByTagGroup != null && (index = this.indexByTagGroup[by - 50]) != null) {
                return index;
            }
            switch (by) {
                case 50: {
                    return this.makeTagGroupIndex((byte)50, TAGS_IN_ORDER);
                }
                case 51: {
                    return this.makeTagGroupIndex((byte)51, LOADABLE_VALUE_TAGS);
                }
                case 52: {
                    return this.makeTagGroupIndex((byte)52, ANY_MEMBER_TAGS);
                }
                case 53: {
                    return null;
                }
            }
            throw new AssertionError((Object)("bad tag group " + by));
        }

        public Index getMemberIndex(byte by, ClassEntry classEntry) {
            if (classEntry == null) {
                throw new RuntimeException("missing class reference for " + ConstantPool.tagName(by));
            }
            if (this.indexByTagAndClass == null) {
                this.indexByTagAndClass = new Index[19][];
            }
            Index index = this.getIndexByTag((byte)7);
            Index[] indexArray = this.indexByTagAndClass[by];
            if (indexArray == null) {
                int n;
                Index index2 = this.getIndexByTag(by);
                int[] nArray = new int[index2.size()];
                for (n = 0; n < nArray.length; ++n) {
                    int n2;
                    MemberEntry memberEntry = (MemberEntry)index2.get(n);
                    nArray[n] = n2 = index.indexOf(memberEntry.classRef);
                }
                indexArray = ConstantPool.partition(index2, nArray);
                for (n = 0; n < indexArray.length; ++n) {
                    assert (indexArray[n] == null || indexArray[n].assertIsSorted());
                }
                this.indexByTagAndClass[by] = indexArray;
            }
            int n = index.indexOf(classEntry);
            return indexArray[n];
        }

        public int getOverloadingIndex(MemberEntry memberEntry) {
            Index index = this.getMemberIndex(memberEntry.tag, memberEntry.classRef);
            Utf8Entry utf8Entry = memberEntry.descRef.nameRef;
            int n = 0;
            for (int i = 0; i < index.cpMap.length; ++i) {
                MemberEntry memberEntry2 = (MemberEntry)index.cpMap[i];
                if (memberEntry2.equals(memberEntry)) {
                    return n;
                }
                if (!memberEntry2.descRef.nameRef.equals(utf8Entry)) continue;
                ++n;
            }
            throw new RuntimeException("should not reach here");
        }

        public MemberEntry getOverloadingForIndex(byte by, ClassEntry classEntry, String string, int n) {
            assert (string.equals(string.intern()));
            Index index = this.getMemberIndex(by, classEntry);
            int n2 = 0;
            for (int i = 0; i < index.cpMap.length; ++i) {
                MemberEntry memberEntry = (MemberEntry)index.cpMap[i];
                if (!memberEntry.descRef.nameRef.stringValue().equals(string)) continue;
                if (n2 == n) {
                    return memberEntry;
                }
                ++n2;
            }
            throw new RuntimeException("should not reach here");
        }

        public boolean haveNumbers() {
            for (byte by : NUMBER_TAGS) {
                if (this.getIndexByTag(by).size() <= 0) continue;
                return true;
            }
            return false;
        }

        public boolean haveExtraTags() {
            for (byte by : EXTRA_TAGS) {
                if (this.getIndexByTag(by).size() <= 0) continue;
                return true;
            }
            return false;
        }
    }

    public static class InvokeDynamicEntry
    extends Entry {
        final BootstrapMethodEntry bssRef;
        final DescriptorEntry descRef;

        @Override
        public Entry getRef(int n) {
            if (n == 0) {
                return this.bssRef;
            }
            if (n == 1) {
                return this.descRef;
            }
            return null;
        }

        @Override
        protected int computeValueHash() {
            int n = this.descRef.hashCode();
            return this.bssRef.hashCode() + (n << 8) ^ n;
        }

        InvokeDynamicEntry(BootstrapMethodEntry bootstrapMethodEntry, DescriptorEntry descriptorEntry) {
            super((byte)18);
            this.bssRef = bootstrapMethodEntry;
            this.descRef = descriptorEntry;
            this.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            if (object == null || object.getClass() != InvokeDynamicEntry.class) {
                return false;
            }
            InvokeDynamicEntry invokeDynamicEntry = (InvokeDynamicEntry)object;
            return this.bssRef.eq(invokeDynamicEntry.bssRef) && this.descRef.eq(invokeDynamicEntry.descRef);
        }

        @Override
        public int compareTo(Object object) {
            int n = this.superCompareTo(object);
            if (n == 0) {
                InvokeDynamicEntry invokeDynamicEntry = (InvokeDynamicEntry)object;
                if (Utils.SORT_INDY_BSS_MAJOR) {
                    n = this.bssRef.compareTo(invokeDynamicEntry.bssRef);
                }
                if (n == 0) {
                    n = this.descRef.compareTo(invokeDynamicEntry.descRef);
                }
                if (n == 0) {
                    n = this.bssRef.compareTo(invokeDynamicEntry.bssRef);
                }
            }
            return n;
        }

        @Override
        public String stringValue() {
            return InvokeDynamicEntry.stringValueOf(this.bssRef, this.descRef);
        }

        static String stringValueOf(BootstrapMethodEntry bootstrapMethodEntry, DescriptorEntry descriptorEntry) {
            return "Indy:" + bootstrapMethodEntry.stringValue() + "." + descriptorEntry.stringValue();
        }
    }

    public static abstract class LiteralEntry
    extends Entry {
        protected LiteralEntry(byte by) {
            super(by);
        }

        public abstract Comparable<?> literalValue();
    }

    public static class MemberEntry
    extends Entry {
        final ClassEntry classRef;
        final DescriptorEntry descRef;

        @Override
        public Entry getRef(int n) {
            if (n == 0) {
                return this.classRef;
            }
            if (n == 1) {
                return this.descRef;
            }
            return null;
        }

        @Override
        protected int computeValueHash() {
            int n = this.descRef.hashCode();
            return this.classRef.hashCode() + (n << 8) ^ n;
        }

        MemberEntry(byte by, ClassEntry classEntry, DescriptorEntry descriptorEntry) {
            super(by);
            assert (ConstantPool.isMemberTag(by));
            this.classRef = classEntry;
            this.descRef = descriptorEntry;
            this.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            if (object == null || object.getClass() != MemberEntry.class) {
                return false;
            }
            MemberEntry memberEntry = (MemberEntry)object;
            return this.classRef.eq(memberEntry.classRef) && this.descRef.eq(memberEntry.descRef);
        }

        @Override
        public int compareTo(Object object) {
            int n = this.superCompareTo(object);
            if (n == 0) {
                MemberEntry memberEntry = (MemberEntry)object;
                if (Utils.SORT_MEMBERS_DESCR_MAJOR) {
                    n = this.descRef.compareTo(memberEntry.descRef);
                }
                if (n == 0) {
                    n = this.classRef.compareTo(memberEntry.classRef);
                }
                if (n == 0) {
                    n = this.descRef.compareTo(memberEntry.descRef);
                }
            }
            return n;
        }

        @Override
        public String stringValue() {
            return MemberEntry.stringValueOf(this.tag, this.classRef, this.descRef);
        }

        static String stringValueOf(byte by, ClassEntry classEntry, DescriptorEntry descriptorEntry) {
            String string;
            assert (ConstantPool.isMemberTag(by));
            switch (by) {
                case 9: {
                    string = "Field:";
                    break;
                }
                case 10: {
                    string = "Method:";
                    break;
                }
                case 11: {
                    string = "IMethod:";
                    break;
                }
                default: {
                    string = by + "???";
                }
            }
            return string + ConstantPool.qualifiedStringValue(classEntry, descriptorEntry);
        }

        public boolean isMethod() {
            return this.descRef.isMethod();
        }
    }

    public static class MethodHandleEntry
    extends Entry {
        final int refKind;
        final MemberEntry memRef;

        @Override
        public Entry getRef(int n) {
            return n == 0 ? this.memRef : null;
        }

        @Override
        protected int computeValueHash() {
            int n = this.refKind;
            return this.memRef.hashCode() + (n << 8) ^ n;
        }

        MethodHandleEntry(byte by, MemberEntry memberEntry) {
            super((byte)15);
            assert (ConstantPool.isRefKind(by));
            this.refKind = by;
            this.memRef = memberEntry;
            this.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            if (object == null || object.getClass() != MethodHandleEntry.class) {
                return false;
            }
            MethodHandleEntry methodHandleEntry = (MethodHandleEntry)object;
            return this.refKind == methodHandleEntry.refKind && this.memRef.eq(methodHandleEntry.memRef);
        }

        @Override
        public int compareTo(Object object) {
            int n = this.superCompareTo(object);
            if (n == 0) {
                MethodHandleEntry methodHandleEntry = (MethodHandleEntry)object;
                if (Utils.SORT_HANDLES_KIND_MAJOR) {
                    n = this.refKind - methodHandleEntry.refKind;
                }
                if (n == 0) {
                    n = this.memRef.compareTo(methodHandleEntry.memRef);
                }
                if (n == 0) {
                    n = this.refKind - methodHandleEntry.refKind;
                }
            }
            return n;
        }

        public static String stringValueOf(int n, MemberEntry memberEntry) {
            return ConstantPool.refKindName(n) + ":" + memberEntry.stringValue();
        }

        @Override
        public String stringValue() {
            return MethodHandleEntry.stringValueOf(this.refKind, this.memRef);
        }
    }

    public static class MethodTypeEntry
    extends Entry {
        final SignatureEntry typeRef;

        @Override
        public Entry getRef(int n) {
            return n == 0 ? this.typeRef : null;
        }

        @Override
        protected int computeValueHash() {
            return this.typeRef.hashCode() + this.tag;
        }

        MethodTypeEntry(SignatureEntry signatureEntry) {
            super((byte)16);
            this.typeRef = signatureEntry;
            this.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            if (object == null || object.getClass() != MethodTypeEntry.class) {
                return false;
            }
            MethodTypeEntry methodTypeEntry = (MethodTypeEntry)object;
            return this.typeRef.eq(methodTypeEntry.typeRef);
        }

        @Override
        public int compareTo(Object object) {
            int n = this.superCompareTo(object);
            if (n == 0) {
                MethodTypeEntry methodTypeEntry = (MethodTypeEntry)object;
                n = this.typeRef.compareTo(methodTypeEntry.typeRef);
            }
            return n;
        }

        @Override
        public String stringValue() {
            return this.typeRef.stringValue();
        }
    }

    public static class NumberEntry
    extends LiteralEntry {
        final Number value;

        NumberEntry(Number number) {
            super(ConstantPool.numberTagOf(number));
            this.value = number;
            this.hashCode();
        }

        @Override
        protected int computeValueHash() {
            return this.value.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            return object != null && object.getClass() == NumberEntry.class && ((NumberEntry)object).value.equals(this.value);
        }

        @Override
        public int compareTo(Object object) {
            int n = this.superCompareTo(object);
            if (n == 0) {
                Comparable comparable = (Comparable)((Object)this.value);
                n = comparable.compareTo(((NumberEntry)object).value);
            }
            return n;
        }

        public Number numberValue() {
            return this.value;
        }

        @Override
        public Comparable<?> literalValue() {
            return (Comparable)((Object)this.value);
        }

        @Override
        public String stringValue() {
            return this.value.toString();
        }
    }

    public static class SignatureEntry
    extends Entry {
        final Utf8Entry formRef;
        final ClassEntry[] classRefs;
        String value;
        Utf8Entry asUtf8Entry;

        @Override
        public Entry getRef(int n) {
            if (n == 0) {
                return this.formRef;
            }
            return n - 1 < this.classRefs.length ? this.classRefs[n - 1] : null;
        }

        SignatureEntry(String string) {
            super((byte)13);
            this.value = string = string.intern();
            String[] stringArray = ConstantPool.structureSignature(string);
            this.formRef = ConstantPool.getUtf8Entry(stringArray[0]);
            this.classRefs = new ClassEntry[stringArray.length - 1];
            for (int i = 1; i < stringArray.length; ++i) {
                this.classRefs[i - 1] = ConstantPool.getClassEntry(stringArray[i]);
            }
            this.hashCode();
        }

        @Override
        protected int computeValueHash() {
            this.stringValue();
            return this.value.hashCode() + this.tag;
        }

        public Utf8Entry asUtf8Entry() {
            if (this.asUtf8Entry == null) {
                this.asUtf8Entry = ConstantPool.getUtf8Entry(this.stringValue());
            }
            return this.asUtf8Entry;
        }

        @Override
        public boolean equals(Object object) {
            return object != null && object.getClass() == SignatureEntry.class && ((SignatureEntry)object).value.equals(this.value);
        }

        @Override
        public int compareTo(Object object) {
            int n = this.superCompareTo(object);
            if (n == 0) {
                SignatureEntry signatureEntry = (SignatureEntry)object;
                n = ConstantPool.compareSignatures(this.value, signatureEntry.value);
            }
            return n;
        }

        @Override
        public String stringValue() {
            if (this.value == null) {
                this.value = SignatureEntry.stringValueOf(this.formRef, this.classRefs);
            }
            return this.value;
        }

        static String stringValueOf(Utf8Entry utf8Entry, ClassEntry[] classEntryArray) {
            String[] stringArray = new String[1 + classEntryArray.length];
            stringArray[0] = utf8Entry.stringValue();
            for (int i = 1; i < stringArray.length; ++i) {
                stringArray[i] = classEntryArray[i - 1].stringValue();
            }
            return ConstantPool.flattenSignature(stringArray).intern();
        }

        public int computeSize(boolean bl) {
            String string = this.formRef.stringValue();
            int n = 0;
            int n2 = 1;
            if (this.isMethod()) {
                n = 1;
                n2 = string.indexOf(41);
            }
            int n3 = 0;
            block5: for (int i = n; i < n2; ++i) {
                switch (string.charAt(i)) {
                    case 'D': 
                    case 'J': {
                        if (!bl) break;
                        ++n3;
                        break;
                    }
                    case '[': {
                        while (string.charAt(i) == '[') {
                            ++i;
                        }
                        break;
                    }
                    case ';': {
                        continue block5;
                    }
                    default: {
                        assert (0 <= "BSCIJFDZLV([".indexOf(string.charAt(i)));
                        break;
                    }
                }
                ++n3;
            }
            return n3;
        }

        public boolean isMethod() {
            return this.formRef.stringValue().charAt(0) == '(';
        }

        public byte getLiteralTag() {
            switch (this.formRef.stringValue().charAt(0)) {
                case 'I': {
                    return 3;
                }
                case 'J': {
                    return 5;
                }
                case 'F': {
                    return 4;
                }
                case 'D': {
                    return 6;
                }
                case 'B': 
                case 'C': 
                case 'S': 
                case 'Z': {
                    return 3;
                }
                case 'L': {
                    return 8;
                }
            }
            assert (false);
            return 0;
        }

        public String prettyString() {
            int n;
            String string;
            if (this.isMethod()) {
                string = this.formRef.stringValue();
                string = string.substring(0, 1 + string.indexOf(41));
            } else {
                string = "/" + this.formRef.stringValue();
            }
            while ((n = string.indexOf(59)) >= 0) {
                string = string.substring(0, n) + string.substring(n + 1);
            }
            return string;
        }
    }

    public static class StringEntry
    extends LiteralEntry {
        final Utf8Entry ref;

        @Override
        public Entry getRef(int n) {
            return n == 0 ? this.ref : null;
        }

        StringEntry(Entry entry) {
            super((byte)8);
            this.ref = (Utf8Entry)entry;
            this.hashCode();
        }

        @Override
        protected int computeValueHash() {
            return this.ref.hashCode() + this.tag;
        }

        @Override
        public boolean equals(Object object) {
            return object != null && object.getClass() == StringEntry.class && ((StringEntry)object).ref.eq(this.ref);
        }

        @Override
        public int compareTo(Object object) {
            int n = this.superCompareTo(object);
            if (n == 0) {
                n = this.ref.compareTo(((StringEntry)object).ref);
            }
            return n;
        }

        @Override
        public Comparable<?> literalValue() {
            return this.ref.stringValue();
        }

        @Override
        public String stringValue() {
            return this.ref.stringValue();
        }
    }

    public static class Utf8Entry
    extends Entry {
        final String value;

        Utf8Entry(String string) {
            super((byte)1);
            this.value = string.intern();
            this.hashCode();
        }

        @Override
        protected int computeValueHash() {
            return this.value.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            return object != null && object.getClass() == Utf8Entry.class && ((Utf8Entry)object).value.equals(this.value);
        }

        @Override
        public int compareTo(Object object) {
            int n = this.superCompareTo(object);
            if (n == 0) {
                n = this.value.compareTo(((Utf8Entry)object).value);
            }
            return n;
        }

        @Override
        public String stringValue() {
            return this.value;
        }
    }
}

