/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.tcp;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import sun.rmi.runtime.NewThreadAction;
import sun.rmi.transport.Connection;
import sun.rmi.transport.tcp.TCPTransport;

class ConnectionAcceptor
implements Runnable {
    private TCPTransport transport;
    private List<Connection> queue = new ArrayList<Connection>();
    private static int threadNum = 0;

    public ConnectionAcceptor(TCPTransport tCPTransport) {
        this.transport = tCPTransport;
    }

    public void startNewAcceptor() {
        Thread thread = AccessController.doPrivileged(new NewThreadAction(this, "Multiplex Accept-" + ++threadNum, true));
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(Connection connection) {
        List<Connection> list = this.queue;
        synchronized (list) {
            this.queue.add(connection);
            this.queue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Connection connection;
        List<Connection> list = this.queue;
        synchronized (list) {
            while (this.queue.size() == 0) {
                try {
                    this.queue.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.startNewAcceptor();
            connection = this.queue.remove(0);
        }
        this.transport.handleMessages(connection, true);
    }
}

