/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.Annotation;
import java.text.AttributeEntry;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIterator;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class AttributedString {
    private static final int ARRAY_SIZE_INCREMENT = 10;
    String text;
    int runArraySize;
    int runCount;
    int[] runStarts;
    Vector<AttributedCharacterIterator.Attribute>[] runAttributes;
    Vector<Object>[] runAttributeValues;

    AttributedString(AttributedCharacterIterator[] attributedCharacterIteratorArray) {
        if (attributedCharacterIteratorArray == null) {
            throw new NullPointerException("Iterators must not be null");
        }
        if (attributedCharacterIteratorArray.length == 0) {
            this.text = "";
        } else {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            for (n = 0; n < attributedCharacterIteratorArray.length; ++n) {
                this.appendContents(stringBuffer, attributedCharacterIteratorArray[n]);
            }
            this.text = stringBuffer.toString();
            if (!this.text.isEmpty()) {
                n = 0;
                Map<AttributedCharacterIterator.Attribute, Object> map = null;
                for (int i = 0; i < attributedCharacterIteratorArray.length; ++i) {
                    AttributedCharacterIterator attributedCharacterIterator = attributedCharacterIteratorArray[i];
                    int n2 = attributedCharacterIterator.getBeginIndex();
                    int n3 = attributedCharacterIterator.getEndIndex();
                    int n4 = n2;
                    while (n4 < n3) {
                        attributedCharacterIterator.setIndex(n4);
                        Map<AttributedCharacterIterator.Attribute, Object> map2 = attributedCharacterIterator.getAttributes();
                        if (AttributedString.mapsDiffer(map, map2)) {
                            this.setAttributes(map2, n4 - n2 + n);
                        }
                        map = map2;
                        n4 = attributedCharacterIterator.getRunLimit();
                    }
                    n += n3 - n2;
                }
            }
        }
    }

    public AttributedString(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.text = string;
    }

    public AttributedString(String string, Map<? extends AttributedCharacterIterator.Attribute, ?> map) {
        if (string == null || map == null) {
            throw new NullPointerException();
        }
        this.text = string;
        if (string.isEmpty()) {
            if (map.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException("Can't add attribute to 0-length text");
        }
        int n = map.size();
        if (n > 0) {
            this.createRunAttributeDataVectors();
            Vector<AttributedCharacterIterator.Attribute> vector = new Vector<AttributedCharacterIterator.Attribute>(n);
            Vector vector2 = new Vector(n);
            this.runAttributes[0] = vector;
            this.runAttributeValues[0] = vector2;
            for (Map.Entry<AttributedCharacterIterator.Attribute, ?> entry : map.entrySet()) {
                vector.addElement(entry.getKey());
                vector2.addElement(entry.getValue());
            }
        }
    }

    public AttributedString(AttributedCharacterIterator attributedCharacterIterator) {
        this(attributedCharacterIterator, attributedCharacterIterator.getBeginIndex(), attributedCharacterIterator.getEndIndex(), null);
    }

    public AttributedString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        this(attributedCharacterIterator, n, n2, null);
    }

    public AttributedString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2, AttributedCharacterIterator.Attribute[] attributeArray) {
        if (attributedCharacterIterator == null) {
            throw new NullPointerException();
        }
        int n3 = attributedCharacterIterator.getBeginIndex();
        int n4 = attributedCharacterIterator.getEndIndex();
        if (n < n3 || n2 > n4 || n > n2) {
            throw new IllegalArgumentException("Invalid substring range");
        }
        StringBuffer stringBuffer = new StringBuffer();
        attributedCharacterIterator.setIndex(n);
        char c = attributedCharacterIterator.current();
        while (attributedCharacterIterator.getIndex() < n2) {
            stringBuffer.append(c);
            c = attributedCharacterIterator.next();
        }
        this.text = stringBuffer.toString();
        if (n == n2) {
            return;
        }
        HashSet<AttributedCharacterIterator.Attribute> hashSet = new HashSet<AttributedCharacterIterator.Attribute>();
        if (attributeArray == null) {
            hashSet.addAll(attributedCharacterIterator.getAllAttributeKeys());
        } else {
            for (int i = 0; i < attributeArray.length; ++i) {
                hashSet.add(attributeArray[i]);
            }
            hashSet.retainAll(attributedCharacterIterator.getAllAttributeKeys());
        }
        if (hashSet.isEmpty()) {
            return;
        }
        block2: for (AttributedCharacterIterator.Attribute attribute : hashSet) {
            attributedCharacterIterator.setIndex(n3);
            while (attributedCharacterIterator.getIndex() < n2) {
                int n5 = attributedCharacterIterator.getRunStart(attribute);
                int n6 = attributedCharacterIterator.getRunLimit(attribute);
                Object object = attributedCharacterIterator.getAttribute(attribute);
                if (object != null) {
                    if (object instanceof Annotation) {
                        if (n5 >= n && n6 <= n2) {
                            this.addAttribute(attribute, object, n5 - n, n6 - n);
                        } else if (n6 > n2) {
                            continue block2;
                        }
                    } else {
                        if (n5 >= n2) continue block2;
                        if (n6 > n) {
                            if (n5 < n) {
                                n5 = n;
                            }
                            if (n6 > n2) {
                                n6 = n2;
                            }
                            if (n5 != n6) {
                                this.addAttribute(attribute, object, n5 - n, n6 - n);
                            }
                        }
                    }
                }
                attributedCharacterIterator.setIndex(n6);
            }
        }
    }

    public void addAttribute(AttributedCharacterIterator.Attribute attribute, Object object) {
        if (attribute == null) {
            throw new NullPointerException();
        }
        int n = this.length();
        if (n == 0) {
            throw new IllegalArgumentException("Can't add attribute to 0-length text");
        }
        this.addAttributeImpl(attribute, object, 0, n);
    }

    public void addAttribute(AttributedCharacterIterator.Attribute attribute, Object object, int n, int n2) {
        if (attribute == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 > this.length() || n >= n2) {
            throw new IllegalArgumentException("Invalid substring range");
        }
        this.addAttributeImpl(attribute, object, n, n2);
    }

    public void addAttributes(Map<? extends AttributedCharacterIterator.Attribute, ?> map, int n, int n2) {
        if (map == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 > this.length() || n > n2) {
            throw new IllegalArgumentException("Invalid substring range");
        }
        if (n == n2) {
            if (map.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException("Can't add attribute to 0-length text");
        }
        if (this.runCount == 0) {
            this.createRunAttributeDataVectors();
        }
        int n3 = this.ensureRunBreak(n);
        int n4 = this.ensureRunBreak(n2);
        for (Map.Entry<AttributedCharacterIterator.Attribute, ?> entry : map.entrySet()) {
            this.addAttributeRunData(entry.getKey(), entry.getValue(), n3, n4);
        }
    }

    private synchronized void addAttributeImpl(AttributedCharacterIterator.Attribute attribute, Object object, int n, int n2) {
        if (this.runCount == 0) {
            this.createRunAttributeDataVectors();
        }
        int n3 = this.ensureRunBreak(n);
        int n4 = this.ensureRunBreak(n2);
        this.addAttributeRunData(attribute, object, n3, n4);
    }

    private final void createRunAttributeDataVectors() {
        int[] nArray = new int[10];
        Vector[] vectorArray = new Vector[10];
        Vector[] vectorArray2 = new Vector[10];
        this.runStarts = nArray;
        this.runAttributes = vectorArray;
        this.runAttributeValues = vectorArray2;
        this.runArraySize = 10;
        this.runCount = 1;
    }

    private final int ensureRunBreak(int n) {
        return this.ensureRunBreak(n, true);
    }

    private final int ensureRunBreak(int n, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        int n2;
        if (n == this.length()) {
            return this.runCount;
        }
        for (n2 = 0; n2 < this.runCount && this.runStarts[n2] < n; ++n2) {
        }
        if (n2 < this.runCount && this.runStarts[n2] == n) {
            return n2;
        }
        if (this.runCount == this.runArraySize) {
            int n3 = this.runArraySize + 10;
            object3 = new int[n3];
            object2 = new Vector[n3];
            object = new Vector[n3];
            for (int i = 0; i < this.runArraySize; ++i) {
                object3[i] = this.runStarts[i];
                object2[i] = this.runAttributes[i];
                object[i] = this.runAttributeValues[i];
            }
            this.runStarts = object3;
            this.runAttributes = object2;
            this.runAttributeValues = object;
            this.runArraySize = n3;
        }
        Vector vector = null;
        object3 = null;
        if (bl) {
            object2 = this.runAttributes[n2 - 1];
            object = this.runAttributeValues[n2 - 1];
            if (object2 != null) {
                vector = new Vector(object2);
            }
            if (object != null) {
                object3 = new Vector(object);
            }
        }
        ++this.runCount;
        for (int i = this.runCount - 1; i > n2; --i) {
            this.runStarts[i] = this.runStarts[i - 1];
            this.runAttributes[i] = this.runAttributes[i - 1];
            this.runAttributeValues[i] = this.runAttributeValues[i - 1];
        }
        this.runStarts[n2] = n;
        this.runAttributes[n2] = vector;
        this.runAttributeValues[n2] = object3;
        return n2;
    }

    private void addAttributeRunData(AttributedCharacterIterator.Attribute attribute, Object object, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            int n3 = -1;
            if (this.runAttributes[i] == null) {
                Vector vector = new Vector();
                Vector vector2 = new Vector();
                this.runAttributes[i] = vector;
                this.runAttributeValues[i] = vector2;
            } else {
                n3 = this.runAttributes[i].indexOf(attribute);
            }
            if (n3 == -1) {
                int n4 = this.runAttributes[i].size();
                this.runAttributes[i].addElement(attribute);
                try {
                    this.runAttributeValues[i].addElement(object);
                }
                catch (Exception exception) {
                    this.runAttributes[i].setSize(n4);
                    this.runAttributeValues[i].setSize(n4);
                }
                continue;
            }
            this.runAttributeValues[i].set(n3, object);
        }
    }

    public AttributedCharacterIterator getIterator() {
        return this.getIterator(null, 0, this.length());
    }

    public AttributedCharacterIterator getIterator(AttributedCharacterIterator.Attribute[] attributeArray) {
        return this.getIterator(attributeArray, 0, this.length());
    }

    public AttributedCharacterIterator getIterator(AttributedCharacterIterator.Attribute[] attributeArray, int n, int n2) {
        return new AttributedStringIterator(attributeArray, n, n2);
    }

    int length() {
        return this.text.length();
    }

    private char charAt(int n) {
        return this.text.charAt(n);
    }

    private synchronized Object getAttribute(AttributedCharacterIterator.Attribute attribute, int n) {
        Vector<AttributedCharacterIterator.Attribute> vector = this.runAttributes[n];
        Vector<Object> vector2 = this.runAttributeValues[n];
        if (vector == null) {
            return null;
        }
        int n2 = vector.indexOf(attribute);
        if (n2 != -1) {
            return vector2.elementAt(n2);
        }
        return null;
    }

    private Object getAttributeCheckRange(AttributedCharacterIterator.Attribute attribute, int n, int n2, int n3) {
        Object object = this.getAttribute(attribute, n);
        if (object instanceof Annotation) {
            int n4;
            int n5;
            if (n2 > 0) {
                n5 = n;
                n4 = this.runStarts[n5];
                while (n4 >= n2 && AttributedString.valuesMatch(object, this.getAttribute(attribute, n5 - 1))) {
                    n4 = this.runStarts[--n5];
                }
                if (n4 < n2) {
                    return null;
                }
            }
            if (n3 < (n5 = this.length())) {
                int n6;
                n4 = n;
                int n7 = n6 = n4 < this.runCount - 1 ? this.runStarts[n4 + 1] : n5;
                while (n6 <= n3 && AttributedString.valuesMatch(object, this.getAttribute(attribute, n4 + 1))) {
                    n6 = ++n4 < this.runCount - 1 ? this.runStarts[n4 + 1] : n5;
                }
                if (n6 > n3) {
                    return null;
                }
            }
        }
        return object;
    }

    private boolean attributeValuesMatch(Set<? extends AttributedCharacterIterator.Attribute> set, int n, int n2) {
        for (AttributedCharacterIterator.Attribute attribute : set) {
            if (AttributedString.valuesMatch(this.getAttribute(attribute, n), this.getAttribute(attribute, n2))) continue;
            return false;
        }
        return true;
    }

    private static final boolean valuesMatch(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    private final void appendContents(StringBuffer stringBuffer, CharacterIterator characterIterator) {
        int n = characterIterator.getBeginIndex();
        int n2 = characterIterator.getEndIndex();
        while (n < n2) {
            characterIterator.setIndex(n++);
            stringBuffer.append(characterIterator.current());
        }
    }

    private void setAttributes(Map<AttributedCharacterIterator.Attribute, Object> map, int n) {
        int n2;
        if (this.runCount == 0) {
            this.createRunAttributeDataVectors();
        }
        int n3 = this.ensureRunBreak(n, false);
        if (map != null && (n2 = map.size()) > 0) {
            Vector<AttributedCharacterIterator.Attribute> vector = new Vector<AttributedCharacterIterator.Attribute>(n2);
            Vector<Object> vector2 = new Vector<Object>(n2);
            for (Map.Entry<AttributedCharacterIterator.Attribute, Object> entry : map.entrySet()) {
                vector.add(entry.getKey());
                vector2.add(entry.getValue());
            }
            this.runAttributes[n3] = vector;
            this.runAttributeValues[n3] = vector2;
        }
    }

    private static <K, V> boolean mapsDiffer(Map<K, V> map, Map<K, V> map2) {
        if (map == null) {
            return map2 != null && map2.size() > 0;
        }
        return !map.equals(map2);
    }

    private final class AttributeMap
    extends AbstractMap<AttributedCharacterIterator.Attribute, Object> {
        int runIndex;
        int beginIndex;
        int endIndex;

        AttributeMap(int n, int n2, int n3) {
            this.runIndex = n;
            this.beginIndex = n2;
            this.endIndex = n3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Map.Entry<AttributedCharacterIterator.Attribute, Object>> entrySet() {
            HashSet<Map.Entry<AttributedCharacterIterator.Attribute, Object>> hashSet = new HashSet<Map.Entry<AttributedCharacterIterator.Attribute, Object>>();
            AttributedString attributedString = AttributedString.this;
            synchronized (attributedString) {
                int n = AttributedString.this.runAttributes[this.runIndex].size();
                for (int i = 0; i < n; ++i) {
                    AttributedCharacterIterator.Attribute attribute = AttributedString.this.runAttributes[this.runIndex].get(i);
                    Object object = AttributedString.this.runAttributeValues[this.runIndex].get(i);
                    if (object instanceof Annotation && (object = AttributedString.this.getAttributeCheckRange(attribute, this.runIndex, this.beginIndex, this.endIndex)) == null) continue;
                    AttributeEntry attributeEntry = new AttributeEntry(attribute, object);
                    hashSet.add(attributeEntry);
                }
            }
            return hashSet;
        }

        @Override
        public Object get(Object object) {
            return AttributedString.this.getAttributeCheckRange((AttributedCharacterIterator.Attribute)object, this.runIndex, this.beginIndex, this.endIndex);
        }
    }

    private final class AttributedStringIterator
    implements AttributedCharacterIterator {
        private int beginIndex;
        private int endIndex;
        private AttributedCharacterIterator.Attribute[] relevantAttributes;
        private int currentIndex;
        private int currentRunIndex;
        private int currentRunStart;
        private int currentRunLimit;

        AttributedStringIterator(AttributedCharacterIterator.Attribute[] attributeArray, int n, int n2) {
            if (n < 0 || n > n2 || n2 > AttributedString.this.length()) {
                throw new IllegalArgumentException("Invalid substring range");
            }
            this.beginIndex = n;
            this.endIndex = n2;
            this.currentIndex = n;
            this.updateRunInfo();
            if (attributeArray != null) {
                this.relevantAttributes = (AttributedCharacterIterator.Attribute[])attributeArray.clone();
            }
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof AttributedStringIterator)) {
                return false;
            }
            AttributedStringIterator attributedStringIterator = (AttributedStringIterator)object;
            if (AttributedString.this != attributedStringIterator.getString()) {
                return false;
            }
            return this.currentIndex == attributedStringIterator.currentIndex && this.beginIndex == attributedStringIterator.beginIndex && this.endIndex == attributedStringIterator.endIndex;
        }

        public int hashCode() {
            return AttributedString.this.text.hashCode() ^ this.currentIndex ^ this.beginIndex ^ this.endIndex;
        }

        @Override
        public Object clone() {
            try {
                AttributedStringIterator attributedStringIterator = (AttributedStringIterator)super.clone();
                return attributedStringIterator;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError(cloneNotSupportedException);
            }
        }

        @Override
        public char first() {
            return this.internalSetIndex(this.beginIndex);
        }

        @Override
        public char last() {
            if (this.endIndex == this.beginIndex) {
                return this.internalSetIndex(this.endIndex);
            }
            return this.internalSetIndex(this.endIndex - 1);
        }

        @Override
        public char current() {
            if (this.currentIndex == this.endIndex) {
                return '\uffff';
            }
            return AttributedString.this.charAt(this.currentIndex);
        }

        @Override
        public char next() {
            if (this.currentIndex < this.endIndex) {
                return this.internalSetIndex(this.currentIndex + 1);
            }
            return '\uffff';
        }

        @Override
        public char previous() {
            if (this.currentIndex > this.beginIndex) {
                return this.internalSetIndex(this.currentIndex - 1);
            }
            return '\uffff';
        }

        @Override
        public char setIndex(int n) {
            if (n < this.beginIndex || n > this.endIndex) {
                throw new IllegalArgumentException("Invalid index");
            }
            return this.internalSetIndex(n);
        }

        @Override
        public int getBeginIndex() {
            return this.beginIndex;
        }

        @Override
        public int getEndIndex() {
            return this.endIndex;
        }

        @Override
        public int getIndex() {
            return this.currentIndex;
        }

        @Override
        public int getRunStart() {
            return this.currentRunStart;
        }

        @Override
        public int getRunStart(AttributedCharacterIterator.Attribute attribute) {
            if (this.currentRunStart == this.beginIndex || this.currentRunIndex == -1) {
                return this.currentRunStart;
            }
            Object object = this.getAttribute(attribute);
            int n = this.currentRunStart;
            int n2 = this.currentRunIndex;
            while (n > this.beginIndex && AttributedString.valuesMatch(object, AttributedString.this.getAttribute(attribute, n2 - 1))) {
                n = AttributedString.this.runStarts[--n2];
            }
            if (n < this.beginIndex) {
                n = this.beginIndex;
            }
            return n;
        }

        @Override
        public int getRunStart(Set<? extends AttributedCharacterIterator.Attribute> set) {
            if (this.currentRunStart == this.beginIndex || this.currentRunIndex == -1) {
                return this.currentRunStart;
            }
            int n = this.currentRunStart;
            int n2 = this.currentRunIndex;
            while (n > this.beginIndex && AttributedString.this.attributeValuesMatch(set, this.currentRunIndex, n2 - 1)) {
                n = AttributedString.this.runStarts[--n2];
            }
            if (n < this.beginIndex) {
                n = this.beginIndex;
            }
            return n;
        }

        @Override
        public int getRunLimit() {
            return this.currentRunLimit;
        }

        @Override
        public int getRunLimit(AttributedCharacterIterator.Attribute attribute) {
            if (this.currentRunLimit == this.endIndex || this.currentRunIndex == -1) {
                return this.currentRunLimit;
            }
            Object object = this.getAttribute(attribute);
            int n = this.currentRunLimit;
            int n2 = this.currentRunIndex;
            while (n < this.endIndex && AttributedString.valuesMatch(object, AttributedString.this.getAttribute(attribute, n2 + 1))) {
                n = ++n2 < AttributedString.this.runCount - 1 ? AttributedString.this.runStarts[n2 + 1] : this.endIndex;
            }
            if (n > this.endIndex) {
                n = this.endIndex;
            }
            return n;
        }

        @Override
        public int getRunLimit(Set<? extends AttributedCharacterIterator.Attribute> set) {
            if (this.currentRunLimit == this.endIndex || this.currentRunIndex == -1) {
                return this.currentRunLimit;
            }
            int n = this.currentRunLimit;
            int n2 = this.currentRunIndex;
            while (n < this.endIndex && AttributedString.this.attributeValuesMatch(set, this.currentRunIndex, n2 + 1)) {
                n = ++n2 < AttributedString.this.runCount - 1 ? AttributedString.this.runStarts[n2 + 1] : this.endIndex;
            }
            if (n > this.endIndex) {
                n = this.endIndex;
            }
            return n;
        }

        @Override
        public Map<AttributedCharacterIterator.Attribute, Object> getAttributes() {
            if (AttributedString.this.runAttributes == null || this.currentRunIndex == -1 || AttributedString.this.runAttributes[this.currentRunIndex] == null) {
                return new Hashtable<AttributedCharacterIterator.Attribute, Object>();
            }
            return new AttributeMap(this.currentRunIndex, this.beginIndex, this.endIndex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<AttributedCharacterIterator.Attribute> getAllAttributeKeys() {
            if (AttributedString.this.runAttributes == null) {
                return new HashSet<AttributedCharacterIterator.Attribute>();
            }
            AttributedString attributedString = AttributedString.this;
            synchronized (attributedString) {
                HashSet<AttributedCharacterIterator.Attribute> hashSet = new HashSet<AttributedCharacterIterator.Attribute>();
                for (int i = 0; i < AttributedString.this.runCount; ++i) {
                    Vector<AttributedCharacterIterator.Attribute> vector;
                    if (AttributedString.this.runStarts[i] >= this.endIndex || i != AttributedString.this.runCount - 1 && AttributedString.this.runStarts[i + 1] <= this.beginIndex || (vector = AttributedString.this.runAttributes[i]) == null) continue;
                    int n = vector.size();
                    while (n-- > 0) {
                        hashSet.add(vector.get(n));
                    }
                }
                return hashSet;
            }
        }

        @Override
        public Object getAttribute(AttributedCharacterIterator.Attribute attribute) {
            int n = this.currentRunIndex;
            if (n < 0) {
                return null;
            }
            return AttributedString.this.getAttributeCheckRange(attribute, n, this.beginIndex, this.endIndex);
        }

        private AttributedString getString() {
            return AttributedString.this;
        }

        private char internalSetIndex(int n) {
            this.currentIndex = n;
            if (n < this.currentRunStart || n >= this.currentRunLimit) {
                this.updateRunInfo();
            }
            if (this.currentIndex == this.endIndex) {
                return '\uffff';
            }
            return AttributedString.this.charAt(n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateRunInfo() {
            if (this.currentIndex == this.endIndex) {
                this.currentRunStart = this.currentRunLimit = this.endIndex;
                this.currentRunIndex = -1;
            } else {
                AttributedString attributedString = AttributedString.this;
                synchronized (attributedString) {
                    int n;
                    for (n = -1; n < AttributedString.this.runCount - 1 && AttributedString.this.runStarts[n + 1] <= this.currentIndex; ++n) {
                    }
                    this.currentRunIndex = n;
                    if (n >= 0) {
                        this.currentRunStart = AttributedString.this.runStarts[n];
                        if (this.currentRunStart < this.beginIndex) {
                            this.currentRunStart = this.beginIndex;
                        }
                    } else {
                        this.currentRunStart = this.beginIndex;
                    }
                    if (n < AttributedString.this.runCount - 1) {
                        this.currentRunLimit = AttributedString.this.runStarts[n + 1];
                        if (this.currentRunLimit > this.endIndex) {
                            this.currentRunLimit = this.endIndex;
                        }
                    } else {
                        this.currentRunLimit = this.endIndex;
                    }
                }
            }
        }
    }
}

