/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.InnerClass;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class InnerClasses
extends Attribute {
    private InnerClass[] innerClasses;

    public InnerClasses(InnerClasses innerClasses) {
        this(innerClasses.getNameIndex(), innerClasses.getLength(), innerClasses.getInnerClasses(), innerClasses.getConstantPool());
    }

    public InnerClasses(int n, int n2, InnerClass[] innerClassArray, ConstantPool constantPool) {
        super((byte)6, n, n2, constantPool);
        this.innerClasses = innerClassArray != null ? innerClassArray : new InnerClass[]{};
    }

    InnerClasses(int n, int n2, DataInput dataInput, ConstantPool constantPool) throws IOException {
        this(n, n2, (InnerClass[])null, constantPool);
        int n3 = dataInput.readUnsignedShort();
        this.innerClasses = new InnerClass[n3];
        for (int i = 0; i < n3; ++i) {
            this.innerClasses[i] = new InnerClass(dataInput);
        }
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitInnerClasses(this);
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.innerClasses.length);
        for (InnerClass innerClass : this.innerClasses) {
            innerClass.dump(dataOutputStream);
        }
    }

    public InnerClass[] getInnerClasses() {
        return this.innerClasses;
    }

    public void setInnerClasses(InnerClass[] innerClassArray) {
        this.innerClasses = innerClassArray != null ? innerClassArray : new InnerClass[]{};
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("InnerClasses(");
        stringBuilder.append(this.innerClasses.length);
        stringBuilder.append("):\n");
        for (InnerClass innerClass : this.innerClasses) {
            stringBuilder.append(innerClass.toString(super.getConstantPool())).append("\n");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        InnerClasses innerClasses = (InnerClasses)this.clone();
        innerClasses.innerClasses = new InnerClass[this.innerClasses.length];
        for (int i = 0; i < this.innerClasses.length; ++i) {
            innerClasses.innerClasses[i] = this.innerClasses[i].copy();
        }
        innerClasses.setConstantPool(constantPool);
        return innerClasses;
    }
}

