/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AudioFloatInputStream;
import com.sun.media.sound.SoftAbstractResampler;
import com.sun.media.sound.SoftAudioBuffer;
import com.sun.media.sound.SoftCubicResampler;
import com.sun.media.sound.SoftLanczosResampler;
import com.sun.media.sound.SoftLinearResampler;
import com.sun.media.sound.SoftLinearResampler2;
import com.sun.media.sound.SoftMixingMixer;
import com.sun.media.sound.SoftPointResampler;
import com.sun.media.sound.SoftSincResampler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;

public abstract class SoftMixingDataLine
implements DataLine {
    public static final FloatControl.Type CHORUS_SEND = new FloatControl.Type("Chorus Send"){};
    private final Gain gain_control = new Gain();
    private final Mute mute_control = new Mute();
    private final Balance balance_control = new Balance();
    private final Pan pan_control = new Pan();
    private final ReverbSend reverbsend_control = new ReverbSend();
    private final ChorusSend chorussend_control = new ChorusSend();
    private final ApplyReverb apply_reverb = new ApplyReverb();
    private final Control[] controls;
    float leftgain = 1.0f;
    float rightgain = 1.0f;
    float eff1gain = 0.0f;
    float eff2gain = 0.0f;
    List<LineListener> listeners = new ArrayList<LineListener>();
    final Object control_mutex;
    SoftMixingMixer mixer;
    DataLine.Info info;

    protected abstract void processControlLogic();

    protected abstract void processAudioLogic(SoftAudioBuffer[] var1);

    SoftMixingDataLine(SoftMixingMixer softMixingMixer, DataLine.Info info) {
        this.mixer = softMixingMixer;
        this.info = info;
        this.control_mutex = softMixingMixer.control_mutex;
        this.controls = new Control[]{this.gain_control, this.mute_control, this.balance_control, this.pan_control, this.reverbsend_control, this.chorussend_control, this.apply_reverb};
        this.calcVolume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void calcVolume() {
        Object object = this.control_mutex;
        synchronized (object) {
            double d = Math.pow(10.0, (double)this.gain_control.getValue() / 20.0);
            if (this.mute_control.getValue()) {
                d = 0.0;
            }
            this.leftgain = (float)d;
            this.rightgain = (float)d;
            if (this.mixer.getFormat().getChannels() > 1) {
                double d2 = this.balance_control.getValue();
                if (d2 > 0.0) {
                    this.leftgain = (float)((double)this.leftgain * (1.0 - d2));
                } else {
                    this.rightgain = (float)((double)this.rightgain * (1.0 + d2));
                }
            }
        }
        this.eff1gain = (float)Math.pow(10.0, (double)this.reverbsend_control.getValue() / 20.0);
        this.eff2gain = (float)Math.pow(10.0, (double)this.chorussend_control.getValue() / 20.0);
        if (!this.apply_reverb.getValue()) {
            this.eff1gain = 0.0f;
        }
    }

    final void sendEvent(LineEvent lineEvent) {
        LineListener[] lineListenerArray;
        if (this.listeners.size() == 0) {
            return;
        }
        for (LineListener lineListener : lineListenerArray = this.listeners.toArray(new LineListener[this.listeners.size()])) {
            lineListener.update(lineEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addLineListener(LineListener lineListener) {
        Object object = this.control_mutex;
        synchronized (object) {
            this.listeners.add(lineListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeLineListener(LineListener lineListener) {
        Object object = this.control_mutex;
        synchronized (object) {
            this.listeners.add(lineListener);
        }
    }

    @Override
    public final Line.Info getLineInfo() {
        return this.info;
    }

    @Override
    public final Control getControl(Control.Type type) {
        if (type != null) {
            for (int i = 0; i < this.controls.length; ++i) {
                if (this.controls[i].getType() != type) continue;
                return this.controls[i];
            }
        }
        throw new IllegalArgumentException("Unsupported control type : " + type);
    }

    @Override
    public final Control[] getControls() {
        return Arrays.copyOf(this.controls, this.controls.length);
    }

    @Override
    public final boolean isControlSupported(Control.Type type) {
        if (type != null) {
            for (int i = 0; i < this.controls.length; ++i) {
                if (this.controls[i].getType() != type) continue;
                return true;
            }
        }
        return false;
    }

    private final class ApplyReverb
    extends BooleanControl {
        private ApplyReverb() {
            super(BooleanControl.Type.APPLY_REVERB, false, "True", "False");
        }

        @Override
        public void setValue(boolean bl) {
            super.setValue(bl);
            SoftMixingDataLine.this.calcVolume();
        }
    }

    protected static final class AudioFloatInputStreamResampler
    extends AudioFloatInputStream {
        private final AudioFloatInputStream ais;
        private final AudioFormat targetFormat;
        private float[] skipbuffer;
        private SoftAbstractResampler resampler;
        private final float[] pitch = new float[1];
        private final float[] ibuffer2;
        private final float[][] ibuffer;
        private float ibuffer_index = 0.0f;
        private int ibuffer_len = 0;
        private int nrofchannels = 0;
        private float[][] cbuffer;
        private final int buffer_len = 512;
        private final int pad;
        private final int pad2;
        private final float[] ix = new float[1];
        private final int[] ox = new int[1];
        private float[][] mark_ibuffer = null;
        private float mark_ibuffer_index = 0.0f;
        private int mark_ibuffer_len = 0;

        public AudioFloatInputStreamResampler(AudioFloatInputStream audioFloatInputStream, AudioFormat audioFormat) {
            this.ais = audioFloatInputStream;
            AudioFormat audioFormat2 = audioFloatInputStream.getFormat();
            this.targetFormat = new AudioFormat(audioFormat2.getEncoding(), audioFormat.getSampleRate(), audioFormat2.getSampleSizeInBits(), audioFormat2.getChannels(), audioFormat2.getFrameSize(), audioFormat.getSampleRate(), audioFormat2.isBigEndian());
            this.nrofchannels = this.targetFormat.getChannels();
            Object object = audioFormat.getProperty("interpolation");
            if (object != null && object instanceof String) {
                String string = (String)object;
                if (string.equalsIgnoreCase("point")) {
                    this.resampler = new SoftPointResampler();
                }
                if (string.equalsIgnoreCase("linear")) {
                    this.resampler = new SoftLinearResampler2();
                }
                if (string.equalsIgnoreCase("linear1")) {
                    this.resampler = new SoftLinearResampler();
                }
                if (string.equalsIgnoreCase("linear2")) {
                    this.resampler = new SoftLinearResampler2();
                }
                if (string.equalsIgnoreCase("cubic")) {
                    this.resampler = new SoftCubicResampler();
                }
                if (string.equalsIgnoreCase("lanczos")) {
                    this.resampler = new SoftLanczosResampler();
                }
                if (string.equalsIgnoreCase("sinc")) {
                    this.resampler = new SoftSincResampler();
                }
            }
            if (this.resampler == null) {
                this.resampler = new SoftLinearResampler2();
            }
            this.pitch[0] = audioFormat2.getSampleRate() / audioFormat.getSampleRate();
            this.pad = this.resampler.getPadding();
            this.pad2 = this.pad * 2;
            this.ibuffer = new float[this.nrofchannels][512 + this.pad2];
            this.ibuffer2 = new float[this.nrofchannels * 512];
            this.ibuffer_index = 512 + this.pad;
            this.ibuffer_len = 512;
        }

        @Override
        public int available() throws IOException {
            return 0;
        }

        @Override
        public void close() throws IOException {
            this.ais.close();
        }

        @Override
        public AudioFormat getFormat() {
            return this.targetFormat;
        }

        @Override
        public long getFrameLength() {
            return -1L;
        }

        @Override
        public void mark(int n) {
            this.ais.mark((int)((float)n * this.pitch[0]));
            this.mark_ibuffer_index = this.ibuffer_index;
            this.mark_ibuffer_len = this.ibuffer_len;
            if (this.mark_ibuffer == null) {
                this.mark_ibuffer = new float[this.ibuffer.length][this.ibuffer[0].length];
            }
            for (int i = 0; i < this.ibuffer.length; ++i) {
                float[] fArray = this.ibuffer[i];
                float[] fArray2 = this.mark_ibuffer[i];
                for (int j = 0; j < fArray2.length; ++j) {
                    fArray2[j] = fArray[j];
                }
            }
        }

        @Override
        public boolean markSupported() {
            return this.ais.markSupported();
        }

        private void readNextBuffer() throws IOException {
            int n;
            int n2;
            int n3;
            if (this.ibuffer_len == -1) {
                return;
            }
            for (n3 = 0; n3 < this.nrofchannels; ++n3) {
                float[] fArray = this.ibuffer[n3];
                int n4 = this.ibuffer_len + this.pad2;
                n2 = this.ibuffer_len;
                n = 0;
                while (n2 < n4) {
                    fArray[n] = fArray[n2];
                    ++n2;
                    ++n;
                }
            }
            this.ibuffer_index -= (float)this.ibuffer_len;
            this.ibuffer_len = this.ais.read(this.ibuffer2);
            if (this.ibuffer_len >= 0) {
                while (this.ibuffer_len < this.ibuffer2.length && (n3 = this.ais.read(this.ibuffer2, this.ibuffer_len, this.ibuffer2.length - this.ibuffer_len)) != -1) {
                    this.ibuffer_len += n3;
                }
                Arrays.fill(this.ibuffer2, this.ibuffer_len, this.ibuffer2.length, 0.0f);
                this.ibuffer_len /= this.nrofchannels;
            } else {
                Arrays.fill(this.ibuffer2, 0, this.ibuffer2.length, 0.0f);
            }
            n3 = this.ibuffer2.length;
            for (int i = 0; i < this.nrofchannels; ++i) {
                float[] fArray = this.ibuffer[i];
                n2 = i;
                n = this.pad2;
                while (n2 < n3) {
                    fArray[n] = this.ibuffer2[n2];
                    n2 += this.nrofchannels;
                    ++n;
                }
            }
        }

        @Override
        public int read(float[] fArray, int n, int n2) throws IOException {
            float[] fArray2;
            int n3;
            int n4;
            int n5;
            if (this.cbuffer == null || this.cbuffer[0].length < n2 / this.nrofchannels) {
                this.cbuffer = new float[this.nrofchannels][n2 / this.nrofchannels];
            }
            if (this.ibuffer_len == -1) {
                return -1;
            }
            if (n2 < 0) {
                return 0;
            }
            int n6 = 0;
            int n7 = this.ibuffer_len;
            for (n4 = n2 / this.nrofchannels; n4 > 0; n4 -= n6 - n5) {
                if (this.ibuffer_len >= 0) {
                    if (this.ibuffer_index >= (float)(this.ibuffer_len + this.pad)) {
                        this.readNextBuffer();
                    }
                    n7 = this.ibuffer_len + this.pad;
                }
                if (this.ibuffer_len < 0 && this.ibuffer_index >= (float)(n7 = this.pad2) || this.ibuffer_index < 0.0f) break;
                n5 = n6;
                for (n3 = 0; n3 < this.nrofchannels; ++n3) {
                    this.ix[0] = this.ibuffer_index;
                    this.ox[0] = n6;
                    fArray2 = this.ibuffer[n3];
                    this.resampler.interpolate(fArray2, this.ix, n7, this.pitch, 0.0f, this.cbuffer[n3], this.ox, n2 / this.nrofchannels);
                }
                this.ibuffer_index = this.ix[0];
                n6 = this.ox[0];
            }
            for (n5 = 0; n5 < this.nrofchannels; ++n5) {
                n3 = 0;
                fArray2 = this.cbuffer[n5];
                for (int i = n5; i < fArray.length; i += this.nrofchannels) {
                    fArray[i] = fArray2[n3++];
                }
            }
            return n2 - n4 * this.nrofchannels;
        }

        @Override
        public void reset() throws IOException {
            this.ais.reset();
            if (this.mark_ibuffer == null) {
                return;
            }
            this.ibuffer_index = this.mark_ibuffer_index;
            this.ibuffer_len = this.mark_ibuffer_len;
            for (int i = 0; i < this.ibuffer.length; ++i) {
                float[] fArray = this.mark_ibuffer[i];
                float[] fArray2 = this.ibuffer[i];
                for (int j = 0; j < fArray2.length; ++j) {
                    fArray2[j] = fArray[j];
                }
            }
        }

        @Override
        public long skip(long l) throws IOException {
            long l2;
            int n;
            if (l > 0L) {
                return 0L;
            }
            if (this.skipbuffer == null) {
                this.skipbuffer = new float[1024 * this.targetFormat.getFrameSize()];
            }
            float[] fArray = this.skipbuffer;
            for (l2 = l; l2 > 0L; l2 -= (long)n) {
                n = this.read(fArray, 0, (int)Math.min(l2, (long)this.skipbuffer.length));
                if (n >= 0) continue;
                if (l2 != l) break;
                return n;
            }
            return l - l2;
        }
    }

    private final class Balance
    extends FloatControl {
        private Balance() {
            super(FloatControl.Type.BALANCE, -1.0f, 1.0f, 0.0078125f, -1, 0.0f, "", "Left", "Center", "Right");
        }

        @Override
        public void setValue(float f) {
            super.setValue(f);
            SoftMixingDataLine.this.calcVolume();
        }
    }

    private final class ChorusSend
    extends FloatControl {
        private ChorusSend() {
            super(CHORUS_SEND, -80.0f, 6.0206f, 0.625f, -1, -80.0f, "dB", "Minimum", "", "Maximum");
        }

        @Override
        public void setValue(float f) {
            super.setValue(f);
            SoftMixingDataLine.this.balance_control.setValue(f);
        }
    }

    private final class Gain
    extends FloatControl {
        private Gain() {
            super(FloatControl.Type.MASTER_GAIN, -80.0f, 6.0206f, 0.625f, -1, 0.0f, "dB", "Minimum", "", "Maximum");
        }

        @Override
        public void setValue(float f) {
            super.setValue(f);
            SoftMixingDataLine.this.calcVolume();
        }
    }

    private final class Mute
    extends BooleanControl {
        private Mute() {
            super(BooleanControl.Type.MUTE, false, "True", "False");
        }

        @Override
        public void setValue(boolean bl) {
            super.setValue(bl);
            SoftMixingDataLine.this.calcVolume();
        }
    }

    private final class Pan
    extends FloatControl {
        private Pan() {
            super(FloatControl.Type.PAN, -1.0f, 1.0f, 0.0078125f, -1, 0.0f, "", "Left", "Center", "Right");
        }

        @Override
        public void setValue(float f) {
            super.setValue(f);
            SoftMixingDataLine.this.balance_control.setValue(f);
        }

        @Override
        public float getValue() {
            return SoftMixingDataLine.this.balance_control.getValue();
        }
    }

    private final class ReverbSend
    extends FloatControl {
        private ReverbSend() {
            super(FloatControl.Type.REVERB_SEND, -80.0f, 6.0206f, 0.625f, -1, -80.0f, "dB", "Minimum", "", "Maximum");
        }

        @Override
        public void setValue(float f) {
            super.setValue(f);
            SoftMixingDataLine.this.balance_control.setValue(f);
        }
    }
}

