/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.resource.internal.inst;

import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import jdk.internal.instrumentation.InstrumentationMethod;
import jdk.internal.instrumentation.InstrumentationTarget;
import jdk.management.resource.ResourceRequest;
import jdk.management.resource.ResourceRequestDeniedException;
import jdk.management.resource.internal.ApproverGroup;
import jdk.management.resource.internal.ResourceIdImpl;

@InstrumentationTarget(value="sun.nio.ch.FileChannelImpl")
public final class FileChannelImplRMHooks {
    private final FileDescriptor fd = null;
    private String path = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public static FileChannel open(FileDescriptor fileDescriptor, String string, boolean bl, boolean bl2, Object object) {
        long l = 0L;
        int n = 0;
        FileChannel fileChannel = null;
        ResourceIdImpl resourceIdImpl = null;
        ResourceRequest resourceRequest = null;
        try {
            fileChannel = FileChannelImplRMHooks.open(fileDescriptor, string, bl, bl2, object);
            resourceIdImpl = ResourceIdImpl.of(string);
            resourceRequest = ApproverGroup.FILE_OPEN_GROUP.getApprover(fileChannel);
            boolean bl3 = false;
            try {
                l = resourceRequest.request(1L, resourceIdImpl);
                if (l < 1L) {
                    throw new ResourceRequestDeniedException(string + ": resource limited: too many open files");
                }
                bl3 = true;
            }
            finally {
                if (!bl3) {
                    try {
                        fileChannel.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            n = 1;
        }
        finally {
            if (resourceRequest != null) {
                resourceRequest.request(-(l - (long)n), resourceIdImpl);
            }
        }
        return fileChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public static FileChannel open(FileDescriptor fileDescriptor, String string, boolean bl, boolean bl2, boolean bl3, Object object) {
        FileChannel fileChannel = FileChannelImplRMHooks.open(fileDescriptor, string, bl, bl2, bl3, object);
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(string);
        ResourceRequest resourceRequest = null;
        long l = 0L;
        boolean bl4 = false;
        if (object == null) {
            resourceRequest = ApproverGroup.FILEDESCRIPTOR_OPEN_GROUP.getApprover(fileDescriptor);
            try {
                l = resourceRequest.request(1L, resourceIdImpl);
                if (l < 1L) {
                    throw new ResourceRequestDeniedException(string + ": resource limited: too many open file descriptors");
                }
                bl4 = true;
            }
            finally {
                if (!bl4) {
                    resourceRequest.request(-1L, resourceIdImpl);
                    try {
                        fileChannel.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        bl4 = false;
        resourceRequest = ApproverGroup.FILE_OPEN_GROUP.getApprover(fileChannel);
        try {
            l = resourceRequest.request(1L, resourceIdImpl);
            if (l < 1L) {
                try {
                    fileChannel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new ResourceRequestDeniedException(string + ": resource limited: too many open files");
            }
            bl4 = true;
        }
        finally {
            if (!bl4) {
                resourceRequest.request(-1L, resourceIdImpl);
                try {
                    fileChannel.close();
                }
                catch (IOException iOException) {}
            }
        }
        return fileChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public int read(ByteBuffer byteBuffer) throws IOException {
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.path);
        ResourceRequest resourceRequest = ApproverGroup.FILE_READ_GROUP.getApprover(this);
        long l = 0L;
        int n = byteBuffer.remaining();
        try {
            l = Math.max(resourceRequest.request(n, resourceIdImpl), 0L);
            if (l < (long)n) {
                throw new IOException("Resource limited: insufficient bytes approved");
            }
        }
        catch (ResourceRequestDeniedException resourceRequestDeniedException) {
            throw new IOException("Resource limited", resourceRequestDeniedException);
        }
        int n2 = 0;
        int n3 = 0;
        try {
            n3 = this.read(byteBuffer);
            n2 = Math.max(n3, 0);
        }
        finally {
            resourceRequest.request(-(l - (long)n2), resourceIdImpl);
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n > byteBufferArray.length - n2) {
            return this.read(byteBufferArray, n, n2);
        }
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.path);
        ResourceRequest resourceRequest = ApproverGroup.FILE_READ_GROUP.getApprover(this);
        long l = 0L;
        int n3 = 0;
        int n4 = n + n2;
        for (int i = n; i < n4; ++i) {
            n3 += byteBufferArray[i].remaining();
        }
        try {
            l = Math.max(resourceRequest.request(n3, resourceIdImpl), 0L);
            if (l < (long)n3) {
                throw new IOException("Resource limited: insufficient bytes approved");
            }
        }
        catch (ResourceRequestDeniedException resourceRequestDeniedException) {
            throw new IOException("Resource limited", resourceRequestDeniedException);
        }
        long l2 = 0L;
        long l3 = 0L;
        try {
            l3 = this.read(byteBufferArray, n, n2);
            l2 = Math.max(l3, 0L);
        }
        finally {
            resourceRequest.request(-(l - l2), resourceIdImpl);
        }
        return l3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public int read(ByteBuffer byteBuffer, long l) throws IOException {
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.path);
        ResourceRequest resourceRequest = ApproverGroup.FILE_READ_GROUP.getApprover(this);
        long l2 = 0L;
        int n = byteBuffer.remaining();
        try {
            l2 = Math.max(resourceRequest.request(n, resourceIdImpl), 0L);
            if (l2 < (long)n) {
                throw new IOException("Resource limited: insufficient bytes approved");
            }
        }
        catch (ResourceRequestDeniedException resourceRequestDeniedException) {
            throw new IOException("Resource limited", resourceRequestDeniedException);
        }
        int n2 = 0;
        int n3 = 0;
        try {
            n3 = this.read(byteBuffer, l);
            n2 = Math.max(n3, 0);
        }
        finally {
            resourceRequest.request(-(l2 - (long)n2), resourceIdImpl);
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public int write(ByteBuffer byteBuffer) throws IOException {
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.path);
        ResourceRequest resourceRequest = ApproverGroup.FILE_WRITE_GROUP.getApprover(this);
        long l = 0L;
        int n = byteBuffer.remaining();
        try {
            l = Math.max(resourceRequest.request(n, resourceIdImpl), 0L);
            if (l < (long)n) {
                throw new IOException("Resource limited: insufficient bytes approved");
            }
        }
        catch (ResourceRequestDeniedException resourceRequestDeniedException) {
            throw new IOException("Resource limited", resourceRequestDeniedException);
        }
        int n2 = 0;
        try {
            n2 = this.write(byteBuffer);
        }
        finally {
            resourceRequest.request(-(l - (long)n2), resourceIdImpl);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n > byteBufferArray.length - n2) {
            return this.write(byteBufferArray, n, n2);
        }
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.path);
        ResourceRequest resourceRequest = ApproverGroup.FILE_WRITE_GROUP.getApprover(this);
        long l = 0L;
        int n3 = 0;
        int n4 = n + n2;
        for (int i = n; i < n4; ++i) {
            n3 += byteBufferArray[i].remaining();
        }
        try {
            l = Math.max(resourceRequest.request(n3, resourceIdImpl), 0L);
            if (l < (long)n3) {
                throw new IOException("Resource limited: insufficient bytes approved");
            }
        }
        catch (ResourceRequestDeniedException resourceRequestDeniedException) {
            throw new IOException("Resource limited", resourceRequestDeniedException);
        }
        long l2 = 0L;
        try {
            l2 = Math.max(this.write(byteBufferArray, n, n2), 0L);
        }
        finally {
            resourceRequest.request(-(l - l2), resourceIdImpl);
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public int write(ByteBuffer byteBuffer, long l) throws IOException {
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.path);
        ResourceRequest resourceRequest = ApproverGroup.FILE_WRITE_GROUP.getApprover(this);
        long l2 = 0L;
        int n = byteBuffer.remaining();
        try {
            l2 = Math.max(resourceRequest.request(n, resourceIdImpl), 0L);
            if (l2 < (long)n) {
                throw new IOException("Resource limited: insufficient bytes approved");
            }
        }
        catch (ResourceRequestDeniedException resourceRequestDeniedException) {
            throw new IOException("Resource limited", resourceRequestDeniedException);
        }
        int n2 = 0;
        try {
            n2 = this.write(byteBuffer, l);
        }
        finally {
            resourceRequest.request(-(l2 - (long)n2), resourceIdImpl);
        }
        return n2;
    }

    @InstrumentationMethod
    protected void implCloseChannel() throws IOException {
        try {
            this.implCloseChannel();
        }
        finally {
            ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.path);
            ResourceRequest resourceRequest = ApproverGroup.FILEDESCRIPTOR_OPEN_GROUP.getApprover(this.fd);
            resourceRequest.request(-1L, resourceIdImpl);
            resourceRequest = ApproverGroup.FILE_OPEN_GROUP.getApprover(this);
            resourceRequest.request(-1L, resourceIdImpl);
        }
    }
}

