/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.stream;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.SecuritySupport;

class FactoryFinder {
    private static final String DEFAULT_PACKAGE = "com.sun.xml.internal.";
    private static boolean debug = false;
    private static final Properties cacheProps = new Properties();
    private static volatile boolean firstTime = true;
    private static final SecuritySupport ss = new SecuritySupport();

    FactoryFinder() {
    }

    private static void dPrint(String string) {
        if (debug) {
            System.err.println("JAXP: " + string);
        }
    }

    private static Class getProviderClass(String string, ClassLoader classLoader, boolean bl, boolean bl2) throws ClassNotFoundException {
        try {
            if (classLoader == null) {
                if (bl2) {
                    return Class.forName(string, false, FactoryFinder.class.getClassLoader());
                }
                classLoader = ss.getContextClassLoader();
                if (classLoader == null) {
                    throw new ClassNotFoundException();
                }
                return Class.forName(string, false, classLoader);
            }
            return Class.forName(string, false, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (bl) {
                return Class.forName(string, false, FactoryFinder.class.getClassLoader());
            }
            throw classNotFoundException;
        }
    }

    static <T> T newInstance(Class<T> clazz, String string, ClassLoader classLoader, boolean bl) throws FactoryConfigurationError {
        return FactoryFinder.newInstance(clazz, string, classLoader, bl, false);
    }

    static <T> T newInstance(Class<T> clazz, String string, ClassLoader classLoader, boolean bl, boolean bl2) throws FactoryConfigurationError {
        assert (clazz != null);
        if (System.getSecurityManager() != null && string != null && string.startsWith(DEFAULT_PACKAGE)) {
            classLoader = null;
            bl2 = true;
        }
        try {
            Class clazz2 = FactoryFinder.getProviderClass(string, classLoader, bl, bl2);
            if (!clazz.isAssignableFrom(clazz2)) {
                throw new ClassCastException(string + " cannot be cast to " + clazz.getName());
            }
            Object t = clazz2.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (debug) {
                FactoryFinder.dPrint("created new instance of " + clazz2 + " using ClassLoader: " + classLoader);
            }
            return clazz.cast(t);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new FactoryConfigurationError("Provider " + string + " not found", classNotFoundException);
        }
        catch (Exception exception) {
            throw new FactoryConfigurationError("Provider " + string + " could not be instantiated: " + exception, exception);
        }
    }

    static <T> T find(Class<T> clazz, String string) throws FactoryConfigurationError {
        return FactoryFinder.find(clazz, clazz.getName(), null, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> T find(Class<T> clazz, String string, ClassLoader classLoader, String string2) throws FactoryConfigurationError {
        Object object;
        block19: {
            String string3;
            FactoryFinder.dPrint("find factoryId =" + string);
            try {
                string3 = clazz.getName().equals(string) ? ss.getSystemProperty(string) : System.getProperty(string);
                if (string3 != null) {
                    FactoryFinder.dPrint("found system property, value=" + string3);
                    return FactoryFinder.newInstance(clazz, string3, classLoader, true);
                }
            }
            catch (SecurityException securityException) {
                throw new FactoryConfigurationError("Failed to read factoryId '" + string + "'", securityException);
            }
            string3 = null;
            try {
                if (firstTime) {
                    object = cacheProps;
                    synchronized (object) {
                        if (firstTime) {
                            string3 = ss.getSystemProperty("java.home") + File.separator + "lib" + File.separator + "stax.properties";
                            File file = new File(string3);
                            firstTime = false;
                            if (ss.doesFileExist(file)) {
                                FactoryFinder.dPrint("Read properties file " + file);
                                cacheProps.load(ss.getFileInputStream(file));
                            } else {
                                string3 = ss.getSystemProperty("java.home") + File.separator + "lib" + File.separator + "jaxp.properties";
                                file = new File(string3);
                                if (ss.doesFileExist(file)) {
                                    FactoryFinder.dPrint("Read properties file " + file);
                                    cacheProps.load(ss.getFileInputStream(file));
                                }
                            }
                        }
                    }
                }
                if ((object = cacheProps.getProperty(string)) != null) {
                    FactoryFinder.dPrint("found in " + string3 + " value=" + (String)object);
                    return FactoryFinder.newInstance(clazz, (String)object, classLoader, true);
                }
            }
            catch (Exception exception) {
                if (!debug) break block19;
                exception.printStackTrace();
            }
        }
        if (clazz.getName().equals(string)) {
            object = FactoryFinder.findServiceProvider(clazz, classLoader);
            if (object != null) {
                return (T)object;
            }
        } else assert (string2 == null);
        if (string2 == null) {
            throw new FactoryConfigurationError("Provider for " + string + " cannot be found", null);
        }
        FactoryFinder.dPrint("loaded from fallback value: " + string2);
        return FactoryFinder.newInstance(clazz, string2, classLoader, true);
    }

    private static <T> T findServiceProvider(final Class<T> clazz, final ClassLoader classLoader) {
        try {
            return AccessController.doPrivileged(new PrivilegedAction<T>(){

                @Override
                public T run() {
                    ServiceLoader serviceLoader = classLoader == null ? ServiceLoader.load(clazz) : ServiceLoader.load(clazz, classLoader);
                    Iterator iterator = serviceLoader.iterator();
                    if (iterator.hasNext()) {
                        return iterator.next();
                    }
                    return null;
                }
            });
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            RuntimeException runtimeException = new RuntimeException("Provider for " + clazz + " cannot be created", serviceConfigurationError);
            FactoryConfigurationError factoryConfigurationError = new FactoryConfigurationError(runtimeException, runtimeException.getMessage());
            throw factoryConfigurationError;
        }
    }

    static {
        try {
            String string = ss.getSystemProperty("jaxp.debug");
            debug = string != null && !"false".equals(string);
        }
        catch (SecurityException securityException) {
            debug = false;
        }
    }
}

