/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.serializer.dom3;

import com.sun.org.apache.xml.internal.serializer.DOM3Serializer;
import com.sun.org.apache.xml.internal.serializer.SerializationHandler;
import com.sun.org.apache.xml.internal.serializer.dom3.DOM3TreeWalker;
import com.sun.org.apache.xml.internal.serializer.utils.WrappedRuntimeException;
import java.io.IOException;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSSerializerFilter;
import org.xml.sax.SAXException;

public final class DOM3SerializerImpl
implements DOM3Serializer {
    private DOMErrorHandler fErrorHandler;
    private LSSerializerFilter fSerializerFilter;
    private String fNewLine;
    private SerializationHandler fSerializationHandler;

    public DOM3SerializerImpl(SerializationHandler serializationHandler) {
        this.fSerializationHandler = serializationHandler;
    }

    @Override
    public DOMErrorHandler getErrorHandler() {
        return this.fErrorHandler;
    }

    @Override
    public LSSerializerFilter getNodeFilter() {
        return this.fSerializerFilter;
    }

    @Override
    public void serializeDOM3(Node node) throws IOException {
        try {
            DOM3TreeWalker dOM3TreeWalker = new DOM3TreeWalker(this.fSerializationHandler, this.fErrorHandler, this.fSerializerFilter, this.fNewLine);
            dOM3TreeWalker.traverse(node);
        }
        catch (SAXException sAXException) {
            throw new WrappedRuntimeException(sAXException);
        }
    }

    @Override
    public void setErrorHandler(DOMErrorHandler dOMErrorHandler) {
        this.fErrorHandler = dOMErrorHandler;
    }

    @Override
    public void setNodeFilter(LSSerializerFilter lSSerializerFilter) {
        this.fSerializerFilter = lSSerializerFilter;
    }

    public void setSerializationHandler(SerializationHandler serializationHandler) {
        this.fSerializationHandler = serializationHandler;
    }

    @Override
    public void setNewLine(String string) {
        this.fNewLine = string;
    }
}

