/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations;

import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverException;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverSpi;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import org.w3c.dom.Element;

public class SingleKeyResolver
extends KeyResolverSpi {
    private final String keyName;
    private final PublicKey publicKey;
    private final PrivateKey privateKey;
    private final SecretKey secretKey;

    public SingleKeyResolver(String string, PublicKey publicKey) {
        this.keyName = string;
        this.publicKey = publicKey;
        this.privateKey = null;
        this.secretKey = null;
    }

    public SingleKeyResolver(String string, PrivateKey privateKey) {
        this.keyName = string;
        this.privateKey = privateKey;
        this.publicKey = null;
        this.secretKey = null;
    }

    public SingleKeyResolver(String string, SecretKey secretKey) {
        this.keyName = string;
        this.secretKey = secretKey;
        this.publicKey = null;
        this.privateKey = null;
    }

    @Override
    protected boolean engineCanResolve(Element element, String string, StorageResolver storageResolver) {
        return XMLUtils.elementIsInSignatureSpace(element, "KeyName");
    }

    @Override
    protected PublicKey engineResolvePublicKey(Element element, String string, StorageResolver storageResolver, boolean bl) throws KeyResolverException {
        String string2;
        if (this.publicKey != null && this.keyName.equals(string2 = element.getFirstChild().getNodeValue())) {
            return this.publicKey;
        }
        return null;
    }

    @Override
    protected X509Certificate engineResolveX509Certificate(Element element, String string, StorageResolver storageResolver, boolean bl) throws KeyResolverException {
        return null;
    }

    @Override
    protected SecretKey engineResolveSecretKey(Element element, String string, StorageResolver storageResolver, boolean bl) throws KeyResolverException {
        String string2;
        if (this.secretKey != null && this.keyName.equals(string2 = element.getFirstChild().getNodeValue())) {
            return this.secretKey;
        }
        return null;
    }

    @Override
    public PrivateKey engineResolvePrivateKey(Element element, String string, StorageResolver storageResolver, boolean bl) throws KeyResolverException {
        String string2;
        if (this.privateKey != null && this.keyName.equals(string2 = element.getFirstChild().getNodeValue())) {
            return this.privateKey;
        }
        return null;
    }
}

