/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.utils;

import com.sun.org.apache.xerces.internal.utils.ConfigurationError;
import com.sun.org.apache.xerces.internal.utils.SecuritySupport;

public final class ObjectFactory {
    private static final String JAXP_INTERNAL = "com.sun.org.apache";
    private static final String STAX_INTERNAL = "com.sun.xml.internal";
    private static final boolean DEBUG = ObjectFactory.isDebugEnabled();

    private static boolean isDebugEnabled() {
        try {
            String string = SecuritySupport.getSystemProperty("xerces.debug");
            return string != null && !"false".equals(string);
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    private static void debugPrintln(String string) {
        if (DEBUG) {
            System.err.println("XERCES: " + string);
        }
    }

    public static ClassLoader findClassLoader() throws ConfigurationError {
        ClassLoader classLoader;
        if (System.getSecurityManager() != null) {
            return null;
        }
        ClassLoader classLoader2 = SecuritySupport.getContextClassLoader();
        ClassLoader classLoader3 = classLoader = SecuritySupport.getSystemClassLoader();
        while (true) {
            if (classLoader2 == classLoader3) {
                ClassLoader classLoader4 = ObjectFactory.class.getClassLoader();
                classLoader3 = classLoader;
                while (true) {
                    if (classLoader4 == classLoader3) {
                        return classLoader;
                    }
                    if (classLoader3 == null) break;
                    classLoader3 = SecuritySupport.getParentClassLoader(classLoader3);
                }
                return classLoader4;
            }
            if (classLoader3 == null) break;
            classLoader3 = SecuritySupport.getParentClassLoader(classLoader3);
        }
        return classLoader2;
    }

    public static Object newInstance(String string, boolean bl) throws ConfigurationError {
        if (System.getSecurityManager() != null) {
            return ObjectFactory.newInstance(string, null, bl);
        }
        return ObjectFactory.newInstance(string, ObjectFactory.findClassLoader(), bl);
    }

    public static Object newInstance(String string, ClassLoader classLoader, boolean bl) throws ConfigurationError {
        try {
            Class clazz = ObjectFactory.findProviderClass(string, classLoader, bl);
            Object t = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (DEBUG) {
                ObjectFactory.debugPrintln("created new instance of " + clazz + " using ClassLoader: " + classLoader);
            }
            return t;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConfigurationError("Provider " + string + " not found", classNotFoundException);
        }
        catch (Exception exception) {
            throw new ConfigurationError("Provider " + string + " could not be instantiated: " + exception, exception);
        }
    }

    public static Class findProviderClass(String string, boolean bl) throws ClassNotFoundException, ConfigurationError {
        return ObjectFactory.findProviderClass(string, ObjectFactory.findClassLoader(), bl);
    }

    public static Class findProviderClass(String string, ClassLoader classLoader, boolean bl) throws ClassNotFoundException, ConfigurationError {
        Class<?> clazz;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (string.startsWith(JAXP_INTERNAL) || string.startsWith(STAX_INTERNAL)) {
                classLoader = null;
            } else {
                int n = string.lastIndexOf(".");
                String string2 = string;
                if (n != -1) {
                    string2 = string.substring(0, n);
                }
                securityManager.checkPackageAccess(string2);
            }
        }
        if (classLoader == null) {
            clazz = Class.forName(string, false, ObjectFactory.class.getClassLoader());
        } else {
            try {
                clazz = classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (bl) {
                    ClassLoader classLoader2 = ObjectFactory.class.getClassLoader();
                    if (classLoader2 == null) {
                        clazz = Class.forName(string);
                    }
                    if (classLoader != classLoader2) {
                        classLoader = classLoader2;
                        clazz = classLoader.loadClass(string);
                    }
                    throw classNotFoundException;
                }
                throw classNotFoundException;
            }
        }
        return clazz;
    }
}

