/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.util;

import com.sun.org.apache.bcel.internal.Const;
import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.ConstantCP;
import com.sun.org.apache.bcel.internal.classfile.ConstantClass;
import com.sun.org.apache.bcel.internal.classfile.ConstantFieldref;
import com.sun.org.apache.bcel.internal.classfile.ConstantInterfaceMethodref;
import com.sun.org.apache.bcel.internal.classfile.ConstantMethodref;
import com.sun.org.apache.bcel.internal.classfile.ConstantNameAndType;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantString;
import com.sun.org.apache.bcel.internal.classfile.Method;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.util.Class2HTML;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

final class ConstantHTML {
    private final String className;
    private final String classPackage;
    private final ConstantPool constantPool;
    private final PrintWriter file;
    private final String[] constantRef;
    private final Constant[] constants;
    private final Method[] methods;

    ConstantHTML(String string, String string2, String string3, Method[] methodArray, ConstantPool constantPool) throws IOException {
        this.className = string2;
        this.classPackage = string3;
        this.constantPool = constantPool;
        this.methods = methodArray;
        this.constants = constantPool.getConstantPool();
        this.file = new PrintWriter(new FileOutputStream(string + string2 + "_cp.html"));
        this.constantRef = new String[this.constants.length];
        this.constantRef[0] = "&lt;unknown&gt;";
        this.file.println("<HTML><BODY BGCOLOR=\"#C0C0C0\"><TABLE BORDER=0>");
        for (int i = 1; i < this.constants.length; ++i) {
            if (i % 2 == 0) {
                this.file.print("<TR BGCOLOR=\"#C0C0C0\"><TD>");
            } else {
                this.file.print("<TR BGCOLOR=\"#A0A0A0\"><TD>");
            }
            if (this.constants[i] != null) {
                this.writeConstant(i);
            }
            this.file.print("</TD></TR>\n");
        }
        this.file.println("</TABLE></BODY></HTML>");
        this.file.close();
    }

    String referenceConstant(int n) {
        return this.constantRef[n];
    }

    private void writeConstant(int n) {
        byte by = this.constants[n].getTag();
        this.file.println("<H4> <A NAME=cp" + n + ">" + n + "</A> " + Const.getConstantName(by) + "</H4>");
        switch (by) {
            case 10: 
            case 11: {
                int n2;
                int n3;
                Object object;
                if (by == 10) {
                    object = (ConstantMethodref)this.constantPool.getConstant(n, (byte)10);
                    n3 = ((ConstantCP)object).getClassIndex();
                    n2 = ((ConstantCP)object).getNameAndTypeIndex();
                } else {
                    object = (ConstantInterfaceMethodref)this.constantPool.getConstant(n, (byte)11);
                    n3 = ((ConstantCP)object).getClassIndex();
                    n2 = ((ConstantCP)object).getNameAndTypeIndex();
                }
                object = this.constantPool.constantToString(n2, (byte)12);
                String string = Class2HTML.toHTML((String)object);
                String string2 = this.constantPool.constantToString(n3, (byte)7);
                String string3 = Utility.compactClassName(string2);
                string3 = Utility.compactClassName(string3, this.classPackage + ".", true);
                ConstantNameAndType constantNameAndType = (ConstantNameAndType)this.constantPool.getConstant(n2, (byte)12);
                String string4 = this.constantPool.constantToString(constantNameAndType.getSignatureIndex(), (byte)1);
                String[] stringArray = Utility.methodSignatureArgumentTypes(string4, false);
                String string5 = Utility.methodSignatureReturnType(string4, false);
                String string6 = Class2HTML.referenceType(string5);
                StringBuilder stringBuilder = new StringBuilder("(");
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuilder.append(Class2HTML.referenceType(stringArray[i]));
                    if (i >= stringArray.length - 1) continue;
                    stringBuilder.append(",&nbsp;");
                }
                stringBuilder.append(")");
                String string7 = stringBuilder.toString();
                String string8 = string2.equals(this.className) ? "<A HREF=\"" + this.className + "_code.html#method" + this.getMethodNumber((String)object + string4) + "\" TARGET=Code>" + string + "</A>" : "<A HREF=\"" + string2 + ".html\" TARGET=_top>" + string3 + "</A>." + string;
                this.constantRef[n] = string6 + "&nbsp;<A HREF=\"" + this.className + "_cp.html#cp" + n3 + "\" TARGET=Constants>" + string3 + "</A>.<A HREF=\"" + this.className + "_cp.html#cp" + n + "\" TARGET=ConstantPool>" + string + "</A>&nbsp;" + string7;
                this.file.println("<P><TT>" + string6 + "&nbsp;" + string8 + string7 + "&nbsp;</TT>\n<UL><LI><A HREF=\"#cp" + n3 + "\">Class index(" + n3 + ")</A>\n<LI><A HREF=\"#cp" + n2 + "\">NameAndType index(" + n2 + ")</A></UL>");
                break;
            }
            case 9: {
                ConstantFieldref constantFieldref = (ConstantFieldref)this.constantPool.getConstant(n, (byte)9);
                int n4 = constantFieldref.getClassIndex();
                int n5 = constantFieldref.getNameAndTypeIndex();
                String string = this.constantPool.constantToString(n4, (byte)7);
                String string9 = Utility.compactClassName(string);
                string9 = Utility.compactClassName(string9, this.classPackage + ".", true);
                String string10 = this.constantPool.constantToString(n5, (byte)12);
                String string11 = string.equals(this.className) ? "<A HREF=\"" + string + "_methods.html#field" + string10 + "\" TARGET=Methods>" + string10 + "</A>" : "<A HREF=\"" + string + ".html\" TARGET=_top>" + string9 + "</A>." + string10 + "\n";
                this.constantRef[n] = "<A HREF=\"" + this.className + "_cp.html#cp" + n4 + "\" TARGET=Constants>" + string9 + "</A>.<A HREF=\"" + this.className + "_cp.html#cp" + n + "\" TARGET=ConstantPool>" + string10 + "</A>";
                this.file.println("<P><TT>" + string11 + "</TT><BR>\n<UL><LI><A HREF=\"#cp" + n4 + "\">Class(" + n4 + ")</A><BR>\n<LI><A HREF=\"#cp" + n5 + "\">NameAndType(" + n5 + ")</A></UL>");
                break;
            }
            case 7: {
                ConstantClass constantClass = (ConstantClass)this.constantPool.getConstant(n, (byte)7);
                int n6 = constantClass.getNameIndex();
                String string = this.constantPool.constantToString(n, by);
                String string12 = Utility.compactClassName(string);
                string12 = Utility.compactClassName(string12, this.classPackage + ".", true);
                String string13 = "<A HREF=\"" + string + ".html\" TARGET=_top>" + string12 + "</A>";
                this.constantRef[n] = "<A HREF=\"" + this.className + "_cp.html#cp" + n + "\" TARGET=ConstantPool>" + string12 + "</A>";
                this.file.println("<P><TT>" + string13 + "</TT><UL><LI><A HREF=\"#cp" + n6 + "\">Name index(" + n6 + ")</A></UL>\n");
                break;
            }
            case 8: {
                ConstantString constantString = (ConstantString)this.constantPool.getConstant(n, (byte)8);
                int n7 = constantString.getStringIndex();
                String string = Class2HTML.toHTML(this.constantPool.constantToString(n, by));
                this.file.println("<P><TT>" + string + "</TT><UL><LI><A HREF=\"#cp" + n7 + "\">Name index(" + n7 + ")</A></UL>\n");
                break;
            }
            case 12: {
                ConstantNameAndType constantNameAndType = (ConstantNameAndType)this.constantPool.getConstant(n, (byte)12);
                int n8 = constantNameAndType.getNameIndex();
                int n9 = constantNameAndType.getSignatureIndex();
                this.file.println("<P><TT>" + Class2HTML.toHTML(this.constantPool.constantToString(n, by)) + "</TT><UL><LI><A HREF=\"#cp" + n8 + "\">Name index(" + n8 + ")</A>\n<LI><A HREF=\"#cp" + n9 + "\">Signature index(" + n9 + ")</A></UL>\n");
                break;
            }
            default: {
                this.file.println("<P><TT>" + Class2HTML.toHTML(this.constantPool.constantToString(n, by)) + "</TT>\n");
            }
        }
    }

    private int getMethodNumber(String string) {
        for (int i = 0; i < this.methods.length; ++i) {
            String string2 = this.methods[i].getName() + this.methods[i].getSignature();
            if (!string2.equals(string)) continue;
            return i;
        }
        return -1;
    }
}

