/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class LineNumber
implements Cloneable,
Node {
    private short startPc;
    private short lineNumber;

    public LineNumber(LineNumber lineNumber) {
        this(lineNumber.getStartPC(), lineNumber.getLineNumber());
    }

    LineNumber(DataInput dataInput) throws IOException {
        this(dataInput.readUnsignedShort(), dataInput.readUnsignedShort());
    }

    public LineNumber(int n, int n2) {
        this.startPc = (short)n;
        this.lineNumber = (short)n2;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitLineNumber(this);
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.startPc);
        dataOutputStream.writeShort(this.lineNumber);
    }

    public int getLineNumber() {
        return 0xFFFF & this.lineNumber;
    }

    public int getStartPC() {
        return 0xFFFF & this.startPc;
    }

    public void setLineNumber(int n) {
        this.lineNumber = (short)n;
    }

    public void setStartPC(int n) {
        this.startPc = (short)n;
    }

    public String toString() {
        return "LineNumber(" + this.startPc + ", " + this.lineNumber + ")";
    }

    public LineNumber copy() {
        try {
            return (LineNumber)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

