/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class CodeException
implements Cloneable,
Node {
    private int startPc;
    private int endPc;
    private int handlerPc;
    private int catchType;

    public CodeException(CodeException codeException) {
        this(codeException.getStartPC(), codeException.getEndPC(), codeException.getHandlerPC(), codeException.getCatchType());
    }

    CodeException(DataInput dataInput) throws IOException {
        this(dataInput.readUnsignedShort(), dataInput.readUnsignedShort(), dataInput.readUnsignedShort(), dataInput.readUnsignedShort());
    }

    public CodeException(int n, int n2, int n3, int n4) {
        this.startPc = n;
        this.endPc = n2;
        this.handlerPc = n3;
        this.catchType = n4;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitCodeException(this);
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.startPc);
        dataOutputStream.writeShort(this.endPc);
        dataOutputStream.writeShort(this.handlerPc);
        dataOutputStream.writeShort(this.catchType);
    }

    public int getCatchType() {
        return this.catchType;
    }

    public int getEndPC() {
        return this.endPc;
    }

    public int getHandlerPC() {
        return this.handlerPc;
    }

    public int getStartPC() {
        return this.startPc;
    }

    public void setCatchType(int n) {
        this.catchType = n;
    }

    public void setEndPC(int n) {
        this.endPc = n;
    }

    public void setHandlerPC(int n) {
        this.handlerPc = n;
    }

    public void setStartPC(int n) {
        this.startPc = n;
    }

    public String toString() {
        return "CodeException(startPc = " + this.startPc + ", endPc = " + this.endPc + ", handlerPc = " + this.handlerPc + ", catchType = " + this.catchType + ")";
    }

    public String toString(ConstantPool constantPool, boolean bl) {
        String string = this.catchType == 0 ? "<Any exception>(0)" : Utility.compactClassName(constantPool.getConstantString(this.catchType, (byte)7), false) + (bl ? "(" + this.catchType + ")" : "");
        return this.startPc + "\t" + this.endPc + "\t" + this.handlerPc + "\t" + string;
    }

    public String toString(ConstantPool constantPool) {
        return this.toString(constantPool, true);
    }

    public CodeException copy() {
        try {
            return (CodeException)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

