/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Annotations;
import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.ElementValue;
import com.sun.org.apache.bcel.internal.classfile.ElementValuePair;
import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AnnotationEntry
implements Node {
    private final int typeIndex;
    private final ConstantPool constantPool;
    private final boolean isRuntimeVisible;
    private List<ElementValuePair> elementValuePairs;

    public static AnnotationEntry read(DataInput dataInput, ConstantPool constantPool, boolean bl) throws IOException {
        AnnotationEntry annotationEntry = new AnnotationEntry(dataInput.readUnsignedShort(), constantPool, bl);
        int n = dataInput.readUnsignedShort();
        annotationEntry.elementValuePairs = new ArrayList<ElementValuePair>();
        for (int i = 0; i < n; ++i) {
            annotationEntry.elementValuePairs.add(new ElementValuePair(dataInput.readUnsignedShort(), ElementValue.readElementValue(dataInput, constantPool), constantPool));
        }
        return annotationEntry;
    }

    public AnnotationEntry(int n, ConstantPool constantPool, boolean bl) {
        this.typeIndex = n;
        this.constantPool = constantPool;
        this.isRuntimeVisible = bl;
    }

    public int getTypeIndex() {
        return this.typeIndex;
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public boolean isRuntimeVisible() {
        return this.isRuntimeVisible;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitAnnotationEntry(this);
    }

    public String getAnnotationType() {
        ConstantUtf8 constantUtf8 = (ConstantUtf8)this.constantPool.getConstant(this.typeIndex, (byte)1);
        return constantUtf8.getBytes();
    }

    public int getAnnotationTypeIndex() {
        return this.typeIndex;
    }

    public final int getNumElementValuePairs() {
        return this.elementValuePairs.size();
    }

    public ElementValuePair[] getElementValuePairs() {
        return this.elementValuePairs.toArray(new ElementValuePair[this.elementValuePairs.size()]);
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.typeIndex);
        dataOutputStream.writeShort(this.elementValuePairs.size());
        for (ElementValuePair elementValuePair : this.elementValuePairs) {
            elementValuePair.dump(dataOutputStream);
        }
    }

    public void addElementNameValuePair(ElementValuePair elementValuePair) {
        this.elementValuePairs.add(elementValuePair);
    }

    public String toShortString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("@");
        stringBuilder.append(this.getAnnotationType());
        ElementValuePair[] elementValuePairArray = this.getElementValuePairs();
        if (elementValuePairArray.length > 0) {
            stringBuilder.append("(");
            for (ElementValuePair elementValuePair : elementValuePairArray) {
                stringBuilder.append(elementValuePair.toShortString());
            }
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.toShortString();
    }

    public static AnnotationEntry[] createAnnotationEntries(Attribute[] attributeArray) {
        ArrayList arrayList = new ArrayList(attributeArray.length);
        for (Attribute attribute : attributeArray) {
            if (!(attribute instanceof Annotations)) continue;
            Annotations annotations = (Annotations)attribute;
            Collections.addAll(arrayList, annotations.getAnnotationEntries());
        }
        return arrayList.toArray(new AnnotationEntry[arrayList.size()]);
    }
}

