/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.algorithms;

import com.sun.org.apache.xml.internal.security.signature.XMLSignatureException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.AlgorithmParameterSpec;
import org.w3c.dom.Element;

public abstract class SignatureAlgorithmSpi {
    protected abstract String engineGetURI();

    protected abstract String engineGetJCEAlgorithmString();

    protected abstract String engineGetJCEProviderName();

    protected abstract void engineUpdate(byte[] var1) throws XMLSignatureException;

    protected abstract void engineUpdate(byte var1) throws XMLSignatureException;

    protected abstract void engineUpdate(byte[] var1, int var2, int var3) throws XMLSignatureException;

    protected abstract void engineInitSign(Key var1) throws XMLSignatureException;

    protected abstract void engineInitSign(Key var1, SecureRandom var2) throws XMLSignatureException;

    protected abstract void engineInitSign(Key var1, AlgorithmParameterSpec var2) throws XMLSignatureException;

    protected abstract byte[] engineSign() throws XMLSignatureException;

    protected abstract void engineInitVerify(Key var1) throws XMLSignatureException;

    protected abstract boolean engineVerify(byte[] var1) throws XMLSignatureException;

    protected abstract void engineSetParameter(AlgorithmParameterSpec var1) throws XMLSignatureException;

    protected void engineGetContextFromElement(Element element) throws XMLSignatureException {
    }

    protected void engineAddContextToElement(Element element) throws XMLSignatureException {
    }

    protected abstract void engineSetHMACOutputLength(int var1) throws XMLSignatureException;

    protected static void engineInitVerify(Key key, Signature signature) throws XMLSignatureException {
        if (!(key instanceof PublicKey)) {
            String string = null;
            if (key != null) {
                string = key.getClass().getName();
            }
            String string2 = PublicKey.class.getName();
            Object[] objectArray = new Object[]{string, string2};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", objectArray);
        }
        try {
            signature.initVerify((PublicKey)key);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSignatureException(invalidKeyException);
        }
    }

    protected static void engineInitSign(Key key, SecureRandom secureRandom, Signature signature) throws XMLSignatureException {
        if (!(key instanceof PrivateKey)) {
            String string = null;
            if (key != null) {
                string = key.getClass().getName();
            }
            String string2 = PrivateKey.class.getName();
            Object[] objectArray = new Object[]{string, string2};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", objectArray);
        }
        try {
            if (secureRandom == null) {
                signature.initSign((PrivateKey)key);
            } else {
                signature.initSign((PrivateKey)key, secureRandom);
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSignatureException(invalidKeyException);
        }
    }
}

