/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.classfile.LineNumber;
import com.sun.org.apache.bcel.internal.generic.BranchInstruction;
import com.sun.org.apache.bcel.internal.generic.ClassGenException;
import com.sun.org.apache.bcel.internal.generic.InstructionHandle;
import com.sun.org.apache.bcel.internal.generic.InstructionTargeter;
import java.util.Objects;

public class LineNumberGen
implements InstructionTargeter,
Cloneable {
    private InstructionHandle ih;
    private int srcLine;

    public LineNumberGen(InstructionHandle instructionHandle, int n) {
        this.setInstruction(instructionHandle);
        this.setSourceLine(n);
    }

    @Override
    public boolean containsTarget(InstructionHandle instructionHandle) {
        return this.ih == instructionHandle;
    }

    @Override
    public void updateTarget(InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        if (instructionHandle != this.ih) {
            throw new ClassGenException("Not targeting " + instructionHandle + ", but " + this.ih + "}");
        }
        this.setInstruction(instructionHandle2);
    }

    public LineNumber getLineNumber() {
        return new LineNumber(this.ih.getPosition(), this.srcLine);
    }

    public void setInstruction(InstructionHandle instructionHandle) {
        Objects.requireNonNull(instructionHandle, "instructionHandle");
        BranchInstruction.notifyTarget(this.ih, instructionHandle, this);
        this.ih = instructionHandle;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Clone Not Supported");
        }
    }

    public InstructionHandle getInstruction() {
        return this.ih;
    }

    public void setSourceLine(int n) {
        this.srcLine = n;
    }

    public int getSourceLine() {
        return this.srcLine;
    }
}

