/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.ElementValue;
import com.sun.org.apache.bcel.internal.classfile.ElementValuePair;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.ElementValueGen;
import java.io.DataOutputStream;
import java.io.IOException;

public class ElementValuePairGen {
    private int nameIdx;
    private final ElementValueGen value;
    private final ConstantPoolGen constantPoolGen;

    public ElementValuePairGen(ElementValuePair elementValuePair, ConstantPoolGen constantPoolGen, boolean bl) {
        this.constantPoolGen = constantPoolGen;
        this.nameIdx = bl ? constantPoolGen.addUtf8(elementValuePair.getNameString()) : elementValuePair.getNameIndex();
        this.value = ElementValueGen.copy(elementValuePair.getValue(), constantPoolGen, bl);
    }

    public ElementValuePair getElementNameValuePair() {
        ElementValue elementValue = this.value.getElementValue();
        return new ElementValuePair(this.nameIdx, elementValue, this.constantPoolGen.getConstantPool());
    }

    protected ElementValuePairGen(int n, ElementValueGen elementValueGen, ConstantPoolGen constantPoolGen) {
        this.nameIdx = n;
        this.value = elementValueGen;
        this.constantPoolGen = constantPoolGen;
    }

    public ElementValuePairGen(String string, ElementValueGen elementValueGen, ConstantPoolGen constantPoolGen) {
        this.nameIdx = constantPoolGen.addUtf8(string);
        this.value = elementValueGen;
        this.constantPoolGen = constantPoolGen;
    }

    protected void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.nameIdx);
        this.value.dump(dataOutputStream);
    }

    public int getNameIndex() {
        return this.nameIdx;
    }

    public final String getNameString() {
        return ((ConstantUtf8)this.constantPoolGen.getConstant(this.nameIdx)).getBytes();
    }

    public final ElementValueGen getValue() {
        return this.value;
    }

    public String toString() {
        return "ElementValuePair:[" + this.getNameString() + "=" + this.value.stringifyValue() + "]";
    }
}

