/*
 * Decompiled with CFR 0.152.
 */
package sun.net.spi.nameservice.dns;

import java.lang.ref.SoftReference;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.spi.NamingManager;
import sun.net.dns.ResolverConfiguration;
import sun.net.spi.nameservice.NameService;
import sun.net.util.IPAddressUtil;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetPropertyAction;

public final class DNSNameService
implements NameService {
    private LinkedList<String> domainList = null;
    private String nameProviderUrl = null;
    private final boolean preferIPv6Addresses = AccessController.doPrivileged(new GetBooleanAction("java.net.preferIPv6Addresses"));
    private final boolean preferIPv4Stack = AccessController.doPrivileged(new GetBooleanAction("java.net.preferIPv4Stack"));
    private static ThreadLocal<SoftReference<ThreadContext>> contextRef = new ThreadLocal();

    private DirContext getTemporaryContext() throws NamingException {
        SoftReference<ThreadContext> softReference = contextRef.get();
        ThreadContext threadContext = null;
        List<String> list = null;
        if (this.nameProviderUrl == null) {
            list = ResolverConfiguration.open().nameservers();
        }
        if (softReference != null && (threadContext = softReference.get()) != null && this.nameProviderUrl == null && !threadContext.nameservers().equals(list)) {
            threadContext = null;
        }
        if (threadContext == null) {
            DirContext dirContext;
            final Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            String string = this.nameProviderUrl;
            if (string == null && (string = DNSNameService.createProviderURL(list)).length() == 0) {
                throw new RuntimeException("bad nameserver configuration");
            }
            hashtable.put("java.naming.provider.url", string);
            try {
                dirContext = AccessController.doPrivileged(new PrivilegedExceptionAction<DirContext>(){

                    @Override
                    public DirContext run() throws NamingException {
                        Context context = NamingManager.getInitialContext(hashtable);
                        if (!(context instanceof DirContext)) {
                            return null;
                        }
                        return (DirContext)context;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (NamingException)privilegedActionException.getException();
            }
            threadContext = new ThreadContext(dirContext, list);
            contextRef.set(new SoftReference<ThreadContext>(threadContext));
        }
        return threadContext.dirContext();
    }

    private ArrayList<String> resolve(final DirContext dirContext, final String string, final String[] stringArray, int n) throws UnknownHostException {
        Attributes attributes;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            attributes = AccessController.doPrivileged(new PrivilegedExceptionAction<Attributes>(){

                @Override
                public Attributes run() throws NamingException {
                    return dirContext.getAttributes(string, stringArray);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new UnknownHostException(privilegedActionException.getException().getMessage());
        }
        NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
        if (!namingEnumeration.hasMoreElements()) {
            throw new UnknownHostException("DNS record not found");
        }
        UnknownHostException unknownHostException = null;
        try {
            while (namingEnumeration.hasMoreElements()) {
                Attribute attribute = namingEnumeration.next();
                String string2 = attribute.getID();
                NamingEnumeration<?> namingEnumeration2 = attribute.getAll();
                while (namingEnumeration2.hasMoreElements()) {
                    String string3 = (String)namingEnumeration2.next();
                    if (string2.equals("CNAME")) {
                        if (n > 4) {
                            throw new UnknownHostException(string + ": possible CNAME loop");
                        }
                        try {
                            arrayList.addAll(this.resolve(dirContext, string3, stringArray, n + 1));
                        }
                        catch (UnknownHostException unknownHostException2) {
                            if (unknownHostException != null) continue;
                            unknownHostException = unknownHostException2;
                        }
                        continue;
                    }
                    arrayList.add(string3);
                }
            }
        }
        catch (NamingException namingException) {
            throw new UnknownHostException(namingException.getMessage());
        }
        if (arrayList.isEmpty() && unknownHostException != null) {
            throw unknownHostException;
        }
        return arrayList;
    }

    public DNSNameService() throws Exception {
        String string;
        String string2 = AccessController.doPrivileged(new GetPropertyAction("sun.net.spi.nameservice.domain"));
        if (string2 != null && string2.length() > 0) {
            this.domainList = new LinkedList();
            this.domainList.add(string2);
        }
        if ((string = AccessController.doPrivileged(new GetPropertyAction("sun.net.spi.nameservice.nameservers"))) != null && string.length() > 0) {
            this.nameProviderUrl = DNSNameService.createProviderURL(string);
            if (this.nameProviderUrl.length() == 0) {
                throw new RuntimeException("malformed nameservers property");
            }
        } else {
            List<String> list = ResolverConfiguration.open().nameservers();
            if (list.isEmpty()) {
                throw new RuntimeException("no nameservers provided");
            }
            boolean bl = false;
            for (String string3 : list) {
                if (!IPAddressUtil.isIPv4LiteralAddress(string3) && !IPAddressUtil.isIPv6LiteralAddress(string3)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new RuntimeException("bad nameserver configuration");
            }
        }
    }

    public InetAddress[] lookupAllHostAddr(String string) throws UnknownHostException {
        Object object;
        Iterator<String> iterator;
        List<String> list;
        DirContext dirContext;
        String[] stringArray = new String[]{"A", "AAAA", "CNAME"};
        try {
            dirContext = this.getTemporaryContext();
        }
        catch (NamingException namingException) {
            throw new Error(namingException);
        }
        ArrayList<String> arrayList = null;
        UnknownHostException unknownHostException = null;
        if (string.indexOf(46) >= 0) {
            try {
                arrayList = this.resolve(dirContext, string, stringArray, 0);
            }
            catch (UnknownHostException unknownHostException2) {
                unknownHostException = unknownHostException2;
            }
        }
        if (arrayList == null) {
            list = null;
            boolean bl = false;
            if (this.domainList != null) {
                iterator = this.domainList.iterator();
            } else {
                list = ResolverConfiguration.open().searchlist();
                if (list.size() > 1) {
                    bl = true;
                }
                iterator = list.iterator();
            }
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                int n = 0;
                while ((n = object.indexOf(".")) != -1 && n < object.length() - 1) {
                    try {
                        arrayList = this.resolve(dirContext, string + "." + (String)object, stringArray, 0);
                        break;
                    }
                    catch (UnknownHostException unknownHostException3) {
                        unknownHostException = unknownHostException3;
                        if (bl) break;
                        object = object.substring(n + 1);
                    }
                }
                if (arrayList == null) continue;
                break;
            }
        }
        if (arrayList == null && string.indexOf(46) < 0) {
            arrayList = this.resolve(dirContext, string, stringArray, 0);
        }
        if (arrayList == null) {
            assert (unknownHostException != null);
            throw unknownHostException;
        }
        assert (arrayList.size() > 0);
        list = new ArrayList<String>();
        iterator = new ArrayList();
        for (String string2 : arrayList) {
            byte[] byArray = IPAddressUtil.textToNumericFormatV4(string2);
            Object object2 = list;
            if (byArray == null && !this.preferIPv4Stack) {
                byArray = IPAddressUtil.textToNumericFormatV6(string2);
                object2 = iterator;
            }
            if (byArray == null) continue;
            ((ArrayList)object2).add((InetAddress)InetAddress.getByAddress(string, byArray));
        }
        if (((ArrayList)list).isEmpty() && ((ArrayList)((Object)iterator)).isEmpty()) {
            throw new UnknownHostException(string + ": no valid DNS records");
        }
        object = new InetAddress[((ArrayList)list).size() + ((ArrayList)((Object)iterator)).size()];
        if (this.preferIPv6Addresses) {
            ((ArrayList)((Object)iterator)).addAll(list);
            return ((ArrayList)((Object)iterator)).toArray((InetAddress[])object);
        }
        ((ArrayList)list).addAll((Collection<String>)((Object)iterator));
        return ((ArrayList)list).toArray((InetAddress[])object);
    }

    public String getHostByAddr(byte[] byArray) throws UnknownHostException {
        String string;
        block12: {
            string = null;
            try {
                DirContext dirContext;
                String string2 = "";
                String[] stringArray = new String[]{"PTR"};
                ArrayList<String> arrayList = null;
                try {
                    dirContext = this.getTemporaryContext();
                }
                catch (NamingException namingException) {
                    throw new Error(namingException);
                }
                if (byArray.length == 4) {
                    for (int i = byArray.length - 1; i >= 0; --i) {
                        string2 = string2 + (byArray[i] & 0xFF) + ".";
                    }
                    string2 = string2 + "IN-ADDR.ARPA.";
                    arrayList = this.resolve(dirContext, string2, stringArray, 0);
                    string = arrayList.get(0);
                    break block12;
                }
                if (byArray.length != 16) break block12;
                for (int i = byArray.length - 1; i >= 0; --i) {
                    string2 = string2 + Integer.toHexString(byArray[i] & 0xF) + "." + Integer.toHexString((byArray[i] & 0xF0) >> 4) + ".";
                }
                String string3 = string2 + "IP6.ARPA.";
                try {
                    arrayList = this.resolve(dirContext, string3, stringArray, 0);
                    string = arrayList.get(0);
                }
                catch (UnknownHostException unknownHostException) {
                    string = null;
                }
                if (string == null) {
                    string3 = string2 + "IP6.INT.";
                    arrayList = this.resolve(dirContext, string3, stringArray, 0);
                    string = arrayList.get(0);
                }
            }
            catch (Exception exception) {
                throw new UnknownHostException(exception.getMessage());
            }
        }
        if (string == null) {
            throw new UnknownHostException();
        }
        if (string.endsWith(".")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private static void appendIfLiteralAddress(String string, StringBuffer stringBuffer) {
        if (IPAddressUtil.isIPv4LiteralAddress(string)) {
            stringBuffer.append("dns://" + string + " ");
        } else if (IPAddressUtil.isIPv6LiteralAddress(string)) {
            stringBuffer.append("dns://[" + string + "] ");
        }
    }

    private static String createProviderURL(List<String> list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : list) {
            DNSNameService.appendIfLiteralAddress(string, stringBuffer);
        }
        return stringBuffer.toString();
    }

    private static String createProviderURL(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            DNSNameService.appendIfLiteralAddress(stringTokenizer.nextToken(), stringBuffer);
        }
        return stringBuffer.toString();
    }

    private static class ThreadContext {
        private DirContext dirCtxt;
        private List<String> nsList;

        public ThreadContext(DirContext dirContext, List<String> list) {
            this.dirCtxt = dirContext;
            this.nsList = list;
        }

        public DirContext dirContext() {
            return this.dirCtxt;
        }

        public List<String> nameservers() {
            return this.nsList;
        }
    }
}

