/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ModuleRequires
implements Cloneable,
Node {
    private final int requiresIndex;
    private final int requiresFlags;
    private final int requiresVersionIndex;

    ModuleRequires(DataInput file) throws IOException {
        this.requiresIndex = file.readUnsignedShort();
        this.requiresFlags = file.readUnsignedShort();
        this.requiresVersionIndex = file.readUnsignedShort();
    }

    @Override
    public void accept(Visitor v) {
        v.visitModuleRequires(this);
    }

    public void dump(DataOutputStream file) throws IOException {
        file.writeShort(this.requiresIndex);
        file.writeShort(this.requiresFlags);
        file.writeShort(this.requiresVersionIndex);
    }

    public String toString() {
        return "requires(" + this.requiresIndex + ", " + String.format("%04x", this.requiresFlags) + ", " + this.requiresVersionIndex + ")";
    }

    public String toString(ConstantPool constant_pool) {
        StringBuilder buf = new StringBuilder();
        String module_name = constant_pool.constantToString(this.requiresIndex, (byte)19);
        buf.append(Utility.compactClassName(module_name, false));
        buf.append(", ").append(String.format("%04x", this.requiresFlags));
        String version = this.requiresVersionIndex == 0 ? "0" : constant_pool.getConstantString(this.requiresVersionIndex, (byte)1);
        buf.append(", ").append(version);
        return buf.toString();
    }

    public ModuleRequires copy() {
        try {
            return (ModuleRequires)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

