/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.security.AccessController;
import sun.awt.X11.XAtom;
import sun.awt.X11.XToolkit;
import sun.security.action.GetPropertyAction;

class MotifColorUtilities {
    static final float XmRED_LUMINOSITY = 0.3f;
    static final float XmGREEN_LUMINOSITY = 0.59f;
    static final float XmBLUE_LUMINOSITY = 0.11f;
    static final int XmINTENSITY_FACTOR = 75;
    static final int XmLIGHT_FACTOR = 0;
    static final int XmLUMINOSITY_FACTOR = 25;
    static final int XmMAX_SHORT = 65535;
    static final int XmCOLOR_PERCENTILE = 655;
    static final int XmDEFAULT_DARK_THRESHOLD = 20;
    static final int XmDEFAULT_LIGHT_THRESHOLD = 93;
    static final int XmDEFAULT_FOREGROUND_THRESHOLD = 35;
    static final int BLACK = -16777216;
    static final int WHITE = -1;
    static final int MOTIF_WINDOW_COLOR = -2105377;
    static final int DEFAULT_COLOR = -3881788;
    static final int XmCOLOR_LITE_THRESHOLD = 60915;
    static final int XmCOLOR_DARK_THRESHOLD = 13100;
    static final int XmFOREGROUND_THRESHOLD = 22925;
    static final int XmCOLOR_LITE_SEL_FACTOR = 15;
    static final int XmCOLOR_LITE_BS_FACTOR = 40;
    static final int XmCOLOR_LITE_TS_FACTOR = 20;
    static final int XmCOLOR_DARK_SEL_FACTOR = 15;
    static final int XmCOLOR_DARK_BS_FACTOR = 30;
    static final int XmCOLOR_DARK_TS_FACTOR = 50;
    static final int XmCOLOR_HI_SEL_FACTOR = 15;
    static final int XmCOLOR_HI_BS_FACTOR = 40;
    static final int XmCOLOR_HI_TS_FACTOR = 60;
    static final int XmCOLOR_LO_SEL_FACTOR = 15;
    static final int XmCOLOR_LO_BS_FACTOR = 60;
    static final int XmCOLOR_LO_TS_FACTOR = 50;

    MotifColorUtilities() {
    }

    static int brightness(int n, int n2, int n3) {
        float f = ((n <<= 8) + (n2 <<= 8) + (n3 <<= 8)) / 3;
        float f2 = (int)(0.3f * (float)n + 0.59f * (float)n2 + 0.11f * (float)n3);
        float f3 = n > n2 ? (n > n3 ? n : n3) : (n2 > n3 ? n2 : n3);
        float f4 = n < n2 ? (n < n3 ? n : n3) : (n2 < n3 ? n2 : n3);
        float f5 = (f4 + f3) / 2.0f;
        float f6 = (f * 75.0f + f5 * 0.0f + f2 * 25.0f) / 100.0f;
        return Math.round(f6);
    }

    static int calculateForegroundFromBackground(int n, int n2, int n3) {
        int n4 = -1;
        int n5 = MotifColorUtilities.brightness(n, n2, n3);
        n4 = n5 > 22925 ? -16777216 : -1;
        return n4;
    }

    static int calculateTopShadowFromBackground(int n, int n2, int n3) {
        float f;
        float f2;
        float f3;
        int n4 = n << 8;
        int n5 = n2 << 8;
        int n6 = n3 << 8;
        int n7 = MotifColorUtilities.brightness(n, n2, n3);
        if (n7 < 13100) {
            float f4 = n4;
            f4 += 50.0f * (65535.0f - f4) / 100.0f;
            f3 = f4;
            f4 = n5;
            f4 += 50.0f * (65535.0f - f4) / 100.0f;
            f2 = f4;
            f4 = n6;
            f4 += 50.0f * (65535.0f - f4) / 100.0f;
            f = f4;
        } else if (n7 > 60915) {
            float f5 = n4;
            f5 -= f5 * 20.0f / 100.0f;
            f3 = f5;
            f5 = n5;
            f5 -= f5 * 20.0f / 100.0f;
            f2 = f5;
            f5 = n6;
            f5 -= f5 * 20.0f / 100.0f;
            f = f5;
        } else {
            float f6 = 50 + n7 * 10 / 65535;
            float f7 = n4;
            f7 += f6 * (65535.0f - f7) / 100.0f;
            f3 = f7;
            f7 = n5;
            f7 += f6 * (65535.0f - f7) / 100.0f;
            f2 = f7;
            f7 = n6;
            f7 += f6 * (65535.0f - f7) / 100.0f;
            f = f7;
        }
        int n8 = (int)f3 >> 8;
        int n9 = (int)f2 >> 8;
        int n10 = (int)f >> 8;
        int n11 = 0xFF000000 | n8 << 16 | n9 << 8 | n10;
        return n11;
    }

    static int calculateBottomShadowFromBackground(int n, int n2, int n3) {
        float f;
        float f2;
        float f3;
        int n4 = n << 8;
        int n5 = n2 << 8;
        int n6 = n3 << 8;
        int n7 = MotifColorUtilities.brightness(n, n2, n3);
        if (n7 < 13100) {
            float f4 = n4;
            f4 += 30.0f * (65535.0f - f4) / 100.0f;
            f3 = f4;
            f4 = n5;
            f4 += 30.0f * (65535.0f - f4) / 100.0f;
            f2 = f4;
            f4 = n6;
            f4 += 30.0f * (65535.0f - f4) / 100.0f;
            f = f4;
        } else if (n7 > 60915) {
            float f5 = n4;
            f5 -= f5 * 40.0f / 100.0f;
            f3 = f5;
            f5 = n5;
            f5 -= f5 * 40.0f / 100.0f;
            f2 = f5;
            f5 = n6;
            f5 -= f5 * 40.0f / 100.0f;
            f = f5;
        } else {
            float f6 = 60 + n7 * -20 / 65535;
            float f7 = n4;
            f7 -= f7 * f6 / 100.0f;
            f3 = f7;
            f7 = n5;
            f7 -= f7 * f6 / 100.0f;
            f2 = f7;
            f7 = n6;
            f7 -= f7 * f6 / 100.0f;
            f = f7;
        }
        int n8 = (int)f3 >> 8;
        int n9 = (int)f2 >> 8;
        int n10 = (int)f >> 8;
        int n11 = 0xFF000000 | n8 << 16 | n9 << 8 | n10;
        return n11;
    }

    static int calculateSelectFromBackground(int n, int n2, int n3) {
        float f;
        float f2;
        float f3;
        int n4 = n << 8;
        int n5 = n2 << 8;
        int n6 = n3 << 8;
        int n7 = MotifColorUtilities.brightness(n, n2, n3);
        if (n7 < 13100) {
            float f4 = n4;
            f4 += 15.0f * (65535.0f - f4) / 100.0f;
            f3 = f4;
            f4 = n5;
            f4 += 15.0f * (65535.0f - f4) / 100.0f;
            f2 = f4;
            f4 = n6;
            f4 += 15.0f * (65535.0f - f4) / 100.0f;
            f = f4;
        } else if (n7 > 60915) {
            float f5 = n4;
            f5 -= f5 * 15.0f / 100.0f;
            f3 = f5;
            f5 = n5;
            f5 -= f5 * 15.0f / 100.0f;
            f2 = f5;
            f5 = n6;
            f5 -= f5 * 15.0f / 100.0f;
            f = f5;
        } else {
            float f6 = 15 + n7 * 0 / 65535;
            float f7 = n4;
            f7 -= f7 * f6 / 100.0f;
            f3 = f7;
            f7 = n5;
            f7 -= f7 * f6 / 100.0f;
            f2 = f7;
            f7 = n6;
            f7 -= f7 * f6 / 100.0f;
            f = f7;
        }
        int n8 = (int)f3 >> 8;
        int n9 = (int)f2 >> 8;
        int n10 = (int)f >> 8;
        int n11 = 0xFF000000 | n8 << 16 | n9 << 8 | n10;
        return n11;
    }

    static void loadSystemColorsForCDE(int[] nArray) throws Exception {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        XAtom xAtom = XAtom.get("RESOURCE_MANAGER");
        String string = xAtom.getProperty(XToolkit.getDefaultRootWindow());
        int n6 = string.length();
        for (n5 = string.indexOf("ColorPalette:"); n5 < n6 && string.charAt(n5) != ':'; ++n5) {
        }
        if (string.charAt(++n5) == '\t') {
            ++n5;
        }
        String string2 = string.substring(n5, string.indexOf("\n", n5));
        String string3 = System.getProperty("user.home") + "/.dt/palettes/" + string2;
        File file = new File(string3);
        if (!file.exists() && !(file = new File(string3 = "/usr/dt/palettes/" + string2)).exists()) {
            throw new FileNotFoundException("Could not open : " + string3);
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        int[] nArray2 = new int[8];
        for (n4 = 0; n4 < 8; ++n4) {
            String string4 = bufferedReader.readLine();
            String string5 = string4.substring(1, string4.length());
            n3 = Integer.valueOf(string5.substring(0, 4), 16) >> 8;
            n2 = Integer.valueOf(string5.substring(4, 8), 16) >> 8;
            n = Integer.valueOf(string5.substring(8, 12), 16) >> 8;
            nArray2[n4] = 0xFF000000 | n3 << 16 | n2 << 8 | n;
        }
        nArray[1] = nArray2[0];
        nArray[3] = nArray2[0];
        nArray[4] = nArray2[1];
        nArray[6] = nArray2[1];
        nArray[7] = nArray2[1];
        nArray[8] = nArray2[1];
        nArray[10] = nArray2[1];
        nArray[12] = nArray2[3];
        nArray[23] = nArray2[1];
        nArray[17] = nArray2[1];
        n3 = (nArray2[0] & 0xFF0000) >> 16;
        n2 = (nArray2[0] & 0xFF00) >> 8;
        n = nArray2[0] & 0xFF;
        n4 = MotifColorUtilities.calculateForegroundFromBackground(n3, n2, n);
        n3 = (nArray2[1] & 0xFF0000) >> 16;
        n2 = (nArray2[1] & 0xFF00) >> 8;
        n = nArray2[1] & 0xFF;
        int n7 = MotifColorUtilities.calculateForegroundFromBackground(n3, n2, n);
        int n8 = MotifColorUtilities.calculateTopShadowFromBackground(n3, n2, n);
        int n9 = MotifColorUtilities.calculateBottomShadowFromBackground(n3, n2, n);
        n3 = (nArray2[3] & 0xFF0000) >> 16;
        n2 = (nArray2[3] & 0xFF00) >> 8;
        n = nArray2[3] & 0xFF;
        int n10 = MotifColorUtilities.calculateForegroundFromBackground(n3, n2, n);
        nArray[2] = n4;
        nArray[5] = n7;
        nArray[9] = n7;
        nArray[11] = n7;
        nArray[13] = n10;
        nArray[14] = -16777216;
        nArray[15] = -3881788;
        nArray[18] = n7;
        Color color = new Color(n8);
        nArray[19] = n8;
        nArray[20] = color.brighter().getRGB();
        color = new Color(n9);
        nArray[21] = n9;
        nArray[22] = color.darker().getRGB();
    }

    static void loadMotifDefaultColors(int[] nArray) {
        nArray[7] = -2105377;
        nArray[12] = -1;
        nArray[9] = -16777216;
        nArray[11] = -16777216;
        nArray[2] = -16777216;
        nArray[5] = -16777216;
        nArray[13] = -16777216;
        nArray[14] = -16777216;
        nArray[15] = -3881788;
        nArray[18] = -16777216;
        nArray[8] = -3881788;
        nArray[10] = -3881788;
        nArray[23] = -3881788;
        nArray[17] = -2105377;
        int n = 196;
        int n2 = 196;
        int n3 = 196;
        int n4 = MotifColorUtilities.calculateTopShadowFromBackground(n, n2, n3);
        int n5 = MotifColorUtilities.calculateBottomShadowFromBackground(n, n2, n3);
        Color color = new Color(n4);
        nArray[19] = n4;
        nArray[20] = color.brighter().getRGB();
        color = new Color(n5);
        nArray[21] = n5;
        nArray[22] = color.darker().getRGB();
    }

    static void loadSystemColors(int[] nArray) {
        if ("Linux".equals(AccessController.doPrivileged(new GetPropertyAction("os.name")))) {
            MotifColorUtilities.loadMotifDefaultColors(nArray);
        } else {
            try {
                MotifColorUtilities.loadSystemColorsForCDE(nArray);
            }
            catch (Exception exception) {
                MotifColorUtilities.loadMotifDefaultColors(nArray);
            }
        }
    }
}

