/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import com.sun.media.sound.AutoConnectSequencer;
import com.sun.media.sound.JDK13Services;
import com.sun.media.sound.MidiDeviceReceiverEnvelope;
import com.sun.media.sound.MidiDeviceTransmitterEnvelope;
import com.sun.media.sound.ReferenceCountingDevice;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiDeviceReceiver;
import javax.sound.midi.MidiDeviceTransmitter;
import javax.sound.midi.MidiFileFormat;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Transmitter;
import javax.sound.midi.spi.MidiDeviceProvider;
import javax.sound.midi.spi.MidiFileReader;
import javax.sound.midi.spi.MidiFileWriter;
import javax.sound.midi.spi.SoundbankReader;

public class MidiSystem {
    private static final boolean is_tru64_or_VMS = System.getProperty("os.name").equals("OpenVMS") || System.getProperty("os.name").equals("OSF1");

    private MidiSystem() {
    }

    public static MidiDevice.Info[] getMidiDeviceInfo() {
        ArrayList<MidiDevice.Info> arrayList = new ArrayList<MidiDevice.Info>();
        List list = MidiSystem.getMidiDeviceProviders();
        for (int i = 0; i < list.size(); ++i) {
            MidiDeviceProvider midiDeviceProvider = (MidiDeviceProvider)list.get(i);
            MidiDevice.Info[] infoArray = midiDeviceProvider.getDeviceInfo();
            for (int j = 0; j < infoArray.length; ++j) {
                arrayList.add(infoArray[j]);
            }
        }
        MidiDevice.Info[] infoArray = arrayList.toArray(new MidiDevice.Info[0]);
        return infoArray;
    }

    public static MidiDevice getMidiDevice(MidiDevice.Info info) throws MidiUnavailableException {
        List list = MidiSystem.getMidiDeviceProviders();
        for (int i = 0; i < list.size(); ++i) {
            MidiDeviceProvider midiDeviceProvider = (MidiDeviceProvider)list.get(i);
            if (!midiDeviceProvider.isDeviceSupported(info)) continue;
            MidiDevice midiDevice = midiDeviceProvider.getDevice(info);
            return midiDevice;
        }
        throw new IllegalArgumentException("Requested device not installed: " + info);
    }

    public static Receiver getReceiver() throws MidiUnavailableException {
        if (is_tru64_or_VMS) {
            throw new MidiUnavailableException("Java sound not supported");
        }
        MidiDevice midiDevice = MidiSystem.getDefaultDeviceWrapper(Receiver.class);
        Receiver receiver = midiDevice instanceof ReferenceCountingDevice ? ((ReferenceCountingDevice)((Object)midiDevice)).getReceiverReferenceCounting() : midiDevice.getReceiver();
        if (!(receiver instanceof MidiDeviceReceiver)) {
            receiver = new MidiDeviceReceiverEnvelope(midiDevice, receiver);
        }
        return receiver;
    }

    public static Transmitter getTransmitter() throws MidiUnavailableException {
        MidiDevice midiDevice = MidiSystem.getDefaultDeviceWrapper(Transmitter.class);
        Transmitter transmitter = midiDevice instanceof ReferenceCountingDevice ? ((ReferenceCountingDevice)((Object)midiDevice)).getTransmitterReferenceCounting() : midiDevice.getTransmitter();
        if (!(transmitter instanceof MidiDeviceTransmitter)) {
            transmitter = new MidiDeviceTransmitterEnvelope(midiDevice, transmitter);
        }
        return transmitter;
    }

    public static Synthesizer getSynthesizer() throws MidiUnavailableException {
        if (is_tru64_or_VMS) {
            throw new MidiUnavailableException("Java sound not supported");
        }
        return (Synthesizer)MidiSystem.getDefaultDeviceWrapper(Synthesizer.class);
    }

    public static Sequencer getSequencer() throws MidiUnavailableException {
        if (is_tru64_or_VMS) {
            throw new MidiUnavailableException("Java sound not supported");
        }
        return MidiSystem.getSequencer(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Sequencer getSequencer(boolean bl) throws MidiUnavailableException {
        Sequencer sequencer = (Sequencer)MidiSystem.getDefaultDeviceWrapper(Sequencer.class);
        if (bl) {
            MidiUnavailableException midiUnavailableException;
            Receiver receiver;
            block16: {
                block15: {
                    receiver = null;
                    midiUnavailableException = null;
                    try {
                        Synthesizer synthesizer = MidiSystem.getSynthesizer();
                        if (synthesizer instanceof ReferenceCountingDevice) {
                            receiver = ((ReferenceCountingDevice)((Object)synthesizer)).getReceiverReferenceCounting();
                            break block15;
                        }
                        synthesizer.open();
                        try {
                            receiver = synthesizer.getReceiver();
                        }
                        finally {
                            if (receiver == null) {
                                synthesizer.close();
                            }
                        }
                    }
                    catch (MidiUnavailableException midiUnavailableException2) {
                        if (!(midiUnavailableException2 instanceof MidiUnavailableException)) break block15;
                        midiUnavailableException = midiUnavailableException2;
                    }
                }
                if (receiver == null) {
                    try {
                        receiver = MidiSystem.getReceiver();
                    }
                    catch (Exception exception) {
                        if (!(exception instanceof MidiUnavailableException)) break block16;
                        midiUnavailableException = (MidiUnavailableException)exception;
                    }
                }
            }
            if (receiver != null) {
                sequencer.getTransmitter().setReceiver(receiver);
                if (sequencer instanceof AutoConnectSequencer) {
                    ((AutoConnectSequencer)((Object)sequencer)).setAutoConnect(receiver);
                }
            } else {
                if (midiUnavailableException != null) {
                    throw midiUnavailableException;
                }
                throw new MidiUnavailableException("no receiver available");
            }
        }
        return sequencer;
    }

    public static Soundbank getSoundbank(InputStream inputStream) throws InvalidMidiDataException, IOException {
        SoundbankReader soundbankReader = null;
        Soundbank soundbank = null;
        List list = MidiSystem.getSoundbankReaders();
        for (int i = 0; i < list.size(); ++i) {
            soundbankReader = (SoundbankReader)list.get(i);
            soundbank = soundbankReader.getSoundbank(inputStream);
            if (soundbank == null) continue;
            return soundbank;
        }
        throw new InvalidMidiDataException("cannot get soundbank from stream");
    }

    public static Soundbank getSoundbank(URL uRL) throws InvalidMidiDataException, IOException {
        SoundbankReader soundbankReader = null;
        Soundbank soundbank = null;
        List list = MidiSystem.getSoundbankReaders();
        for (int i = 0; i < list.size(); ++i) {
            soundbankReader = (SoundbankReader)list.get(i);
            soundbank = soundbankReader.getSoundbank(uRL);
            if (soundbank == null) continue;
            return soundbank;
        }
        throw new InvalidMidiDataException("cannot get soundbank from stream");
    }

    public static Soundbank getSoundbank(File file) throws InvalidMidiDataException, IOException {
        SoundbankReader soundbankReader = null;
        Soundbank soundbank = null;
        List list = MidiSystem.getSoundbankReaders();
        for (int i = 0; i < list.size(); ++i) {
            soundbankReader = (SoundbankReader)list.get(i);
            soundbank = soundbankReader.getSoundbank(file);
            if (soundbank == null) continue;
            return soundbank;
        }
        throw new InvalidMidiDataException("cannot get soundbank from stream");
    }

    public static MidiFileFormat getMidiFileFormat(InputStream inputStream) throws InvalidMidiDataException, IOException {
        List list = MidiSystem.getMidiFileReaders();
        MidiFileFormat midiFileFormat = null;
        for (int i = 0; i < list.size(); ++i) {
            MidiFileReader midiFileReader = (MidiFileReader)list.get(i);
            try {
                midiFileFormat = midiFileReader.getMidiFileFormat(inputStream);
                break;
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                continue;
            }
        }
        if (midiFileFormat == null) {
            throw new InvalidMidiDataException("input stream is not a supported file type");
        }
        return midiFileFormat;
    }

    public static MidiFileFormat getMidiFileFormat(URL uRL) throws InvalidMidiDataException, IOException {
        List list = MidiSystem.getMidiFileReaders();
        MidiFileFormat midiFileFormat = null;
        for (int i = 0; i < list.size(); ++i) {
            MidiFileReader midiFileReader = (MidiFileReader)list.get(i);
            try {
                midiFileFormat = midiFileReader.getMidiFileFormat(uRL);
                break;
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                continue;
            }
        }
        if (midiFileFormat == null) {
            throw new InvalidMidiDataException("url is not a supported file type");
        }
        return midiFileFormat;
    }

    public static MidiFileFormat getMidiFileFormat(File file) throws InvalidMidiDataException, IOException {
        List list = MidiSystem.getMidiFileReaders();
        MidiFileFormat midiFileFormat = null;
        for (int i = 0; i < list.size(); ++i) {
            MidiFileReader midiFileReader = (MidiFileReader)list.get(i);
            try {
                midiFileFormat = midiFileReader.getMidiFileFormat(file);
                break;
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                continue;
            }
        }
        if (midiFileFormat == null) {
            throw new InvalidMidiDataException("file is not a supported file type");
        }
        return midiFileFormat;
    }

    public static Sequence getSequence(InputStream inputStream) throws InvalidMidiDataException, IOException {
        List list = MidiSystem.getMidiFileReaders();
        Sequence sequence = null;
        for (int i = 0; i < list.size(); ++i) {
            MidiFileReader midiFileReader = (MidiFileReader)list.get(i);
            try {
                sequence = midiFileReader.getSequence(inputStream);
                break;
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                continue;
            }
        }
        if (sequence == null) {
            throw new InvalidMidiDataException("could not get sequence from input stream");
        }
        return sequence;
    }

    public static Sequence getSequence(URL uRL) throws InvalidMidiDataException, IOException {
        List list = MidiSystem.getMidiFileReaders();
        Sequence sequence = null;
        for (int i = 0; i < list.size(); ++i) {
            MidiFileReader midiFileReader = (MidiFileReader)list.get(i);
            try {
                sequence = midiFileReader.getSequence(uRL);
                break;
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                continue;
            }
        }
        if (sequence == null) {
            throw new InvalidMidiDataException("could not get sequence from URL");
        }
        return sequence;
    }

    public static Sequence getSequence(File file) throws InvalidMidiDataException, IOException {
        List list = MidiSystem.getMidiFileReaders();
        Sequence sequence = null;
        for (int i = 0; i < list.size(); ++i) {
            MidiFileReader midiFileReader = (MidiFileReader)list.get(i);
            try {
                sequence = midiFileReader.getSequence(file);
                break;
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                continue;
            }
        }
        if (sequence == null) {
            throw new InvalidMidiDataException("could not get sequence from file");
        }
        return sequence;
    }

    public static int[] getMidiFileTypes() {
        Object object;
        List list = MidiSystem.getMidiFileWriters();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i = 0; i < list.size(); ++i) {
            MidiFileWriter midiFileWriter = (MidiFileWriter)list.get(i);
            object = midiFileWriter.getMidiFileTypes();
            for (int j = 0; j < ((Object)object).length; ++j) {
                hashSet.add(new Integer((int)object[j]));
            }
        }
        int[] nArray = new int[hashSet.size()];
        int n = 0;
        object = hashSet.iterator();
        while (object.hasNext()) {
            Integer n2 = (Integer)object.next();
            nArray[n++] = n2;
        }
        return nArray;
    }

    public static boolean isFileTypeSupported(int n) {
        List list = MidiSystem.getMidiFileWriters();
        for (int i = 0; i < list.size(); ++i) {
            MidiFileWriter midiFileWriter = (MidiFileWriter)list.get(i);
            if (!midiFileWriter.isFileTypeSupported(n)) continue;
            return true;
        }
        return false;
    }

    public static int[] getMidiFileTypes(Sequence sequence) {
        Object object;
        List list = MidiSystem.getMidiFileWriters();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i = 0; i < list.size(); ++i) {
            MidiFileWriter midiFileWriter = (MidiFileWriter)list.get(i);
            object = midiFileWriter.getMidiFileTypes(sequence);
            for (int j = 0; j < ((Object)object).length; ++j) {
                hashSet.add(new Integer((int)object[j]));
            }
        }
        int[] nArray = new int[hashSet.size()];
        int n = 0;
        object = hashSet.iterator();
        while (object.hasNext()) {
            Integer n2 = (Integer)object.next();
            nArray[n++] = n2;
        }
        return nArray;
    }

    public static boolean isFileTypeSupported(int n, Sequence sequence) {
        List list = MidiSystem.getMidiFileWriters();
        for (int i = 0; i < list.size(); ++i) {
            MidiFileWriter midiFileWriter = (MidiFileWriter)list.get(i);
            if (!midiFileWriter.isFileTypeSupported(n, sequence)) continue;
            return true;
        }
        return false;
    }

    public static int write(Sequence sequence, int n, OutputStream outputStream) throws IOException {
        List list = MidiSystem.getMidiFileWriters();
        int n2 = -2;
        for (int i = 0; i < list.size(); ++i) {
            MidiFileWriter midiFileWriter = (MidiFileWriter)list.get(i);
            if (!midiFileWriter.isFileTypeSupported(n, sequence)) continue;
            n2 = midiFileWriter.write(sequence, n, outputStream);
            break;
        }
        if (n2 == -2) {
            throw new IllegalArgumentException("MIDI file type is not supported");
        }
        return n2;
    }

    public static int write(Sequence sequence, int n, File file) throws IOException {
        List list = MidiSystem.getMidiFileWriters();
        int n2 = -2;
        for (int i = 0; i < list.size(); ++i) {
            MidiFileWriter midiFileWriter = (MidiFileWriter)list.get(i);
            if (!midiFileWriter.isFileTypeSupported(n, sequence)) continue;
            n2 = midiFileWriter.write(sequence, n, file);
            break;
        }
        if (n2 == -2) {
            throw new IllegalArgumentException("MIDI file type is not supported");
        }
        return n2;
    }

    private static List getMidiDeviceProviders() {
        return MidiSystem.getProviders(MidiDeviceProvider.class);
    }

    private static List getSoundbankReaders() {
        return MidiSystem.getProviders(SoundbankReader.class);
    }

    private static List getMidiFileWriters() {
        return MidiSystem.getProviders(MidiFileWriter.class);
    }

    private static List getMidiFileReaders() {
        return MidiSystem.getProviders(MidiFileReader.class);
    }

    private static MidiDevice getDefaultDeviceWrapper(Class clazz) throws MidiUnavailableException {
        try {
            return MidiSystem.getDefaultDevice(clazz);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MidiUnavailableException midiUnavailableException = new MidiUnavailableException();
            midiUnavailableException.initCause(illegalArgumentException);
            throw midiUnavailableException;
        }
    }

    private static MidiDevice getDefaultDevice(Class clazz) {
        MidiDevice midiDevice;
        MidiDeviceProvider midiDeviceProvider;
        List list = MidiSystem.getMidiDeviceProviders();
        String string = JDK13Services.getDefaultProviderClassName(clazz);
        String string2 = JDK13Services.getDefaultInstanceName(clazz);
        if (string != null && (midiDeviceProvider = MidiSystem.getNamedProvider(string, list)) != null) {
            if (string2 != null && (midiDevice = MidiSystem.getNamedDevice(string2, midiDeviceProvider, clazz)) != null) {
                return midiDevice;
            }
            midiDevice = MidiSystem.getFirstDevice(midiDeviceProvider, clazz);
            if (midiDevice != null) {
                return midiDevice;
            }
        }
        if (string2 != null && (midiDevice = MidiSystem.getNamedDevice(string2, list, clazz)) != null) {
            return midiDevice;
        }
        midiDevice = MidiSystem.getFirstDevice(list, clazz);
        if (midiDevice != null) {
            return midiDevice;
        }
        throw new IllegalArgumentException("Requested device not installed");
    }

    private static MidiDeviceProvider getNamedProvider(String string, List list) {
        for (int i = 0; i < list.size(); ++i) {
            MidiDeviceProvider midiDeviceProvider = (MidiDeviceProvider)list.get(i);
            if (!midiDeviceProvider.getClass().getName().equals(string)) continue;
            return midiDeviceProvider;
        }
        return null;
    }

    private static MidiDevice getNamedDevice(String string, MidiDeviceProvider midiDeviceProvider, Class clazz) {
        MidiDevice midiDevice = MidiSystem.getNamedDevice(string, midiDeviceProvider, clazz, false, false);
        if (midiDevice != null) {
            return midiDevice;
        }
        if (clazz == Receiver.class && (midiDevice = MidiSystem.getNamedDevice(string, midiDeviceProvider, clazz, true, false)) != null) {
            return midiDevice;
        }
        return null;
    }

    private static MidiDevice getNamedDevice(String string, MidiDeviceProvider midiDeviceProvider, Class clazz, boolean bl, boolean bl2) {
        MidiDevice.Info[] infoArray = midiDeviceProvider.getDeviceInfo();
        for (int i = 0; i < infoArray.length; ++i) {
            MidiDevice midiDevice;
            if (!infoArray[i].getName().equals(string) || !MidiSystem.isAppropriateDevice(midiDevice = midiDeviceProvider.getDevice(infoArray[i]), clazz, bl, bl2)) continue;
            return midiDevice;
        }
        return null;
    }

    private static MidiDevice getNamedDevice(String string, List list, Class clazz) {
        MidiDevice midiDevice = MidiSystem.getNamedDevice(string, list, clazz, false, false);
        if (midiDevice != null) {
            return midiDevice;
        }
        if (clazz == Receiver.class && (midiDevice = MidiSystem.getNamedDevice(string, list, clazz, true, false)) != null) {
            return midiDevice;
        }
        return null;
    }

    private static MidiDevice getNamedDevice(String string, List list, Class clazz, boolean bl, boolean bl2) {
        for (int i = 0; i < list.size(); ++i) {
            MidiDeviceProvider midiDeviceProvider = (MidiDeviceProvider)list.get(i);
            MidiDevice midiDevice = MidiSystem.getNamedDevice(string, midiDeviceProvider, clazz, bl, bl2);
            if (midiDevice == null) continue;
            return midiDevice;
        }
        return null;
    }

    private static MidiDevice getFirstDevice(MidiDeviceProvider midiDeviceProvider, Class clazz) {
        MidiDevice midiDevice = MidiSystem.getFirstDevice(midiDeviceProvider, clazz, false, false);
        if (midiDevice != null) {
            return midiDevice;
        }
        if (clazz == Receiver.class && (midiDevice = MidiSystem.getFirstDevice(midiDeviceProvider, clazz, true, false)) != null) {
            return midiDevice;
        }
        return null;
    }

    private static MidiDevice getFirstDevice(MidiDeviceProvider midiDeviceProvider, Class clazz, boolean bl, boolean bl2) {
        MidiDevice.Info[] infoArray = midiDeviceProvider.getDeviceInfo();
        for (int i = 0; i < infoArray.length; ++i) {
            MidiDevice midiDevice = midiDeviceProvider.getDevice(infoArray[i]);
            if (!MidiSystem.isAppropriateDevice(midiDevice, clazz, bl, bl2)) continue;
            return midiDevice;
        }
        return null;
    }

    private static MidiDevice getFirstDevice(List list, Class clazz) {
        MidiDevice midiDevice = MidiSystem.getFirstDevice(list, clazz, false, false);
        if (midiDevice != null) {
            return midiDevice;
        }
        if (clazz == Receiver.class && (midiDevice = MidiSystem.getFirstDevice(list, clazz, true, false)) != null) {
            return midiDevice;
        }
        return null;
    }

    private static MidiDevice getFirstDevice(List list, Class clazz, boolean bl, boolean bl2) {
        for (int i = 0; i < list.size(); ++i) {
            MidiDeviceProvider midiDeviceProvider = (MidiDeviceProvider)list.get(i);
            MidiDevice midiDevice = MidiSystem.getFirstDevice(midiDeviceProvider, clazz, bl, bl2);
            if (midiDevice == null) continue;
            return midiDevice;
        }
        return null;
    }

    private static boolean isAppropriateDevice(MidiDevice midiDevice, Class clazz, boolean bl, boolean bl2) {
        if (clazz.isInstance(midiDevice)) {
            return true;
        }
        return (!(midiDevice instanceof Sequencer) && !(midiDevice instanceof Synthesizer) || midiDevice instanceof Sequencer && bl2 || midiDevice instanceof Synthesizer && bl) && (clazz == Receiver.class && midiDevice.getMaxReceivers() != 0 || clazz == Transmitter.class && midiDevice.getMaxTransmitters() != 0);
    }

    private static List getProviders(Class clazz) {
        return JDK13Services.getProviders(clazz);
    }
}

