/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.time.ZoneId;
import java.util.Date;
import java.util.Locale;
import java.util.PropertyPermission;
import sun.security.action.GetPropertyAction;
import sun.util.calendar.ZoneInfo;
import sun.util.calendar.ZoneInfoFile;
import sun.util.locale.provider.TimeZoneNameUtility;

public abstract class TimeZone
implements Serializable,
Cloneable {
    public static final int SHORT = 0;
    public static final int LONG = 1;
    private static final int ONE_MINUTE = 60000;
    private static final int ONE_HOUR = 3600000;
    private static final int ONE_DAY = 86400000;
    static final long serialVersionUID = 3581463369166924961L;
    static final TimeZone NO_TIMEZONE = null;
    private String ID;
    private static volatile TimeZone defaultTimeZone;
    static final String GMT_ID = "GMT";
    private static final int GMT_ID_LENGTH = 3;
    private static volatile TimeZone mainAppContextDefault;

    public abstract int getOffset(int var1, int var2, int var3, int var4, int var5, int var6);

    public int getOffset(long l) {
        if (this.inDaylightTime(new Date(l))) {
            return this.getRawOffset() + this.getDSTSavings();
        }
        return this.getRawOffset();
    }

    int getOffsets(long l, int[] nArray) {
        int n = this.getRawOffset();
        int n2 = 0;
        if (this.inDaylightTime(new Date(l))) {
            n2 = this.getDSTSavings();
        }
        if (nArray != null) {
            nArray[0] = n;
            nArray[1] = n2;
        }
        return n + n2;
    }

    public abstract void setRawOffset(int var1);

    public abstract int getRawOffset();

    public String getID() {
        return this.ID;
    }

    public void setID(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.ID = string;
    }

    public final String getDisplayName() {
        return this.getDisplayName(false, 1, Locale.getDefault(Locale.Category.DISPLAY));
    }

    public final String getDisplayName(Locale locale) {
        return this.getDisplayName(false, 1, locale);
    }

    public final String getDisplayName(boolean bl, int n) {
        return this.getDisplayName(bl, n, Locale.getDefault(Locale.Category.DISPLAY));
    }

    public String getDisplayName(boolean bl, int n, Locale locale) {
        int n2;
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Illegal style: " + n);
        }
        String string = this.getID();
        String string2 = TimeZoneNameUtility.retrieveDisplayName(string, bl, n, locale);
        if (string2 != null) {
            return string2;
        }
        if (string.startsWith(GMT_ID) && string.length() > 3 && ((n2 = (int)string.charAt(3)) == 43 || n2 == 45)) {
            return string;
        }
        n2 = this.getRawOffset();
        if (bl) {
            n2 += this.getDSTSavings();
        }
        return ZoneInfoFile.toCustomID(n2);
    }

    private static String[] getDisplayNames(String string, Locale locale) {
        return TimeZoneNameUtility.retrieveDisplayNames(string, locale);
    }

    public int getDSTSavings() {
        if (this.useDaylightTime()) {
            return 3600000;
        }
        return 0;
    }

    public abstract boolean useDaylightTime();

    public boolean observesDaylightTime() {
        return this.useDaylightTime() || this.inDaylightTime(new Date());
    }

    public abstract boolean inDaylightTime(Date var1);

    public static synchronized TimeZone getTimeZone(String string) {
        return TimeZone.getTimeZone(string, true);
    }

    public static TimeZone getTimeZone(ZoneId zoneId) {
        String string = zoneId.getId();
        char c = string.charAt(0);
        if (c == '+' || c == '-') {
            string = GMT_ID + string;
        } else if (c == 'Z' && string.length() == 1) {
            string = "UTC";
        }
        return TimeZone.getTimeZone(string, true);
    }

    public ZoneId toZoneId() {
        String string = this.getID();
        if (ZoneInfoFile.useOldMapping() && string.length() == 3) {
            if ("EST".equals(string)) {
                return ZoneId.of("America/New_York");
            }
            if ("MST".equals(string)) {
                return ZoneId.of("America/Denver");
            }
            if ("HST".equals(string)) {
                return ZoneId.of("America/Honolulu");
            }
        }
        return ZoneId.of(string, ZoneId.SHORT_IDS);
    }

    private static TimeZone getTimeZone(String string, boolean bl) {
        TimeZone timeZone = ZoneInfo.getTimeZone(string);
        if (timeZone == null && (timeZone = TimeZone.parseCustomTimeZone(string)) == null && bl) {
            timeZone = new ZoneInfo(GMT_ID, 0);
        }
        return timeZone;
    }

    public static synchronized String[] getAvailableIDs(int n) {
        return ZoneInfo.getAvailableIDs(n);
    }

    public static synchronized String[] getAvailableIDs() {
        return ZoneInfo.getAvailableIDs();
    }

    private static native String getSystemTimeZoneID(String var0);

    private static native String getSystemGMTOffsetID();

    public static TimeZone getDefault() {
        return (TimeZone)TimeZone.getDefaultRef().clone();
    }

    static TimeZone getDefaultRef() {
        TimeZone timeZone = defaultTimeZone;
        if (timeZone == null) {
            timeZone = TimeZone.setDefaultZone();
            assert (timeZone != null);
        }
        return timeZone;
    }

    private static synchronized TimeZone setDefaultZone() {
        TimeZone timeZone = null;
        String string = AccessController.doPrivileged(new GetPropertyAction("user.timezone"));
        if (string == null || string.isEmpty()) {
            String string2;
            String string3 = AccessController.doPrivileged(new GetPropertyAction("java.home"));
            try {
                string = TimeZone.getSystemTimeZoneID(string3);
                if (string != null) {
                    timeZone = TimeZone.getTimeZone(string, false);
                } else {
                    string = GMT_ID;
                }
            }
            catch (NullPointerException nullPointerException) {
                string = GMT_ID;
            }
            if (timeZone == null && (string2 = TimeZone.getSystemGMTOffsetID()) != null) {
                string = string2;
            }
            string2 = string;
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    System.setProperty("user.timezone", string2);
                    return null;
                }
            });
        }
        timeZone = TimeZone.getTimeZone(string, true);
        assert (timeZone != null);
        defaultTimeZone = timeZone;
        return timeZone;
    }

    public static void setDefault(TimeZone timeZone) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new PropertyPermission("user.timezone", "write"));
        }
        defaultTimeZone = timeZone;
    }

    public boolean hasSameRules(TimeZone timeZone) {
        return timeZone != null && this.getRawOffset() == timeZone.getRawOffset() && this.useDaylightTime() == timeZone.useDaylightTime();
    }

    public Object clone() {
        try {
            TimeZone timeZone = (TimeZone)super.clone();
            timeZone.ID = this.ID;
            return timeZone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException);
        }
    }

    private static final TimeZone parseCustomTimeZone(String string) {
        char c;
        int n = string.length();
        if (n < 5 || string.indexOf(GMT_ID) != 0) {
            return null;
        }
        ZoneInfo zoneInfo = ZoneInfoFile.getZoneInfo(string);
        if (zoneInfo != null) {
            return zoneInfo;
        }
        int n2 = 3;
        boolean bl = false;
        if ((c = string.charAt(n2++)) == '-') {
            bl = true;
        } else if (c != '+') {
            return null;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n2 < n) {
            if ((c = string.charAt(n2++)) == ':') {
                if (n5 > 0) {
                    return null;
                }
                if (n6 > 2) {
                    return null;
                }
                n3 = n4;
                ++n5;
                n4 = 0;
                n6 = 0;
                continue;
            }
            if (c < '0' || c > '9') {
                return null;
            }
            n4 = n4 * 10 + (c - 48);
            ++n6;
        }
        if (n2 != n) {
            return null;
        }
        if (n5 == 0) {
            if (n6 <= 2) {
                n3 = n4;
                n4 = 0;
            } else {
                n3 = n4 / 100;
                n4 %= 100;
            }
        } else if (n6 != 2) {
            return null;
        }
        if (n3 > 23 || n4 > 59) {
            return null;
        }
        int n7 = (n3 * 60 + n4) * 60 * 1000;
        if (n7 == 0) {
            zoneInfo = ZoneInfoFile.getZoneInfo(GMT_ID);
            if (bl) {
                zoneInfo.setID("GMT-00:00");
            } else {
                zoneInfo.setID("GMT+00:00");
            }
        } else {
            zoneInfo = ZoneInfoFile.getCustomTimeZone(string, bl ? -n7 : n7);
        }
        return zoneInfo;
    }
}

