/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.dgc.VMID;
import java.rmi.server.ObjID;
import java.rmi.server.Unreferenced;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sun.rmi.runtime.Log;
import sun.rmi.runtime.NewThreadAction;
import sun.rmi.server.Dispatcher;
import sun.rmi.transport.DGCImpl;
import sun.rmi.transport.ObjectEndpoint;
import sun.rmi.transport.ObjectTable;
import sun.rmi.transport.SequenceEntry;
import sun.rmi.transport.Transport;
import sun.rmi.transport.WeakRef;

public final class Target {
    private final ObjID id;
    private final boolean permanent;
    private final WeakRef weakImpl;
    private volatile Dispatcher disp;
    private final Remote stub;
    private final Vector<VMID> refSet = new Vector();
    private final Hashtable<VMID, SequenceEntry> sequenceTable = new Hashtable(5);
    private final AccessControlContext acc;
    private final ClassLoader ccl;
    private int callCount = 0;
    private boolean removed = false;
    private volatile Transport exportedTransport = null;
    private static int nextThreadNum = 0;

    public Target(Remote remote, Dispatcher dispatcher, Remote remote2, ObjID objID, boolean bl) {
        this.weakImpl = new WeakRef(remote, ObjectTable.reapQueue);
        this.disp = dispatcher;
        this.stub = remote2;
        this.id = objID;
        this.acc = AccessController.getContext();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader2 = remote.getClass().getClassLoader();
        this.ccl = Target.checkLoaderAncestry(classLoader, classLoader2) ? classLoader : classLoader2;
        this.permanent = bl;
        if (bl) {
            this.pinImpl();
        }
    }

    private static boolean checkLoaderAncestry(ClassLoader classLoader, ClassLoader classLoader2) {
        if (classLoader2 == null) {
            return true;
        }
        if (classLoader == null) {
            return false;
        }
        for (ClassLoader classLoader3 = classLoader; classLoader3 != null; classLoader3 = classLoader3.getParent()) {
            if (classLoader3 != classLoader2) continue;
            return true;
        }
        return false;
    }

    public Remote getStub() {
        return this.stub;
    }

    ObjectEndpoint getObjectEndpoint() {
        return new ObjectEndpoint(this.id, this.exportedTransport);
    }

    WeakRef getWeakImpl() {
        return this.weakImpl;
    }

    Dispatcher getDispatcher() {
        return this.disp;
    }

    AccessControlContext getAccessControlContext() {
        return this.acc;
    }

    ClassLoader getContextClassLoader() {
        return this.ccl;
    }

    Remote getImpl() {
        return (Remote)this.weakImpl.get();
    }

    boolean isPermanent() {
        return this.permanent;
    }

    synchronized void pinImpl() {
        this.weakImpl.pin();
    }

    synchronized void unpinImpl() {
        if (!this.permanent && this.refSet.isEmpty()) {
            this.weakImpl.unpin();
        }
    }

    void setExportedTransport(Transport transport) {
        if (this.exportedTransport == null) {
            this.exportedTransport = transport;
        }
    }

    synchronized void referenced(long l, VMID vMID) {
        SequenceEntry sequenceEntry = this.sequenceTable.get(vMID);
        if (sequenceEntry == null) {
            this.sequenceTable.put(vMID, new SequenceEntry(l));
        } else if (sequenceEntry.sequenceNum < l) {
            sequenceEntry.update(l);
        } else {
            return;
        }
        if (!this.refSet.contains(vMID)) {
            this.pinImpl();
            if (this.getImpl() == null) {
                return;
            }
            if (DGCImpl.dgcLog.isLoggable(Log.VERBOSE)) {
                DGCImpl.dgcLog.log(Log.VERBOSE, "add to dirty set: " + vMID);
            }
            this.refSet.addElement(vMID);
            DGCImpl.getDGCImpl().registerTarget(vMID, this);
        }
    }

    synchronized void unreferenced(long l, VMID vMID, boolean bl) {
        SequenceEntry sequenceEntry = this.sequenceTable.get(vMID);
        if (sequenceEntry == null || sequenceEntry.sequenceNum > l) {
            return;
        }
        if (bl) {
            sequenceEntry.retain(l);
        } else if (!sequenceEntry.keep) {
            this.sequenceTable.remove(vMID);
        }
        if (DGCImpl.dgcLog.isLoggable(Log.VERBOSE)) {
            DGCImpl.dgcLog.log(Log.VERBOSE, "remove from dirty set: " + vMID);
        }
        this.refSetRemove(vMID);
    }

    private synchronized void refSetRemove(VMID vMID) {
        DGCImpl.getDGCImpl().unregisterTarget(vMID, this);
        if (this.refSet.removeElement(vMID) && this.refSet.isEmpty()) {
            Remote remote;
            if (DGCImpl.dgcLog.isLoggable(Log.VERBOSE)) {
                DGCImpl.dgcLog.log(Log.VERBOSE, "reference set is empty: target = " + this);
            }
            if ((remote = this.getImpl()) instanceof Unreferenced) {
                final Unreferenced unreferenced = (Unreferenced)((Object)remote);
                AccessController.doPrivileged(new NewThreadAction(new Runnable(){

                    @Override
                    public void run() {
                        Thread.currentThread().setContextClassLoader(Target.this.ccl);
                        AccessController.doPrivileged(new PrivilegedAction<Void>(){

                            @Override
                            public Void run() {
                                unreferenced.unreferenced();
                                return null;
                            }
                        }, Target.this.acc);
                    }
                }, "Unreferenced-" + nextThreadNum++, false, true)).start();
            }
            this.unpinImpl();
        }
    }

    synchronized boolean unexport(boolean bl) {
        if (bl || this.callCount == 0 || this.disp == null) {
            this.disp = null;
            this.unpinImpl();
            DGCImpl dGCImpl = DGCImpl.getDGCImpl();
            Enumeration<VMID> enumeration = this.refSet.elements();
            while (enumeration.hasMoreElements()) {
                VMID vMID = enumeration.nextElement();
                dGCImpl.unregisterTarget(vMID, this);
            }
            return true;
        }
        return false;
    }

    synchronized void markRemoved() {
        if (this.removed) {
            throw new AssertionError();
        }
        this.removed = true;
        if (!this.permanent && this.callCount == 0) {
            ObjectTable.decrementKeepAliveCount();
        }
        if (this.exportedTransport != null) {
            this.exportedTransport.targetUnexported();
        }
    }

    synchronized void incrementCallCount() throws NoSuchObjectException {
        if (this.disp != null) {
            ++this.callCount;
        } else {
            throw new NoSuchObjectException("object not accepting new calls");
        }
    }

    synchronized void decrementCallCount() {
        if (--this.callCount < 0) {
            throw new Error("internal error: call count less than zero");
        }
        if (!this.permanent && this.removed && this.callCount == 0) {
            ObjectTable.decrementKeepAliveCount();
        }
    }

    boolean isEmpty() {
        return this.refSet.isEmpty();
    }

    public synchronized void vmidDead(VMID vMID) {
        if (DGCImpl.dgcLog.isLoggable(Log.BRIEF)) {
            DGCImpl.dgcLog.log(Log.BRIEF, "removing endpoint " + vMID + " from reference set");
        }
        this.sequenceTable.remove(vMID);
        this.refSetRemove(vMID);
    }
}

