/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal;

import java.util.Iterator;
import sun.org.mozilla.javascript.internal.Context;
import sun.org.mozilla.javascript.internal.IdFunctionObject;
import sun.org.mozilla.javascript.internal.IdScriptableObject;
import sun.org.mozilla.javascript.internal.JavaScriptException;
import sun.org.mozilla.javascript.internal.NativeGenerator;
import sun.org.mozilla.javascript.internal.NativeObject;
import sun.org.mozilla.javascript.internal.ScriptRuntime;
import sun.org.mozilla.javascript.internal.Scriptable;
import sun.org.mozilla.javascript.internal.ScriptableObject;
import sun.org.mozilla.javascript.internal.Undefined;
import sun.org.mozilla.javascript.internal.VMBridge;

public final class NativeIterator
extends IdScriptableObject {
    private static final long serialVersionUID = -4136968203581667681L;
    private static final Object ITERATOR_TAG = "Iterator";
    private static final String STOP_ITERATION = "StopIteration";
    public static final String ITERATOR_PROPERTY_NAME = "__iterator__";
    private static final int Id_constructor = 1;
    private static final int Id_next = 2;
    private static final int Id___iterator__ = 3;
    private static final int MAX_PROTOTYPE_ID = 3;
    private Object objectIterator;

    static void init(ScriptableObject scriptableObject, boolean bl) {
        NativeIterator nativeIterator = new NativeIterator();
        nativeIterator.exportAsJSClass(3, scriptableObject, bl);
        NativeGenerator.init(scriptableObject, bl);
        StopIteration stopIteration = new StopIteration();
        stopIteration.setPrototype(NativeIterator.getObjectPrototype(scriptableObject));
        stopIteration.setParentScope(scriptableObject);
        if (bl) {
            stopIteration.sealObject();
        }
        ScriptableObject.defineProperty(scriptableObject, STOP_ITERATION, stopIteration, 2);
        scriptableObject.associateValue(ITERATOR_TAG, stopIteration);
    }

    private NativeIterator() {
    }

    private NativeIterator(Object object) {
        this.objectIterator = object;
    }

    public static Object getStopIterationObject(Scriptable scriptable) {
        Scriptable scriptable2 = ScriptableObject.getTopLevelScope(scriptable);
        return ScriptableObject.getTopScopeValue(scriptable2, ITERATOR_TAG);
    }

    @Override
    public String getClassName() {
        return "Iterator";
    }

    @Override
    protected void initPrototypeId(int n) {
        String string;
        int n2;
        switch (n) {
            case 1: {
                n2 = 2;
                string = "constructor";
                break;
            }
            case 2: {
                n2 = 0;
                string = "next";
                break;
            }
            case 3: {
                n2 = 1;
                string = ITERATOR_PROPERTY_NAME;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(ITERATOR_TAG, n, string, n2);
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(ITERATOR_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        if (n == 1) {
            return NativeIterator.jsConstructor(context, scriptable, scriptable2, objectArray);
        }
        if (!(scriptable2 instanceof NativeIterator)) {
            throw NativeIterator.incompatibleCallError(idFunctionObject);
        }
        NativeIterator nativeIterator = (NativeIterator)scriptable2;
        switch (n) {
            case 2: {
                return nativeIterator.next(context, scriptable);
            }
            case 3: {
                return scriptable2;
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    private static Object jsConstructor(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        Scriptable scriptable3;
        Iterator<?> iterator;
        boolean bl;
        if (objectArray.length == 0 || objectArray[0] == null || objectArray[0] == Undefined.instance) {
            Object object = objectArray.length == 0 ? Undefined.instance : objectArray[0];
            throw ScriptRuntime.typeError1("msg.no.properties", ScriptRuntime.toString(object));
        }
        Scriptable scriptable4 = ScriptRuntime.toObject(scriptable, objectArray[0]);
        boolean bl2 = bl = objectArray.length > 1 && ScriptRuntime.toBoolean(objectArray[1]);
        if (scriptable2 != null) {
            iterator = VMBridge.instance.getJavaIterator(context, scriptable, scriptable4);
            if (iterator != null) {
                scriptable = ScriptableObject.getTopLevelScope(scriptable);
                return context.getWrapFactory().wrap(context, scriptable, new WrappedJavaIterator(iterator, scriptable), WrappedJavaIterator.class);
            }
            scriptable3 = ScriptRuntime.toIterator(context, scriptable, scriptable4, bl);
            if (scriptable3 != null) {
                return scriptable3;
            }
        }
        iterator = ScriptRuntime.enumInit((Object)scriptable4, context, bl ? 3 : 5);
        ScriptRuntime.setEnumNumbers(iterator, true);
        scriptable3 = new NativeIterator(iterator);
        ((ScriptableObject)scriptable3).setPrototype(ScriptableObject.getClassPrototype(scriptable, ((NativeIterator)scriptable3).getClassName()));
        ((ScriptableObject)scriptable3).setParentScope(scriptable);
        return scriptable3;
    }

    private Object next(Context context, Scriptable scriptable) {
        Boolean bl = ScriptRuntime.enumNext(this.objectIterator);
        if (!bl.booleanValue()) {
            throw new JavaScriptException(NativeIterator.getStopIterationObject(scriptable), null, 0);
        }
        return ScriptRuntime.enumId(this.objectIterator, context);
    }

    @Override
    protected int findPrototypeId(String string) {
        int n;
        block5: {
            n = 0;
            String string2 = null;
            int n2 = string.length();
            if (n2 == 4) {
                string2 = "next";
                n = 2;
            } else if (n2 == 11) {
                string2 = "constructor";
                n = 1;
            } else if (n2 == 12) {
                string2 = ITERATOR_PROPERTY_NAME;
                n = 3;
            }
            if (string2 == null || string2 == string || string2.equals(string)) break block5;
            n = 0;
        }
        return n;
    }

    public static class WrappedJavaIterator {
        private Iterator<?> iterator;
        private Scriptable scope;

        WrappedJavaIterator(Iterator<?> iterator, Scriptable scriptable) {
            this.iterator = iterator;
            this.scope = scriptable;
        }

        public Object next() {
            if (!this.iterator.hasNext()) {
                throw new JavaScriptException(NativeIterator.getStopIterationObject(this.scope), null, 0);
            }
            return this.iterator.next();
        }

        public Object __iterator__(boolean bl) {
            return this;
        }
    }

    static class StopIteration
    extends NativeObject {
        private static final long serialVersionUID = 2485151085722377663L;

        StopIteration() {
        }

        @Override
        public String getClassName() {
            return NativeIterator.STOP_ITERATION;
        }

        @Override
        public boolean hasInstance(Scriptable scriptable) {
            return scriptable instanceof StopIteration;
        }
    }
}

