/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.FileSystemException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sun.nio.fs.AbstractUserDefinedFileAttributeView;
import sun.nio.fs.UnixChannelFactory;
import sun.nio.fs.UnixCopyFile;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileAttributes;
import sun.nio.fs.UnixNativeDispatcher;
import sun.nio.fs.UnixPath;

class HPUserDefinedFileAttributeView
extends AbstractUserDefinedFileAttributeView {
    private final UnixPath file;
    private final boolean followLinks;

    private byte[] nameAsBytes(UnixPath unixPath, String string) throws IOException {
        byte[] byArray = string.getBytes();
        if ((byArray.length == 0 || byArray[0] == 46) && (byArray.length <= 1 || byArray.length == 2 && byArray[1] == 46)) {
            throw new FileSystemException(unixPath.getPathForExceptionMessage(), null, "'" + string + "' is not a valid name");
        }
        return byArray;
    }

    HPUserDefinedFileAttributeView(UnixPath unixPath, boolean bl) {
        this.file = unixPath;
        this.followLinks = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> list() throws IOException {
        if (System.getSecurityManager() != null) {
            this.checkAccess(this.file.getPathForPermissionCheck(), true, false);
        }
        try {
            Object object;
            long l;
            String string = new String(this.file.asByteArray());
            int n = !this.followLinks ? UnixNativeDispatcher.hpOpenat(string.getBytes(), 16777317, 0) : UnixNativeDispatcher.hpOpenat(string.getBytes(), 0, 0);
            try {
                l = UnixNativeDispatcher.hpOpendir(this.file.asByteArray());
            }
            catch (UnixException unixException) {
                UnixNativeDispatcher.close(n);
                throw unixException;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            try {
                while ((object = UnixNativeDispatcher.readdir(l)) != null) {
                    String string2 = new String((byte[])object);
                    if (string2.equals(".") || string2.equals("..")) continue;
                    arrayList.add(string2);
                }
            }
            finally {
                UnixNativeDispatcher.closedir(l);
            }
            object = Collections.unmodifiableList(arrayList);
            return object;
        }
        catch (UnixException unixException) {
            throw new FileSystemException(this.file.getPathForExceptionMessage(), null, "Unable to get list of extended attributes: " + unixException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size(String string) throws IOException {
        int n;
        if (System.getSecurityManager() != null) {
            this.checkAccess(this.file.getPathForPermissionCheck(), true, false);
        }
        int n2 = !this.followLinks ? UnixNativeDispatcher.hpOpenat(this.file.asByteArray(), 16777317, 0) : UnixNativeDispatcher.hpOpenat(this.file.asByteArray(), 101, 0);
        try {
            UnixFileAttributes unixFileAttributes = UnixFileAttributes.get(n2);
            long l = unixFileAttributes.size();
            if (l > Integer.MAX_VALUE) {
                throw new ArithmeticException("Extended attribute value too large");
            }
            n = (int)l;
        }
        catch (Throwable throwable) {
            try {
                UnixNativeDispatcher.close(n2);
                throw throwable;
            }
            catch (UnixException unixException) {
                throw new FileSystemException(this.file.getPathForExceptionMessage(), null, "Unable to get size of extended attribute '" + string + "': " + unixException.getMessage());
            }
        }
        UnixNativeDispatcher.close(n2);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(String string, ByteBuffer byteBuffer) throws IOException {
        int n;
        if (System.getSecurityManager() != null) {
            this.checkAccess(this.file.getPathForPermissionCheck(), true, false);
        }
        int n2 = !this.followLinks ? UnixNativeDispatcher.hpOpenat(this.file.asByteArray(), 16777317, 0) : UnixNativeDispatcher.hpOpenat(this.file.asByteArray(), 101, 0);
        FileChannel fileChannel = UnixChannelFactory.newFileChannel(n2, this.file.toString(), true, false);
        try {
            if (fileChannel.size() > (long)byteBuffer.remaining()) {
                throw new IOException("Extended attribute file too large");
            }
            int n3 = 0;
            while (byteBuffer.hasRemaining() && (n = fileChannel.read(byteBuffer)) >= 0) {
                n3 += n;
            }
            n = n3;
        }
        catch (Throwable throwable) {
            try {
                fileChannel.close();
                throw throwable;
            }
            catch (UnixException unixException) {
                throw new FileSystemException(this.file.getPathForExceptionMessage(), null, "Unable to read extended attribute '" + string + "': " + unixException.getMessage());
            }
        }
        fileChannel.close();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(String string, ByteBuffer byteBuffer) throws IOException {
        int n;
        if (System.getSecurityManager() != null) {
            this.checkAccess(this.file.getPathForPermissionCheck(), false, true);
        }
        int n2 = !this.followLinks ? UnixNativeDispatcher.hpOpenat(this.file.asByteArray(), 16778085, 511) : UnixNativeDispatcher.hpOpenat(this.file.asByteArray(), 869, 511);
        FileChannel fileChannel = UnixChannelFactory.newFileChannel(n2, this.file.toString(), false, true);
        try {
            int n3 = byteBuffer.remaining();
            while (byteBuffer.hasRemaining()) {
                fileChannel.write(byteBuffer);
            }
            n = n3;
        }
        catch (Throwable throwable) {
            try {
                fileChannel.close();
                throw throwable;
            }
            catch (UnixException unixException) {
                throw new FileSystemException(this.file.getPathForExceptionMessage(), null, "Unable to write extended attribute '" + string + "': " + unixException.getMessage());
            }
        }
        fileChannel.close();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String string) throws IOException {
        if (System.getSecurityManager() != null) {
            this.checkAccess(this.file.getPathForPermissionCheck(), false, true);
        }
        try {
            int n = !this.followLinks ? UnixNativeDispatcher.hpOpenat(this.file.asByteArray(), 16777317, 0) : UnixNativeDispatcher.hpOpenat(this.file.asByteArray(), 101, 0);
            try {
                File file = new File(string);
                if (file != null) {
                    UnixNativeDispatcher.unlink(this.file.resolve(file.toPath()));
                }
            }
            finally {
                UnixNativeDispatcher.close(n);
            }
        }
        catch (UnixException unixException) {
            throw new FileSystemException(this.file.getPathForExceptionMessage(), null, "Unable to delete extended attribute '" + string + "': " + unixException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copyExtendedAttributes(UnixPath unixPath, UnixPath unixPath2) {
        try {
            String string = new String(unixPath.asByteArray());
            long l = 0L;
            l = UnixNativeDispatcher.hpOpendir(string.getBytes());
            try {
                byte[] byArray;
                while ((byArray = UnixNativeDispatcher.readdir(l)) != null) {
                    if (byArray[0] == 46 && (byArray.length == 1 || byArray.length == 2 && byArray[1] == 46)) continue;
                    HPUserDefinedFileAttributeView.copyExtendedAttribute(byArray, unixPath, unixPath2);
                }
            }
            finally {
                UnixNativeDispatcher.closedir(l);
            }
        }
        catch (UnixException unixException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyExtendedAttribute(byte[] byArray, UnixPath unixPath, UnixPath unixPath2) throws UnixException {
        String string = new String(unixPath.asByteArray()) + "/" + byArray;
        String string2 = new String(unixPath2.asByteArray()) + "/" + byArray;
        int n = UnixNativeDispatcher.hpOpenat(string.getBytes(), 101, 0);
        try {
            int n2 = UnixNativeDispatcher.hpOpenat(string2.getBytes(), 869, 511);
            try {
                UnixCopyFile.transfer(n2, n, 0L);
            }
            finally {
                UnixNativeDispatcher.close(n2);
            }
        }
        finally {
            UnixNativeDispatcher.close(n);
        }
    }
}

