/*
 * Decompiled with CFR 0.152.
 */
package jdk.xml.internal;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import jdk.xml.internal.AbstractMap;

public class HashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    static final long serialVersionUID = 6142122841748287840L;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int TREEIFY_THRESHOLD = 8;
    static final int UNTREEIFY_THRESHOLD = 6;
    static final int MIN_TREEIFY_CAPACITY = 64;
    transient Node<K, V>[] table;
    transient Set<Map.Entry<K, V>> entrySet;
    transient int size;
    transient int modCount;
    int threshold;
    final float loadFactor;

    static final int hash(Object key) {
        int n;
        if (key == null) {
            n = 0;
        } else {
            int h = key.hashCode();
            n = h ^ h >>> 16;
        }
        return n;
    }

    static final int objectHashCode(Object o) {
        return o != null ? o.hashCode() : 0;
    }

    static final boolean objectEquals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    static Class<?> comparableClassFor(Object x) {
        if (x instanceof Comparable) {
            Class<?> c = x.getClass();
            if (c == String.class) {
                return c;
            }
            Type[] ts = c.getGenericInterfaces();
            if (ts != null) {
                for (int i = 0; i < ts.length; ++i) {
                    Type[] as;
                    ParameterizedType p;
                    Type t = ts[i];
                    if (!(t instanceof ParameterizedType) || (p = (ParameterizedType)t).getRawType() != Comparable.class || (as = p.getActualTypeArguments()) == null || as.length != 1 || as[0] != c) continue;
                    return c;
                }
            }
        }
        return null;
    }

    static int compareComparables(Class<?> kc, Object k, Object x) {
        return x == null || x.getClass() != kc ? 0 : ((Comparable)k).compareTo(x);
    }

    static final int tableSizeFor(int cap) {
        int n = cap - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) < 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
    }

    public HashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        this.threshold = HashMap.tableSizeFor(initialCapacity);
    }

    public HashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public HashMap() {
        this.loadFactor = 0.75f;
    }

    public HashMap(Map<? extends K, ? extends V> m) {
        this.loadFactor = 0.75f;
        this.putMapEntries(m, false);
    }

    final void putMapEntries(Map<? extends K, ? extends V> m, boolean evict) {
        int s = m.size();
        if (s > 0) {
            if (this.table == null) {
                int t;
                float ft = (float)s / this.loadFactor + 1.0f;
                int n = t = ft < 1.0737418E9f ? (int)ft : 0x40000000;
                if (t > this.threshold) {
                    this.threshold = HashMap.tableSizeFor(t);
                }
            } else if (s > this.threshold) {
                this.resize();
            }
            for (Map.Entry<K, V> e : m.entrySet()) {
                K key = e.getKey();
                V value = e.getValue();
                this.putVal(HashMap.hash(key), key, value, false, evict);
            }
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public V get(Object key) {
        Node<K, V> e = this.getNode(HashMap.hash(key), key);
        return e == null ? null : (V)e.value;
    }

    final Node<K, V> getNode(int hash, Object key) {
        Node<K, V> first;
        int n;
        Node<K, V>[] tab = this.table;
        if (this.table != null && (n = tab.length) > 0 && (first = tab[n - 1 & hash]) != null) {
            Object k;
            if (first.hash == hash && ((k = first.key) == key || key != null && key.equals(k))) {
                return first;
            }
            Node e = first.next;
            if (e != null) {
                if (first instanceof TreeNode) {
                    return ((TreeNode)first).getTreeNode(hash, key);
                }
                do {
                    if (e.hash != hash || (k = e.key) != key && (key == null || !key.equals(k))) continue;
                    return e;
                } while ((e = e.next) != null);
            }
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getNode(HashMap.hash(key), key) != null;
    }

    @Override
    public V put(K key, V value) {
        return this.putVal(HashMap.hash(key), key, value, false, true);
    }

    final V putVal(int hash, K key, V value, boolean onlyIfAbsent, boolean evict) {
        int i;
        Node<K, V> p;
        int n;
        Node<K, V>[] tab = this.table;
        if (this.table == null || (n = tab.length) == 0) {
            tab = this.resize();
            n = tab.length;
        }
        if ((p = tab[i = n - 1 & hash]) == null) {
            tab[i] = this.newNode(hash, key, value, null);
        } else {
            Node<K, V> e;
            Object k;
            if (p.hash == hash && ((k = p.key) == key || key != null && key.equals(k))) {
                e = p;
            } else if (p instanceof TreeNode) {
                e = ((TreeNode)p).putTreeVal(this, tab, hash, key, value);
            } else {
                int binCount = 0;
                while (true) {
                    if ((e = p.next) == null) {
                        p.next = this.newNode(hash, key, value, null);
                        if (binCount < 7) break;
                        this.treeifyBin(tab, hash);
                        break;
                    }
                    if (e.hash == hash && ((k = e.key) == key || key != null && key.equals(k))) break;
                    p = e;
                    ++binCount;
                }
            }
            if (e != null) {
                Object oldValue = e.value;
                if (!onlyIfAbsent || oldValue == null) {
                    e.value = value;
                }
                return oldValue;
            }
        }
        ++this.modCount;
        if (++this.size > this.threshold) {
            this.resize();
        }
        return null;
    }

    final Node<K, V>[] resize() {
        int newCap;
        Node<K, V>[] oldTab = this.table;
        int oldCap = oldTab == null ? 0 : oldTab.length;
        int oldThr = this.threshold;
        int newThr = 0;
        if (oldCap > 0) {
            if (oldCap >= 0x40000000) {
                this.threshold = Integer.MAX_VALUE;
                return oldTab;
            }
            newCap = oldCap << 1;
            if (newCap < 0x40000000 && oldCap >= 16) {
                newThr = oldThr << 1;
            }
        } else if (oldThr > 0) {
            newCap = oldThr;
        } else {
            newCap = 16;
            newThr = 12;
        }
        if (newThr == 0) {
            float ft = (float)newCap * this.loadFactor;
            newThr = newCap < 0x40000000 && ft < 1.0737418E9f ? (int)ft : Integer.MAX_VALUE;
        }
        this.threshold = newThr;
        Node[] newTab = new Node[newCap];
        this.table = newTab;
        if (oldTab != null) {
            for (int j = 0; j < oldCap; ++j) {
                Node next;
                Node<K, V> e = oldTab[j];
                if (e == null) continue;
                oldTab[j] = null;
                if (e.next == null) {
                    newTab[e.hash & newCap - 1] = e;
                    continue;
                }
                if (e instanceof TreeNode) {
                    ((TreeNode)e).split(this, newTab, j, oldCap);
                    continue;
                }
                Node<K, V> loHead = null;
                Node<K, V> loTail = null;
                Node<K, V> hiHead = null;
                Node<K, V> hiTail = null;
                do {
                    next = e.next;
                    if ((e.hash & oldCap) == 0) {
                        if (loTail == null) {
                            loHead = e;
                        } else {
                            loTail.next = e;
                        }
                        loTail = e;
                        continue;
                    }
                    if (hiTail == null) {
                        hiHead = e;
                    } else {
                        hiTail.next = e;
                    }
                    hiTail = e;
                } while ((e = next) != null);
                if (loTail != null) {
                    loTail.next = null;
                    newTab[j] = loHead;
                }
                if (hiTail == null) continue;
                hiTail.next = null;
                newTab[j + oldCap] = hiHead;
            }
        }
        return newTab;
    }

    final void treeifyBin(Node<K, V>[] tab, int hash) {
        int n;
        if (tab == null || (n = tab.length) < 64) {
            this.resize();
        } else {
            int index = n - 1 & hash;
            Node<K, V> e = tab[index];
            if (e != null) {
                TreeNode<K, V> hd = null;
                TreeNode<K, V> tl = null;
                do {
                    TreeNode<K, V> p = this.replacementTreeNode(e, null);
                    if (tl == null) {
                        hd = p;
                    } else {
                        p.prev = tl;
                        tl.next = p;
                    }
                    tl = p;
                } while ((e = e.next) != null);
                tab[index] = hd;
                if (tab[index] != null) {
                    hd.treeify(tab);
                }
            }
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.putMapEntries(m, true);
    }

    @Override
    public V remove(Object key) {
        Node<K, V> e = this.removeNode(HashMap.hash(key), key, null, false, true);
        return e == null ? null : (V)e.value;
    }

    final Node<K, V> removeNode(int hash, Object key, Object value, boolean matchValue, boolean movable) {
        int index;
        Node<K, V> p;
        int n;
        Node<K, V>[] tab = this.table;
        if (this.table != null && (n = tab.length) > 0 && (p = tab[index = n - 1 & hash]) != null) {
            Object v;
            Object k;
            Node<K, V> node = null;
            if (p.hash == hash && ((k = p.key) == key || key != null && key.equals(k))) {
                node = p;
            } else {
                Node e = p.next;
                if (e != null) {
                    if (p instanceof TreeNode) {
                        node = ((TreeNode)p).getTreeNode(hash, key);
                    } else {
                        do {
                            if (e.hash == hash && ((k = e.key) == key || key != null && key.equals(k))) {
                                node = e;
                                break;
                            }
                            p = e;
                        } while ((e = e.next) != null);
                    }
                }
            }
            if (node != null && (!matchValue || (v = node.value) == value || value != null && value.equals(v))) {
                if (node instanceof TreeNode) {
                    ((TreeNode)node).removeTreeNode(this, tab, movable);
                } else if (node == p) {
                    tab[index] = node.next;
                } else {
                    p.next = node.next;
                }
                ++this.modCount;
                --this.size;
                return node;
            }
        }
        return null;
    }

    @Override
    public void clear() {
        ++this.modCount;
        Node<K, V>[] tab = this.table;
        if (this.table != null && this.size > 0) {
            this.size = 0;
            for (int i = 0; i < tab.length; ++i) {
                tab[i] = null;
            }
        }
    }

    @Override
    public boolean containsValue(Object value) {
        Node<K, V>[] tab = this.table;
        if (this.table != null && this.size > 0) {
            for (int i = 0; i < tab.length; ++i) {
                Node<K, V> e = tab[i];
                while (e != null) {
                    Object v = e.value;
                    if (v == value || value != null && value.equals(v)) {
                        return true;
                    }
                    e = e.next;
                }
            }
        }
        return false;
    }

    @Override
    public Set<K> keySet() {
        Set ks = this.keySet;
        return ks == null ? (this.keySet = new KeySet()) : ks;
    }

    @Override
    public Collection<V> values() {
        Collection vs = this.values;
        return vs == null ? (this.values = new Values()) : vs;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        return es == null ? (this.entrySet = new EntrySet()) : es;
    }

    @Override
    public Object clone() {
        HashMap result;
        try {
            result = (HashMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
        result.reinitialize();
        result.putMapEntries(this, false);
        return result;
    }

    final float loadFactor() {
        return this.loadFactor;
    }

    final int capacity() {
        return this.table != null ? this.table.length : (this.threshold > 0 ? this.threshold : 16);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        int buckets = this.capacity();
        s.defaultWriteObject();
        s.writeInt(buckets);
        s.writeInt(this.size);
        this.internalWriteEntries(s);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.reinitialize();
        if (this.loadFactor <= 0.0f || Float.isNaN(this.loadFactor)) {
            throw new InvalidObjectException("Illegal load factor: " + this.loadFactor);
        }
        s.readInt();
        int mappings = s.readInt();
        if (mappings < 0) {
            throw new InvalidObjectException("Illegal mappings count: " + mappings);
        }
        if (mappings > 0) {
            float lf = Math.min(Math.max(0.25f, this.loadFactor), 4.0f);
            float fc = (float)mappings / lf + 1.0f;
            int cap = fc < 16.0f ? 16 : (fc >= 1.0737418E9f ? 0x40000000 : HashMap.tableSizeFor((int)fc));
            float ft = (float)cap * lf;
            this.threshold = cap < 0x40000000 && ft < 1.0737418E9f ? (int)ft : Integer.MAX_VALUE;
            Node[] tab = new Node[cap];
            this.table = tab;
            for (int i = 0; i < mappings; ++i) {
                Object key = s.readObject();
                Object value = s.readObject();
                this.putVal(HashMap.hash(key), key, value, false, false);
            }
        }
    }

    Node<K, V> newNode(int hash, K key, V value, Node<K, V> next) {
        return new Node<K, V>(hash, key, value, next);
    }

    Node<K, V> replacementNode(Node<K, V> p, Node<K, V> next) {
        return new Node(p.hash, p.key, p.value, next);
    }

    TreeNode<K, V> newTreeNode(int hash, K key, V value, Node<K, V> next) {
        return new TreeNode<K, V>(hash, key, value, next);
    }

    TreeNode<K, V> replacementTreeNode(Node<K, V> p, Node<K, V> next) {
        return new TreeNode(p.hash, p.key, p.value, next);
    }

    void reinitialize() {
        this.table = null;
        this.entrySet = null;
        this.keySet = null;
        this.values = null;
        this.modCount = 0;
        this.threshold = 0;
        this.size = 0;
    }

    void internalWriteEntries(ObjectOutputStream s) throws IOException {
        if (this.size > 0) {
            Node<K, V>[] tab = this.table;
            if (this.table != null) {
                for (int i = 0; i < tab.length; ++i) {
                    Node<K, V> e = tab[i];
                    while (e != null) {
                        s.writeObject(e.key);
                        s.writeObject(e.value);
                        e = e.next;
                    }
                }
            }
        }
    }

    static final class TreeNode<K, V>
    extends LinkedHashMapEntry<K, V> {
        TreeNode<K, V> parent;
        TreeNode<K, V> left;
        TreeNode<K, V> right;
        TreeNode<K, V> prev;
        boolean red;

        TreeNode(int hash, K key, V val, Node<K, V> next) {
            super(hash, key, val, next);
        }

        final TreeNode<K, V> root() {
            TreeNode<K, V> r = this;
            TreeNode<K, V> p;
            while ((p = r.parent) != null) {
                r = p;
            }
            return r;
        }

        static <K, V> void moveRootToFront(Node<K, V>[] tab, TreeNode<K, V> root) {
            int n;
            if (root != null && tab != null && (n = tab.length) > 0) {
                int index = n - 1 & root.hash;
                TreeNode first = (TreeNode)tab[index];
                if (root != first) {
                    tab[index] = root;
                    TreeNode<K, V> rp = root.prev;
                    Node rn = root.next;
                    if (rn != null) {
                        ((TreeNode)rn).prev = rp;
                    }
                    if (rp != null) {
                        rp.next = rn;
                    }
                    if (first != null) {
                        first.prev = root;
                    }
                    root.next = first;
                    root.prev = null;
                }
                assert (TreeNode.checkInvariants(root));
            }
        }

        final TreeNode<K, V> find(int h, Object k, Class<?> kc) {
            TreeNode<K, V> p = this;
            do {
                int dir;
                TreeNode<K, V> pl = p.left;
                TreeNode<K, V> pr = p.right;
                int ph = p.hash;
                if (ph > h) {
                    p = pl;
                    continue;
                }
                if (ph < h) {
                    p = pr;
                    continue;
                }
                Object pk = p.key;
                if (pk == k || k != null && k.equals(pk)) {
                    return p;
                }
                if (pl == null) {
                    p = pr;
                    continue;
                }
                if (pr == null) {
                    p = pl;
                    continue;
                }
                if ((kc != null || (kc = HashMap.comparableClassFor(k)) != null) && (dir = HashMap.compareComparables(kc, k, pk)) != 0) {
                    p = dir < 0 ? pl : pr;
                    continue;
                }
                TreeNode<K, V> q = pr.find(h, k, kc);
                if (q != null) {
                    return q;
                }
                p = pl;
            } while (p != null);
            return null;
        }

        final TreeNode<K, V> getTreeNode(int h, Object k) {
            return (this.parent != null ? this.root() : this).find(h, k, null);
        }

        static int tieBreakOrder(Object a, Object b) {
            int d;
            if (a == null || b == null || (d = a.getClass().getName().compareTo(b.getClass().getName())) == 0) {
                d = System.identityHashCode(a) <= System.identityHashCode(b) ? -1 : 1;
            }
            return d;
        }

        final void treeify(Node<K, V>[] tab) {
            TreeNode<K, V> root = null;
            TreeNode<K, V> x = this;
            while (x != null) {
                TreeNode next = (TreeNode)x.next;
                x.right = null;
                x.left = null;
                if (root == null) {
                    x.parent = null;
                    x.red = false;
                    root = x;
                } else {
                    TreeNode<K, V> xp;
                    int dir;
                    Object k = x.key;
                    int h = x.hash;
                    Class<?> kc = null;
                    TreeNode<K, V> p = root;
                    do {
                        Object pk = p.key;
                        int ph = p.hash;
                        if (ph > h) {
                            dir = -1;
                        } else if (ph < h) {
                            dir = 1;
                        } else if (kc == null && (kc = HashMap.comparableClassFor(k)) == null || (dir = HashMap.compareComparables(kc, k, pk)) == 0) {
                            dir = TreeNode.tieBreakOrder(k, pk);
                        }
                        xp = p;
                    } while ((p = dir <= 0 ? p.left : p.right) != null);
                    x.parent = xp;
                    if (dir <= 0) {
                        xp.left = x;
                    } else {
                        xp.right = x;
                    }
                    root = TreeNode.balanceInsertion(root, x);
                }
                x = next;
            }
            TreeNode.moveRootToFront(tab, root);
        }

        final Node<K, V> untreeify(HashMap<K, V> map) {
            Node<K, V> hd = null;
            Node<K, V> tl = null;
            Node q = this;
            while (q != null) {
                Node<K, V> p = map.replacementNode(q, null);
                if (tl == null) {
                    hd = p;
                } else {
                    tl.next = p;
                }
                tl = p;
                q = q.next;
            }
            return hd;
        }

        final TreeNode<K, V> putTreeVal(HashMap<K, V> map, Node<K, V>[] tab, int h, K k, V v) {
            TreeNode<K, V> xp;
            int dir;
            TreeNode<K, V> root;
            Class<?> kc = null;
            boolean searched = false;
            TreeNode<K, V> p = root = this.parent != null ? this.root() : this;
            do {
                int ph;
                if ((ph = p.hash) > h) {
                    dir = -1;
                } else if (ph < h) {
                    dir = 1;
                } else {
                    Object pk = p.key;
                    if (pk == k || k != null && k.equals(pk)) {
                        return p;
                    }
                    if (kc == null && (kc = HashMap.comparableClassFor(k)) == null || (dir = HashMap.compareComparables(kc, k, pk)) == 0) {
                        if (!searched) {
                            TreeNode<K, V> q;
                            searched = true;
                            TreeNode<K, V> ch = p.left;
                            if (ch != null && (q = ch.find(h, k, kc)) != null || (ch = p.right) != null && (q = ch.find(h, k, kc)) != null) {
                                return q;
                            }
                        }
                        dir = TreeNode.tieBreakOrder(k, pk);
                    }
                }
                xp = p;
            } while ((p = dir <= 0 ? p.left : p.right) != null);
            Node xpn = xp.next;
            TreeNode<K, V> x = map.newTreeNode(h, k, v, xpn);
            if (dir <= 0) {
                xp.left = x;
            } else {
                xp.right = x;
            }
            xp.next = x;
            x.prev = xp;
            x.parent = x.prev;
            if (xpn != null) {
                ((TreeNode)xpn).prev = x;
            }
            TreeNode.moveRootToFront(tab, TreeNode.balanceInsertion(root, x));
            return null;
        }

        final void removeTreeNode(HashMap<K, V> map, Node<K, V>[] tab, boolean movable) {
            TreeNode<K, V> r;
            TreeNode<K, V> replacement;
            TreeNode<K, V> rl;
            TreeNode<K, V> first;
            int n;
            if (tab == null || (n = tab.length) == 0) {
                return;
            }
            int index = n - 1 & this.hash;
            TreeNode<K, V> root = first = (TreeNode<K, V>)tab[index];
            TreeNode succ = (TreeNode)this.next;
            TreeNode<K, V> pred = this.prev;
            if (pred == null) {
                first = succ;
                tab[index] = first;
            } else {
                pred.next = succ;
            }
            if (succ != null) {
                succ.prev = pred;
            }
            if (first == null) {
                return;
            }
            if (root.parent != null) {
                root = root.root();
            }
            if (root == null || root.right == null || (rl = root.left) == null || rl.left == null) {
                tab[index] = first.untreeify(map);
                return;
            }
            TreeNode<K, V> p = this;
            TreeNode<K, V> pl = this.left;
            TreeNode<K, V> pr = this.right;
            if (pl != null && pr != null) {
                TreeNode<K, V> sl;
                TreeNode<K, V> s = pr;
                while ((sl = s.left) != null) {
                    s = sl;
                }
                boolean c = s.red;
                s.red = p.red;
                p.red = c;
                TreeNode<K, V> sr = s.right;
                TreeNode<K, V> pp = p.parent;
                if (s == pr) {
                    p.parent = s;
                    s.right = p;
                } else {
                    TreeNode<K, V> sp = s.parent;
                    p.parent = sp;
                    if (p.parent != null) {
                        if (s == sp.left) {
                            sp.left = p;
                        } else {
                            sp.right = p;
                        }
                    }
                    if ((s.right = pr) != null) {
                        pr.parent = s;
                    }
                }
                p.left = null;
                p.right = sr;
                if (p.right != null) {
                    sr.parent = p;
                }
                if ((s.left = pl) != null) {
                    pl.parent = s;
                }
                if ((s.parent = pp) == null) {
                    root = s;
                } else if (p == pp.left) {
                    pp.left = s;
                } else {
                    pp.right = s;
                }
                replacement = sr != null ? sr : p;
            } else {
                replacement = pl != null ? pl : (pr != null ? pr : p);
            }
            if (replacement != p) {
                replacement.parent = p.parent;
                TreeNode<K, V> pp = replacement.parent;
                if (pp == null) {
                    root = replacement;
                } else if (p == pp.left) {
                    pp.left = replacement;
                } else {
                    pp.right = replacement;
                }
                p.parent = null;
                p.right = null;
                p.left = null;
            }
            TreeNode<K, V> treeNode = r = p.red ? root : TreeNode.balanceDeletion(root, replacement);
            if (replacement == p) {
                TreeNode<K, V> pp = p.parent;
                p.parent = null;
                if (pp != null) {
                    if (p == pp.left) {
                        pp.left = null;
                    } else if (p == pp.right) {
                        pp.right = null;
                    }
                }
            }
            if (movable) {
                TreeNode.moveRootToFront(tab, r);
            }
        }

        final void split(HashMap<K, V> map, Node<K, V>[] tab, int index, int bit) {
            TreeNode b = this;
            TreeNode loHead = null;
            TreeNode loTail = null;
            TreeNode hiHead = null;
            TreeNode hiTail = null;
            int lc = 0;
            int hc = 0;
            TreeNode e = b;
            while (e != null) {
                TreeNode next = (TreeNode)e.next;
                e.next = null;
                if ((e.hash & bit) == 0) {
                    e.prev = loTail;
                    if (e.prev == null) {
                        loHead = e;
                    } else {
                        loTail.next = e;
                    }
                    loTail = e;
                    ++lc;
                } else {
                    e.prev = hiTail;
                    if (e.prev == null) {
                        hiHead = e;
                    } else {
                        hiTail.next = e;
                    }
                    hiTail = e;
                    ++hc;
                }
                e = next;
            }
            if (loHead != null) {
                if (lc <= 6) {
                    tab[index] = loHead.untreeify(map);
                } else {
                    tab[index] = loHead;
                    if (hiHead != null) {
                        loHead.treeify(tab);
                    }
                }
            }
            if (hiHead != null) {
                if (hc <= 6) {
                    tab[index + bit] = hiHead.untreeify(map);
                } else {
                    tab[index + bit] = hiHead;
                    if (loHead != null) {
                        hiHead.treeify(tab);
                    }
                }
            }
        }

        static <K, V> TreeNode<K, V> rotateLeft(TreeNode<K, V> root, TreeNode<K, V> p) {
            TreeNode<K, V> r;
            if (p != null && (r = p.right) != null) {
                p.right = r.left;
                TreeNode<K, V> rl = p.right;
                if (p.right != null) {
                    rl.parent = p;
                }
                TreeNode<K, V> pp = r.parent = p.parent;
                if (r.parent == null) {
                    root = r;
                    r.red = false;
                } else if (pp.left == p) {
                    pp.left = r;
                } else {
                    pp.right = r;
                }
                r.left = p;
                p.parent = r;
            }
            return root;
        }

        static <K, V> TreeNode<K, V> rotateRight(TreeNode<K, V> root, TreeNode<K, V> p) {
            TreeNode<K, V> l;
            if (p != null && (l = p.left) != null) {
                p.left = l.right;
                TreeNode<K, V> lr = p.left;
                if (p.left != null) {
                    lr.parent = p;
                }
                TreeNode<K, V> pp = l.parent = p.parent;
                if (l.parent == null) {
                    root = l;
                    l.red = false;
                } else if (pp.right == p) {
                    pp.right = l;
                } else {
                    pp.left = l;
                }
                l.right = p;
                p.parent = l;
            }
            return root;
        }

        static <K, V> TreeNode<K, V> balanceInsertion(TreeNode<K, V> root, TreeNode<K, V> x) {
            x.red = true;
            while (true) {
                TreeNode<K, V> xpp;
                TreeNode<K, V> xp;
                if ((xp = x.parent) == null) {
                    x.red = false;
                    return x;
                }
                if (!xp.red || (xpp = xp.parent) == null) {
                    return root;
                }
                TreeNode<K, V> xppl = xpp.left;
                if (xp == xppl) {
                    TreeNode<K, V> xppr = xpp.right;
                    if (xppr != null && xppr.red) {
                        xppr.red = false;
                        xp.red = false;
                        xpp.red = true;
                        x = xpp;
                        continue;
                    }
                    if (x == xp.right) {
                        x = xp;
                        root = TreeNode.rotateLeft(root, x);
                        xp = x.parent;
                        TreeNode<K, V> treeNode = xpp = xp == null ? null : xp.parent;
                    }
                    if (xp == null) continue;
                    xp.red = false;
                    if (xpp == null) continue;
                    xpp.red = true;
                    root = TreeNode.rotateRight(root, xpp);
                    continue;
                }
                if (xppl != null && xppl.red) {
                    xppl.red = false;
                    xp.red = false;
                    xpp.red = true;
                    x = xpp;
                    continue;
                }
                if (x == xp.left) {
                    x = xp;
                    root = TreeNode.rotateRight(root, x);
                    xp = x.parent;
                    TreeNode<K, V> treeNode = xpp = xp == null ? null : xp.parent;
                }
                if (xp == null) continue;
                xp.red = false;
                if (xpp == null) continue;
                xpp.red = true;
                root = TreeNode.rotateLeft(root, xpp);
            }
        }

        static <K, V> TreeNode<K, V> balanceDeletion(TreeNode<K, V> root, TreeNode<K, V> x) {
            while (x != null && x != root) {
                TreeNode<K, V> sr;
                TreeNode<K, V> sl;
                TreeNode<K, V> xp = x.parent;
                if (xp == null) {
                    x.red = false;
                    return x;
                }
                if (x.red) {
                    x.red = false;
                    return root;
                }
                TreeNode<K, V> xpl = xp.left;
                if (xpl == x) {
                    TreeNode<K, V> xpr = xp.right;
                    if (xpr != null && xpr.red) {
                        xpr.red = false;
                        xp.red = true;
                        root = TreeNode.rotateLeft(root, xp);
                        xp = x.parent;
                        TreeNode<K, V> treeNode = xpr = xp == null ? null : xp.right;
                    }
                    if (xpr == null) {
                        x = xp;
                        continue;
                    }
                    sl = xpr.left;
                    sr = xpr.right;
                    if (!(sr != null && sr.red || sl != null && sl.red)) {
                        xpr.red = true;
                        x = xp;
                        continue;
                    }
                    if (sr == null || !sr.red) {
                        if (sl != null) {
                            sl.red = false;
                        }
                        xpr.red = true;
                        root = TreeNode.rotateRight(root, xpr);
                        xp = x.parent;
                        TreeNode<K, V> treeNode = xpr = xp == null ? null : xp.right;
                    }
                    if (xpr != null) {
                        xpr.red = xp == null ? false : xp.red;
                        sr = xpr.right;
                        if (sr != null) {
                            sr.red = false;
                        }
                    }
                    if (xp != null) {
                        xp.red = false;
                        root = TreeNode.rotateLeft(root, xp);
                    }
                    x = root;
                    continue;
                }
                if (xpl != null && xpl.red) {
                    xpl.red = false;
                    xp.red = true;
                    root = TreeNode.rotateRight(root, xp);
                    xp = x.parent;
                    TreeNode<K, V> treeNode = xpl = xp == null ? null : xp.left;
                }
                if (xpl == null) {
                    x = xp;
                    continue;
                }
                sl = xpl.left;
                sr = xpl.right;
                if (!(sl != null && sl.red || sr != null && sr.red)) {
                    xpl.red = true;
                    x = xp;
                    continue;
                }
                if (sl == null || !sl.red) {
                    if (sr != null) {
                        sr.red = false;
                    }
                    xpl.red = true;
                    root = TreeNode.rotateLeft(root, xpl);
                    xp = x.parent;
                    TreeNode<K, V> treeNode = xpl = xp == null ? null : xp.left;
                }
                if (xpl != null) {
                    xpl.red = xp == null ? false : xp.red;
                    sl = xpl.left;
                    if (sl != null) {
                        sl.red = false;
                    }
                }
                if (xp != null) {
                    xp.red = false;
                    root = TreeNode.rotateRight(root, xp);
                }
                x = root;
            }
            return root;
        }

        static <K, V> boolean checkInvariants(TreeNode<K, V> t) {
            TreeNode<K, V> tp = t.parent;
            TreeNode<K, V> tl = t.left;
            TreeNode<K, V> tr = t.right;
            TreeNode<K, V> tb = t.prev;
            TreeNode tn = (TreeNode)t.next;
            if (tb != null && tb.next != t) {
                return false;
            }
            if (tn != null && tn.prev != t) {
                return false;
            }
            if (tp != null && t != tp.left && t != tp.right) {
                return false;
            }
            if (tl != null && (tl.parent != t || tl.hash > t.hash)) {
                return false;
            }
            if (tr != null && (tr.parent != t || tr.hash < t.hash)) {
                return false;
            }
            if (t.red && tl != null && tl.red && tr != null && tr.red) {
                return false;
            }
            if (tl != null && !TreeNode.checkInvariants(tl)) {
                return false;
            }
            return tr == null || TreeNode.checkInvariants(tr);
        }
    }

    static class LinkedHashMapEntry<K, V>
    extends Node<K, V> {
        LinkedHashMapEntry(int hash, K key, V value, Node<K, V> next) {
            super(hash, key, value, next);
        }
    }

    final class EntryIterator
    extends HashIterator
    implements Iterator<Map.Entry<K, V>> {
        EntryIterator() {
        }

        @Override
        public final Map.Entry<K, V> next() {
            return this.nextNode();
        }
    }

    final class ValueIterator
    extends HashIterator
    implements Iterator<V> {
        ValueIterator() {
        }

        @Override
        public final V next() {
            return this.nextNode().value;
        }
    }

    final class KeyIterator
    extends HashIterator
    implements Iterator<K> {
        KeyIterator() {
        }

        @Override
        public final K next() {
            return this.nextNode().key;
        }
    }

    abstract class HashIterator {
        Node<K, V> next;
        Node<K, V> current;
        int expectedModCount;
        int index;

        HashIterator() {
            this.expectedModCount = HashMap.this.modCount;
            Node<K, V>[] t = HashMap.this.table;
            this.next = null;
            this.current = null;
            this.index = 0;
            if (t != null && HashMap.this.size > 0) {
                while (this.index < t.length && (this.next = t[this.index++]) == null) {
                }
            }
        }

        public final boolean hasNext() {
            return this.next != null;
        }

        final Node<K, V> nextNode() {
            Node e = this.next;
            if (HashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.current = e;
            this.next = this.current.next;
            if (this.next == null) {
                Node<K, V>[] t = HashMap.this.table;
                if (HashMap.this.table != null) {
                    while (this.index < t.length && (this.next = t[this.index++]) == null) {
                    }
                }
            }
            return e;
        }

        public final void remove() {
            Node p = this.current;
            if (p == null) {
                throw new IllegalStateException();
            }
            if (HashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.current = null;
            Object key = p.key;
            HashMap.this.removeNode(HashMap.hash(key), key, null, false, false);
            this.expectedModCount = HashMap.this.modCount;
        }
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public final int size() {
            return HashMap.this.size;
        }

        @Override
        public final void clear() {
            HashMap.this.clear();
        }

        @Override
        public final Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public final boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            Node candidate = HashMap.this.getNode(HashMap.hash(key), key);
            return candidate != null && candidate.equals(e);
        }

        @Override
        public final boolean remove(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                Object value = e.getValue();
                return HashMap.this.removeNode(HashMap.hash(key), key, value, true, true) != null;
            }
            return false;
        }
    }

    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public final int size() {
            return HashMap.this.size;
        }

        @Override
        public final void clear() {
            HashMap.this.clear();
        }

        @Override
        public final Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public final boolean contains(Object o) {
            return HashMap.this.containsValue(o);
        }
    }

    final class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public final int size() {
            return HashMap.this.size;
        }

        @Override
        public final void clear() {
            HashMap.this.clear();
        }

        @Override
        public final Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public final boolean contains(Object o) {
            return HashMap.this.containsKey(o);
        }

        @Override
        public final boolean remove(Object key) {
            return HashMap.this.removeNode(HashMap.hash(key), key, null, false, true) != null;
        }
    }

    static class Node<K, V>
    implements Map.Entry<K, V> {
        final int hash;
        final K key;
        V value;
        Node<K, V> next;

        Node(int hash, K key, V value, Node<K, V> next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        public final String toString() {
            return this.key + "=" + this.value;
        }

        @Override
        public final int hashCode() {
            return HashMap.objectHashCode(this.key) ^ HashMap.objectHashCode(this.value);
        }

        @Override
        public final V setValue(V newValue) {
            V oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public final boolean equals(Object o) {
            Map.Entry e;
            if (o == this) {
                return true;
            }
            return o instanceof Map.Entry && HashMap.objectEquals(this.key, (e = (Map.Entry)o).getKey()) && HashMap.objectEquals(this.value, e.getValue());
        }
    }
}

