/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.serializer;

import com.sun.org.apache.xalan.internal.utils.SecuritySupport;
import com.sun.org.apache.xml.internal.serializer.utils.SystemIDResolver;
import com.sun.org.apache.xml.internal.serializer.utils.Utils;
import com.sun.org.apache.xml.internal.serializer.utils.WrappedRuntimeException;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.xml.transform.TransformerException;
import jdk.xml.internal.HashMap;

final class CharInfo {
    private HashMap m_charToString = new HashMap();
    public static final String HTML_ENTITIES_RESOURCE = "com.sun.org.apache.xml.internal.serializer.HTMLEntities";
    public static final String XML_ENTITIES_RESOURCE = "com.sun.org.apache.xml.internal.serializer.XMLEntities";
    public static final char S_HORIZONAL_TAB = '\t';
    public static final char S_LINEFEED = '\n';
    public static final char S_CARRIAGERETURN = '\r';
    final boolean onlyQuotAmpLtGt;
    private static final int ASCII_MAX = 128;
    private boolean[] isSpecialAttrASCII = new boolean[128];
    private boolean[] isSpecialTextASCII = new boolean[128];
    private boolean[] isCleanTextASCII = new boolean[128];
    private int[] array_of_bits = this.createEmptySetOfIntegers(65535);
    private static final int SHIFT_PER_WORD = 5;
    private static final int LOW_ORDER_BITMASK = 31;
    private int firstWordNotUsed;
    private static HashMap m_getCharInfoCache = new HashMap();

    private CharInfo(String entitiesResource, String method) {
        this(entitiesResource, method, false);
    }

    private CharInfo(String entitiesResource, String method, boolean internal) {
        ResourceBundle entities = null;
        boolean noExtraEntities = true;
        try {
            if (internal) {
                entities = PropertyResourceBundle.getBundle(entitiesResource);
            } else {
                ClassLoader cl = SecuritySupport.getContextClassLoader();
                if (cl != null) {
                    entities = PropertyResourceBundle.getBundle(entitiesResource, Locale.getDefault(), cl);
                }
            }
        }
        catch (Exception cl) {
            // empty catch block
        }
        if (entities != null) {
            Enumeration<String> keys = entities.getKeys();
            while (keys.hasMoreElements()) {
                String name = keys.nextElement();
                String value = entities.getString(name);
                int code = Integer.parseInt(value);
                this.defineEntity(name, (char)code);
                if (!this.extraEntity(code)) continue;
                noExtraEntities = false;
            }
            this.set(10);
            this.set(13);
        } else {
            InputStream is = null;
            String err = null;
            try {
                BufferedReader reader;
                if (internal) {
                    is = CharInfo.class.getResourceAsStream(entitiesResource);
                } else {
                    ClassLoader cl = SecuritySupport.getContextClassLoader();
                    if (cl != null) {
                        try {
                            is = cl.getResourceAsStream(entitiesResource);
                        }
                        catch (Exception e) {
                            err = e.getMessage();
                        }
                    }
                    if (is == null) {
                        try {
                            URL url = new URL(entitiesResource);
                            is = url.openStream();
                        }
                        catch (Exception e) {
                            err = e.getMessage();
                        }
                    }
                }
                if (is == null) {
                    throw new RuntimeException(Utils.messages.createMessage("ER_RESOURCE_COULD_NOT_FIND", new Object[]{entitiesResource, err}));
                }
                try {
                    reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    reader = new BufferedReader(new InputStreamReader(is));
                }
                String line = reader.readLine();
                while (line != null) {
                    if (line.length() == 0 || line.charAt(0) == '#') {
                        line = reader.readLine();
                        continue;
                    }
                    int index = line.indexOf(32);
                    if (index > 1) {
                        String name = line.substring(0, index);
                        if (++index < line.length()) {
                            String value = line.substring(index);
                            if ((index = value.indexOf(32)) > 0) {
                                value = value.substring(0, index);
                            }
                            int code = Integer.parseInt(value);
                            this.defineEntity(name, (char)code);
                            if (this.extraEntity(code)) {
                                noExtraEntities = false;
                            }
                        }
                    }
                    line = reader.readLine();
                }
                is.close();
                this.set(10);
                this.set(13);
            }
            catch (Exception e) {
                throw new RuntimeException(Utils.messages.createMessage("ER_RESOURCE_COULD_NOT_LOAD", new Object[]{entitiesResource, e.toString(), entitiesResource, e.toString()}));
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        for (int ch = 0; ch < 128; ++ch) {
            if ((32 <= ch || 10 == ch || 13 == ch || 9 == ch) && !this.get(ch) || 34 == ch) {
                this.isCleanTextASCII[ch] = true;
                this.isSpecialTextASCII[ch] = false;
                continue;
            }
            this.isCleanTextASCII[ch] = false;
            this.isSpecialTextASCII[ch] = true;
        }
        this.onlyQuotAmpLtGt = noExtraEntities;
        for (int i = 0; i < 128; ++i) {
            this.isSpecialAttrASCII[i] = this.get(i);
        }
        if ("xml".equals(method)) {
            this.isSpecialAttrASCII[9] = true;
        }
    }

    private void defineEntity(String name, char value) {
        StringBuilder sb = new StringBuilder("&");
        sb.append(name);
        sb.append(';');
        String entityString = sb.toString();
        this.defineChar2StringMapping(entityString, value);
    }

    String getOutputStringForChar(char value) {
        CharKey charKey = new CharKey();
        charKey.setChar(value);
        return (String)this.m_charToString.get(charKey);
    }

    final boolean isSpecialAttrChar(int value) {
        if (value < 128) {
            return this.isSpecialAttrASCII[value];
        }
        return this.get(value);
    }

    final boolean isSpecialTextChar(int value) {
        if (value < 128) {
            return this.isSpecialTextASCII[value];
        }
        return this.get(value);
    }

    final boolean isTextASCIIClean(int value) {
        return this.isCleanTextASCII[value];
    }

    static CharInfo getCharInfoInternal(String entitiesFileName, String method) {
        CharInfo charInfo = (CharInfo)m_getCharInfoCache.get(entitiesFileName);
        if (charInfo != null) {
            return charInfo;
        }
        charInfo = new CharInfo(entitiesFileName, method, true);
        m_getCharInfoCache.put(entitiesFileName, charInfo);
        return charInfo;
    }

    static CharInfo getCharInfo(String entitiesFileName, String method) {
        try {
            return new CharInfo(entitiesFileName, method, false);
        }
        catch (Exception exception) {
            String absoluteEntitiesFileName;
            if (entitiesFileName.indexOf(58) < 0) {
                absoluteEntitiesFileName = SystemIDResolver.getAbsoluteURIFromRelative(entitiesFileName);
            } else {
                try {
                    absoluteEntitiesFileName = SystemIDResolver.getAbsoluteURI(entitiesFileName, null);
                }
                catch (TransformerException te) {
                    throw new WrappedRuntimeException(te);
                }
            }
            return new CharInfo(absoluteEntitiesFileName, method, false);
        }
    }

    private static int arrayIndex(int i) {
        return i >> 5;
    }

    private static int bit(int i) {
        int ret = 1 << (i & 0x1F);
        return ret;
    }

    private int[] createEmptySetOfIntegers(int max) {
        this.firstWordNotUsed = 0;
        int[] arr = new int[CharInfo.arrayIndex(max - 1) + 1];
        return arr;
    }

    private final void set(int i) {
        this.setASCIIdirty(i);
        int j = i >> 5;
        int k = j + 1;
        if (this.firstWordNotUsed < k) {
            this.firstWordNotUsed = k;
        }
        int n = j;
        this.array_of_bits[n] = this.array_of_bits[n] | 1 << (i & 0x1F);
    }

    private final boolean get(int i) {
        boolean in_the_set = false;
        int j = i >> 5;
        if (j < this.firstWordNotUsed) {
            in_the_set = (this.array_of_bits[j] & 1 << (i & 0x1F)) != 0;
        }
        return in_the_set;
    }

    private boolean extraEntity(int entityValue) {
        boolean extra = false;
        if (entityValue < 128) {
            switch (entityValue) {
                case 34: 
                case 38: 
                case 60: 
                case 62: {
                    break;
                }
                default: {
                    extra = true;
                }
            }
        }
        return extra;
    }

    private void setASCIIdirty(int j) {
        if (0 <= j && j < 128) {
            this.isCleanTextASCII[j] = false;
            this.isSpecialTextASCII[j] = true;
        }
    }

    private void setASCIIclean(int j) {
        if (0 <= j && j < 128) {
            this.isCleanTextASCII[j] = true;
            this.isSpecialTextASCII[j] = false;
        }
    }

    private void defineChar2StringMapping(String outputString, char inputChar) {
        CharKey character = new CharKey(inputChar);
        this.m_charToString.put(character, outputString);
        this.set(inputChar);
    }

    private static class CharKey {
        private char m_char;

        public CharKey(char key) {
            this.m_char = key;
        }

        public CharKey() {
        }

        public final void setChar(char c) {
            this.m_char = c;
        }

        public final int hashCode() {
            return this.m_char;
        }

        public final boolean equals(Object obj) {
            return ((CharKey)obj).m_char == this.m_char;
        }
    }
}

