/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.util;

import com.sun.org.apache.bcel.internal.classfile.ClassParser;
import com.sun.org.apache.bcel.internal.classfile.JavaClass;
import com.sun.org.apache.bcel.internal.util.ClassPath;
import com.sun.org.apache.bcel.internal.util.Repository;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.util.HashMap;

public class SyntheticRepository
implements Repository {
    private static final String DEFAULT_PATH = ClassPath.getClassPath();
    private static jdk.xml.internal.HashMap _instances = new jdk.xml.internal.HashMap();
    private ClassPath _path = null;
    private jdk.xml.internal.HashMap<String, JavaClass> _loadedClasses = new jdk.xml.internal.HashMap();
    private static final long serialVersionUID = 4274520361292963981L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("_path", ClassPath.class), new ObjectStreamField("_loadedClasses", HashMap.class)};

    private SyntheticRepository(ClassPath path) {
        this._path = path;
    }

    public static SyntheticRepository getInstance() {
        return SyntheticRepository.getInstance(ClassPath.SYSTEM_CLASS_PATH);
    }

    public static SyntheticRepository getInstance(ClassPath classPath) {
        SyntheticRepository rep = (SyntheticRepository)_instances.get(classPath);
        if (rep == null) {
            rep = new SyntheticRepository(classPath);
            _instances.put(classPath, rep);
        }
        return rep;
    }

    @Override
    public void storeClass(JavaClass clazz) {
        this._loadedClasses.put(clazz.getClassName(), clazz);
        clazz.setRepository(this);
    }

    @Override
    public void removeClass(JavaClass clazz) {
        this._loadedClasses.remove(clazz.getClassName());
    }

    @Override
    public JavaClass findClass(String className) {
        return this._loadedClasses.get(className);
    }

    @Override
    public JavaClass loadClass(String className) throws ClassNotFoundException {
        if (className == null || className.equals("")) {
            throw new IllegalArgumentException("Invalid class name " + className);
        }
        className = className.replace('/', '.');
        try {
            return this.loadClass(this._path.getInputStream(className), className);
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Exception while looking for class " + className + ": " + e.toString());
        }
    }

    @Override
    public JavaClass loadClass(Class clazz) throws ClassNotFoundException {
        String className = clazz.getName();
        String name = className;
        int i = name.lastIndexOf(46);
        if (i > 0) {
            name = name.substring(i + 1);
        }
        return this.loadClass(clazz.getResourceAsStream(name + ".class"), className);
    }

    private JavaClass loadClass(InputStream is, String className) throws ClassNotFoundException {
        JavaClass clazz = this.findClass(className);
        if (clazz != null) {
            return clazz;
        }
        try {
            if (is != null) {
                ClassParser parser = new ClassParser(is, className);
                clazz = parser.parse();
                this.storeClass(clazz);
                return clazz;
            }
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Exception while looking for class " + className + ": " + e.toString());
        }
        throw new ClassNotFoundException("SyntheticRepository could not load " + className);
    }

    @Override
    public void clear() {
        this._loadedClasses.clear();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        HashMap<String, JavaClass> loadedClasses = new HashMap<String, JavaClass>(this._loadedClasses);
        ObjectOutputStream.PutField pf = out.putFields();
        pf.put("_loadedClasses", loadedClasses);
        pf.put("_path", this._path);
        out.writeFields();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField gf = in.readFields();
        HashMap loadedClasses = (HashMap)gf.get("_loadedClasses", null);
        if (loadedClasses != null) {
            this._loadedClasses = new jdk.xml.internal.HashMap(loadedClasses);
        }
        this._path = (ClassPath)gf.get("_path", null);
    }
}

