/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.util;

import com.sun.org.apache.bcel.internal.classfile.ClassParser;
import com.sun.org.apache.bcel.internal.classfile.JavaClass;
import com.sun.org.apache.bcel.internal.util.Repository;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.util.HashMap;

public class ClassLoaderRepository
implements Repository {
    private ClassLoader loader;
    private jdk.xml.internal.HashMap<String, JavaClass> loadedClasses = new jdk.xml.internal.HashMap();
    private static final long serialVersionUID = -5917543689769325856L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("loader", ClassLoader.class), new ObjectStreamField("loadedClasses", HashMap.class)};

    public ClassLoaderRepository(ClassLoader loader) {
        this.loader = loader;
    }

    @Override
    public void storeClass(JavaClass clazz) {
        this.loadedClasses.put(clazz.getClassName(), clazz);
        clazz.setRepository(this);
    }

    @Override
    public void removeClass(JavaClass clazz) {
        this.loadedClasses.remove(clazz.getClassName());
    }

    @Override
    public JavaClass findClass(String className) {
        if (this.loadedClasses.containsKey(className)) {
            return this.loadedClasses.get(className);
        }
        return null;
    }

    @Override
    public JavaClass loadClass(String className) throws ClassNotFoundException {
        String classFile = className.replace('.', '/');
        JavaClass RC = this.findClass(className);
        if (RC != null) {
            return RC;
        }
        try {
            InputStream is = this.loader.getResourceAsStream(classFile + ".class");
            if (is == null) {
                throw new ClassNotFoundException(className + " not found.");
            }
            ClassParser parser = new ClassParser(is, className);
            RC = parser.parse();
            this.storeClass(RC);
            return RC;
        }
        catch (IOException e) {
            throw new ClassNotFoundException(e.toString());
        }
    }

    @Override
    public JavaClass loadClass(Class clazz) throws ClassNotFoundException {
        return this.loadClass(clazz.getName());
    }

    @Override
    public void clear() {
        this.loadedClasses.clear();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        HashMap<String, JavaClass> _loadedClasses = new HashMap<String, JavaClass>(this.loadedClasses);
        ObjectOutputStream.PutField pf = out.putFields();
        pf.put("loadedClasses", _loadedClasses);
        pf.put("loader", this.loader);
        out.writeFields();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField gf = in.readFields();
        HashMap _loadedClasses = (HashMap)gf.get("loadedClasses", null);
        if (_loadedClasses != null) {
            this.loadedClasses = new jdk.xml.internal.HashMap(_loadedClasses);
        }
        this.loader = (ClassLoader)gf.get("loader", null);
    }
}

