/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.ext.ExtendedCharsets;

public class Roman8
extends Charset
implements HistoricallyNamedCharset {
    private static final char REPLACEMENT_CHARACTER = '\ufffd';

    public Roman8() {
        super("Roman8", ExtendedCharsets.aliasesFor("Roman8"));
    }

    @Override
    public String historicalName() {
        return "Roman8";
    }

    @Override
    public boolean contains(Charset charset) {
        return charset instanceof Roman8;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    public static boolean canConvert(char c) {
        if (c < '\u00a1') {
            return true;
        }
        if (c > '\u00ff') {
            switch (c) {
                case '\u0160': 
                case '\u0161': 
                case '\u0178': 
                case '\u0192': 
                case '\u02c6': 
                case '\u02cb': 
                case '\u02dc': 
                case '\u20a4': 
                case '\u220e': 
                case '\u22c5': {
                    return true;
                }
            }
            return false;
        }
        switch (c) {
            case '\u00a6': 
            case '\u00a9': 
            case '\u00ac': 
            case '\u00ae': 
            case '\u00b2': 
            case '\u00b3': 
            case '\u00b8': 
            case '\u00b9': 
            case '\u00d7': 
            case '\u00f7': {
                return false;
            }
        }
        return true;
    }

    private static char mapRoman9ToUnicode(int n) {
        if (n < 161) {
            return (char)n;
        }
        switch (n) {
            case 161: {
                return '\u00c0';
            }
            case 162: {
                return '\u00c2';
            }
            case 163: {
                return '\u00c8';
            }
            case 164: {
                return '\u00ca';
            }
            case 165: {
                return '\u00cb';
            }
            case 166: {
                return '\u00ce';
            }
            case 167: {
                return '\u00cf';
            }
            case 168: {
                return '\u00b4';
            }
            case 169: {
                return '\u02cb';
            }
            case 170: {
                return '\u02c6';
            }
            case 171: {
                return '\u00a8';
            }
            case 172: {
                return '\u02dc';
            }
            case 173: {
                return '\u00d9';
            }
            case 174: {
                return '\u00db';
            }
            case 175: {
                return '\u20a4';
            }
            case 176: {
                return '\u00af';
            }
            case 177: {
                return '\u00dd';
            }
            case 178: {
                return '\u00fd';
            }
            case 179: {
                return '\u00b0';
            }
            case 180: {
                return '\u00c7';
            }
            case 181: {
                return '\u00e7';
            }
            case 182: {
                return '\u00d1';
            }
            case 183: {
                return '\u00f1';
            }
            case 184: {
                return '\u00a1';
            }
            case 185: {
                return '\u00bf';
            }
            case 186: {
                return '\u00a4';
            }
            case 187: {
                return '\u00a3';
            }
            case 188: {
                return '\u00a5';
            }
            case 189: {
                return '\u00a7';
            }
            case 190: {
                return '\u0192';
            }
            case 191: {
                return '\u00a2';
            }
            case 192: {
                return '\u00e2';
            }
            case 193: {
                return '\u00ea';
            }
            case 194: {
                return '\u00f4';
            }
            case 195: {
                return '\u00fb';
            }
            case 196: {
                return '\u00e1';
            }
            case 197: {
                return '\u00e9';
            }
            case 198: {
                return '\u00f3';
            }
            case 199: {
                return '\u00fa';
            }
            case 200: {
                return '\u00e0';
            }
            case 201: {
                return '\u00e8';
            }
            case 202: {
                return '\u00f2';
            }
            case 203: {
                return '\u00f9';
            }
            case 204: {
                return '\u00e4';
            }
            case 205: {
                return '\u00eb';
            }
            case 206: {
                return '\u00f6';
            }
            case 207: {
                return '\u00fc';
            }
            case 208: {
                return '\u00c5';
            }
            case 209: {
                return '\u00ee';
            }
            case 210: {
                return '\u00d8';
            }
            case 211: {
                return '\u00c6';
            }
            case 212: {
                return '\u00e5';
            }
            case 213: {
                return '\u00ed';
            }
            case 214: {
                return '\u00f8';
            }
            case 215: {
                return '\u00e6';
            }
            case 216: {
                return '\u00c4';
            }
            case 217: {
                return '\u00ec';
            }
            case 218: {
                return '\u00d6';
            }
            case 219: {
                return '\u00dc';
            }
            case 220: {
                return '\u00c9';
            }
            case 221: {
                return '\u00ef';
            }
            case 222: {
                return '\u00df';
            }
            case 223: {
                return '\u00d4';
            }
            case 224: {
                return '\u00c1';
            }
            case 225: {
                return '\u00c3';
            }
            case 226: {
                return '\u00e3';
            }
            case 227: {
                return '\u00d0';
            }
            case 228: {
                return '\u00f0';
            }
            case 229: {
                return '\u00cd';
            }
            case 230: {
                return '\u00cc';
            }
            case 231: {
                return '\u00d3';
            }
            case 232: {
                return '\u00d2';
            }
            case 233: {
                return '\u00d5';
            }
            case 234: {
                return '\u00f5';
            }
            case 235: {
                return '\u0160';
            }
            case 236: {
                return '\u0161';
            }
            case 237: {
                return '\u00da';
            }
            case 238: {
                return '\u0178';
            }
            case 239: {
                return '\u00ff';
            }
            case 240: {
                return '\u00de';
            }
            case 241: {
                return '\u00fe';
            }
            case 242: {
                return '\u00b7';
            }
            case 243: {
                return '\u00b5';
            }
            case 244: {
                return '\u00b6';
            }
            case 245: {
                return '\u00be';
            }
            case 246: {
                return '\u00ad';
            }
            case 247: {
                return '\u00bc';
            }
            case 248: {
                return '\u00bd';
            }
            case 249: {
                return '\u00aa';
            }
            case 250: {
                return '\u00ba';
            }
            case 251: {
                return '\u00ab';
            }
            case 252: {
                return '\u220e';
            }
            case 253: {
                return '\u00bb';
            }
            case 254: {
                return '\u00b1';
            }
        }
        return (char)n;
    }

    private static char mapUnicodeToRoman9(int n) {
        if (n < 161) {
            return (char)n;
        }
        switch (n) {
            case 8901: {
                return '\u00f2';
            }
            case 164: {
                return '\u00ba';
            }
            case 161: {
                return '\u00b8';
            }
            case 162: {
                return '\u00bf';
            }
            case 163: {
                return '\u00bb';
            }
            case 165: {
                return '\u00bc';
            }
            case 167: {
                return '\u00bd';
            }
            case 168: {
                return '\u00ab';
            }
            case 170: {
                return '\u00f9';
            }
            case 171: {
                return '\u00fb';
            }
            case 173: {
                return '\u00f6';
            }
            case 175: {
                return '\u00b0';
            }
            case 176: {
                return '\u00b3';
            }
            case 177: {
                return '\u00fe';
            }
            case 180: {
                return '\u00a8';
            }
            case 181: {
                return '\u00f3';
            }
            case 182: {
                return '\u00f4';
            }
            case 183: {
                return '\u00f2';
            }
            case 186: {
                return '\u00fa';
            }
            case 187: {
                return '\u00fd';
            }
            case 188: {
                return '\u00f7';
            }
            case 189: {
                return '\u00f8';
            }
            case 190: {
                return '\u00f5';
            }
            case 191: {
                return '\u00b9';
            }
            case 192: {
                return '\u00a1';
            }
            case 193: {
                return '\u00e0';
            }
            case 194: {
                return '\u00a2';
            }
            case 195: {
                return '\u00e1';
            }
            case 196: {
                return '\u00d8';
            }
            case 197: {
                return '\u00d0';
            }
            case 198: {
                return '\u00d3';
            }
            case 199: {
                return '\u00b4';
            }
            case 200: {
                return '\u00a3';
            }
            case 201: {
                return '\u00dc';
            }
            case 202: {
                return '\u00a4';
            }
            case 203: {
                return '\u00a5';
            }
            case 204: {
                return '\u00e6';
            }
            case 205: {
                return '\u00e5';
            }
            case 206: {
                return '\u00a6';
            }
            case 207: {
                return '\u00a7';
            }
            case 208: {
                return '\u00e3';
            }
            case 209: {
                return '\u00b6';
            }
            case 210: {
                return '\u00e8';
            }
            case 211: {
                return '\u00e7';
            }
            case 212: {
                return '\u00df';
            }
            case 213: {
                return '\u00e9';
            }
            case 214: {
                return '\u00da';
            }
            case 216: {
                return '\u00d2';
            }
            case 217: {
                return '\u00ad';
            }
            case 218: {
                return '\u00ed';
            }
            case 219: {
                return '\u00ae';
            }
            case 220: {
                return '\u00db';
            }
            case 221: {
                return '\u00b1';
            }
            case 222: {
                return '\u00f0';
            }
            case 223: {
                return '\u00de';
            }
            case 224: {
                return '\u00c8';
            }
            case 225: {
                return '\u00c4';
            }
            case 226: {
                return '\u00c0';
            }
            case 227: {
                return '\u00e2';
            }
            case 228: {
                return '\u00cc';
            }
            case 229: {
                return '\u00d4';
            }
            case 230: {
                return '\u00d7';
            }
            case 231: {
                return '\u00b5';
            }
            case 232: {
                return '\u00c9';
            }
            case 233: {
                return '\u00c5';
            }
            case 234: {
                return '\u00c1';
            }
            case 235: {
                return '\u00cd';
            }
            case 236: {
                return '\u00d9';
            }
            case 237: {
                return '\u00d5';
            }
            case 238: {
                return '\u00d1';
            }
            case 239: {
                return '\u00dd';
            }
            case 240: {
                return '\u00e4';
            }
            case 241: {
                return '\u00b7';
            }
            case 242: {
                return '\u00ca';
            }
            case 243: {
                return '\u00c6';
            }
            case 244: {
                return '\u00c2';
            }
            case 245: {
                return '\u00ea';
            }
            case 246: {
                return '\u00ce';
            }
            case 248: {
                return '\u00d6';
            }
            case 249: {
                return '\u00cb';
            }
            case 250: {
                return '\u00c7';
            }
            case 251: {
                return '\u00c3';
            }
            case 252: {
                return '\u00cf';
            }
            case 253: {
                return '\u00b2';
            }
            case 254: {
                return '\u00f1';
            }
            case 255: {
                return '\u00ef';
            }
            case 715: {
                return '\u00a9';
            }
            case 710: {
                return '\u00aa';
            }
            case 732: {
                return '\u00ac';
            }
            case 8356: {
                return '\u00af';
            }
            case 8364: {
                return '\u00ba';
            }
            case 402: {
                return '\u00be';
            }
            case 352: {
                return '\u00eb';
            }
            case 353: {
                return '\u00ec';
            }
            case 376: {
                return '\u00ee';
            }
            case 8718: {
                return '\u00fc';
            }
        }
        return '\ufffd';
    }

    private static class Encoder
    extends CharsetEncoder {
        private Encoder(Charset charset) {
            super(charset, 1.1f, 1.1f);
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            if (charBuffer.hasArray() && byteBuffer.hasArray()) {
                return this.encodeArrayLoop(charBuffer, byteBuffer);
            }
            return this.encodeBufferLoop(charBuffer, byteBuffer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            char[] cArray = charBuffer.array();
            int n = charBuffer.arrayOffset() + charBuffer.position();
            int n2 = charBuffer.arrayOffset() + charBuffer.limit();
            assert (n <= n2);
            byte[] byArray = byteBuffer.array();
            int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
            int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
            assert (n3 <= n4);
            n3 = n3 <= n4 ? n3 : n4;
            try {
                int n5;
                for (n = n <= n2 ? n : n2; n < n2; n += n5) {
                    n5 = 1;
                    int n6 = 65533;
                    int n7 = cArray[n];
                    n7 = n7 > 255 ? cArray[n] : cArray[n] & 0xFF;
                    if (!Roman8.canConvert((char)n7)) {
                        CoderResult coderResult = CoderResult.unmappableForLength(n5);
                        return coderResult;
                    }
                    n6 = Roman8.mapUnicodeToRoman9(n7);
                    if (n2 - n < 1) {
                        CoderResult coderResult = CoderResult.UNDERFLOW;
                        return coderResult;
                    }
                    if (n6 == 65533) {
                        CoderResult coderResult = CoderResult.unmappableForLength(n5);
                        return coderResult;
                    }
                    if (n4 - n3 < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    byArray[n3++] = (byte)n6;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n - charBuffer.arrayOffset());
                byteBuffer.position(n3 - byteBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            int n = charBuffer.position();
            try {
                while (charBuffer.hasRemaining()) {
                    int n2 = 1;
                    int n3 = 65533;
                    int n4 = charBuffer.get() & 0xFF;
                    if (!Roman8.canConvert((char)n4)) {
                        CoderResult coderResult = CoderResult.unmappableForLength(n2);
                        return coderResult;
                    }
                    n3 = Roman8.mapUnicodeToRoman9(n4);
                    if (charBuffer.remaining() <= -1) {
                        CoderResult coderResult = CoderResult.UNDERFLOW;
                        return coderResult;
                    }
                    if (n3 == 65533) {
                        CoderResult coderResult = CoderResult.unmappableForLength(n2);
                        return coderResult;
                    }
                    if (byteBuffer.remaining() < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    byteBuffer.put((byte)n3);
                    n += n2;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n);
            }
        }
    }

    private static class Decoder
    extends CharsetDecoder {
        private Decoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            if (byteBuffer.hasArray() && charBuffer.hasArray()) {
                return this.decodeArrayLoop(byteBuffer, charBuffer);
            }
            return this.decodeBufferLoop(byteBuffer, charBuffer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            byte[] byArray = byteBuffer.array();
            int n = byteBuffer.arrayOffset() + byteBuffer.position();
            int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
            assert (n <= n2);
            char[] cArray = charBuffer.array();
            int n3 = charBuffer.arrayOffset() + charBuffer.position();
            int n4 = charBuffer.arrayOffset() + charBuffer.limit();
            assert (n3 <= n4);
            n3 = n3 <= n4 ? n3 : n4;
            try {
                int n5;
                for (n = n <= n2 ? n : n2; n < n2; n += n5) {
                    n5 = 1;
                    int n6 = 65533;
                    int n7 = byArray[n] & 0xFF;
                    if (n7 > 254) {
                        CoderResult coderResult = CoderResult.malformedForLength(1);
                        return coderResult;
                    }
                    n6 = Roman8.mapRoman9ToUnicode(n7);
                    if (n6 == 65533) {
                        CoderResult coderResult = CoderResult.unmappableForLength(n5);
                        return coderResult;
                    }
                    if (n4 - n3 < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    cArray[n3++] = n6;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n - byteBuffer.arrayOffset());
                charBuffer.position(n3 - charBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            int n = byteBuffer.position();
            try {
                while (byteBuffer.hasRemaining()) {
                    int n2 = 1;
                    char c = '\ufffd';
                    int n3 = byteBuffer.get() & 0xFF;
                    if (n3 > 254) {
                        CoderResult coderResult = CoderResult.malformedForLength(1);
                        return coderResult;
                    }
                    c = Roman8.mapRoman9ToUnicode(n3);
                    if (c == '\ufffd') {
                        CoderResult coderResult = CoderResult.unmappableForLength(n2);
                        return coderResult;
                    }
                    if (charBuffer.remaining() < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    charBuffer.put(c);
                    n += n2;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n);
            }
        }
    }
}

