/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import sun.nio.cs.ext.CompoundTextSupport;

public class COMPOUND_TEXT_Decoder
extends CharsetDecoder {
    private static final int NORMAL_BYTES = 0;
    private static final int NONSTANDARD_BYTES = 1;
    private static final int VERSION_SEQUENCE_V = 2;
    private static final int VERSION_SEQUENCE_TERM = 3;
    private static final int ESCAPE_SEQUENCE = 4;
    private static final int CHARSET_NGIIF = 5;
    private static final int CHARSET_NLIIF = 6;
    private static final int CHARSET_NLIF = 7;
    private static final int CHARSET_NRIIF = 8;
    private static final int CHARSET_NRIF = 9;
    private static final int CHARSET_NONSTANDARD_FOML = 10;
    private static final int CHARSET_NONSTANDARD_OML = 11;
    private static final int CHARSET_NONSTANDARD_ML = 12;
    private static final int CHARSET_NONSTANDARD_L = 13;
    private static final int CHARSET_NONSTANDARD = 14;
    private static final int CHARSET_LIIF = 15;
    private static final int CHARSET_LIF = 16;
    private static final int CHARSET_RIIF = 17;
    private static final int CHARSET_RIF = 18;
    private static final int CONTROL_SEQUENCE_PIF = 19;
    private static final int CONTROL_SEQUENCE_IF = 20;
    private static final int EXTENSION_ML = 21;
    private static final int EXTENSION_L = 22;
    private static final int EXTENSION = 23;
    private static final int ESCAPE_SEQUENCE_OTHER = 24;
    private static final String ERR_LATIN1 = "ISO8859_1 unsupported";
    private static final String ERR_ILLSTATE = "Illegal state";
    private static final String ERR_ESCBYTE = "Illegal byte in 0x1B escape sequence";
    private static final String ERR_ENCODINGBYTE = "Illegal byte in non-standard character set name";
    private static final String ERR_CTRLBYTE = "Illegal byte in 0x9B control sequence";
    private static final String ERR_CTRLPI = "P following I in 0x9B control sequence";
    private static final String ERR_VERSTART = "Versioning escape sequence can only appear at start of byte stream";
    private static final String ERR_VERMANDATORY = "Cannot parse mandatory extensions";
    private static final String ERR_ENCODING = "Unknown encoding: ";
    private static final String ERR_FLUSH = "Escape sequence, control sequence, or ML extension not terminated";
    private int state = 0;
    private int ext_count;
    private int ext_offset;
    private boolean versionSequenceAllowed = true;
    private byte[] byteBuf = new byte[1];
    private ByteBuffer inBB = ByteBuffer.allocate(16);
    private ByteArrayOutputStream queue = new ByteArrayOutputStream();
    private ByteArrayOutputStream encodingQueue = new ByteArrayOutputStream();
    private CharsetDecoder glDecoder;
    private CharsetDecoder grDecoder;
    private CharsetDecoder nonStandardDecoder;
    private CharsetDecoder lastDecoder;
    private boolean glHigh = false;
    private boolean grHigh = true;
    private ByteBuffer fbb = ByteBuffer.allocate(0);

    public COMPOUND_TEXT_Decoder(Charset charset) {
        super(charset, 1.0f, 1.0f);
        try {
            this.glDecoder = Charset.forName("ASCII").newDecoder();
            this.grDecoder = Charset.forName("ISO8859_1").newDecoder();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.error(ERR_LATIN1);
        }
        this.initDecoder(this.glDecoder);
        this.initDecoder(this.grDecoder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        int n;
        CoderResult coderResult = CoderResult.UNDERFLOW;
        byte[] byArray = byteBuffer.array();
        int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
        try {
            for (n = byteBuffer.arrayOffset() + byteBuffer.position(); n < n2 && coderResult.isUnderflow(); ++n) {
                coderResult = this.handleByte((short)(byArray[n] & 0xFF), charBuffer);
            }
            CoderResult coderResult2 = coderResult;
            return coderResult2;
        }
        finally {
            byteBuffer.position(n - byteBuffer.arrayOffset());
            this.inBB.clear();
        }
    }

    private CoderResult handleByte(short s, CharBuffer charBuffer) {
        CoderResult coderResult = CoderResult.UNDERFLOW;
        switch (this.state) {
            case 0: {
                coderResult = this.normalBytes(s, charBuffer);
                break;
            }
            case 1: {
                coderResult = this.nonStandardBytes(s, charBuffer);
                break;
            }
            case 2: 
            case 3: {
                coderResult = this.versionSequence(s);
                break;
            }
            case 4: {
                coderResult = this.escapeSequence(s);
                break;
            }
            case 5: {
                coderResult = this.charset94N(s);
                break;
            }
            case 6: 
            case 7: {
                coderResult = this.charset94NL(s, charBuffer);
                break;
            }
            case 8: 
            case 9: {
                coderResult = this.charset94NR(s, charBuffer);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                coderResult = this.charsetNonStandard(s, charBuffer);
                break;
            }
            case 15: 
            case 16: {
                coderResult = this.charset9496L(s, charBuffer);
                break;
            }
            case 17: 
            case 18: {
                coderResult = this.charset9496R(s, charBuffer);
                break;
            }
            case 19: 
            case 20: {
                coderResult = this.controlSequence(s);
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                coderResult = this.extension(s);
                break;
            }
            case 24: {
                coderResult = this.escapeSequenceOther(s);
                break;
            }
            default: {
                this.error(ERR_ILLSTATE);
            }
        }
        return coderResult;
    }

    private CoderResult normalBytes(short s, CharBuffer charBuffer) {
        CoderResult coderResult = CoderResult.UNDERFLOW;
        if (s >= 0 && s <= 31 || s >= 128 && s <= 159) {
            char c;
            switch (s) {
                case 27: {
                    this.state = 4;
                    this.queue.write(s);
                    return coderResult;
                }
                case 155: {
                    this.state = 19;
                    this.versionSequenceAllowed = false;
                    this.queue.write(s);
                    return coderResult;
                }
                case 9: {
                    this.versionSequenceAllowed = false;
                    c = '\t';
                    break;
                }
                case 10: {
                    this.versionSequenceAllowed = false;
                    c = '\n';
                    break;
                }
                default: {
                    this.versionSequenceAllowed = false;
                    return coderResult;
                }
            }
            if (!charBuffer.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            charBuffer.put(c);
        } else {
            boolean bl;
            CharsetDecoder charsetDecoder;
            this.versionSequenceAllowed = false;
            if (s >= 32 && s <= 127) {
                charsetDecoder = this.glDecoder;
                bl = this.glHigh;
            } else {
                charsetDecoder = this.grDecoder;
                bl = this.grHigh;
            }
            if (this.lastDecoder != null && charsetDecoder != this.lastDecoder) {
                coderResult = this.flushDecoder(this.lastDecoder, charBuffer);
            }
            this.lastDecoder = charsetDecoder;
            if (charsetDecoder != null) {
                byte by = (byte)s;
                by = bl ? (byte)(by | 0x80) : (byte)(by & 0x7F);
                if (!this.inBB.hasRemaining()) {
                    this.inBB.clear();
                    return CoderResult.unmappableForLength(16);
                }
                this.inBB.put(by);
                this.inBB.flip();
                coderResult = charsetDecoder.decode(this.inBB, charBuffer, false);
                if (!this.inBB.hasRemaining() || coderResult.isMalformed()) {
                    this.inBB.clear();
                } else {
                    int n = this.inBB.limit();
                    this.inBB.clear();
                    this.inBB.position(n);
                }
            } else if (charBuffer.remaining() < this.replacement().length()) {
                charBuffer.put(this.replacement());
            } else {
                return CoderResult.OVERFLOW;
            }
        }
        return coderResult;
    }

    private CoderResult nonStandardBytes(short s, CharBuffer charBuffer) {
        CoderResult coderResult = CoderResult.UNDERFLOW;
        if (this.nonStandardDecoder != null) {
            this.inBB.put((byte)s);
            this.inBB.flip();
            coderResult = this.nonStandardDecoder.decode(this.inBB, charBuffer, false);
            if (!this.inBB.hasRemaining()) {
                this.inBB.clear();
            } else {
                int n = this.inBB.limit();
                this.inBB.clear();
                this.inBB.position(n);
            }
        } else if (charBuffer.remaining() < this.replacement().length()) {
            charBuffer.put(this.replacement());
        } else {
            return CoderResult.OVERFLOW;
        }
        ++this.ext_offset;
        if (this.ext_offset >= this.ext_count) {
            this.ext_count = 0;
            this.ext_offset = 0;
            this.state = 0;
            coderResult = this.flushDecoder(this.nonStandardDecoder, charBuffer);
            this.nonStandardDecoder = null;
        }
        return coderResult;
    }

    private CoderResult escapeSequence(short s) {
        switch (s) {
            case 35: {
                this.state = 2;
                break;
            }
            case 36: {
                this.state = 5;
                this.versionSequenceAllowed = false;
                break;
            }
            case 37: {
                this.state = 10;
                this.versionSequenceAllowed = false;
                break;
            }
            case 40: {
                this.state = 15;
                this.versionSequenceAllowed = false;
                break;
            }
            case 41: 
            case 45: {
                this.state = 17;
                this.versionSequenceAllowed = false;
                break;
            }
            default: {
                return this.escapeSequenceOther(s);
            }
        }
        this.queue.write(s);
        return CoderResult.UNDERFLOW;
    }

    private CoderResult escapeSequenceOther(short s) {
        if (s >= 32 && s <= 47) {
            this.state = 24;
            this.versionSequenceAllowed = false;
            this.queue.write(s);
        } else if (s >= 48 && s <= 126) {
            this.state = 0;
            this.versionSequenceAllowed = false;
            this.queue.reset();
        } else {
            return this.malformedInput(ERR_ESCBYTE);
        }
        return CoderResult.UNDERFLOW;
    }

    private CoderResult controlSequence(short s) {
        if (s >= 48 && s <= 63) {
            if (this.state == 20) {
                return this.malformedInput(ERR_CTRLPI);
            }
            this.queue.write(s);
        } else if (s >= 32 && s <= 47) {
            this.state = 20;
            this.queue.write(s);
        } else if (s >= 64 && s <= 126) {
            this.state = 0;
            this.queue.reset();
        } else {
            return this.malformedInput(ERR_CTRLBYTE);
        }
        return CoderResult.UNDERFLOW;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CoderResult versionSequence(short s) {
        if (this.state == 2) {
            if (s < 32 || s > 47) return this.escapeSequenceOther(s);
            this.state = 3;
            this.queue.write(s);
            return CoderResult.UNDERFLOW;
        } else {
            switch (s) {
                case 48: {
                    if (!this.versionSequenceAllowed) {
                        return this.malformedInput(ERR_VERSTART);
                    }
                    this.versionSequenceAllowed = false;
                    this.state = 0;
                    this.queue.reset();
                    return CoderResult.UNDERFLOW;
                }
                case 49: {
                    return this.malformedInput(this.versionSequenceAllowed ? ERR_VERMANDATORY : ERR_VERSTART);
                }
                default: {
                    return this.escapeSequenceOther(s);
                }
            }
        }
    }

    private CoderResult charset94N(short s) {
        switch (s) {
            case 40: {
                this.state = 6;
                break;
            }
            case 41: {
                this.state = 8;
                break;
            }
            default: {
                return this.escapeSequenceOther(s);
            }
        }
        this.queue.write(s);
        return CoderResult.UNDERFLOW;
    }

    private CoderResult charset94NL(short s, CharBuffer charBuffer) {
        if (s < 33 || s > (this.state == 6 ? (short)35 : 47)) {
            if (s >= 64 && s <= 126) {
                return this.switchDecoder(s, charBuffer);
            }
            return this.escapeSequenceOther(s);
        }
        this.state = 7;
        this.queue.write(s);
        return CoderResult.UNDERFLOW;
    }

    private CoderResult charset94NR(short s, CharBuffer charBuffer) {
        if (s < 33 || s > (this.state == 8 ? (short)35 : 47)) {
            if (s >= 64 && s <= 126) {
                return this.switchDecoder(s, charBuffer);
            }
            return this.escapeSequenceOther(s);
        }
        this.state = 9;
        this.queue.write(s);
        return CoderResult.UNDERFLOW;
    }

    private CoderResult charset9496L(short s, CharBuffer charBuffer) {
        if (s >= 33 && s <= (this.state == 15 ? (short)35 : 47)) {
            this.state = 16;
            this.queue.write(s);
            return CoderResult.UNDERFLOW;
        }
        if (s >= 64 && s <= 126) {
            return this.switchDecoder(s, charBuffer);
        }
        return this.escapeSequenceOther(s);
    }

    private CoderResult charset9496R(short s, CharBuffer charBuffer) {
        if (s >= 33 && s <= (this.state == 17 ? (short)35 : 47)) {
            this.state = 18;
            this.queue.write(s);
            return CoderResult.UNDERFLOW;
        }
        if (s >= 64 && s <= 126) {
            return this.switchDecoder(s, charBuffer);
        }
        return this.escapeSequenceOther(s);
    }

    private CoderResult charsetNonStandard(short s, CharBuffer charBuffer) {
        switch (this.state) {
            case 10: {
                if (s == 47) {
                    this.state = 11;
                    this.queue.write(s);
                    break;
                }
                return this.escapeSequenceOther(s);
            }
            case 11: {
                if (s >= 48 && s <= 52) {
                    this.state = 12;
                    this.queue.write(s);
                    break;
                }
                if (s >= 53 && s <= 63) {
                    this.state = 21;
                    this.queue.write(s);
                    break;
                }
                return this.escapeSequenceOther(s);
            }
            case 12: {
                this.ext_count = (s & 0x7F) * 128;
                this.state = 13;
                break;
            }
            case 13: {
                this.ext_count += s & 0x7F;
                this.state = this.ext_count > 0 ? 14 : 0;
                break;
            }
            case 14: {
                if (s == 63 || s == 42) {
                    this.queue.reset();
                    return this.malformedInput(ERR_ENCODINGBYTE);
                }
                ++this.ext_offset;
                if (this.ext_offset >= this.ext_count) {
                    this.ext_count = 0;
                    this.ext_offset = 0;
                    this.state = 0;
                    this.queue.reset();
                    this.encodingQueue.reset();
                    break;
                }
                if (s == 2) {
                    return this.switchDecoder((short)0, charBuffer);
                }
                this.encodingQueue.write(s);
                break;
            }
            default: {
                this.error(ERR_ILLSTATE);
            }
        }
        return CoderResult.UNDERFLOW;
    }

    private CoderResult extension(short s) {
        switch (this.state) {
            case 21: {
                this.ext_count = (s & 0x7F) * 128;
                this.state = 22;
                break;
            }
            case 22: {
                this.ext_count += s & 0x7F;
                this.state = this.ext_count > 0 ? 23 : 0;
                break;
            }
            case 23: {
                ++this.ext_offset;
                if (this.ext_offset < this.ext_count) break;
                this.ext_count = 0;
                this.ext_offset = 0;
                this.state = 0;
                this.queue.reset();
                break;
            }
            default: {
                this.error(ERR_ILLSTATE);
            }
        }
        return CoderResult.UNDERFLOW;
    }

    private CoderResult switchDecoder(short s, CharBuffer charBuffer) {
        CoderResult coderResult = CoderResult.UNDERFLOW;
        CharsetDecoder charsetDecoder = null;
        boolean bl = false;
        byte[] byArray = null;
        if (s != 0) {
            this.queue.write(s);
        }
        byte[] byArray2 = this.queue.toByteArray();
        this.queue.reset();
        if (this.state == 14) {
            byArray = this.encodingQueue.toByteArray();
            this.encodingQueue.reset();
            charsetDecoder = CompoundTextSupport.getNonStandardDecoder(byArray2, byArray);
        } else {
            charsetDecoder = CompoundTextSupport.getStandardDecoder(byArray2);
            bl = CompoundTextSupport.getHighBit(byArray2);
        }
        if (charsetDecoder != null) {
            this.initDecoder(charsetDecoder);
        } else if (this.unmappableCharacterAction() == CodingErrorAction.REPORT) {
            int n = 1;
            if (byArray != null) {
                n = byArray.length;
            } else if (byArray2.length > 0) {
                n = byArray2.length;
            }
            return CoderResult.unmappableForLength(n);
        }
        if (this.state == 6 || this.state == 7 || this.state == 15 || this.state == 16) {
            if (this.lastDecoder == this.glDecoder) {
                coderResult = this.flushDecoder(this.glDecoder, charBuffer);
            }
            this.glDecoder = this.lastDecoder = charsetDecoder;
            this.glHigh = bl;
            this.state = 0;
        } else if (this.state == 8 || this.state == 9 || this.state == 17 || this.state == 18) {
            if (this.lastDecoder == this.grDecoder) {
                coderResult = this.flushDecoder(this.grDecoder, charBuffer);
            }
            this.grDecoder = this.lastDecoder = charsetDecoder;
            this.grHigh = bl;
            this.state = 0;
        } else if (this.state == 14) {
            if (this.lastDecoder != null) {
                coderResult = this.flushDecoder(this.lastDecoder, charBuffer);
                this.lastDecoder = null;
            }
            this.nonStandardDecoder = charsetDecoder;
            this.state = 1;
        } else {
            this.error(ERR_ILLSTATE);
        }
        return coderResult;
    }

    private CoderResult flushDecoder(CharsetDecoder charsetDecoder, CharBuffer charBuffer) {
        charsetDecoder.decode(this.fbb, charBuffer, true);
        CoderResult coderResult = charsetDecoder.flush(charBuffer);
        charsetDecoder.reset();
        return coderResult;
    }

    private CoderResult malformedInput(String string) {
        int n = this.queue.size() + 1;
        this.queue.reset();
        return CoderResult.malformedForLength(n);
    }

    private void error(String string) {
        throw new InternalError(string);
    }

    @Override
    protected CoderResult implFlush(CharBuffer charBuffer) {
        CoderResult coderResult = CoderResult.UNDERFLOW;
        if (this.lastDecoder != null) {
            coderResult = this.flushDecoder(this.lastDecoder, charBuffer);
        }
        if (this.state != 0) {
            coderResult = CoderResult.malformedForLength(0);
        }
        this.reset();
        return coderResult;
    }

    @Override
    protected void implReset() {
        this.state = 0;
        this.ext_offset = 0;
        this.ext_count = 0;
        this.versionSequenceAllowed = true;
        this.queue.reset();
        this.encodingQueue.reset();
        this.lastDecoder = null;
        this.nonStandardDecoder = null;
        this.glHigh = false;
        this.grHigh = true;
        try {
            this.glDecoder = Charset.forName("ASCII").newDecoder();
            this.grDecoder = Charset.forName("ISO8859_1").newDecoder();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.error(ERR_LATIN1);
        }
        this.initDecoder(this.glDecoder);
        this.initDecoder(this.grDecoder);
    }

    @Override
    protected void implOnMalformedInput(CodingErrorAction codingErrorAction) {
        if (this.glDecoder != null) {
            this.glDecoder.onMalformedInput(codingErrorAction);
        }
        if (this.grDecoder != null) {
            this.grDecoder.onMalformedInput(codingErrorAction);
        }
        if (this.nonStandardDecoder != null) {
            this.nonStandardDecoder.onMalformedInput(codingErrorAction);
        }
    }

    @Override
    protected void implOnUnmappableCharacter(CodingErrorAction codingErrorAction) {
        if (this.glDecoder != null) {
            this.glDecoder.onUnmappableCharacter(codingErrorAction);
        }
        if (this.grDecoder != null) {
            this.grDecoder.onUnmappableCharacter(codingErrorAction);
        }
        if (this.nonStandardDecoder != null) {
            this.nonStandardDecoder.onUnmappableCharacter(codingErrorAction);
        }
    }

    @Override
    protected void implReplaceWith(String string) {
        if (this.glDecoder != null) {
            this.glDecoder.replaceWith(string);
        }
        if (this.grDecoder != null) {
            this.grDecoder.replaceWith(string);
        }
        if (this.nonStandardDecoder != null) {
            this.nonStandardDecoder.replaceWith(string);
        }
    }

    private void initDecoder(CharsetDecoder charsetDecoder) {
        charsetDecoder.onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith(this.replacement());
    }
}

