/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.j9.section.monitor;

import com.ibm.dtfj.javacore.builder.BuilderFailureException;
import com.ibm.dtfj.javacore.builder.IImageBuilder;
import com.ibm.dtfj.javacore.builder.IImageProcessBuilder;
import com.ibm.dtfj.javacore.builder.IJavaRuntimeBuilder;
import com.ibm.dtfj.javacore.parser.framework.parser.ILookAheadBuffer;
import com.ibm.dtfj.javacore.parser.framework.parser.ParserException;
import com.ibm.dtfj.javacore.parser.j9.IAttributeValueMap;
import com.ibm.dtfj.javacore.parser.j9.J9TagManager;
import com.ibm.dtfj.javacore.parser.j9.SovereignSectionParserPart;
import com.ibm.dtfj.javacore.parser.j9.section.monitor.IMonitorTypes;
import com.ibm.dtfj.javacore.parser.j9.section.monitor.IMonitorTypesSov;
import com.ibm.dtfj.javacore.parser.j9.section.monitor.MonitorSectionParser;
import java.util.HashMap;

public class MonitorSovSectionParserPart
extends SovereignSectionParserPart
implements IMonitorTypes,
IMonitorTypesSov {
    private IJavaRuntimeBuilder fRuntimeBuilder;
    private IImageProcessBuilder fImageProcessBuilder;

    public MonitorSovSectionParserPart() {
        super("LOCKS");
    }

    @Override
    public void computeSovRule(String sovRuleID, ILookAheadBuffer lookAheadBuffer) throws ParserException {
        IAttributeValueMap results;
        this.setLookAheadBuffer(lookAheadBuffer);
        this.setTagManager(J9TagManager.getCurrent());
        if (sovRuleID.equals("1LKREGMONDUMP") && (results = this.processTagLineOptional("1LKFLATMONDUMP")) != null) {
            HashMap<Integer, Long> threads = new HashMap<Integer, Long>();
            while ((results = this.processTagLineOptional("2LKFLATMON")) != null) {
                int flatid = results.getIntValue("monitor_flat_id");
                String name = results.getTokenValue("monitor_thd_name");
                if (name != null && name.length() >= 2) {
                    name = name.substring(1, name.length() - 1);
                }
                long tid = results.getLongValue("monitor_thread_id");
                long ee = results.getLongValue("monitor_thread_ee");
                threads.put(flatid, tid);
                try {
                    this.fRuntimeBuilder.addJavaThread(null, name, -1L, tid, -1L, ee, "", -1, 0L, null);
                }
                catch (BuilderFailureException builderFailureException) {}
            }
            results = this.processTagLineRequired("1LKOBJMONDUMP");
            do {
                if ((results = this.processTagLineOptional("2LKINFLATEDMON")) != null) {
                    this.processTagLineRequired("3LKINFLDETAILS");
                    continue;
                }
                results = this.processTagLineOptional("2LKFLATLOCKED");
                if (results == null) continue;
                String className = results.getTokenValue("mon_obj_full_java_name");
                className = MonitorSectionParser.fixMonitorClassName(className);
                long objectID = results.getLongValue("monitor_object_address");
                long monitorID = results.getLongValue("monitor_object_address");
                results = this.processTagLineRequired("3LKFLATDETAILS");
                int flatid = results.getIntValue("monitor_flat_id");
                Object p = threads.get(flatid);
                long threadID = p instanceof Long ? (Long)p : -1L;
                try {
                    if (monitorID == -1L) continue;
                    this.fRuntimeBuilder.addJavaMonitor(null, monitorID, objectID, className, threadID);
                }
                catch (BuilderFailureException e) {
                    this.handleError("Could not add monitor to builder: " + objectID, e);
                }
            } while (results != null);
        }
    }

    public Object readIntoDTFJ(ILookAheadBuffer lookAhead) throws ParserException {
        return null;
    }

    @Override
    public void readIntoDTFJ(ILookAheadBuffer lookAhead, IImageBuilder imageBuilder) throws ParserException {
        this.fImageProcessBuilder = imageBuilder.getCurrentAddressSpaceBuilder().getCurrentImageProcessBuilder();
        this.fRuntimeBuilder = this.fImageProcessBuilder.getCurrentJavaRuntimeBuilder();
    }
}

