/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.javacore;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.javacore.JCCorruptData;
import com.ibm.dtfj.image.javacore.JCImageAddressSpace;
import com.ibm.dtfj.image.javacore.JCImageProcess;
import com.ibm.dtfj.image.javacore.JCImageThread;
import com.ibm.dtfj.image.javacore.LookupKey;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.java.JavaVMInitArgs;
import com.ibm.dtfj.java.javacore.JCInvalidArgumentsException;
import com.ibm.dtfj.java.javacore.JCJavaClass;
import com.ibm.dtfj.java.javacore.JCJavaClassLoader;
import com.ibm.dtfj.java.javacore.JCJavaMonitor;
import com.ibm.dtfj.java.javacore.JCJavaRuntimeMemoryCategory;
import com.ibm.dtfj.java.javacore.JCJavaThread;
import com.ibm.dtfj.java.javacore.JCJavaVMInitArgs;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public class JCJavaRuntime
implements JavaRuntime {
    private Vector fHeaps;
    private Vector fCompiledMethods;
    private HashMap fJavaClassLoaders;
    private HashMap fJavaClasses;
    private HashMap fMonitors;
    private HashMap fJavaThreads;
    private HashMap fJavaClassIDs;
    private JCJavaVMInitArgs fJavaVMInitArgs;
    private List fMemoryCategories;
    private String fFullVersion;
    private String fVersion;
    private String fID;
    private final LookupKey fIDLookupKey;
    private final JCImageProcess fImageProcess;
    private final JCImageAddressSpace fImageAddressSpace;
    private boolean isJITEnabled = false;
    private Properties jitOptions = new Properties();
    private long fStartTime;
    private boolean fStartTimeSet = false;
    private long fStartTimeNanos;
    private boolean fStartTimeNanosSet = false;

    public JCJavaRuntime(JCImageProcess imageProcess, String id) throws JCInvalidArgumentsException {
        if (imageProcess == null) {
            throw new JCInvalidArgumentsException("A runtime must be associated with a valid image process");
        }
        if (id == null) {
            throw new JCInvalidArgumentsException("A runtime must be associated with a valid id. This is necessary when parsing multiple runtimes");
        }
        this.fID = id;
        this.fImageProcess = imageProcess;
        this.fImageAddressSpace = imageProcess.getImageAddressSpace();
        this.fHeaps = new Vector();
        this.fCompiledMethods = new Vector();
        this.fJavaClassLoaders = new LinkedHashMap();
        this.fMonitors = new LinkedHashMap();
        this.fJavaThreads = new LinkedHashMap();
        this.fJavaClasses = new HashMap();
        this.fJavaClassIDs = new HashMap();
        this.fMemoryCategories = new LinkedList();
        this.fFullVersion = null;
        this.fVersion = null;
        this.fIDLookupKey = new LookupKey(-1L);
        imageProcess.addRuntime(this);
    }

    @Override
    public Iterator getCompiledMethods() {
        return this.fCompiledMethods.iterator();
    }

    @Override
    public Iterator getHeaps() {
        return this.fHeaps.iterator();
    }

    @Override
    public Iterator getJavaClassLoaders() {
        return this.fJavaClassLoaders.values().iterator();
    }

    @Override
    public Iterator getMonitors() {
        return this.fMonitors.values().iterator();
    }

    @Override
    public Iterator getThreads() {
        return this.fJavaThreads.values().iterator();
    }

    @Override
    public JavaVMInitArgs getJavaVMInitArgs() throws DataUnavailable, CorruptDataException {
        if (this.fJavaVMInitArgs == null) {
            throw new DataUnavailable("JavaVMInitArgs not available");
        }
        return this.fJavaVMInitArgs;
    }

    @Override
    public ImagePointer getJavaVM() throws CorruptDataException {
        throw new CorruptDataException(new JCCorruptData(null));
    }

    @Override
    public Object getTraceBuffer(String arg0, boolean arg1) throws CorruptDataException {
        throw new CorruptDataException(new JCCorruptData(null));
    }

    @Override
    public String getFullVersion() throws CorruptDataException {
        if (this.fFullVersion == null) {
            throw new CorruptDataException(new JCCorruptData(null));
        }
        return this.fFullVersion;
    }

    @Override
    public String getVersion() throws CorruptDataException {
        if (this.fVersion == null) {
            throw new CorruptDataException(new JCCorruptData(null));
        }
        return this.fVersion;
    }

    public String getInternalID() {
        return this.fID;
    }

    public void addJavaClassLoader(JCJavaClassLoader javaClassLoader) throws JCInvalidArgumentsException {
        if (javaClassLoader == null) {
            throw new JCInvalidArgumentsException("Not a valid java class loader.");
        }
        this.fJavaClassLoaders.put(new LookupKey(javaClassLoader.getPointerID().getAddress()), javaClassLoader);
    }

    public JCJavaClassLoader findJavaClassLoader(long clLoaderID) {
        this.fIDLookupKey.setKey(clLoaderID);
        return (JCJavaClassLoader)this.fJavaClassLoaders.get(this.fIDLookupKey);
    }

    public void addMonitor(JCJavaMonitor monitor) throws JCInvalidArgumentsException {
        if (monitor == null) {
            throw new JCInvalidArgumentsException("Must pass a valid java monitor");
        }
        this.fMonitors.put(new LookupKey(monitor.getID().getAddress()), monitor);
    }

    public JCJavaMonitor findMonitor(long id) {
        this.fIDLookupKey.setKey(id);
        return (JCJavaMonitor)this.fMonitors.get(this.fIDLookupKey);
    }

    public void addJavaThread(JCJavaThread javaThread) throws JCInvalidArgumentsException {
        if (javaThread == null) {
            throw new JCInvalidArgumentsException("Must pass a valid java thread");
        }
        this.fJavaThreads.put(new LookupKey(javaThread.getThreadID().getAddress()), javaThread);
    }

    public JCJavaThread findJavaThread(long threadID) {
        JCJavaThread javaThread = null;
        this.fIDLookupKey.setKey(threadID);
        Object v = this.fJavaThreads.get(this.fIDLookupKey);
        javaThread = (JCJavaThread)v;
        if (v == null) {
            Iterator it = this.fJavaThreads.values().iterator();
            while (javaThread == null && it.hasNext()) {
                long address;
                JCJavaThread jThread = (JCJavaThread)it.next();
                JCImageThread imageThread = jThread.internalGetImageThread();
                if (imageThread == null) continue;
                ImagePointer pointer = imageThread.getSystemThreadID();
                long l = address = pointer != null ? pointer.getAddress() : -1L;
                if (address != -1L && address == threadID) {
                    javaThread = jThread;
                    continue;
                }
                pointer = imageThread.getInternalID();
                if (pointer.getAddress() != threadID) continue;
                javaThread = jThread;
            }
        }
        return javaThread;
    }

    public JCImageProcess getImageProcess() {
        return this.fImageProcess;
    }

    public void addJavaClass(JCJavaClass javaClass) throws JCInvalidArgumentsException {
        if (javaClass == null) {
            throw new JCInvalidArgumentsException("Must pass a valid javaClass");
        }
        String javaClassName = javaClass.internalGetName();
        ImagePointer pointer = javaClass.getID();
        if (pointer != null) {
            long id = pointer.getAddress();
            this.fJavaClassIDs.put(new LookupKey(id), javaClass);
        }
        this.fJavaClasses.put(javaClassName, javaClass);
    }

    public JCJavaClass findJavaClass(String javaClassName) {
        return (JCJavaClass)this.fJavaClasses.get(javaClassName);
    }

    public JCJavaClass findJavaClass(long id) {
        JCJavaClass javaClass = null;
        if (this.fImageAddressSpace.isValidAddressID(id)) {
            this.fIDLookupKey.setKey(id);
            javaClass = (JCJavaClass)this.fJavaClassIDs.get(this.fIDLookupKey);
        }
        return javaClass;
    }

    public void addJavaVMInitArgs(JCJavaVMInitArgs args) throws JCInvalidArgumentsException {
        if (args == null) {
            throw new JCInvalidArgumentsException("Must pass a valid JavaVMInitArgs object");
        }
        this.fJavaVMInitArgs = args;
    }

    @Override
    public Iterator getHeapRoots() {
        return Collections.EMPTY_LIST.iterator();
    }

    @Override
    public JavaObject getObjectAtAddress(ImagePointer address) throws DataUnavailable {
        throw new DataUnavailable("Object information not available.");
    }

    public void setVersion(String version) {
        this.fVersion = version;
    }

    @Override
    public Iterator getMemoryCategories() throws DataUnavailable {
        return Collections.unmodifiableList(this.fMemoryCategories).iterator();
    }

    @Override
    public Iterator getMemorySections(boolean includeFreed) throws DataUnavailable {
        throw new DataUnavailable("Memory section data not available in JavaCore");
    }

    public void addTopLevelMemoryCategory(JCJavaRuntimeMemoryCategory category) {
        this.fMemoryCategories.add(category);
    }

    @Override
    public boolean isJITEnabled() throws DataUnavailable, CorruptDataException {
        return this.isJITEnabled;
    }

    public void setJITEnabled(boolean enabled) {
        this.isJITEnabled = enabled;
    }

    public void addJITProperty(String name, String value) {
        this.jitOptions.put(name, value);
    }

    @Override
    public Properties getJITProperties() throws DataUnavailable, CorruptDataException {
        if (this.isJITEnabled) {
            return this.jitOptions;
        }
        throw new DataUnavailable("The JIT was not enabled for this runtime");
    }

    @Override
    public long getStartTime() throws DataUnavailable, CorruptDataException {
        if (this.fStartTimeSet) {
            return this.fStartTime;
        }
        throw new DataUnavailable("JVM start time not available");
    }

    @Override
    public long getStartTimeNanos() throws DataUnavailable, CorruptDataException {
        if (this.fStartTimeNanosSet) {
            return this.fStartTimeNanos;
        }
        throw new DataUnavailable("JVM start nanotime not available");
    }

    public void setStartTime(long startTime) {
        this.fStartTime = startTime;
        this.fStartTimeSet = true;
    }

    public void setStartTimeNanos(long nanoTime) {
        this.fStartTimeNanos = nanoTime;
        this.fStartTimeNanosSet = true;
    }
}

