/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.image.j9;

import com.ibm.dtfj.addressspace.IAbstractAddressSpace;
import com.ibm.dtfj.corereaders.MemoryRange;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.image.j9.RawImageSection;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class ImageAddressSpace
implements com.ibm.dtfj.image.ImageAddressSpace {
    private Vector _processes = new Vector();
    private IAbstractAddressSpace _shadow;
    private int _asid = 0;

    public ImageAddressSpace(IAbstractAddressSpace memory, int asid) {
        this._shadow = memory;
        this._asid = asid;
    }

    @Override
    public ByteOrder getByteOrder() {
        return this._shadow.getByteOrder();
    }

    @Override
    public ImageProcess getCurrentProcess() {
        ImageProcess currentProc = null;
        if (this._processes.size() > 0) {
            currentProc = (ImageProcess)this._processes.elementAt(0);
        }
        return currentProc;
    }

    @Override
    public Iterator getProcesses() {
        return this._processes.iterator();
    }

    @Override
    public ImagePointer getPointer(long address) {
        return new com.ibm.dtfj.image.j9.ImagePointer(this, address);
    }

    public void addProcess(ImageProcess proc) {
        this._processes.add(proc);
    }

    public byte readByteAtIndex(long address) throws MemoryAccessException {
        try {
            return this._shadow.getByteAt(this._asid, address);
        }
        catch (com.ibm.dtfj.corereaders.MemoryAccessException e) {
            throw new MemoryAccessException(this.getPointer(address));
        }
    }

    public ImagePointer readPointerAtIndex(long address) throws MemoryAccessException {
        try {
            long ptr = this._shadow.getPointerAt(this._asid, address);
            return this.getPointer(ptr);
        }
        catch (com.ibm.dtfj.corereaders.MemoryAccessException e) {
            throw new MemoryAccessException(this.getPointer(address));
        }
    }

    public int readIntAtIndex(long address) throws MemoryAccessException {
        try {
            return this._shadow.getIntAt(this._asid, address);
        }
        catch (com.ibm.dtfj.corereaders.MemoryAccessException e) {
            throw new MemoryAccessException(this.getPointer(address));
        }
    }

    public long readLongAtIndex(long address) throws MemoryAccessException {
        try {
            return this._shadow.getLongAt(this._asid, address);
        }
        catch (com.ibm.dtfj.corereaders.MemoryAccessException e) {
            throw new MemoryAccessException(this.getPointer(address));
        }
    }

    public short readShortAtIndex(long address) throws MemoryAccessException {
        try {
            return this._shadow.getShortAt(this._asid, address);
        }
        catch (com.ibm.dtfj.corereaders.MemoryAccessException e) {
            throw new MemoryAccessException(this.getPointer(address));
        }
    }

    @Override
    public Iterator getImageSections() {
        Iterator rangeWalker = this._shadow.getMemoryRanges();
        Vector<RawImageSection> sections = new Vector<RawImageSection>();
        while (rangeWalker.hasNext()) {
            MemoryRange range = (MemoryRange)rangeWalker.next();
            if (range.getAsid() != this._asid) continue;
            long virtualAddress = range.getVirtualAddress();
            RawImageSection section = new RawImageSection(this.getPointer(virtualAddress), range.getSize());
            sections.add(section);
        }
        return sections.iterator();
    }

    boolean isExecutableAt(long address) throws DataUnavailable {
        try {
            return this._shadow.isExecutable(this._asid, address);
        }
        catch (com.ibm.dtfj.corereaders.MemoryAccessException e) {
            throw new DataUnavailable();
        }
    }

    boolean isReadOnly(long address) throws DataUnavailable {
        try {
            return this._shadow.isReadOnly(this._asid, address);
        }
        catch (com.ibm.dtfj.corereaders.MemoryAccessException e) {
            throw new DataUnavailable();
        }
    }

    boolean isShared(long address) throws DataUnavailable {
        try {
            return this._shadow.isShared(this._asid, address);
        }
        catch (com.ibm.dtfj.corereaders.MemoryAccessException e) {
            throw new DataUnavailable();
        }
    }

    public int bytesPerPointer() {
        return this._shadow.bytesPerPointer(this._asid);
    }

    public String toString() {
        return this._asid != 0 ? "0x" + Integer.toHexString(this._asid) : super.toString();
    }

    @Override
    public String getID() throws DataUnavailable, CorruptDataException {
        return "0x" + Long.toHexString(this._asid);
    }

    @Override
    public Properties getProperties() {
        return new Properties();
    }
}

