/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.image.j9;

import com.ibm.dtfj.corereaders.ClosingFileReader;
import com.ibm.dtfj.corereaders.DumpFactory;
import com.ibm.dtfj.corereaders.ICoreFileReader;
import com.ibm.dtfj.corereaders.ResourceReleaser;
import com.ibm.dtfj.image.j9.DefaultFileLocationResolver;
import com.ibm.dtfj.image.j9.IFileLocationResolver;
import com.ibm.dtfj.image.j9.Image;
import com.ibm.dtfj.image.j9.ImageFactory;
import com.ibm.dtfj.image.j9.ReleasingImage;
import com.ibm.dtfj.image.j9.ZipExtractionResolver;
import com.ibm.dtfj.utils.file.FileManager;
import com.ibm.jvm.j9.dump.indexsupport.XMLIndexReader;
import com.ibm.jvm.j9.dump.indexsupport.XMLInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteOrder;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.imageio.stream.ImageInputStream;

public class DTFJImageFactory
implements com.ibm.dtfj.image.ImageFactory {
    @Override
    public com.ibm.dtfj.image.Image[] getImagesFromArchive(File archive, boolean extract) throws IOException {
        throw new IOException("Not supported for legacy DTFJ");
    }

    @Override
    public com.ibm.dtfj.image.Image getImage(File imageFile) throws IOException {
        ReleasingImage image = null;
        try {
            ZipFile zip = new ZipFile(imageFile);
            ZipExtractionResolver resolver = new ZipExtractionResolver(zip);
            File coreFile = resolver.decompressCoreFile();
            InputStream metaStream = resolver.decompressMetaDataStream();
            image = this.getImage(coreFile, metaStream, resolver);
            image.addReleasable(resolver);
        }
        catch (ZipException z) {
            return this.getImage(imageFile, new File(imageFile.toString() + ".xml"));
        }
        return image;
    }

    @Override
    public com.ibm.dtfj.image.Image getImage(ImageInputStream in, URI sourceID) throws IOException {
        throw new IOException("Legacy DTFJ requires an XML file to be supplied when creating an image from a stream.");
    }

    @Override
    public com.ibm.dtfj.image.Image getImage(ImageInputStream in, final ImageInputStream meta, URI sourceID) throws IOException {
        in.setByteOrder(ByteOrder.BIG_ENDIAN);
        ICoreFileReader core = DumpFactory.createDumpForCore(in);
        XMLIndexReader indexData = new XMLIndexReader();
        InputStream stream = new InputStream(){

            @Override
            public int read() throws IOException {
                return meta.read();
            }
        };
        XMLInputStream xmlstream = new XMLInputStream(stream);
        IFileLocationResolver resolver = null;
        File source = null;
        if (sourceID.getFragment() != null && sourceID.getFragment().length() != 0) {
            try {
                URI uri = new URI(sourceID.getScheme() + "://" + sourceID.getPath());
                source = new File(uri);
            }
            catch (URISyntaxException uri) {}
        } else {
            source = new File(sourceID);
        }
        if (source.exists()) {
            if (FileManager.isArchive(source)) {
                ZipFile zip = new ZipFile(source);
                resolver = new ZipExtractionResolver(zip);
            } else {
                resolver = new DefaultFileLocationResolver(source.getParentFile());
            }
        }
        Image image = indexData.parseIndexWithDump((InputStream)xmlstream, core, in, resolver);
        meta.close();
        image.addReleasable(core);
        if (image instanceof Image) {
            image.SetSource(sourceID);
        }
        return image;
    }

    @Override
    public com.ibm.dtfj.image.Image getImage(File imageFile, File metadata) throws IOException {
        FileInputStream metastream = null;
        IFileLocationResolver resolver = null;
        if (FileManager.isArchive(metadata)) {
            File meta = new File(imageFile.getParentFile(), imageFile.getName() + ".xml");
            metastream = new FileInputStream(meta);
            ZipFile zip = new ZipFile(metadata);
            resolver = new ZipExtractionResolver(zip);
        } else {
            metastream = new FileInputStream(metadata);
            resolver = new DefaultFileLocationResolver(imageFile.getParentFile());
        }
        ReleasingImage image = this.getImage(imageFile, metastream, resolver);
        metastream.close();
        return image;
    }

    private ReleasingImage getImage(File imageFile, InputStream metadata, IFileLocationResolver resolver) throws IOException {
        ClosingFileReader reader = new ClosingFileReader(imageFile);
        ICoreFileReader core = DumpFactory.createDumpForCore(reader);
        XMLIndexReader indexData = new XMLIndexReader();
        XMLInputStream in = new XMLInputStream(metadata);
        Image image = indexData.parseIndexWithDump((InputStream)in, core, reader, resolver);
        image.addReleasable(in);
        image.addReleasable(reader);
        image.addReleasable(core);
        if (resolver instanceof ResourceReleaser) {
            image.addReleasable((ResourceReleaser)((Object)resolver));
        }
        return image;
    }

    @Override
    public int getDTFJMajorVersion() {
        return 1;
    }

    @Override
    public int getDTFJMinorVersion() {
        return 12;
    }

    @Override
    public int getDTFJModificationLevel() {
        int buildNumber = 0;
        try {
            buildNumber = Integer.parseInt(ImageFactory.class.getPackage().getImplementationVersion());
        }
        catch (NumberFormatException nfe) {
            buildNumber = -1;
        }
        return buildNumber;
    }
}

