/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jstat;

import java.io.PrintStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import sun.jvmstat.monitor.Monitor;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredVm;
import sun.jvmstat.monitor.StringMonitor;
import sun.tools.jstat.OutputFormatter;

public class JStatLogger {
    private MonitoredVm monitoredVm;
    private volatile boolean active = true;

    public JStatLogger(MonitoredVm monitoredVm) {
        this.monitoredVm = monitoredVm;
    }

    public void printNames(String string, Comparator<Monitor> comparator, boolean bl, PrintStream printStream) throws MonitorException, PatternSyntaxException {
        List<Monitor> list = this.monitoredVm.findByPattern(string);
        Collections.sort(list, comparator);
        for (Monitor monitor : list) {
            if (!monitor.isSupported() && !bl) continue;
            printStream.println(monitor.getName());
        }
    }

    public void printSnapShot(String string, Comparator<Monitor> comparator, boolean bl, boolean bl2, PrintStream printStream) throws MonitorException, PatternSyntaxException {
        List<Monitor> list = this.monitoredVm.findByPattern(string);
        Collections.sort(list, comparator);
        this.printList(list, bl, bl2, printStream);
    }

    public void printList(List<Monitor> list, boolean bl, boolean bl2, PrintStream printStream) throws MonitorException {
        for (Monitor monitor : list) {
            if (!monitor.isSupported() && !bl2) continue;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(monitor.getName()).append("=");
            if (monitor instanceof StringMonitor) {
                stringBuilder.append("\"").append(monitor.getValue()).append("\"");
            } else {
                stringBuilder.append(monitor.getValue());
            }
            if (bl) {
                stringBuilder.append(" ").append(monitor.getUnits());
                stringBuilder.append(" ").append(monitor.getVariability());
                stringBuilder.append(" ").append(monitor.isSupported() ? "Supported" : "Unsupported");
            }
            printStream.println(stringBuilder);
        }
    }

    public void stopLogging() {
        this.active = false;
    }

    public void logSamples(OutputFormatter outputFormatter, int n, int n2, int n3, PrintStream printStream) throws MonitorException {
        long l = 0L;
        int n4 = 0;
        int n5 = n;
        if (n5 == 0) {
            printStream.println(outputFormatter.getHeader());
            n5 = -1;
        }
        while (this.active) {
            if (n5 > 0 && --n4 <= 0) {
                n4 = n5;
                printStream.println(outputFormatter.getHeader());
            }
            printStream.println(outputFormatter.getRow());
            if (n3 > 0 && ++l >= (long)n3) break;
            try {
                Thread.sleep(n2);
            }
            catch (Exception exception) {}
        }
    }
}

