/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.AlreadyBoundException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetBoundException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import sun.net.NetworkProvider;
import sun.net.SocketAction;
import sun.nio.ch.IOStatus;
import sun.nio.ch.IOUtil;
import sun.nio.ch.NIONetworkSelector;
import sun.nio.ch.NativeThread;
import sun.nio.ch.Net;
import sun.nio.ch.RDMAIOUtil;
import sun.nio.ch.RDMANet;
import sun.nio.ch.RDMASelChImpl;
import sun.nio.ch.RDMAServerSocketAdaptor;
import sun.nio.ch.RDMASocketChannelImpl;
import sun.nio.ch.RDMASocketDispatcher;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.ServerSocketChannelImpl;
import sun.nio.ch.SocketChannelImpl;

class RDMAServerSocketChannelImpl
extends ServerSocketChannelImpl
implements RDMASelChImpl {
    private static RDMASocketDispatcher rsd;
    private final long rsockPtr;
    private boolean providerSwitchDone = false;
    private boolean readyToAccept = false;
    private volatile long thread = 0L;
    private final Object lock = new Object();
    private final Object stateLock = new Object();
    private static final int ST_UNINITIALIZED = -1;
    private static final int ST_INUSE = 0;
    private static final int ST_KILLED = 1;
    private int state = -1;
    private InetSocketAddress localAddress;
    private boolean isReuseAddress;
    private ServerSocket socket;

    RDMAServerSocketChannelImpl(SelectorProvider selectorProvider) throws IOException {
        super(selectorProvider);
        this.rsockPtr = RDMANet.socket(true);
        this.state = 0;
        if (NIONetworkSelector.isDebugOn()) {
            System.out.printf("JSORI:NIO:%X: RDMA server socketchannel created%n", this.hashCode());
        }
    }

    RDMAServerSocketChannelImpl(SelectorProvider selectorProvider, long l, boolean bl) throws IOException {
        super(selectorProvider);
        this.rsockPtr = l;
        this.state = 0;
        if (bl) {
            this.localAddress = RDMANet.localAddress(l);
            this.providerSwitchDone = true;
        }
        if (NIONetworkSelector.isDebugOn()) {
            if (bl) {
                System.out.printf("JSORI:NIO:%X: RDMA server socketchannel bound to %s created%n", this.hashCode(), this.localAddress);
            } else {
                System.out.printf("JSORI:NIO:%X: RDMA server socketchannel created%n", this.hashCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServerSocket socket() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.socket == null) {
                this.socket = RDMAServerSocketAdaptor.create(this);
                if (NIONetworkSelector.isDebugOn()) {
                    System.out.printf("JSORI:NIO:%X: RDMA server socketchannel adaptor created%n", this.hashCode());
                }
            }
            return this.socket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketAddress getLocalAddress() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            InetSocketAddress inetSocketAddress;
            if (!this.providerSwitchDone) {
                return super.getLocalAddress();
            }
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            InetSocketAddress inetSocketAddress2 = inetSocketAddress = this.localAddress == null ? this.localAddress : Net.getRevealedLocalAddress(Net.asInetSocketAddress(this.localAddress));
            if (NIONetworkSelector.isDebugOn()) {
                System.out.printf("JSORI:NIO:%X: Retrieved RDMA server socketchannel local addr %s%n", this.hashCode(), inetSocketAddress);
            }
            return inetSocketAddress;
        }
    }

    public final Set<SocketOption<?>> rdmaSupportedOptions() {
        return RDMASupportedOptionsHolder.optionSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> ServerSocketChannel setOption(SocketOption<T> socketOption, T t) throws IOException {
        if (socketOption == null) {
            throw new NullPointerException();
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.providerSwitchDone) {
                return super.setOption((SocketOption)socketOption, (Object)t);
            }
            if (!this.rdmaSupportedOptions().contains(socketOption)) {
                throw new UnsupportedOperationException("'" + socketOption + "' not supported");
            }
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (socketOption == StandardSocketOptions.SO_REUSEADDR && Net.useExclusiveBind()) {
                this.isReuseAddress = (Boolean)t;
            } else {
                RDMANet.setSocketOption(this.rsockPtr, socketOption, t);
            }
            if (NIONetworkSelector.isDebugOn()) {
                System.out.printf("JSORI:NIO:%X: RDMA server socketchannel option %s set to %s%n", this.hashCode(), socketOption, t);
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getOption(SocketOption<T> socketOption) throws IOException {
        if (socketOption == null) {
            throw new NullPointerException();
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.providerSwitchDone) {
                return super.getOption(socketOption);
            }
            if (!this.rdmaSupportedOptions().contains(socketOption)) {
                throw new UnsupportedOperationException("'" + socketOption + "' not supported");
            }
            Object object2 = socketOption == StandardSocketOptions.SO_REUSEADDR && Net.useExclusiveBind() ? Boolean.valueOf(this.isReuseAddress) : RDMANet.getSocketOption(this.rsockPtr, socketOption);
            if (NIONetworkSelector.isDebugOn()) {
                System.out.printf("JSORI:NIO:%X: RDMA server socketchannel option %s value %s%n", this.hashCode(), socketOption, object2);
            }
            return (T)object2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBound() {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.providerSwitchDone) {
                return super.isBound();
            }
            return this.localAddress != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InetSocketAddress localAddress() {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.providerSwitchDone) {
                return super.localAddress();
            }
            if (NIONetworkSelector.isDebugOn()) {
                System.out.printf("JSORI:NIO:%X: Retrieved RDMA server socketchannel local addr %s%n", this.hashCode(), this.localAddress);
            }
            return this.localAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServerSocketChannel bind(SocketAddress socketAddress, int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            Object object2;
            NetworkProvider networkProvider;
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (this.isBound()) {
                throw new AlreadyBoundException();
            }
            InetSocketAddress inetSocketAddress = socketAddress == null ? new InetSocketAddress(0) : Net.checkAddress(socketAddress);
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkListen(inetSocketAddress.getPort());
            }
            if ((networkProvider = NIONetworkSelector.getNetworkProvider(SocketAction.BIND, inetSocketAddress.getAddress(), inetSocketAddress.getPort(), null)) == null) {
                if (NIONetworkSelector.isDebugOn()) {
                    System.out.printf("JSORW:NIO:%X: RDMA network provider not avail for bind addr %s%n", this.hashCode(), inetSocketAddress);
                }
                return super.bind(socketAddress, n);
            }
            if (networkProvider.getPreferredAddress() != null && (((InetAddress)(object2 = inetSocketAddress.getAddress())).isAnyLocalAddress() || ((InetAddress)object2).isLoopbackAddress())) {
                inetSocketAddress = new InetSocketAddress(networkProvider.getPreferredAddress(), inetSocketAddress.getPort());
            }
            RDMANet.bind(this.rsockPtr, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
            RDMANet.listen(this.rsockPtr, n < 1 ? 50 : n);
            object2 = this.stateLock;
            synchronized (object2) {
                this.providerSwitchDone = true;
                this.localAddress = RDMANet.localAddress(this.rsockPtr);
            }
            if (NIONetworkSelector.isDebugOn()) {
                System.out.printf("JSORI:NIO:%X: RDMA server socketchannel bound to addr %s%n", this.hashCode(), this.localAddress);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public SocketChannel accept() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            NetworkProvider networkProvider;
            Object object2;
            boolean bl;
            InetSocketAddress[] inetSocketAddressArray;
            Long l;
            int n;
            Object object3;
            block28: {
                object3 = this.stateLock;
                synchronized (object3) {
                    if (!this.providerSwitchDone) {
                        SocketChannelImpl socketChannelImpl = (SocketChannelImpl)super.accept();
                        RDMASocketChannelImpl rDMASocketChannelImpl = null;
                        if (socketChannelImpl != null) {
                            rDMASocketChannelImpl = new RDMASocketChannelImpl(this.provider(), socketChannelImpl.getFD(), (InetSocketAddress)socketChannelImpl.remoteAddress());
                        }
                        return rDMASocketChannelImpl;
                    }
                }
                if (!this.isOpen()) {
                    throw new ClosedChannelException();
                }
                if (!this.isBound()) {
                    throw new NotYetBoundException();
                }
                object3 = null;
                n = 0;
                l = new Long(0L);
                inetSocketAddressArray = new InetSocketAddress[1];
                bl = false;
                object2 = this.stateLock;
                synchronized (object2) {
                    if (this.readyToAccept) {
                        bl = true;
                        this.readyToAccept = false;
                    }
                }
                this.begin();
                if (this.isOpen()) break block28;
                object2 = null;
                this.thread = 0L;
                this.end(n > 0);
                assert (IOStatus.check(n));
                return object2;
            }
            try {
                this.thread = NativeThread.current();
                while ((n = this.accept0(this.rsockPtr, l, inetSocketAddressArray, bl)) == -3 && this.isOpen()) {
                }
                this.thread = 0L;
                this.end(n > 0);
            }
            catch (Throwable throwable) {
                this.thread = 0L;
                this.end(n > 0);
                assert (IOStatus.check(n));
                throw throwable;
            }
            assert (IOStatus.check(n));
            if (n < 1) {
                return null;
            }
            RDMAIOUtil.configureBlocking(l, true);
            object2 = inetSocketAddressArray[0];
            object3 = new RDMASocketChannelImpl(this.provider(), l, (InetSocketAddress)object2);
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                try {
                    securityManager.checkAccept(((InetSocketAddress)object2).getAddress().getHostAddress(), ((InetSocketAddress)object2).getPort());
                }
                catch (SecurityException securityException) {
                    ((AbstractInterruptibleChannel)object3).close();
                    throw securityException;
                }
            }
            if ((networkProvider = NIONetworkSelector.getNetworkProvider(SocketAction.ACCEPT, this.localAddress.getAddress(), this.localAddress.getPort(), ((InetSocketAddress)object2).getAddress())) == null) {
                if (NIONetworkSelector.isDebugOn()) {
                    System.out.printf("JSORW:NIO:%X: RDMA network provider not avail for connect addr %s%n", this.hashCode(), object2);
                }
                ((AbstractInterruptibleChannel)object3).close();
                throw new IOException("Remote host not allowed to connect in RDMA mode");
            }
            if (NIONetworkSelector.isDebugOn()) {
                System.out.printf("JSORI:NIO:%X: RDMA connect request from %s accepted on %s%n", this.hashCode(), object2, this.localAddress);
            }
            return object3;
        }
    }

    @Override
    protected void implConfigureBlocking(boolean bl) throws IOException {
        super.implConfigureBlocking(bl);
        RDMAIOUtil.configureBlocking(this.rsockPtr, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implCloseSelectableChannel() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.thread != 0L) {
                NativeThread.signal(this.thread);
            }
            rsd.preClose(this.rsockPtr);
            if (!this.isRegistered()) {
                this.kill();
            }
            super.implCloseSelectableChannel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void kill() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            super.kill();
            if (this.state == 1) {
                return;
            }
            if (this.state == -1) {
                this.state = 1;
                return;
            }
            assert (!this.isOpen() && !this.isRegistered());
            rsd.close(this.rsockPtr);
            this.state = 1;
            if (NIONetworkSelector.isDebugOn()) {
                System.out.printf("JSORI:NIO:%X: RDMA server socketchannel closed%n", this.hashCode());
            }
        }
    }

    @Override
    public boolean translateReadyOps(int n, int n2, SelectionKeyImpl selectionKeyImpl) {
        if (!this.providerSwitchDone) {
            return super.translateReadyOps(n, n2, selectionKeyImpl);
        }
        int n3 = selectionKeyImpl.nioInterestOps();
        int n4 = selectionKeyImpl.nioReadyOps();
        int n5 = n2;
        if ((n & Net.POLLNVAL) != 0) {
            return false;
        }
        if ((n & (Net.POLLERR | Net.POLLHUP)) != 0) {
            n5 = n3;
            selectionKeyImpl.nioReadyOps(n5);
            return (n5 & ~n4) != 0;
        }
        if ((n & Net.POLLIN) != 0 && (n3 & 0x10) != 0) {
            n5 |= 0x10;
            this.readyToAccept = true;
        }
        selectionKeyImpl.nioReadyOps(n5);
        return (n5 & ~n4) != 0;
    }

    @Override
    public boolean translateAndUpdateReadyOps(int n, SelectionKeyImpl selectionKeyImpl) {
        return this.translateReadyOps(n, selectionKeyImpl.nioReadyOps(), selectionKeyImpl);
    }

    @Override
    public boolean translateAndSetReadyOps(int n, SelectionKeyImpl selectionKeyImpl) {
        return this.translateReadyOps(n, 0, selectionKeyImpl);
    }

    @Override
    public void translateAndSetInterestOps(int n, SelectionKeyImpl selectionKeyImpl) {
        int n2 = 0;
        if ((n & 0x10) != 0) {
            n2 |= Net.POLLIN;
        }
        selectionKeyImpl.selector.putEventOps(selectionKeyImpl, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append('[');
        if (!this.isOpen()) {
            stringBuffer.append("closed");
        } else {
            Object object = this.stateLock;
            synchronized (object) {
                InetSocketAddress inetSocketAddress = this.localAddress();
                if (inetSocketAddress == null) {
                    stringBuffer.append("unbound");
                } else {
                    stringBuffer.append(Net.getRevealedLocalAddressAsString(inetSocketAddress));
                }
            }
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    private native int accept0(long var1, Long var3, InetSocketAddress[] var4, boolean var5) throws IOException;

    private static native void initIDs();

    @Override
    public long getRsocketPtr() {
        return this.rsockPtr;
    }

    @Override
    public int getTcpFD() {
        if (this.providerSwitchDone) {
            return -1;
        }
        return IOUtil.fdVal(super.getFD());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    int poll(int n, long l) throws IOException {
        int n2;
        block14: {
            int n3;
            if (!$assertionsDisabled) {
                if (!Thread.holdsLock(this.blockingLock())) throw new AssertionError();
                if (this.isBlocking()) {
                    throw new AssertionError();
                }
            }
            Object object = this.stateLock;
            // MONITORENTER : object
            if (!this.providerSwitchDone) {
                // MONITOREXIT : object
                return super.poll(n, l);
            }
            // MONITOREXIT : object
            object = this.lock;
            // MONITORENTER : object
            n2 = 0;
            try {
                this.begin();
                Object object2 = this.stateLock;
                // MONITORENTER : object2
                if (this.isOpen()) break block14;
                n3 = 0;
                // MONITOREXIT : object2
                this.thread = 0L;
                this.end(n2 > 0);
            }
            catch (Throwable throwable) {
                this.thread = 0L;
                this.end(n2 > 0);
                throw throwable;
            }
            return n3;
        }
        this.thread = NativeThread.current();
        // MONITOREXIT : object2
        n2 = RDMANet.poll(this.rsockPtr, n, l);
        if (n2 > 0 && (n & Net.POLLIN) != 0) {
            this.readyToAccept = true;
        }
        this.thread = 0L;
        this.end(n2 > 0);
        return n2;
    }

    static {
        RDMAIOUtil.load();
        RDMAServerSocketChannelImpl.initIDs();
        rsd = new RDMASocketDispatcher();
    }

    private static class RDMASupportedOptionsHolder {
        static final Set<SocketOption<?>> optionSet = RDMASupportedOptionsHolder.supportedOptions();

        private RDMASupportedOptionsHolder() {
        }

        private static Set<SocketOption<?>> supportedOptions() {
            HashSet<SocketOption<Comparable<Integer>>> hashSet = new HashSet<SocketOption<Comparable<Integer>>>(2);
            hashSet.add(StandardSocketOptions.SO_RCVBUF);
            hashSet.add(StandardSocketOptions.SO_REUSEADDR);
            return Collections.unmodifiableSet(hashSet);
        }
    }
}

