/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.cmm;

import java.awt.color.CMMException;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_Profile;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.ServiceLoader;
import sun.java2d.cmm.CMMServiceProvider;
import sun.java2d.cmm.ColorTransform;
import sun.java2d.cmm.PCMM;
import sun.java2d.cmm.Profile;
import sun.security.action.GetPropertyAction;

public class CMSManager {
    public static ColorSpace GRAYspace;
    public static ColorSpace LINEAR_RGBspace;
    private static PCMM cmmImpl;

    public static synchronized PCMM getModule() {
        if (cmmImpl != null) {
            return cmmImpl;
        }
        String string = AccessController.doPrivileged(new GetPropertyAction("os.name"));
        final String string2 = "z/OS".equals(string) ? "sun.java2d.cmm.kcms.CMM" : "sun.java2d.cmm.lcms.LcmsServiceProvider";
        CMMServiceProvider cMMServiceProvider = AccessController.doPrivileged(new PrivilegedAction<CMMServiceProvider>(){

            @Override
            public CMMServiceProvider run() {
                String string = System.getProperty("sun.java2d.cmm", string2);
                ServiceLoader<CMMServiceProvider> serviceLoader = ServiceLoader.loadInstalled(CMMServiceProvider.class);
                CMMServiceProvider cMMServiceProvider = null;
                Iterator<CMMServiceProvider> iterator = serviceLoader.iterator();
                while (iterator.hasNext()) {
                    CMMServiceProvider cMMServiceProvider2;
                    cMMServiceProvider = cMMServiceProvider2 = iterator.next();
                    if (!cMMServiceProvider2.getClass().getName().equals(string)) continue;
                    break;
                }
                return cMMServiceProvider;
            }
        });
        cmmImpl = cMMServiceProvider.getColorManagementModule();
        if (cmmImpl == null) {
            throw new CMMException("Cannot initialize Color Management System.No CM module found");
        }
        GetPropertyAction getPropertyAction = new GetPropertyAction("sun.java2d.cmm.trace");
        String string3 = AccessController.doPrivileged(getPropertyAction);
        if (string3 != null) {
            cmmImpl = new CMMTracer(cmmImpl);
        }
        return cmmImpl;
    }

    static synchronized boolean canCreateModule() {
        return cmmImpl == null;
    }

    static {
        cmmImpl = null;
    }

    public static class CMMTracer
    implements PCMM {
        PCMM tcmm;
        String cName;

        public CMMTracer(PCMM pCMM) {
            this.tcmm = pCMM;
            this.cName = pCMM.getClass().getName();
        }

        @Override
        public Profile loadProfile(byte[] byArray) {
            System.err.print(this.cName + ".loadProfile");
            Profile profile = this.tcmm.loadProfile(byArray);
            System.err.printf("(ID=%s)\n", profile.toString());
            return profile;
        }

        @Override
        public void freeProfile(Profile profile) {
            System.err.printf(this.cName + ".freeProfile(ID=%s)\n", profile.toString());
            this.tcmm.freeProfile(profile);
        }

        @Override
        public int getProfileSize(Profile profile) {
            System.err.print(this.cName + ".getProfileSize(ID=" + profile + ")");
            int n = this.tcmm.getProfileSize(profile);
            System.err.println("=" + n);
            return n;
        }

        @Override
        public void getProfileData(Profile profile, byte[] byArray) {
            System.err.print(this.cName + ".getProfileData(ID=" + profile + ") ");
            System.err.println("requested " + byArray.length + " byte(s)");
            this.tcmm.getProfileData(profile, byArray);
        }

        @Override
        public int getTagSize(Profile profile, int n) {
            System.err.printf(this.cName + ".getTagSize(ID=%x, TagSig=%s)", profile, CMMTracer.signatureToString(n));
            int n2 = this.tcmm.getTagSize(profile, n);
            System.err.println("=" + n2);
            return n2;
        }

        @Override
        public void getTagData(Profile profile, int n, byte[] byArray) {
            System.err.printf(this.cName + ".getTagData(ID=%x, TagSig=%s)", profile, CMMTracer.signatureToString(n));
            System.err.println(" requested " + byArray.length + " byte(s)");
            this.tcmm.getTagData(profile, n, byArray);
        }

        @Override
        public void setTagData(Profile profile, int n, byte[] byArray) {
            System.err.print(this.cName + ".setTagData(ID=" + profile + ", TagSig=" + n + ")");
            System.err.println(" sending " + byArray.length + " byte(s)");
            this.tcmm.setTagData(profile, n, byArray);
        }

        @Override
        public ColorTransform createTransform(ICC_Profile iCC_Profile, int n, int n2) {
            System.err.println(this.cName + ".createTransform(ICC_Profile,int,int)");
            return this.tcmm.createTransform(iCC_Profile, n, n2);
        }

        @Override
        public ColorTransform createTransform(ColorTransform[] colorTransformArray) {
            System.err.println(this.cName + ".createTransform(ColorTransform[])");
            return this.tcmm.createTransform(colorTransformArray);
        }

        private static String signatureToString(int n) {
            return String.format("%c%c%c%c", Character.valueOf((char)(0xFF & n >> 24)), Character.valueOf((char)(0xFF & n >> 16)), Character.valueOf((char)(0xFF & n >> 8)), Character.valueOf((char)(0xFF & n)));
        }
    }
}

