/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import com.ibm.jvm.MemorySafetyService;
import com.ibm.jvm.util.GlobalMap;
import java.lang.ref.SoftReference;
import java.text.CollationKey;
import java.text.spi.CollatorProvider;
import java.util.Comparator;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import sun.util.locale.provider.LocaleProviderAdapter;
import sun.util.locale.provider.LocaleServiceProviderPool;

public abstract class Collator
implements Comparator<Object>,
Cloneable {
    public static final int PRIMARY = 0;
    public static final int SECONDARY = 1;
    public static final int TERTIARY = 2;
    public static final int IDENTICAL = 3;
    public static final int NO_DECOMPOSITION = 0;
    public static final int CANONICAL_DECOMPOSITION = 1;
    public static final int FULL_DECOMPOSITION = 2;
    private int strength = 2;
    private int decmp = 1;
    private static final ConcurrentMap<Locale, SoftReference<Collator>> cache = new ConcurrentHashMap<Locale, SoftReference<Collator>>();
    private static GlobalMap<Locale, Collator> immortalCache = new GlobalMap();
    static final int LESS = -1;
    static final int EQUAL = 0;
    static final int GREATER = 1;

    public static synchronized Collator getInstance() {
        return Collator.getInstance(Locale.getDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collator getInstance(Locale locale) {
        Collator collator;
        block11: {
            SoftReference<Collator> softReference = (SoftReference<Collator>)cache.get(locale);
            collator = null;
            if (!MemorySafetyService.isSafeMode()) {
                collator = softReference != null ? (Collator)softReference.get() : null;
            } else {
                long l = -1L;
                try {
                    l = MemorySafetyService.enterSafeMemoryArea();
                    collator = immortalCache.getItem(locale);
                }
                finally {
                    MemorySafetyService.exitLastMemoryArea((long)l);
                }
            }
            if (collator == null) {
                Collator collator2;
                LocaleProviderAdapter localeProviderAdapter = LocaleProviderAdapter.getAdapter(CollatorProvider.class, locale);
                CollatorProvider collatorProvider = localeProviderAdapter.getCollatorProvider();
                collator = collatorProvider.getInstance(locale);
                if (collator == null) {
                    collator = LocaleProviderAdapter.forJRE().getCollatorProvider().getInstance(locale);
                }
                do {
                    if (softReference != null) {
                        cache.remove(locale, softReference);
                    }
                    if ((softReference = cache.putIfAbsent(locale, new SoftReference<Collator>(collator))) == null) break block11;
                } while ((collator2 = softReference.get()) == null);
                collator = collator2;
            }
        }
        if (MemorySafetyService.isSafeMode()) {
            immortalCache.putItem(locale, collator);
        }
        return (Collator)collator.clone();
    }

    @Override
    public abstract int compare(String var1, String var2);

    @Override
    public int compare(Object object, Object object2) {
        return this.compare((String)object, (String)object2);
    }

    public abstract CollationKey getCollationKey(String var1);

    public boolean equals(String string, String string2) {
        return this.compare(string, string2) == 0;
    }

    public synchronized int getStrength() {
        return this.strength;
    }

    public synchronized void setStrength(int n) {
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException("Incorrect comparison level.");
        }
        this.strength = n;
    }

    public synchronized int getDecomposition() {
        return this.decmp;
    }

    public synchronized void setDecomposition(int n) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("Wrong decomposition mode.");
        }
        this.decmp = n;
    }

    public static synchronized Locale[] getAvailableLocales() {
        LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool(CollatorProvider.class);
        return localeServiceProviderPool.getAvailableLocales();
    }

    public Object clone() {
        try {
            return (Collator)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Collator collator = (Collator)object;
        return this.strength == collator.strength && this.decmp == collator.decmp;
    }

    public abstract int hashCode();

    protected Collator() {
    }
}

