/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleProxies;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.SecurityFrameInjector;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.sql.DriverManager;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import sun.misc.Unsafe;
import sun.reflect.Reflection;

class MethodHandleUtils {
    MethodHandleUtils() {
    }

    static boolean isCallerSensitive(Class<?> clazz, String string) {
        return MethodHandleUtils.isCallerSensitive(null, clazz, string);
    }

    static boolean isCallerSensitive(MethodHandle methodHandle, Class<?> clazz, String string) {
        switch (string) {
            case "doPrivileged": 
            case "doPrivilegedWithCombiner": {
                return clazz == AccessController.class;
            }
            case "checkMemberAccess": {
                return SecurityFrameInjector.virtualCallAllowed((MethodHandle)methodHandle, SecurityManager.class);
            }
            case "getUnsafe": {
                return clazz == Unsafe.class;
            }
            case "lookup": {
                return clazz == MethodHandles.class;
            }
            case "findStatic": 
            case "findVirtual": 
            case "findConstructor": 
            case "findSpecial": 
            case "findGetter": 
            case "findSetter": 
            case "findStaticGetter": 
            case "findStaticSetter": 
            case "bind": 
            case "unreflect": 
            case "unreflectSpecial": 
            case "unreflectConstructor": 
            case "unreflectGetter": 
            case "unreflectSetter": {
                return clazz == MethodHandles.Lookup.class;
            }
            case "invoke": {
                return clazz == Method.class;
            }
            case "get": 
            case "getBoolean": 
            case "getByte": 
            case "getChar": 
            case "getShort": 
            case "getInt": 
            case "getLong": 
            case "getFloat": 
            case "getDouble": 
            case "set": 
            case "setBoolean": 
            case "setByte": 
            case "setChar": 
            case "setShort": 
            case "setInt": 
            case "setLong": 
            case "setFloat": 
            case "setDouble": {
                return clazz == Field.class;
            }
            case "newInstance": {
                if (clazz == Constructor.class) {
                    return true;
                }
                if (clazz != Class.class) break;
                return true;
            }
            case "forName": 
            case "getClassLoader": 
            case "getClasses": 
            case "getFields": 
            case "getMethods": 
            case "getConstructors": 
            case "getDeclaredClasses": 
            case "getDeclaredFields": 
            case "getDeclaredMethods": 
            case "getDeclaredConstructors": 
            case "getField": 
            case "getMethod": 
            case "getConstructor": 
            case "getDeclaredField": 
            case "getDeclaredMethod": 
            case "getDeclaredConstructor": {
                return clazz == Class.class;
            }
            case "getConnection": 
            case "getDriver": 
            case "getDrivers": 
            case "deregisterDriver": {
                return clazz == DriverManager.class;
            }
            case "newUpdater": {
                if (clazz == AtomicIntegerFieldUpdater.class) {
                    return true;
                }
                if (clazz == AtomicLongFieldUpdater.class) {
                    return true;
                }
                if (clazz != AtomicReferenceFieldUpdater.class) break;
                return true;
            }
            case "getContextClassLoader": {
                return SecurityFrameInjector.virtualCallAllowed((MethodHandle)methodHandle, Thread.class);
            }
            case "getPackage": 
            case "getPackages": {
                return clazz == Package.class;
            }
            case "getParent": 
            case "getSystemClassLoader": {
                return clazz == ClassLoader.class;
            }
            case "load": 
            case "loadLibrary": {
                if (clazz == Runtime.class) {
                    return true;
                }
                if (clazz != System.class) break;
                return true;
            }
            case "getCallerClass": {
                if (clazz == Reflection.class) {
                    return true;
                }
                if (clazz != System.class) break;
                return true;
            }
            case "getCallerClassLoader": {
                return clazz == ClassLoader.class;
            }
            case "registerAsParallelCapable": {
                return SecurityFrameInjector.virtualCallAllowed((MethodHandle)methodHandle, ClassLoader.class);
            }
            case "getProxyClass": 
            case "newProxyInstance": {
                return clazz == Proxy.class;
            }
            case "asInterfaceInstance": {
                return clazz == MethodHandleProxies.class;
            }
            case "getBundle": 
            case "clearCache": {
                return clazz == ResourceBundle.class;
            }
        }
        return false;
    }
}

