/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.misc;

abstract class AbstractSignalInfo {
    private static String[] signalList = null;

    AbstractSignalInfo() {
    }

    protected static void setSignalList(String[] stringArray) {
        signalList = stringArray;
    }

    public static int checkSignalNumber(String string) {
        if (string == null) {
            return -1;
        }
        if (string.length() == 0) {
            return -1;
        }
        for (int i = 0; i < signalList.length; ++i) {
            if (!signalList[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public static int getSignalNumber(String string) throws IllegalArgumentException, NullPointerException {
        if (string == null) {
            throw new NullPointerException("Signal name is null");
        }
        int n = AbstractSignalInfo.checkSignalNumber(string);
        if (n < 0) {
            throw new IllegalArgumentException("Unknown signal: " + string);
        }
        return n;
    }

    public static String getSignalName(int n) {
        String string = "";
        if (n >= 0 && n < signalList.length) {
            string = signalList[n];
        }
        if (string.equals("")) {
            string = Integer.toString(n);
        }
        return string;
    }

    public static boolean isInterruptSignal(int n) {
        return n > 0 && (n == AbstractSignalInfo.checkSignalNumber("HUP") || n == AbstractSignalInfo.checkSignalNumber("INT") || n == AbstractSignalInfo.checkSignalNumber("TERM"));
    }

    public static boolean isDumpSignal(int n) {
        return n > 0 && (n == AbstractSignalInfo.checkSignalNumber("QUIT") || n == AbstractSignalInfo.checkSignalNumber("BREAK"));
    }
}

