/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.util;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.omg.CORBA.NO_IMPLEMENT;

public class IdentityHashtable
implements Map {
    private static byte MIN_REHASH_FACTOR = 1;
    private byte rehash_factor = (byte)4;
    private transient IdentityHashtableEntry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;
    protected Thread ownerThread = null;
    private int probableSizetoGrow;

    public IdentityHashtable(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = f;
        this.table = new IdentityHashtableEntry[n];
        this.threshold = (int)((float)n * f);
    }

    public IdentityHashtable(int n) {
        this(n, 1.0f);
    }

    public IdentityHashtable() {
        this(101, 1.0f);
    }

    public Object get(Object object) {
        IdentityHashtableEntry[] identityHashtableEntryArray = this.table;
        int n = System.identityHashCode(object);
        int n2 = (n & Integer.MAX_VALUE) % identityHashtableEntryArray.length;
        IdentityHashtableEntry identityHashtableEntry = identityHashtableEntryArray[n2];
        while (identityHashtableEntry != null) {
            if (identityHashtableEntry.hash == n && identityHashtableEntry.key == object) {
                return identityHashtableEntry.value;
            }
            identityHashtableEntry = identityHashtableEntry.next;
        }
        return null;
    }

    private void rehash() {
        int n = this.table.length;
        IdentityHashtableEntry[] identityHashtableEntryArray = this.table;
        int n2 = this.getNewCapacity(n);
        IdentityHashtableEntry[] identityHashtableEntryArray2 = new IdentityHashtableEntry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = identityHashtableEntryArray2;
        int n3 = n;
        while (n3-- > 0) {
            IdentityHashtableEntry identityHashtableEntry = identityHashtableEntryArray[n3];
            while (identityHashtableEntry != null) {
                IdentityHashtableEntry identityHashtableEntry2 = identityHashtableEntry;
                identityHashtableEntry = identityHashtableEntry.next;
                int n4 = (identityHashtableEntry2.hash & Integer.MAX_VALUE) % n2;
                identityHashtableEntry2.next = identityHashtableEntryArray2[n4];
                identityHashtableEntryArray2[n4] = identityHashtableEntry2;
            }
        }
    }

    private int getNewCapacity(int n) {
        int n2 = n;
        for (int i = 0; i < this.rehash_factor; ++i) {
            n2 = (n2 << 1) + 1;
        }
        this.rehash_factor = (byte)(this.rehash_factor - 2);
        if (this.rehash_factor <= MIN_REHASH_FACTOR) {
            this.rehash_factor = MIN_REHASH_FACTOR;
        }
        if (n2 < this.table.length + this.probableSizetoGrow) {
            n2 = this.getNewCapacity(n2);
        }
        this.probableSizetoGrow = 0;
        return n2;
    }

    public void add(Object object, Object object2) {
        IdentityHashtableEntry identityHashtableEntry;
        if (this.count >= this.threshold) {
            this.rehash();
        }
        IdentityHashtableEntry[] identityHashtableEntryArray = this.table;
        int n = System.identityHashCode(object);
        int n2 = (n & Integer.MAX_VALUE) % identityHashtableEntryArray.length;
        identityHashtableEntryArray[n2] = identityHashtableEntry = new IdentityHashtableEntry(n, object, object2, identityHashtableEntryArray[n2]);
        ++this.count;
    }

    @Override
    public void clear() {
        IdentityHashtableEntry[] identityHashtableEntryArray = this.table;
        int n = identityHashtableEntryArray.length;
        while (--n >= 0) {
            IdentityHashtableEntry identityHashtableEntry = identityHashtableEntryArray[n];
            while (identityHashtableEntry != null) {
                IdentityHashtableEntry identityHashtableEntry2 = identityHashtableEntry.next;
                identityHashtableEntry.hash = 0;
                identityHashtableEntry.key = null;
                identityHashtableEntry.value = -1;
                identityHashtableEntry.next = null;
                identityHashtableEntry = identityHashtableEntry2;
            }
            identityHashtableEntryArray[n] = null;
        }
        this.count = 0;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public boolean containsKey(Object object) {
        IdentityHashtableEntry[] identityHashtableEntryArray = this.table;
        int n = System.identityHashCode(object);
        int n2 = (n & Integer.MAX_VALUE) % identityHashtableEntryArray.length;
        IdentityHashtableEntry identityHashtableEntry = identityHashtableEntryArray[n2];
        while (identityHashtableEntry != null) {
            if (identityHashtableEntry.hash == n && identityHashtableEntry.key == object) {
                return true;
            }
            identityHashtableEntry = identityHashtableEntry.next;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        IdentityHashtableEntry[] identityHashtableEntryArray = this.table;
        int n = identityHashtableEntryArray.length;
        while (n-- > 0) {
            IdentityHashtableEntry identityHashtableEntry = identityHashtableEntryArray[n];
            while (identityHashtableEntry != null) {
                if (identityHashtableEntry.value == object) {
                    return true;
                }
                identityHashtableEntry = identityHashtableEntry.next;
            }
        }
        return false;
    }

    public Object put(Object object, Object object2) {
        if (object2 == null) {
            throw new NullPointerException();
        }
        IdentityHashtableEntry[] identityHashtableEntryArray = this.table;
        int n = System.identityHashCode(object);
        int n2 = (n & Integer.MAX_VALUE) % identityHashtableEntryArray.length;
        IdentityHashtableEntry identityHashtableEntry = identityHashtableEntryArray[n2];
        while (identityHashtableEntry != null) {
            if (identityHashtableEntry.hash == n && identityHashtableEntry.key == object) {
                Object object3 = identityHashtableEntry.value;
                identityHashtableEntry.value = object2;
                return object3;
            }
            identityHashtableEntry = identityHashtableEntry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            identityHashtableEntryArray = this.table;
            n2 = (n & Integer.MAX_VALUE) % identityHashtableEntryArray.length;
        }
        identityHashtableEntryArray[n2] = identityHashtableEntry = new IdentityHashtableEntry(n, object, object2, identityHashtableEntryArray[n2]);
        ++this.count;
        return null;
    }

    public Object remove(Object object) {
        IdentityHashtableEntry[] identityHashtableEntryArray = this.table;
        int n = System.identityHashCode(object);
        int n2 = (n & Integer.MAX_VALUE) % identityHashtableEntryArray.length;
        IdentityHashtableEntry identityHashtableEntry = identityHashtableEntryArray[n2];
        IdentityHashtableEntry identityHashtableEntry2 = null;
        while (identityHashtableEntry != null) {
            if (identityHashtableEntry.hash == n && identityHashtableEntry.key == object) {
                if (identityHashtableEntry2 != null) {
                    identityHashtableEntry2.next = identityHashtableEntry.next;
                } else {
                    identityHashtableEntryArray[n2] = identityHashtableEntry.next;
                }
                --this.count;
                Object object2 = identityHashtableEntry.value;
                identityHashtableEntry.key = null;
                identityHashtableEntry.value = null;
                return object2;
            }
            identityHashtableEntry2 = identityHashtableEntry;
            identityHashtableEntry = identityHashtableEntry.next;
        }
        return null;
    }

    public void putAll(Map map) {
        throw new NO_IMPLEMENT("Not implemented for " + this.getClass().getName());
    }

    public Set keySet() {
        throw new NO_IMPLEMENT("Not implemented for " + this.getClass().getName());
    }

    public Collection values() {
        throw new NO_IMPLEMENT("Not implemented for " + this.getClass().getName());
    }

    public Set entrySet() {
        throw new NO_IMPLEMENT("Not implemented for " + this.getClass().getName());
    }

    public void resizeIndicator(int n) {
        if (this.probableSizetoGrow == 0) {
            this.probableSizetoGrow = n - (this.threshold - this.count);
            if (this.probableSizetoGrow < 0) {
                this.probableSizetoGrow = 0;
            }
        } else {
            this.probableSizetoGrow += n;
        }
    }

    private static class IdentityHashtableEntry {
        int hash;
        Object key;
        Object value;
        IdentityHashtableEntry next;

        public IdentityHashtableEntry(int n, Object object, Object object2, IdentityHashtableEntry identityHashtableEntry) {
            this.hash = n;
            this.key = object;
            this.value = object2;
            this.next = identityHashtableEntry;
        }
    }
}

