/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.Message;
import com.ibm.jvm.format.MessageFile;
import com.ibm.jvm.format.TraceFormat;
import com.ibm.jvm.format.TraceRecord;
import com.ibm.jvm.format.Util;
import java.math.BigInteger;

public class TracePoint
implements Comparable,
com.ibm.jvm.trace.TracePoint {
    private static final String CHANGE_OF_THREAD_INDICATOR = "*";
    private String componentName = null;
    private String containerComponentName = null;
    private int tracepointID = -1;
    private byte[] parameterData = null;
    private BigInteger rawTimeStamp = null;
    private long threadID = -1L;
    private boolean isChangeOfThread = false;
    private int tplen = -1;
    private String padding = null;
    private static String compNamePadding = "          ";
    private static String tpIDPadding = "    ";
    private boolean isLongTracePoint = false;
    private int longTracePointLength = 0;
    private boolean isNormalTracepoint = true;
    private boolean isInvalid = false;
    private boolean isLostRecord = false;
    private long lostRecordCount = 0L;
    private long startOffsetInTraceFile = -1L;
    private long endOffsetInTraceFile = -1L;
    private boolean fragmented = false;
    private String nameOfTraceFile = null;
    private boolean isNewTimerUpperWord = false;
    private long newTimerUpperWord = -1L;
    BigInteger upperWord = null;

    public TracePoint(byte[] rawTracePoint, int length, BigInteger upperWord, long threadID, String fileName, long offsetOfStartOfTracePointInFile, long offsetOfEndOfTracePointInFile, boolean wasFragmented) {
        this.upperWord = upperWord;
        this.threadID = threadID;
        this.nameOfTraceFile = fileName;
        this.startOffsetInTraceFile = offsetOfStartOfTracePointInFile;
        this.endOffsetInTraceFile = offsetOfEndOfTracePointInFile;
        this.fragmented = wasFragmented;
        this.parseDataIntoTracepoint(rawTracePoint, length);
        this.padding = Integer.valueOf(Util.getProperty("POINTER_SIZE")) == 4 ? "            " : "                    ";
    }

    private TracePoint parseDataIntoTracepoint(byte[] rawTracePoint, int length) {
        int parmDataStartsAt;
        int parmDataLength;
        if (length == 0) {
            this.isInvalid = true;
            this.isNormalTracepoint = false;
            return this;
        }
        if (rawTracePoint == null) {
            TraceFormat.outStream.println("TracePoint passed null data array - can't extract tracepoint from it. " + this.from());
            this.isInvalid = true;
            this.isNormalTracepoint = false;
            return this;
        }
        this.tplen = length;
        if (this.tplen == 0) {
            TraceFormat.outStream.println("Tracepoint extracted zero from first byte of trace data - returning without creating tracepoint " + this.from());
            this.isInvalid = true;
            this.isNormalTracepoint = false;
            return this;
        }
        if (rawTracePoint.length < length) {
            Util.Debug.println("Partial buffer passed in - most likely partly overwritten during a buffer wrap");
            this.isInvalid = true;
            this.isNormalTracepoint = false;
            return this;
        }
        this.tracepointID = Util.constructTraceID(rawTracePoint, 1);
        this.tracepointID &= 0x3FFF;
        if (rawTracePoint[0] == 0 && rawTracePoint[1] == 0 && rawTracePoint[2] == 1 && rawTracePoint[3] == 0 && this.tplen == 8) {
            Util.Debug.println("Lost Record TracePoint detected, should have been handled by TraceRecord50 " + this.from());
            this.isNormalTracepoint = false;
            this.isLostRecord = true;
            this.lostRecordCount = Util.constructUnsignedInt(rawTracePoint, 4);
            return this;
        }
        if (this.tracepointID == 0) {
            this.isNormalTracepoint = false;
            if (this.tplen != 8) {
                Util.Debug.println("Possible inconsistency in buffer - tracePointID 0 detected but length = " + this.tplen);
                Util.Debug.println("Ignoring this tracepoint for now - inspect tracefile for further details " + this.from());
                this.isInvalid = true;
                return this;
            }
            long sequenceWrap = Util.constructUnsignedInt(rawTracePoint, 4);
            this.isNormalTracepoint = false;
            this.isNewTimerUpperWord = true;
            this.newTimerUpperWord = sequenceWrap;
            Util.Debug.println("Sequence wrap found, value = " + sequenceWrap + " " + this.from());
            return this;
        }
        if (this.tplen == 4) {
            if (rawTracePoint[1] == 0 && rawTracePoint[2] == 0) {
                Util.Debug.println("Long entry data");
                int longEntryID = Util.constructUnsignedByte(rawTracePoint, 3);
                int longEntryLength = Util.constructUnsignedByte(rawTracePoint, 0);
                this.longTracePointLength = longEntryLength | longEntryID << 8;
                Util.Debug.println(" longEntryID = " + longEntryID + " length = " + this.longTracePointLength + " " + this.from());
                this.isLongTracePoint = true;
                this.componentName = "longtracepoint id";
                this.isNormalTracepoint = false;
                return this;
            }
            Util.Debug.println("Found a 4 byte length tracepoint that doesn't seem to contain a long tracepoint marker" + this.from());
            Util.Debug.println("Incorrect long tracepoint found - bytes 1 and 2 aren;t zero (as they should be):");
            Util.Debug.println("    byte 1 == " + Byte.toString(rawTracePoint[1]) + " byte 2 == " + Byte.toString(rawTracePoint[2]));
            this.isInvalid = true;
            this.isNormalTracepoint = false;
            return null;
        }
        BigInteger tempLower = Util.constructUnsignedLong(rawTracePoint, 4, 4);
        this.rawTimeStamp = this.upperWord.shiftLeft(32).or(tempLower);
        long compNameLength = Util.constructUnsignedInt(rawTracePoint, 8);
        if (compNameLength <= 0L || compNameLength > (long)this.tplen) {
            Util.Debug.println("TracePoint.parseDataIntoTracepoint() detected bad component name length: " + this.from());
            this.isInvalid = true;
            this.isNormalTracepoint = false;
            return this;
        }
        this.componentName = Util.constructString(rawTracePoint, 12, (int)compNameLength);
        if (this.componentName == null || this.componentName.length() == 0) {
            Util.Debug.println("TracePoint.parseDataIntoTracepoint() detected bad component name: " + this.from());
            this.isInvalid = true;
            this.isNormalTracepoint = false;
            return this;
        }
        if (this.componentName.equals("INTERNALTRACECOMPONENT")) {
            this.componentName = "dg";
        } else {
            this.tracepointID -= 257;
        }
        int openBracketIndex = this.componentName.indexOf("(");
        if (openBracketIndex >= 0) {
            String newComponentName;
            int closeBracketIndex = this.componentName.indexOf(")");
            if (closeBracketIndex < 0 || closeBracketIndex < openBracketIndex) {
                Util.Debug.println("Overriding closeBracketIndex - not found in [" + this.componentName + "]");
                closeBracketIndex = this.componentName.length();
            }
            this.containerComponentName = this.componentName.substring(openBracketIndex + 1, closeBracketIndex);
            this.componentName = newComponentName = this.componentName.substring(0, openBracketIndex);
        }
        if ((parmDataLength = this.tplen - (parmDataStartsAt = 12 + (int)compNameLength)) > 0) {
            this.parameterData = new byte[parmDataLength];
            System.arraycopy(rawTracePoint, parmDataStartsAt, this.parameterData, 0, parmDataLength);
        }
        return this;
    }

    public boolean isLongTracePoint() {
        return this.isLongTracePoint;
    }

    public int longTracePointLength() {
        if (this.isLongTracePoint) {
            return this.longTracePointLength;
        }
        Util.Debug.println("longTracePointLength called on a completed tracepoint");
        return 0;
    }

    public String toString() {
        StringBuffer tpFormatted = new StringBuffer();
        String threadIDString = Util.formatAsHexString(this.threadID);
        if (this.isChangeOfThread) {
            tpFormatted.append(this.padding.substring(Math.min(threadIDString.length() + 1, this.padding.length())));
            tpFormatted.append(CHANGE_OF_THREAD_INDICATOR);
        } else {
            tpFormatted.append(this.padding.substring(Math.min(threadIDString.length(), this.padding.length())));
        }
        tpFormatted.append(threadIDString);
        String userVMID = TraceFormat.getUserVMIdentifier();
        if (userVMID != null) {
            tpFormatted.append(" " + userVMID);
        }
        if (this.isLostRecord) {
            tpFormatted.append(" " + this.lostRecordCount + " trace buffers of data were discarded for this thread");
            return tpFormatted.toString();
        }
        if (this.componentName.length() < compNamePadding.length()) {
            tpFormatted.append(compNamePadding.substring(this.componentName.length()));
        }
        tpFormatted.append(" ");
        tpFormatted.append(this.componentName);
        if (this.containerComponentName != null) {
            tpFormatted.append("(" + this.containerComponentName + ")");
        }
        tpFormatted.append(".");
        tpFormatted.append(this.tracepointID);
        if (Integer.toString(this.tracepointID).length() < tpIDPadding.length()) {
            tpFormatted.append(tpIDPadding.substring(Integer.toString(this.tracepointID).length()));
        }
        return tpFormatted.toString();
    }

    public String getFileName() {
        return this.nameOfTraceFile;
    }

    public long getOffsetInTraceFile() {
        return this.startOffsetInTraceFile;
    }

    public int getTPID() {
        return this.tracepointID;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getContainerComponentName() {
        return this.containerComponentName;
    }

    @Override
    public long getThreadID() {
        return this.threadID;
    }

    public String getParameterDataFormatted() {
        Message msg = MessageFile.getMessageFromID(this.getComponentName(), this.getTPID());
        byte[] parmData = this.getParmData();
        String formattedData = null;
        if (parmData == null) {
            parmData = new byte[1];
            try {
                formattedData = msg.getMessage(parmData, 0, 0);
            }
            catch (Exception e) {
                formattedData = "FORMATTING PROBLEM OCCURRED WHILE PROCESSING THE RAW DATA FOR THIS TRACEPOINT - PARAMETER DATA UNAVAILABLE";
            }
        } else {
            try {
                formattedData = msg.getMessage(parmData, 0, parmData.length);
            }
            catch (Exception e) {
                formattedData = "FORMATTING PROBLEM OCCURRED WHILE PROCESSING THE RAW DATA FOR THIS TRACEPOINT - PARAMETER DATA UNAVAILABLE";
            }
        }
        return formattedData;
    }

    public byte[] getParmData() {
        return this.parameterData;
    }

    public BigInteger getRawTimeStamp() {
        return this.rawTimeStamp;
    }

    void setRawTimeStamp(BigInteger timestamp) {
        this.rawTimeStamp = timestamp;
    }

    public boolean isTimerUpperWord() {
        return this.isNewTimerUpperWord;
    }

    public long getNewTimerUpperWord() {
        if (this.isNewTimerUpperWord) {
            return this.newTimerUpperWord;
        }
        TraceFormat.outStream.println("an attempt to get a new timer upper word has been made on a tracepoint that doesn't seem to be a timer wrap!");
        TraceFormat.outStream.println(" tracepoint = " + this.tracepointID + "." + this.componentName);
        return -1L;
    }

    public boolean setTracePointsUpperWord(BigInteger upperWord) {
        BigInteger temp;
        if (upperWord == null) {
            TraceFormat.outStream.println(" attempt made to set the upper word of tracepoint to a null - original tracepoint: " + this.from());
            return false;
        }
        if (this.rawTimeStamp == null) {
            TraceFormat.outStream.println(" attempt made to set the upper word on a tracepoint whose timestamp is null - original tracepoint: " + this.from());
            return false;
        }
        this.rawTimeStamp = temp = upperWord.shiftLeft(32).or(this.rawTimeStamp);
        return true;
    }

    public boolean isNormalTracepoint() {
        return this.isNormalTracepoint;
    }

    public boolean isLostRecord() {
        return this.isLostRecord;
    }

    public int compareTo(Object other) {
        if (this.rawTimeStamp == null) {
            TraceFormat.outStream.println("TracePoint compareTo called on TracePoint with no rawTimeStamp");
            return 0;
        }
        if (((TracePoint)other).getRawTimeStamp() == null) {
            TraceFormat.outStream.println("TracePoint compareTo called with a TracePoint with no rawTimeStamp");
            return 0;
        }
        return this.rawTimeStamp.compareTo(((TracePoint)other).getRawTimeStamp());
    }

    @Override
    public String getFormattedParameters() {
        return this.getParameterDataFormatted();
    }

    @Override
    public String getFormattedTime() {
        return Util.getFormattedTime(this.getRawTimeStamp());
    }

    public void setIsChangeOfThread(boolean isChangeOfThread) {
        this.isChangeOfThread = isChangeOfThread;
    }

    public boolean isInvalid() {
        return this.isInvalid;
    }

    public int getTypeAsInt() {
        Message msg = MessageFile.getMessageFromID(this.getComponentName(), this.getTPID());
        return msg.getType();
    }

    @Override
    public int getID() {
        return this.getTPID();
    }

    @Override
    public long getTimestampMillis() {
        return 0L;
    }

    @Override
    public int getMicrosecondsCount() {
        return 0;
    }

    @Override
    public String getComponent() {
        return this.getComponentName();
    }

    @Override
    public String getContainerComponent() {
        return this.getContainerComponentName();
    }

    @Override
    public String getParameterFormattingTemplate() {
        Message msg = MessageFile.getMessageFromID(this.getComponentName(), this.getTPID());
        return msg.getFormattingTemplate();
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String[] getGroups() {
        return null;
    }

    @Override
    public int getLevel() {
        return -1;
    }

    @Override
    public String getType() {
        Message msg = MessageFile.getMessageFromID(this.getComponentName(), this.getTPID());
        int type = msg.getType();
        return TraceRecord.types[type];
    }

    public String from() {
        StringBuffer sb = new StringBuffer();
        sb.append("from: 0x");
        sb.append(Long.toHexString(this.startOffsetInTraceFile));
        sb.append("->0x");
        sb.append(Long.toHexString(this.endOffsetInTraceFile));
        sb.append(":");
        if (this.fragmented) {
            sb.append("F");
            if (this.startOffsetInTraceFile == -1L) {
                sb.append("I");
            } else if (this.startOffsetInTraceFile == -2L) {
                sb.append("E");
            } else {
                sb.append("X");
            }
        }
        sb.append(":");
        sb.append(this.nameOfTraceFile);
        return sb.toString();
    }
}

