/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.TraceFile;
import com.ibm.jvm.format.Util;
import java.io.BufferedWriter;
import java.io.IOException;

public class ProcessorSection {
    private String eyecatcher_string;
    private int length;
    private int version;
    private int modification;
    private int arch;
    private boolean big;
    private int word;
    private int procs;
    private int subType;
    private int counter;

    public ProcessorSection(TraceFile traceFile, int start) throws IOException {
        traceFile.seek(start);
        this.eyecatcher_string = Util.convertAndCheckEyecatcher(traceFile.readI());
        this.length = traceFile.readI();
        this.version = traceFile.readI();
        this.modification = traceFile.readI();
        traceFile.skipBytes(16);
        this.arch = traceFile.readI();
        this.big = traceFile.readI() != 0;
        this.word = traceFile.readI();
        this.procs = traceFile.readI();
        traceFile.skipBytes(16);
        this.subType = traceFile.readI();
        this.counter = traceFile.readI();
        Util.setTimerType(this.counter);
        Util.Debug.println("ProcessorSection: eyecatcher:      " + this.eyecatcher_string);
        Util.Debug.println("ProcessorSection: length:          " + this.length);
        Util.Debug.println("ProcessorSection: version:         " + this.version);
        Util.Debug.println("ProcessorSection: modification:    " + this.modification);
        Util.Debug.println("ProcessorSection: arch:            " + this.arch);
        Util.Debug.println("ProcessorSection: big:             " + this.big);
        Util.Debug.println("ProcessorSection: word:            " + this.word);
        Util.Debug.println("ProcessorSection: procs:           " + this.procs);
        Util.Debug.println("ProcessorSection: subType:         " + this.subType);
        Util.Debug.println("ProcessorSection: counter:         " + this.counter);
    }

    protected void summary(BufferedWriter out) throws IOException {
        String[] Archs = new String[]{"Unknown", "x86", "S390", "Power", "IA64", "S390X", "AMD64", "RISCV"};
        String[] SubTypes = new String[]{"i486", "i586", "Pentium II", "Pentium III", "Merced", "McKinley", "PowerRS", "PowerPC", "GigaProcessor", "ESA", "Pentium IV", "T-Rex", "Opteron", "RV64G"};
        String[] trCounter = new String[]{"Sequence Counter", "Special", "RDTSC Timer", "AIX Timer", "MFSPR Timer", "MFTB Timer", "STCK Timer", "J9 timer"};
        out.write("Sys Processor Info :");
        out.newLine();
        out.write("        Arch family " + Archs[this.arch]);
        out.newLine();
        out.write("        Processor Sub-type " + SubTypes[this.subType]);
        out.newLine();
        out.write("        Num Processors " + this.procs);
        out.newLine();
        out.write("        Big Endian " + this.big);
        out.newLine();
        out.write("        Word size " + this.word);
        out.newLine();
        out.write("        Using Trace Counter " + trCounter[this.counter]);
        out.newLine();
        out.newLine();
    }
}

