/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore.entry;

import com.ibm.gsk.ikeyman.command.CommandParameters;
import com.ibm.gsk.ikeyman.command.Constants$Parameter;
import com.ibm.gsk.ikeyman.error.InternalKeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.io.CertificateParserFactory;
import com.ibm.gsk.ikeyman.io.CertificateParserFactory$CertificateParser;
import com.ibm.gsk.ikeyman.io.SecretKeyReader;
import com.ibm.gsk.ikeyman.io.SecretKeyReader$SecretKeyInfo;
import com.ibm.gsk.ikeyman.keystore.entry.CMSCertificateItem;
import com.ibm.gsk.ikeyman.keystore.entry.CMSCertificateItemImpl;
import com.ibm.gsk.ikeyman.keystore.entry.CMSKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.CMSKeyItemImpl;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateItem;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateItemImpl;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateKeyItemImpl;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateRequestItem;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateRequestItemImpl;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateRequestKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateRequestKeyItemImpl;
import com.ibm.gsk.ikeyman.keystore.entry.DisplayItemFactory;
import com.ibm.gsk.ikeyman.keystore.entry.DisplayItemFactory$DNItem;
import com.ibm.gsk.ikeyman.keystore.entry.DisplayItemFactory$SanItem;
import com.ibm.gsk.ikeyman.keystore.entry.SecretKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.SecretKeyItemImpl;
import com.ibm.gsk.ikeyman.keystore.entry.UnloadableCMSCertificateItem;
import com.ibm.gsk.ikeyman.keystore.entry.UnloadableCertificateItemImpl;
import com.ibm.gsk.ikeyman.keystore.entry.UnloadableCertificateRequestItemImpl;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.util.Debug;
import com.ibm.gsk.ikeyman.util.KeymanUtil;
import com.ibm.gsk.ikeyman.util.TypeDisplayerFactory;
import com.ibm.gsk.ikeyman.util.TypeDisplayerFactory$TypeDisplayer;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.pkcs10.CertificationRequestInfo;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.pkcsutil.PKCSAttributes;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.AuthorityKeyIdentifierExtension;
import com.ibm.security.x509.BasicConstraintsExtension;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.CertificateAlgorithmId;
import com.ibm.security.x509.CertificateExtensions;
import com.ibm.security.x509.CertificateSerialNumber;
import com.ibm.security.x509.CertificateValidity;
import com.ibm.security.x509.CertificateX509Key;
import com.ibm.security.x509.ExtKeyUsageExtension;
import com.ibm.security.x509.KeyIdentifier;
import com.ibm.security.x509.KeyUsageExtension;
import com.ibm.security.x509.SubjectKeyIdentifierExtension;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import com.ibm.security.x509.X509CertInfo;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;

public class EntryFactory {
    private static TypeDisplayerFactory$TypeDisplayer classDisplayer = TypeDisplayerFactory.newGUIEntryDisplayer();

    public static void setClassDisplayer(TypeDisplayerFactory$TypeDisplayer typeDisplayerFactory$TypeDisplayer) {
        classDisplayer = typeDisplayerFactory$TypeDisplayer;
    }

    public static TypeDisplayerFactory$TypeDisplayer getClassDisplayer() {
        return classDisplayer;
    }

    public static Collection loadCertificateItems(String string, String string2) throws KeyManagerException {
        try {
            Collection collection = EntryFactory.generateCertificates(string, string2);
            if (collection.isEmpty()) {
                throw new CertificateException(Messages.getString("Label.EmptyFile"));
            }
            ArrayList<CertificateItemImpl> arrayList = new ArrayList<CertificateItemImpl>();
            for (Certificate certificate : collection) {
                X509Certificate x509Certificate = (X509Certificate)certificate;
                arrayList.add(new CertificateItemImpl(x509Certificate.getSubjectDN().getName(), x509Certificate));
            }
            return arrayList;
        }
        catch (CertificateException certificateException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.CORRUPT_CERTIFICATE, certificateException, new String[]{string});
        }
    }

    public static CertificateItem newCertificateItem(String string, X509Certificate x509Certificate) throws KeyManagerException {
        return new CertificateItemImpl(string, x509Certificate);
    }

    public static CertificateKeyItem newKeyItem(String string, PrivateKey privateKey, Certificate[] certificateArray) throws KeyManagerException {
        return new CertificateKeyItemImpl(string, privateKey, certificateArray);
    }

    public static CertificateKeyItem newKeyItem(CommandParameters commandParameters, KeyPair keyPair, String string, String string2) throws KeyManagerException {
        try {
            Object object;
            CertificateExtensions certificateExtensions;
            DisplayItemFactory$DNItem displayItemFactory$DNItem;
            DisplayItemFactory$DNItem displayItemFactory$DNItem2 = displayItemFactory$DNItem = commandParameters.isParameterPresent(Constants$Parameter.DN) ? commandParameters.getDn() : DisplayItemFactory.getDNItem("");
            if (displayItemFactory$DNItem.isEmpty() && commandParameters.getSan().isEmpty()) {
                throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_DN_OR_SAN);
            }
            X500Name x500Name = displayItemFactory$DNItem.getX500Name();
            PublicKey publicKey = keyPair.getPublic();
            PrivateKey privateKey = keyPair.getPrivate();
            Calendar calendar = Calendar.getInstance();
            Calendar calendar2 = Calendar.getInstance();
            calendar2.add(6, commandParameters.getExpire());
            CertificateValidity certificateValidity = new CertificateValidity(calendar.getTime(), calendar2.getTime());
            X509CertInfo x509CertInfo = new X509CertInfo(string2);
            x509CertInfo.set("version", (Object)commandParameters.getX509Ver().getInternalVersion());
            x509CertInfo.set("serialNumber", (Object)new CertificateSerialNumber((int)(calendar.getTime().getTime() / 1000L)));
            AlgorithmId algorithmId = AlgorithmId.get((String)string);
            x509CertInfo.set("algorithmID", (Object)new CertificateAlgorithmId(algorithmId));
            x509CertInfo.set("subject", (Object)x500Name);
            x509CertInfo.set("key", (Object)new CertificateX509Key(publicKey));
            x509CertInfo.set("validity", (Object)certificateValidity);
            x509CertInfo.set("issuer", (Object)x500Name);
            try {
                KeyUsageExtension keyUsageExtension;
                certificateExtensions = new CertificateExtensions();
                CertAttrSet certAttrSet = commandParameters.getSan().toExtension(displayItemFactory$DNItem.isEmpty());
                if (certAttrSet != null) {
                    certificateExtensions.set(certAttrSet.getName(), (Object)certAttrSet);
                }
                if (commandParameters.isParameterPresent(Constants$Parameter.CA) && commandParameters.isCa()) {
                    certificateExtensions.set("BasicConstraints", (Object)new BasicConstraintsExtension(true, Integer.MAX_VALUE));
                }
                if (((Vector)(object = commandParameters.getExtendedKeyUsage())).size() > 0) {
                    certificateExtensions.set("ExtKeyUsage", (Object)new ExtKeyUsageExtension((Vector)object));
                }
                if ((keyUsageExtension = commandParameters.getKeyUsage()) != null) {
                    certificateExtensions.set("KeyUsage", (Object)keyUsageExtension);
                }
                byte[] byArray = new byte[8];
                MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
                messageDigest.update(publicKey.getEncoded());
                byte[] byArray2 = messageDigest.digest();
                System.arraycopy(byArray2, byArray2.length - 8, byArray, 0, 8);
                byArray[0] = (byte)(byArray[0] & (0x8F & byArray[0]));
                KeyIdentifier keyIdentifier = new KeyIdentifier(byArray);
                SubjectKeyIdentifierExtension subjectKeyIdentifierExtension = new SubjectKeyIdentifierExtension(keyIdentifier.getIdentifier());
                certificateExtensions.set("SubjectKeyIdentifier", (Object)subjectKeyIdentifierExtension);
                AuthorityKeyIdentifierExtension authorityKeyIdentifierExtension = new AuthorityKeyIdentifierExtension(keyIdentifier, null, null);
                certificateExtensions.set("AuthorityKeyIdentifier", (Object)authorityKeyIdentifierExtension);
                x509CertInfo.set("extensions", (Object)certificateExtensions);
            }
            catch (IOException iOException) {
                throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_SAN, iOException, new String[]{iOException.getMessage()});
            }
            certificateExtensions = new X509CertImpl(x509CertInfo, string2);
            if (KeymanUtil.isIBMJCE()) {
                try {
                    certificateExtensions.sign(privateKey, string, string2);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    object = null;
                    if (KeymanUtil.isIBMJCEPlusModeOn() && (object = KeymanUtil.getJCEProviderNameLegacy()) != null) {
                        certificateExtensions.sign(privateKey, string, (String)object);
                    }
                    throw noSuchAlgorithmException;
                }
            } else {
                certificateExtensions.sign(privateKey, string);
            }
            return new CertificateKeyItemImpl(commandParameters.getLabel(), privateKey, new Certificate[]{certificateExtensions});
        }
        catch (CertificateException certificateException) {
            if (certificateException.getMessage().contains("Invalid version")) {
                throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_CERTIFICATE_VERSION, certificateException, new String[]{commandParameters.getLabel()});
            }
            throw new KeyManagerException(KeyManagerException$ExceptionReason.CERTIFICATE_CREATE_ERROR, (Throwable)certificateException);
        }
        catch (IOException iOException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.IO_ERROR, (Throwable)iOException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_SUCH_ALGORITHM, noSuchAlgorithmException, new String[]{string});
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new InternalKeyManagerException(KeyManagerException$ExceptionReason.NO_SUCH_PROVIDER, noSuchProviderException, new String[]{string2});
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_KEY_FOR_SIGNING, invalidKeyException, new String[]{commandParameters.getLabel()});
        }
        catch (SignatureException signatureException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.SIGNATURE_ERROR, signatureException, new String[]{commandParameters.getLabel()});
        }
    }

    public static CertificateKeyItem newKeyItem(String string, X509Certificate x509Certificate, PrivateKey privateKey) throws KeyManagerException {
        return new CertificateKeyItemImpl(string, privateKey, new Certificate[]{x509Certificate});
    }

    public static SecretKeyItem newSecretKey(String string, SecretKey secretKey) throws KeyManagerException {
        return new SecretKeyItemImpl(string, secretKey);
    }

    public static Collection loadSecretKeys(String string, PrivateKey privateKey, String string2) throws KeyManagerException {
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(string));
            SecretKeyReader secretKeyReader = new SecretKeyReader(inputStream);
            List list = secretKeyReader.readKeys();
            ArrayList<SecretKeyItem> arrayList = new ArrayList<SecretKeyItem>();
            for (SecretKeyReader$SecretKeyInfo secretKeyReader$SecretKeyInfo : list) {
                arrayList.add(SecretKeyItemImpl.decryptKey(privateKey, secretKeyReader$SecretKeyInfo.encryptedKey, secretKeyReader$SecretKeyInfo.algorithm, secretKeyReader$SecretKeyInfo.alias, string2));
            }
            ArrayList<SecretKeyItem> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.INPUT_FILE_NOT_FOUND, fileNotFoundException, new String[]{string});
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new InternalKeyManagerException(KeyManagerException$ExceptionReason.NO_SUCH_PROVIDER, (Throwable)noSuchProviderException);
        }
        catch (IOException iOException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.INPUT_STREAM_CLOSE_ERROR, iOException, new String[]{string});
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.KEY_DECRYPTION_ERROR, (Throwable)invalidKeyException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_SUCH_ALGORITHM, noSuchAlgorithmException, new String[]{noSuchAlgorithmException.getMessage()});
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.KEY_DECRYPTION_ERROR, noSuchPaddingException, new String[]{string});
        }
        catch (Exception exception) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.SECRET_KEY_FILE_FORMAT_NOT_SUPPORTED, exception, new String[]{string});
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    Debug.log(iOException.toString(), new Object[0]);
                }
            }
        }
    }

    public static CMSCertificateItem newCMSCertificate(String string, X509Certificate x509Certificate) throws KeyManagerException {
        return new CMSCertificateItemImpl(string, x509Certificate);
    }

    public static CMSKeyItem newCMSKey(String string, PrivateKey privateKey, Certificate[] certificateArray) throws KeyManagerException {
        return new CMSKeyItemImpl(string, privateKey, certificateArray);
    }

    public static CertificateRequestKeyItem newUnloadableCertificateRequestItem(String string) throws KeyManagerException {
        return new UnloadableCertificateRequestItemImpl(string);
    }

    public static CertificateRequestItem loadCertificateRequestItem(String string, CommandParameters commandParameters) throws KeyManagerException {
        try {
            CertificationRequest certificationRequest = new CertificationRequest(commandParameters.getFile(), true);
            return new CertificateRequestItemImpl(string, certificationRequest, commandParameters);
        }
        catch (IOException iOException) {
            if (iOException.getMessage().contains("not found")) {
                throw new KeyManagerException(KeyManagerException$ExceptionReason.CERTIFICATE_REQUEST_FILE_NOT_FOUND, iOException, new String[]{commandParameters.getFile()});
            }
            throw new KeyManagerException(KeyManagerException$ExceptionReason.CERTIFICATE_REQUEST_DECODING_ERROR, iOException, new String[]{commandParameters.getFile()});
        }
    }

    public static CertificateRequestKeyItem loadCertificateRequestItem(String string, CertificationRequest certificationRequest, PrivateKey privateKey) throws KeyManagerException {
        return new CertificateRequestKeyItemImpl(string, certificationRequest, privateKey);
    }

    public static CertificateRequestKeyItem newCertificateRequestItem(CommandParameters commandParameters, KeyPair keyPair, String string, String string2) throws KeyManagerException {
        DisplayItemFactory$SanItem displayItemFactory$SanItem = commandParameters.getSan();
        DisplayItemFactory$DNItem displayItemFactory$DNItem = commandParameters.isParameterPresent(Constants$Parameter.DN) ? commandParameters.getDn() : DisplayItemFactory.getDNItem("");
        String string3 = commandParameters.getLabel();
        return EntryFactory.newCertificateRequestItem(commandParameters, string3, displayItemFactory$DNItem, displayItemFactory$SanItem, keyPair, string, string2, null);
    }

    public static CertificateRequestKeyItem newCertificateRequestItem(CommandParameters commandParameters, CertificateItem certificateItem, KeyPair keyPair, String string) throws KeyManagerException {
        DisplayItemFactory$SanItem displayItemFactory$SanItem = certificateItem.getSan();
        DisplayItemFactory$DNItem displayItemFactory$DNItem = certificateItem.getSubjectDN();
        String string2 = certificateItem.getLabel();
        return EntryFactory.newCertificateRequestItem(commandParameters, string2, displayItemFactory$DNItem, displayItemFactory$SanItem, keyPair, KeymanUtil.getSignatureDigest(keyPair.getPrivate(), certificateItem.getSignatureAlgorithm().getOID()), string, certificateItem);
    }

    private static CertificateRequestKeyItem newCertificateRequestItem(CommandParameters commandParameters, String string, DisplayItemFactory$DNItem displayItemFactory$DNItem, DisplayItemFactory$SanItem displayItemFactory$SanItem, KeyPair keyPair, String string2, String string3, CertificateItem certificateItem) throws KeyManagerException {
        if (displayItemFactory$DNItem.isEmpty() && displayItemFactory$SanItem.isEmpty()) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_DN_OR_SAN);
        }
        CertificationRequest certificationRequest = null;
        try {
            PKCSAttribute pKCSAttribute;
            KeyUsageExtension keyUsageExtension;
            Vector vector;
            CertAttrSet certAttrSet = displayItemFactory$SanItem.toExtension(displayItemFactory$DNItem.isEmpty());
            PKCSAttributes pKCSAttributes = null;
            CertificateExtensions certificateExtensions = new CertificateExtensions();
            if (certAttrSet != null) {
                certificateExtensions.set(certAttrSet.getName(), (Object)certAttrSet);
            }
            Vector vector2 = vector = commandParameters == null ? certificateItem.getExtendedKeyUsageV() : commandParameters.getExtendedKeyUsage();
            if (vector.size() > 0) {
                certificateExtensions.set("ExtKeyUsage", (Object)new ExtKeyUsageExtension(vector));
            }
            KeyUsageExtension keyUsageExtension2 = keyUsageExtension = commandParameters == null ? certificateItem.getKeyUsage() : commandParameters.getKeyUsage();
            if (keyUsageExtension != null) {
                certificateExtensions.set("KeyUsage", (Object)keyUsageExtension);
            }
            if (certificateExtensions.getAllExtensions().size() > 0) {
                pKCSAttribute = new PKCSAttribute(PKCSOID.EXTENSION_REQUEST_OID, (Object)certificateExtensions);
                pKCSAttributes = new PKCSAttributes(new PKCSAttribute[]{pKCSAttribute});
            }
            pKCSAttribute = new CertificationRequestInfo(displayItemFactory$DNItem.getX500Name(), keyPair.getPublic(), pKCSAttributes, string3);
            certificationRequest = KeymanUtil.isIBMJCE() ? new CertificationRequest((CertificationRequestInfo)pKCSAttribute, string3) : new CertificationRequest((CertificationRequestInfo)pKCSAttribute);
            certificationRequest = certificationRequest.sign(string2, keyPair.getPrivate());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_DN, iOException, new String[]{displayItemFactory$DNItem.toString()});
        }
        catch (PKCSException pKCSException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.REQUEST_SIGNING_ERROR, pKCSException, new String[]{string});
        }
        catch (SignatureException signatureException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.SIGNATURE_ERROR, signatureException, new String[]{string});
        }
        return new CertificateRequestKeyItemImpl(string, certificationRequest, keyPair.getPrivate());
    }

    private static Collection generateCertificates(String string, String string2) throws KeyManagerException {
        CertificateParserFactory$CertificateParser certificateParserFactory$CertificateParser = CertificateParserFactory.getCertificateParser();
        return certificateParserFactory$CertificateParser.getCertificates(new File(string), string2);
    }

    public static List reorderCertChain(Collection collection) {
        List list = EntryFactory.extractCertChain(collection.toArray(new CertificateItem[0]), (CertificateItem)collection.toArray()[0]);
        if (list.size() < collection.size()) {
            for (CertificateItem certificateItem : collection) {
                boolean bl = false;
                for (CertificateItem certificateItem2 : list) {
                    if (!certificateItem.equals(certificateItem2)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                list.add(certificateItem);
            }
        }
        return list;
    }

    public static List extractCertChain(CertificateItem[] certificateItemArray, CertificateItem certificateItem) {
        ArrayList<CertificateItem> arrayList = new ArrayList<CertificateItem>();
        CertificateItem certificateItem2 = null;
        CertificateItem certificateItem3 = EntryFactory.findLowestCert(certificateItem, certificateItemArray);
        arrayList.add(certificateItem3);
        certificateItem2 = certificateItem3;
        for (int i = 0; i < certificateItemArray.length - 1; ++i) {
            for (CertificateItem certificateItem4 : certificateItemArray) {
                if (certificateItem4 instanceof UnloadableCertificateItemImpl || certificateItem4 instanceof UnloadableCMSCertificateItem || certificateItem2.equals(certificateItem4) || !certificateItem2.getIssuerDN().getX500Name().equals(certificateItem4.getSubjectDN().getX500Name()) || !EntryFactory.verifySignature(certificateItem2.getCert(), certificateItem4.getCert())) continue;
                certificateItem2 = certificateItem4;
                break;
            }
            if (certificateItem2.equals(certificateItem3)) continue;
            arrayList.add(certificateItem2);
            certificateItem3 = certificateItem2;
        }
        return arrayList;
    }

    private static boolean verifySignature(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        try {
            x509Certificate.verify(x509Certificate2.getPublicKey());
        }
        catch (InvalidKeyException invalidKeyException) {
            return false;
        }
        catch (CertificateException certificateException) {
            return false;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return false;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            return false;
        }
        catch (SignatureException signatureException) {
            return false;
        }
        return true;
    }

    public static Set extractCertTrustAnchor(CertificateItem[] certificateItemArray) {
        HashSet<TrustAnchor> hashSet = new HashSet<TrustAnchor>();
        for (CertificateItem certificateItem : certificateItemArray) {
            if (!certificateItem.getIssuerDN().getX500Name().equals(certificateItem.getSubjectDN().getX500Name())) continue;
            hashSet.add(new TrustAnchor(certificateItem.getCert(), null));
        }
        return hashSet;
    }

    private static CertificateItem findLowestCert(CertificateItem certificateItem, CertificateItem[] certificateItemArray) {
        CertificateItem certificateItem2 = certificateItem;
        for (int i = 0; i < certificateItemArray.length - 1; ++i) {
            for (CertificateItem certificateItem3 : certificateItemArray) {
                if (certificateItem3 instanceof UnloadableCertificateItemImpl || certificateItem3 instanceof UnloadableCMSCertificateItem || !certificateItem3.getIssuerDN().getX500Name().equals(certificateItem2.getSubjectDN().getX500Name()) || certificateItem3.getIssuerDN().getX500Name().equals(certificateItem3.getSubjectDN().getX500Name()) || !EntryFactory.verifySignature(certificateItem3.getCert(), certificateItem2.getCert())) continue;
                certificateItem2 = certificateItem3;
                break;
            }
            if (certificateItem2.equals(certificateItem)) break;
        }
        return certificateItem2;
    }
}

